(function(a) {
    a.fn.gracket = function(b) {
        a.fn.gracket.defaults = {
            gracketClass: "g_gracket",
            gameClass: "g_game",
            roundClass: "g_round",
            roundLabelClass: "g_round_label",
            teamClass: "g_team",
            winnerClass: "g_winner",
            spacerClass: "g_spacer",
            currentClass: "g_current",
            seedClass: "g_seed",
            cornerRadius: 15,
            canvasId: "g_canvas",
            canvasClass: "g_canvas",
            canvasLineColor: "#eee",
            canvasLineCap: "round",
            canvasLineWidth: 2,
            canvasLineGap: 15,
            roundLabels: [],
            src: []
        };
        var c = this,
            h = (typeof c.data("gracket") === "undefined") ? [] : (typeof c.data("gracket") === "string") ? JSON.parse(c.data("gracket")) : c.data("gracket"),
            j, i, f, e = [];
        a.fn.gracket.settings = {};
        var g = {
            init: function(w) {
                this.gracket.settings = a.extend({}, this.gracket.defaults, w);
                if (this.gracket.settings.src.length) {
                    h = this.gracket.settings.src
                }
                this.gracket.settings.canvasId = this.gracket.settings.canvasId + "_" + ((new Date()).getTime());
                var q = document.createElement("canvas");
                q.id = this.gracket.settings.canvasId;
                q.className = this.gracket.settings.canvasClass;
                q.style.position = "absolute";
                q.style.left = 0;
                q.style.top = 0;
                q.style.right = "auto";
                c.addClass(this.gracket.settings.gracketClass).prepend(q);
                i = h.length;
                for (var k = 0; k < i; k++) {
                    var m = d.build.round(this.gracket.settings);
                    c.append(m);
                    f = h[k].length;
                    for (var p = 0; p < f; p++) {
                        var o = d.build.game(this.gracket.settings),
                            v = c.find("." + this.gracket.settings.gameClass).outerHeight(true),
                            s = d.build.spacer(this.gracket.settings, v, k, (k !== 0 && p === 0) ? true : false);
                        if (p % 1 == 0 && k !== 0) {
                            m.append(s)
                        }
                        m.append(o);
                        j = h[k][p].length;
                        for (var u = 0; u < j; u++) {
                            var l = d.build.team(h[k][p][u], this.gracket.settings);
                            o.append(l);
                            var n = l.outerWidth(true);
                            if (e[k] === undefined || e[k] < n) {
                                e[k] = n
                            }
                            if (j === 1) {
                                o.prev().remove();
                                d.align.winner(o, this.gracket.settings, o.parent().prev().children().eq(0).height());
                                d.listeners(this.gracket.settings, h, o.parent().prev().children().eq(1))
                            }
                        }
                    }
                }
            }
        };
        var d = {
            build: {
                team: function(m, l) {
                    var k = ["<h3" + ((typeof m.score === "undefined") ? "" : ' title="Score: ' + m.score + '"') + ">", '<span class="' + l.seedClass + '">', ((typeof m.displaySeed === "undefined") ? m.seed : m.displaySeed), "</span>", "&nbsp;" + m.name + "&nbsp;", "<small>", ((typeof m.score === "undefined") ? "" : m.score), "</small>", "</h3>"].join("");
                    return team = a("<div />", {
                        html: k,
                        "class": l.teamClass + " " + (m.id || "id_null")
                    })
                },
                game: function(k) {
                    return game = a("<div />", {
                        "class": k.gameClass
                    })
                },
                round: function(k) {
                    return round = a("<div />", {
                        "class": k.roundClass
                    })
                },
                spacer: function(m, n, l, k) {
                    return spacer = a("<div />", {
                        "class": m.spacerClass
                    }).css({
                        height: (k) ? (((Math.pow(2, l)) - 1) * (n / 2)) : ((Math.pow(2, l) - 1) * n)
                    })
                },
                labels: function(n, q) {
                    var p = q,
                        l, k = n.length,
                        o, m = 0;
                    for (l = 0; l < k; l++) {
                        o = (l === 0 ? p.padding + m : p.padding + m + (p.right * l));
                        a("<h5 />", {
                            html: (p.labels.length ? p.labels[l] : "Round " + (l + 1)),
                            "class": p["class"]
                        }).css({
                            position: "absolute",
                            left: o,
                            width: q.width
                        }).prependTo(c);
                        m += e[l]
                    }
                },
                canvas: {
                    resize: function(l) {
                        var k = document.getElementById(l.canvasId);
                        k.height = c.innerHeight();
                        k.width = c.innerWidth();
                        a(k).css({
                            height: c.innerHeight(),
                            width: c.innerWidth(),
                            zIndex: 1,
                            pointerEvents: "none"
                        })
                    },
                    draw: function(F, O, M) {
                        var t = document.getElementById(F.canvasId);
                        if (typeof G_vmlCanvasManager != "undefined") {
                            G_vmlCanvasManager.initElement(t)
                        }
                        var H = t.getContext("2d");
                        var n = e[0],
                            o = M.outerHeight(true),
                            J = (parseInt(c.css("paddingLeft")) || 0),
                            K = (parseInt(c.css("paddingTop")) || 0),
                            C = (parseInt(M.css("marginBottom")) || 0),
                            w = n + J,
                            s = (parseInt(c.find("> div").css("marginRight")) || 0),
                            x = F.cornerRadius,
                            B = F.canvasLineGap,
                            P = (M.height() - 2 * M.find("> div").eq(1).height());
                        _playerHt = M.find("> div").eq(1).height(), _totalItemWidth = 0;
                        if (typeof console !== "undefined") {
                            console.info("Padding Left: " + J + "px", "Player/Name Width: " + n + "px", "Container padding left: " + w + "px")
                        }
                        if (x > o / 3) {
                            x = o / 3
                        }
                        if (x > s / 2) {
                            x = s / 2 - 2
                        }
                        if (x <= 0) {
                            x = 1
                        }
                        if (B > s / 3) {
                            B = s / 3
                        }
                        H.strokeStyle = F.canvasLineColor;
                        H.lineCap = F.canvasLineCap;
                        H.lineWidth = F.canvasLineWidth;
                        H.beginPath();
                        var A = Math.pow(2, O.length - 2),
                            L = 0,
                            I, z = 0.5,
                            u = ((L === 0 && A === 1) ? true : false);
                        if (u) {
                            var v = a("." + F.gameClass);
                            var y = v.eq(v.length - 1);
                            o = y.outerHeight(true);
                            n = y.outerWidth(true)
                        }
                        while (A >= 1) {
                            for (I = 0; I < A; I++) {
                                if (A == 1) {
                                    z = 1
                                }
                                var m = (u) ? (n + J) : (w + _totalItemWidth + L * s),
                                    l = z * s,
                                    D = ((Math.pow(2, L - 1) - 0.5) * (L && 1) + I * Math.pow(2, L)) * o + K + ((u) ? (v.find("> div").eq(1).height()) : (_playerHt)) + P / 2;
                                if (A > 1) {
                                    H.moveTo(m + B, D);
                                    H.lineTo(m + l - x, D)
                                } else {
                                    H.moveTo(m + B, D);
                                    H.lineTo(m + (3 * B), D)
                                }
                                if (A > 1 && I % 2 == 0) {
                                    var N = D + x;
                                    var k = D + Math.pow(2, L) * o - x;
                                    H.moveTo(m + l, N);
                                    H.lineTo(m + l, k);
                                    var G = m + l - x,
                                        E = D + x;
                                    H.moveTo(G, E - x);
                                    H.arcTo(G + x, E - x, G + x, E, x);
                                    E = D + Math.pow(2, L) * o - x;
                                    H.moveTo(G + x, E - x);
                                    H.arcTo(G + x, E + x, G, E + x, x);
                                    var q = (N + k) / 2;
                                    H.moveTo(m + l, q);
                                    H.lineTo(m + l + B, q)
                                }
                            }
                            L++;
                            n = e[L];
                            _totalItemWidth += n;
                            A = A / 2
                        }
                        H.stroke();
                        d.build.labels(O, {
                            padding: J,
                            left: w,
                            right: s,
                            labels: F.roundLabels,
                            "class": F.roundLabelClass
                        })
                    }
                }
            },
            align: {
                winner: function(l, m, o) {
                    var k = (l.parent().siblings().not("canvas").length === 1) ? true : false;
                    var n = k ? o - (l.height() + (l.height() / 2)) : o + (l.height() / 2);
                    return l.addClass(m.winnerClass).css({
                        "margin-top": n
                    })
                }
            },
            listeners: function(l, m, k) {
                var n = "." + l.teamClass + " > h3";
                a.each(a(n), function(o) {
                    var p = "." + a(this).parent().attr("class").split(" ")[1];
                    if (p !== undefined) {
                        a(p).hover(function() {
                            a(p).addClass(l.currentClass)
                        }, function() {
                            a(p).removeClass(l.currentClass)
                        })
                    }
                });
                d.build.canvas.resize(l);
                d.build.canvas.draw(l, m, k)
            }
        };
        if (g[b]) {
            return g[b].apply(this, Array.prototype.slice.call(arguments, 1))
        } else {
            if (typeof b === "object" || !b) {
                return g.init.apply(this, arguments)
            } else {
                a.error('Method "' + b + '" does not exist in gracket!')
            }
        }
    }
})(jQuery);