<?php
class general extends database{
    function snDateDiff($dt, $full = false){
        $d = round((time() - strtotime($dt)) / 86400);
        if($d < 1){
            $d = round(time() - strtotime($dt));
            if(($x = $d / 3600) > 1) return round($x).($full ? ' hour'.(round($x) > 1 ? 's' : '') : 'h');
            if(($x = $d / 60) > 1) return  round($x).($full ? ' minute'.(round($x) > 1 ? 's' : '') : 'm');
            return $d.($full ? ' second'.($d > 1 ? 's' : '') : 's');
        }
        if($d < 7) return $d.($full ? ' day'.($d > 1 ? 's' : '') : 'd');
        $x = $d / 7.0;
        if($d >= 7 && $d <= 30) return round($d / 7).($full ? ' week'.(round($d / 7) > 1 ? 's' : '') : 'wk');
        $x = $d / 30.5;
        if($x >= 1 && $x < 12) return round($x).($full ? ' month'.(round($x) > 1 ? 's' : '') : 'mth');
        return floor($d / 365).($full ? ' year'.(floor($d / 365) > 1 ? 's' : '') : 'yr');
    }

    function eventThumbnail($filename,$usertype){
        $final_width_of_image = 65;
        $final_height_of_image = 65;
        if($usertype == "admin"){
            $path_to_image_directory = "../../../imgs/tmp_loc/";
            $path_to_thumbs_directory = "../../../imgs/event/thumb/";
        }

        if(preg_match('/[.](jpg)$/', $filename) || preg_match('/[.](jpeg)$/', $filename)) {
            $im = imagecreatefromjpeg($path_to_image_directory . $filename);
        }else if (preg_match('/[.](gif)$/', $filename)) {
            $im = imagecreatefromgif($path_to_image_directory . $filename);
        }else if (preg_match('/[.](png)$/', $filename)) {
            $im = imagecreatefrompng($path_to_image_directory . $filename);
        }
        $ox = imagesx($im);
        $oy = imagesy($im);
        $nx = $final_width_of_image;
        $ny = $final_height_of_image;
        $nm = imagecreatetruecolor($nx, $ny);
        imagecopyresized($nm, $im, 0,0,0,0,$nx,$ny,$ox,$oy);
        if(!file_exists($path_to_thumbs_directory)) {
            if(!mkdir($path_to_thumbs_directory)) {
                die("There was a problem. Please try again!");
            }
        }
        imagejpeg($nm, $path_to_thumbs_directory . $filename);
        return;
    }
    // here we get contract balance
    function contractBalance(){
        /* = parent::query("select p.*,b.*,v.* from tbl_bank_payment as p join tbl_bankaccountdetail as b join tbl_vehicle as v where p.bankaccountdetail_id = b.bankaccountdetail_id  and b.vehicle_id = v.vehicle_id and p.payment_status='0'");
        foreach($sumofcontract_balance as $allpaiddata){
        $bankaccountdetail_id = $allpaiddata['bankaccountdetail_id'];
        $ddamount = $allpaiddata['ddamount'];
        $sumofunpaid = parent::query("SELECT COUNT(*) as paidcount from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id and p.payment_status = '1' and b.bankaccountdetail_id = $bankaccountdetail_id");
        $paidcount = $sumofunpaid[0]['paidcount'] * $ddamount;
        $sum = $sum + $paidcount;
    }*/
    $sumofpaid = parent::query("SELECT SUM(payment_amount) as paidcount from tbl_bank_payment as p WHERE p.payment_status = '0'");
    $sum = $sumofpaid[0]['paidcount'];
    return $sum;
}
// End

// here we fetch all commission
function TotalCommission(){
    $allcommission = parent::select("tbl_vehiclesales_detail","SUM(commission_price) as total_commission");
    $total_commission = $allcommission[0]['total_commission'];
    return $total_commission;
}
// End

// Here we get week sum
function weekSumbalance(){
    $sumofpaid = parent::query("SELECT SUM(payment_amount) as paidcount from tbl_bank_payment as p join tbl_bankaccountdetail as b join tbl_vehicle as v where p.bankaccountdetail_id = b.bankaccountdetail_id  and b.vehicle_id = v.vehicle_id and  p.payment_status = '0' and  payment_due_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 6 DAY)");
    /*$sumweek_record = parent::query("select p.*,b.*,v.* from tbl_bank_payment as p join tbl_bankaccountdetail as b join tbl_vehicle as v where p.bankaccountdetail_id = b.bankaccountdetail_id  and b.vehicle_id = v.vehicle_id and p.payment_status='1' and p.payment_due_date BETWEEN DATE_SUB(CURDATE(), INTERVAL 7 DAY) AND CURDATE()");
    foreach($sumweek_record as $weekdata){
    $week_bankaccountdetail_id = $weekdata['bankaccountdetail_id'];
    $ddamount = $weekdata['ddamount'];
    $sumo_week_funpaid = parent::query("SELECT COUNT(*) as week_paidcount from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id and p.payment_status = '1' and b.bankaccountdetail_id = $week_bankaccountdetail_id");
    $weeklypaid_count = $sumo_week_funpaid[0]['week_paidcount'] * $ddamount;
    $week_sum = $week_sum + $weeklypaid_count;
}*/
$week_sum = $sumofpaid[0]['paidcount'];
return $week_sum;
}
// End

// here we show the todays payment count
function todaySumbalance(){
    $todays = date("Y-m-d");
    $sumofpaid = parent::query("SELECT SUM(payment_amount) as paidcount from tbl_bank_payment as p join tbl_bankaccountdetail as b join tbl_vehicle as v where p.bankaccountdetail_id = b.bankaccountdetail_id  and b.vehicle_id = v.vehicle_id and p.payment_status = '0' and payment_due_date = '".$todays."'");
    $today_payment  = $sumofpaid[0]['paidcount'];

    return $today_payment;
}
// End

// here we create function for specific user contract balance
function usercontractBalance($accountdetailid){
    $contractbalance_details = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='0' and p.bankaccountdetail_id = $accountdetailid");
    $count_payment_remaing = count($contractbalance_details);
    foreach($contractbalance_details as $allunpaiddata){
        $ddamount = $allunpaiddata['ddamount'];
        $sum = $sum + $ddamount;
    }
    return $sum;

}
// End

// here we set the user total paid balance
function usertotalPaid($accountdetailid){
    //echo "select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='1' and p.bankaccountdetail_id = $accountdetailid";exit;
    $paid_data = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='1' and p.bankaccountdetail_id = $accountdetailid");
    $count_of_paid = count($paid_data);
    foreach($paid_data as $allpaiddata){
        $ddamount = $allpaiddata['ddamount'];
        $user_totla_paid_amt = $user_totla_paid_amt + $ddamount;
    }
    return $user_totla_paid_amt;
}
// End

// here we fetch the count of total paid by specific user
function userpaidCount($accountdetailid){
    $paid_data = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='1' and p.bankaccountdetail_id = $accountdetailid");
    $count_of_paid = count($paid_data);
    return $count_of_paid;
}
// End
// here we fetch count of remaing paiments by user
function userremaingCount($accountdetailid){
    $contractbalance_details = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='0' and p.bankaccountdetail_id = $accountdetailid");
    $count_payment_remaing = count($contractbalance_details);
    return $count_payment_remaing;
}
// End
// Here wetch count of cancel payment of specific user
function usercancelCount($accountdetailid){
    $all_cancel_payment = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='2' and p.bankaccountdetail_id = $accountdetailid");
    $count_of_cancel = count($all_cancel_payment);
    return $count_of_cancel;
}
// End
// here we fetch sum of cancel payment of specific user
function user_cancelpayment_amount($accountdetailid){
    $all_cancel_payment = parent::query("select p.*,b.* from tbl_bank_payment as p join tbl_bankaccountdetail as b where p.bankaccountdetail_id = b.bankaccountdetail_id  and p.payment_status='2' and p.bankaccountdetail_id = $accountdetailid");
    $count_of_cancel = count($all_cancel_payment);
    foreach($all_cancel_payment as $cancelpayment){
        $ddamount = $cancelpayment['ddamount'];
        $user_cancel_amt = $user_cancel_amt + $ddamount;
    }
    return $user_cancel_amt;
}

// End

function check_link($desc){
    global $dclass;
    if(strpos($desc,"#") !== false){
        preg_match_all("/(#\w+)/", $desc, $hashmatches);
        foreach($hashmatches[0] as $hashname){
            $uname = str_replace("#", "", $hashname);
            $link = "hashtag_search.php?name=$uname";
            $usr_link = "<a href=$link>$uname</a>";
            $det = str_replace($uname, $usr_link, $desc);
            $desc = str_replace("#", "", $det);
        }
    }
    if(strpos($desc,"@") !== false){
        preg_match_all("/(@\w+)/", $desc, $hashmatches);
        foreach($hashmatches[0] as $hashname){
            $uname = str_replace("@", "", $hashname);
            $usrinfo = $dclass->select("tbl_user","user_id,firstname,lastname"," AND firstname = '$uname'");
            $usr_cnt = count($usrinfo);
            $user_id = $usrinfo[0]["user_id"];
            $first_name = $usrinfo[0]["firstname"];
            $last_name = $usrinfo[0]["lastname"];
            $fulsrname = $first_name." ".$last_name;
            $usr_link = "<a href=user_wall.php?uid=$user_id>$fulsrname</a>";
            $det = str_replace($fulsrname, $usr_link, $desc);
            $desc = str_replace("@", "", $det);
        }
        if(strpos($desc,".com") || strpos($desc,".org") || strpos($desc,".net") || strpos($desc,".edu") || strpos($desc,".gov") || strpos($desc,"www.") || strpos($desc,"http") || strpos($desc,"mail.") !== false){
            $reg_exUrl = "/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
            preg_match_all($reg_exUrl, $desc, $matches);
            if(!empty($matches)){
                $usedPatterns = array();
                foreach($matches[0] as $pattern){
                    if($pattern != "profile.php" && $pattern != "home.php" && !array_key_exists($pattern, $usedPatterns)){
                        $usedPatterns[$pattern] = true;
                        $desc = str_replace($pattern, "<a href=http://$pattern>$pattern</a>", $desc);
                    }
                }
            }else{
                $post_desc = str_replace("https://", "", $desc);
                $description = "<a href=http://$post_desc>$desc</a>";
            }
        }
        $description = $desc;
    }else if(strpos($desc,"www.") !== false || strpos($desc,"http") !== false || strpos($desc,"mail.") !== false){
        if(substr($desc, 0, 5) == "https"){
            $post_desc = str_replace("https://", "", $desc);
            $description = "<a href=http://$post_desc>$desc</a>";
        }else if(substr($desc, 0, 5) != "https" && substr($desc, 0, 4) != "http"){
            $reg_exUrl = "/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
            preg_match_all($reg_exUrl, $desc, $matches);
            $usedPatterns = array();
            foreach($matches[0] as $pattern){
                if(!array_key_exists($pattern, $usedPatterns)){
                    $usedPatterns[$pattern]=true;
                    $desc = str_replace($pattern, "<a href=http://$pattern>$pattern</a>", $desc);
                }
            }
            $description = $desc;
        }else{
            $post_desc = str_replace("http://", "", $desc);
            $description = "<a href=http://$post_desc>$desc</a>";
        }
    }else if(strpos($desc,".com") !== false || strpos($desc,".org") !== false || strpos($desc,".net") !== false || strpos($desc,".edu") !== false || strpos($desc,".gov") !== false){
        $reg_exUrl = "/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
        preg_match_all($reg_exUrl, $desc, $matches);
        if(!empty($matches)){
            $usedPatterns = array();
            foreach($matches[0] as $pattern){
                if(!array_key_exists($pattern, $usedPatterns)){
                    $usedPatterns[$pattern]=true;
                    $desc = str_replace($pattern, "<a href=http://$pattern>$pattern</a>", $desc);
                }
            }
            $description = $desc;
        }else{
            $post_desc = str_replace("https://", "", $desc);
            $description = "<a href=http://$post_desc>$desc</a>";
        }
    }else{
        $description = $desc;
    }
    return $description;
}


function mysql_dt() { return date(MYSQL_DT_FORMAT); }

function redirectTo($redirect_url){
    @header("location: {$redirect_url}");
    echo "<script type=\"text/javascript\">location.href = \"{$redirect_url}\"</script>";
    die();
}

function dateDiff($dformat, $endDate, $beginDate){
    $date_parts1=explode($dformat, $beginDate);
    $date_parts2=explode($dformat, $endDate);
    $start_date=gregoriantojd($date_parts1[0], $date_parts1[1], $date_parts1[2]);
    $end_date=gregoriantojd($date_parts2[0], $date_parts2[1], $date_parts2[2]);
    return $end_date - $start_date;
}

function convertDateToDb($date,$sep){
    $explode = explode($sep,$date);
    $yy = $explode[2];
    $dd = $explode[0];
    $mm = $explode[1];
    $newdate = $yy.$sep.$mm.$sep.$dd;
    return $newdate;
}

function convertDbToFormat($date,$sep){
    $explode = explode($sep,$date);
    $yy = $explode[0];
    $mm = $explode[1];
    $dd = $explode[2];
    $newdate = $dd.$sep.$mm.$sep.$yy;
    return $newdate;
}

function createThumb($name,$filename,$new_w,$new_h,$path=""){
    $wh = getimagesize($path.$name);
    if($wh[0] < $new_w)
    $new_w = $wh[0];
    if($wh[1] < $new_h)
    $new_h = $wh[1];
    $gd2=1;
    $system=explode(".",$name);
    if(preg_match("/jpg|jpeg|JPG|JPEG/",$system[1])){
        $src_img=imagecreatefromjpeg($path.$name);
    }
    if(preg_match("/gif|GIF/",$system[1])){
        $src_img=imagecreatefromgif($path.$name);
    }
    if(preg_match("/png|PNG/",$system[1])){
        $src_img=imagecreatefrompng($path.$name);
    }
    $old_x=imageSX($src_img);
    $old_y=imageSY($src_img);
    if($old_x > $old_y){
        $thumb_w=$new_w;
        $thumb_h=$new_w*($old_y/$old_x);
    }
    if($old_x < $old_y){
        $thumb_w=$new_h*($old_x/$old_y);
        $thumb_h=$new_h;
    }
    if($old_x == $old_y){
        $thumb_w=$new_w;
        $thumb_h=$new_h;
    }
    if($gd2==1){
        $dst_img=ImageCreateTrueColor($thumb_w,$thumb_h);
        imagefill($dst_img,0,0,imagecolorallocate($dst_img,255,255,255));
        imagecopyresized($dst_img,$src_img,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y);
    }else{
        $dst_img=ImageCreateTrueColor($thumb_w,$thumb_h);
        imagecopyresampled($dst_img,$src_img,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y);
    }
    if(preg_match("/gif|GIF/",$system[1])){
        imagegif($dst_img,$path.$filename);
        chmod($path.$filename,0777);
    }else{
        imagejpeg($dst_img,$path.$filename);
        chmod($path.$filename,0777);
    }
    imagedestroy($dst_img);
    imagedestroy($src_img);
}

function createThumbnail($filename,$usertype){
    $final_width_of_image = 45;
    $final_height_of_image = 45;
    if($usertype == "slider"){
        $path_to_image_directory = "../upload/slider/";
        $path_to_thumbs_directory = "../upload/slider/thumbs/";
    }else if($usertype == "user"){
        $path_to_image_directory = "imgs/user/";
        $path_to_thumbs_directory = "imgs/user/thumbs/";
    }else{
        $path_to_image_directory = "upload/product/";
        $path_to_thumbs_directory = "upload/product/thumbs/";
    }

    if(preg_match('/[.](jpg)$/', $filename) || preg_match('/[.](jpeg)$/', $filename)) {
        $im = imagecreatefromjpeg($path_to_image_directory . $filename);
    }else if (preg_match('/[.](gif)$/', $filename)) {
        $im = imagecreatefromgif($path_to_image_directory . $filename);
    }else if (preg_match('/[.](png)$/', $filename)) {
        $im = imagecreatefrompng($path_to_image_directory . $filename);
    }
    $ox = imagesx($im);
    $oy = imagesy($im);
    $nx = $final_width_of_image;
    $ny = $final_height_of_image;
    $nm = imagecreatetruecolor($nx, $ny);
    imagecopyresized($nm, $im, 0,0,0,0,$nx,$ny,$ox,$oy);
    if(!file_exists($path_to_thumbs_directory)) {
        if(!mkdir($path_to_thumbs_directory)) {
            die("There was a problem. Please try again!");
        }
    }
    imagejpeg($nm, $path_to_thumbs_directory . $filename);
    return;
}

function checkEmail($email){
    // checks proper syntax
    if(!preg_match( "/^([a-zA-Z0-9])+([a-zA-Z0-9._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9._-]+)+$/", $email)){
        return false;
    }else{
        return true;
    }
}

function getSettings($field){
    global $dclass;
    $row = $dclass->select("tbl_setting","l_values"," AND v_name = '".$field."'");
    return $row[0]['l_values'];
}

function get_payment_settings($payment_id,$field){
    global $dclass;
    $row = $dclass->fetchArray($dclass->query("SELECT l_value FROM tbl_payment_settings WHERE i_payment_id = '".$payment_id."' AND v_option = '".$field."'"));
    return $row['l_value'];
}

function randompassword($length=32,$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'){
    $chars_length = (strlen($chars) - 1);
    $string = $chars{rand(0, $chars_length)};
    for($i = 1; $i < $length; $i = strlen($string)){
        $r = $chars{rand(0, $chars_length)};
        if($r != $string{$i - 1}) $string .=  $r;
    }
    return $string;
}

function printdate($date){
    $date1=explode("-",$date);
    $year=$date1[0];
    $month=$date1[1];
    $day=$date1[2];
    $day1=explode(":",$day);
    $aday=$day1[0];
    $aday=substr($aday,0,3);
    $hr=$day1[0];
    $month_array = array("Jan","Feb","Mar","Apr","May","June","Jul","Aug","Sep","Oct","Nov","Dec");
    $month = $month_array[$month-1];
    $newdate=$month."-".$aday."-".$year;
    return $newdate;
}



function subString($string,$length){
    $string = strip_tags($string);
    if(strlen($string) > $length){
        $string1 = substr($string,0,$length)."...";
    }
    else{
        $string1 = $string;
    }
    return $string1;
}

function correctURL($url){
    $test_arr=split("//",$url);
    if($test_arr[0]=="http:" || $test_arr[0]=="https:")
    return $url;
    else
    return "http://".$url;
}

///////////////////////////////////////////////////////////////////////////////


////////////// funtion to fetch to content of the given url ////////////////////////////

function fetchURL($address) {
    $host = $address;
    $contents = '';
    $handle = @fopen($host, "rb");
    if($handle){
        while (!@feof($handle)) {
            $contents .= @fread($handle, 8192);
        }
        @fclose($handle);
    }
    //print_r($contents);
    return $contents;
}

function disableRightclick(){
    echo '<script language="javascript" type="text/javascript" src="js/disablerightkey.js"></script>';
}

function removeChars($string){
    $arra = array(" ","@","#","?","&","&amp;");
    for($i=0;$i<count($arra);$i++){
        if(strstr($string,$arra[$i])){
            $string = str_replace($arra[$i],"",$string);
        }
    }
    return $string;
}

function upload_image($file_name,$apend_id,$dest,$thumb_path,$gen_th_flag,$height,$width){
    if($file_name != "" && $dest != ""){
        if(isset($_FILES[$file_name]['name']) && $_FILES[$file_name]['name'] != ""){
            $file_src = $_FILES[$file_name]['tmp_name'];
            $file_name_db = $apend_id.$this->removeChars($_FILES[$file_name]['name']);
            $destination = $dest.$apend_id.$this->removeChars($_FILES[$file_name]['name']);
            move_uploaded_file($file_src,$destination) or die('There is an error in upload');
            if($gen_th_flag == 1){
                $thumb_path = $thumb_path.$file_name_db;
                $this->thumb($destination,$thumb_path,$height,$width,$path="");
            }
            return $file_name_db;
        }
    }
}

function back(){
    return "<a href='javascript:history.go(-1);'>Back</a>";
}



function getLocationTree($parentId = '0', $level='', $selected_value, $old_pid ){
    $sqlCountry1 ="SELECT *
    FROM tblcategories
    WHERE  `parent_id` = '".$parentId."'
    ORDER BY intid ASC
    ";
    //echo $sqlCountry
    $relCountry1 = mysql_query($sqlCountry1);

    while ( $rowCountry1 = mysql_fetch_array($relCountry1)){
        //$options[] = array("value" => $rowCountry['lc_locid'], "text" => $level.$rowCountry['lc_txtname']);
        //echo "old_pid  ".$old_pid."<br>";
        //echo "rowCountry['intparantlocation']  ".$rowCountry['intparantlocation']."<br>";

        if ($rowCountry1['parent_id']  == $old_pid && $rowCountry1['parent_id'] != 0){
            //echo "levelbefore".$level;
            $level = substr($level,0,strlen($level)-2);
            //echo "level".$level;
            $old_pid = $rowCountry1['parent_id'];
        }
        if ($rowCountry1['parent_id'] == 0)
        $level = "" ;
        $option_value = $rowCountry1['intid'];
        $option_text = $level.$rowCountry1['name'];

        if($option_value==$selected_value)
        $selection = "selected='selected'";
        else
        $selection = "";

        echo "<option value=\"$option_value\" $selection>$option_text</option>\n";
        $sqlLocation1 ="SELECT *
        FROM tblcategories
        WHERE `parent_id` = '".$rowCountry1['intid']."'
        ORDER BY intid ASC
        ";
        $relLocation1 = mysql_query($sqlLocation1);
        $numLocation1 = mysql_num_rows($relLocation1);
        //echo $option_text.$old_pid."=>".$rowCountry1['intparantlocation']."<br>";
        if (($old_pid <= $rowCountry1['parent_id']) || $old_pid == 0){
            $level .= '- ';
            $old_pid = $rowCountry1['parent_id'];
        }
        if ($numLocation1>0){
            $this->getLocationTree($rowCountry1['intid'],$level,$selected_value,$rowCountry1['parent_id']);
        }

    }

}


function getCats($parentId = '0', $level='', $selected_value, $old_pid){
    $sqlCountry1 ="SELECT *
    FROM tblcategories
    WHERE  `parent_id` = '".$parentId."'
    ORDER BY intid ASC
    ";
    //echo $sqlCountry
    $relCountry1 = mysql_query($sqlCountry1);
    $templevel = $level;
    $level++;

    echo $level." - ".$templevel.'<br />';
    while ( $rowCountry1 = mysql_fetch_array($relCountry1)){
        if($level>$templevel){
            //echo "<br />" .$rowCountry1['intid'] ;
        }
        $s = '';
        $str.='<li class="subcat"><a href="#">'.$rowCountry1['name'].'</a>';
        $str.='</li>';
        $this->getCats($rowCountry1['intid'],$level,$selected_value,$rowCountry1['parent_id']);
    }

    return $str;

}


function getBanner(){
    global $dclass;
    $q = $dclass->select("*","tblbanners"," AND status='active' ORDER BY RAND() LIMIT 0,1");
    return $q[0];
}

function makefilename($file_name){
    $file_name = str_replace("&","",$file_name);
    $file_name = str_replace("?","",$file_name);
    $file_name = str_replace("/","",$file_name);
    $file_name = str_replace(">","",$file_name);
    $file_name = str_replace("<","",$file_name);
    $file_name = str_replace("&","",$file_name);
    $file_name = str_replace("#","",$file_name);
    $file_name = str_replace(" ","",$file_name);
    $file_name = stripslashes($file_name);
    return $file_name;
}

function mailToUsers($winning_prize,$cylinder){
    global $dclass;
    $email_from = $this->getSettings("varsenderemial");
    $memid = $_SESSION['memberid'];
    $mem_details = $dclass->select("current_safe_id,current_cylinder_id,varfname,varlname","tblmembers"," AND intid='$memid'");

    $send_mems = $dclass->select("varusername,varemail","tblmembers"," AND intid != '$memid' AND current_safe_id='".$mem_details[0]['current_safe_id']."' AND current_cylinder_id='".$mem_details[0]['current_cylinder_id']."'");

    $safe_name = $this->getName("intid",$mem_details[0]['current_safe_id'],"tblsafe","safe_name");

    $email_subject = $mem_details[0]['varfname']." has won - Safecracker";
    if(count($send_mems)>0){
        for($i=0;$i<count($send_mems);$i++){
            $email_to = $send_mems[$i]['varemail'];
            $email_message = "hi,<br />".$send_mems[$i]['varusername']."<br />";
            $email_message.= "Safe $safe_name is opened<br />";
            $email_message.= $mem_details[0]['varfname']." has won $winning_prize &pound;<br />";
            $email_message.= "<br />
            Regards,
            Safecracker
            ";
            $this->email($email_from, $email_to, "", "", $email_subject, $email_message, "html");
        }
    }
}



function checkLogin(){
    
    if(isset($_SESSION['adminid']) || isset($_SESSION['directorid']) || isset($_SESSION['mediatorid'])){

        if(($_SESSION['adminid'] == '' || $_SESSION['adminid'] == NULL) && ($_SESSION['directorid'] == '' || $_SESSION['directorid'] == NULL)  && ($_SESSION['mediatorid'] == '' || $_SESSION['mediatorid'] == NULL)){
            return 0;
        }else{
            return 1;
        }
    }else{

        return 0;
    }
}


function checkUserLogin(){
    if(isset($_SESSION['userid'])){
        if($_SESSION['userid'] == '' || $_SESSION['userid'] == NULL){
            return 0;
        }else{
            return 1;
        }
    }else{
        return 0;
    }
}

function getStatus($status_arr,$selval){
    $str = '';
    for($i=0;$i<count($status_arr);$i++){
        if($selval==$status_arr[$i]){$sel = 'selected="selected"';}
        else{$sel = '';}
        $str.= '<option value="'.$status_arr[$i].'" '.$sel.'>'.ucwords($status_arr[$i]).'</option>';
    }
    echo $str;
}

function getLangLat($address){
    $google_address = urlencode($address);
    $geocode1 = "http://maps.google.com/maps/geo?q=$google_address&output=csv&key=".GOOGLE_API_KEY;
    $handle = @fopen($geocode1, "r");
    $contents = '';
    if ( $handle != "" ){
        while (!feof($handle) ) {
            $contents .= fread($handle, 8192);

        }
        fclose($handle);
    }
    $coord_array = explode(",",$contents);
    $latlog[0] = $coord_array[2];
    $latlog[1] = $coord_array[3];
    return $latlog;
}


function ZipcodeInRadius($zipcode, $distance) {
    global $dclass;
    $state_concat = 1;
    $rs_city = $dclass->query("select latitude,longitude from tblzipcodes where zipcode='".$zipcode."'");
    $Data=@mysql_fetch_object($rs_city);

    $latitude1=$Data->latitude;
    $longitude1=$Data->longitude;

    //================================= SELECT ID OF CURRENT CITY============================

    $City_id_list='';
    $rs_allcity = $dclass->query("select zipcode,latitude,longitude,state from tblzipcodes where zipcode!='".$zipcode."'");
    while($Data3=@mysql_fetch_object($rs_allcity)){
        $latitude2=$Data3->latitude;
        $longitude2=$Data3->longitude;
        $City_dis =round($this->distance($latitude1, $longitude1, $latitude2, $longitude2, 'M'));

        //====================================== SELECT CITY CODE LIST===========================
        if($City_dis<=$distance){
            if($Data3->zipcode){
                if(!$state_concat){$City_id_list.=$Data3->zipcode.',';}
                else{$City_id_list.="'".$Data3->state." ".$Data3->zipcode."',";}
            }
        }
    }

    $City_id_list=substr($City_id_list, 0, -1);
    if($City_id_list=='')
    $City_id_list='-1';

    return $City_id_list;
}

function distance($lat1, $lon1, $lat2, $lon2, $unit) {
    $theta = $lon1 - $lon2;
    $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
    $dist = acos($dist);
    $dist = rad2deg($dist);
    $miles = $dist * 60 * 1.1515;
    $unit = strtoupper($unit);

    if ($unit == "K") {
        return ($miles * 1.609344);
    } else if ($unit == "N") {
        return ($miles * 0.8684);
    } else {
        return $miles;
    }
}

function getSortingArrow($field){
    $str = "";
    $sb = $_REQUEST['sb'];
    $st = $_REQUEST['st'];
    if($field == $sb){
        if($st == 0){
            $str = '<img src="images/up.png" alt="" />';
        }else if($st == 1){
            $str = '<img src="images/down.png" alt="" />';
        }
    }
    return $str;
}

function getRating($id){
    global $dclass;
    $r = $dclass->fetchArray($dclass->query("SELECT ROUND(AVG(rate_weight)) AS rate FROM tblcomments WHERE article_id='$id' AND type='rate' AND status='approved'"));
    $rate_str = "";
    if($r['rate']>0){
        $rate = $dclass->fetchArray($dclass->query("select * from tblratingtype where intid = '".$r['rate']."'"));
        //_p($rate);
        if($rate['type']){
            $rate_str = '<span class="fl"><img alt="" src="images/'.$rate['icon'].'"></span><span class="fl fontlucida font10">'.$rate['type'].' Experience</span>';
        }
    }
    return $rate_str;
}

function getRateTypes($id){
    global $dclass;
    $str = "";
    $rate_q = $dclass->query("select * from tblratingtype");
    while($rate = $dclass->fetchArray($rate_q)){
        //$str.='<span class="fl"> <img src="images/'.$rate['icon'].'" alt=""></span> <a href="article.php?rate_weight='.base64_encode($rate['intid']).'&amp;rate='.base64_encode($rate['type']).'&amp;id='.$id.'" class="fl"><strong>'.$rate['type'].' Experience</strong><br/>'.$rate['title'].'.</a><div class="clear"></div>';

        $str.='<span class="fl"> <img src="images/'.$rate['icon'].'" alt=""></span> <a href="javascript:void(0);" class="fl" onclick="rateArticle('.$id.',\''.base64_encode($rate['intid']).'\')"><strong>'.$rate['type'].' Experience</strong><br/>'.$rate['title'].'.</a><div class="clear"></div>';
    }
    return $str;
}

function checkMemLogin(){
    if(isset($_SESSION['memberid'])){
        return true;
    }else{
        return false;
    }
}

function logMemActivity($activity,$page_url){
    global $dclass;
    $ins['activity'] = $activity;
    $ins['member_id'] = $_SESSION['memberid'];
    $ins['page_url'] = $page_url;
    $ins['dtadd'] = date('Y-m-d H:i:s');
    $ins['ip'] = $_SERVER['REMOTE_ADDR'];

    $dclass->insert("tblactivity",$ins);

}


function getParentId($id){
    global $dclass;
    $q = $dclass->query("SELECT parent_id,intid FROM tblcategories WHERE intid='$id'");
    //$lastid = $id;
    if(mysql_num_rows($q)>0){
        $d = $dclass->fetchArray($q);
        //_p($d);
        $this->getParentId($d['parent_id']);

        if($d['parent_id']==0){
            $lastid = $d['intid'];
            $_SESSION['last_parent_id'] = $lastid;
        }
    }

}


function processContent($content){
    if($content!=''){
        preg_match_all("~href=\"(.*?)\"~i", $content, $urls);
        $all = $urls[1];
        if(is_array($all)){
            for($i=0;$i<count($all);$i++){
                $object = strtolower($all[$i]);
                if(strstr($object,".jpg") || strstr($object,".png") || strstr($object,".gif")){
                    $image = "<img src=".$all[$i].">";
                    $content = str_replace('href="'.$all[$i].'"',"href='".$all[$i]."' onmouseover=\"showTooltip(event,'$image')\" onmouseout=''",$content);
                }
                else if(strstr($object,"youtube.com")){
                    $vidurl = "http://www.youtube.com/v/".$this->getYouTubeURL($all[$i]);
                    $emb =  addslashes("<object width='440' height='285'><param name='movie' value='".$vidurl."?fs=1&amp;hl=en_US&amp;autoplay=1'></param><param name='allowFullScreen' value='true'><param name='autoplay' value='1'></param><param name='allowscriptaccess' value='always'></param><embed src='".$vidurl."?fs=1&amp;hl=en_US&amp;autoplay=1' type='application/x-shockwave-flash' allowscriptaccess='always' allowfullscreen='true' autoplay='1' width='440' height='285'></embed></object>");

                    $content = str_replace('href="'.$all[$i].'"','href="#" onmouseout="hideTooltip()" onmouseover="showTooltip(event,\''.$emb.'\');"',$content);

                }
            }
        }

        return $content;
    }
}

function getYouTubeURL($string) {
    $splitString =	$string;
    $splitString = explode("=",$splitString);
    $videoID = $splitString[1];
    return $videoID;
}




/*
*	Added by Roger on 06-01
*	Forum Category parent-child Combo
*/
function getParentChildCombo($tbl,$tbl2,$id,$name,$parentid,$parentIdVal = '0', $level='', $selected_value, $old_pid,$statusfield='e_status',$statusval='active',$condition=''){

    $foreign = substr($tbl,4);

    $sql1 = "SELECT t1.*, t2.".$name."
    FROM ".$tbl." t1
    LEFT JOIN ".$tbl2." t2
    ON t1.".$id." = t2.i_".$foreign."_id
    WHERE  t1.".$parentid." = '".$parentIdVal."'
    AND t1.".$statusfield." = '".$statusval."'
    ".$condition."
    GROUP BY t2.i_".$foreign."_id
    ORDER BY t1.".$id." ASC";
    //echo $sql;
    $rel1 = mysql_query($sql1);

    while ( $row1 = mysql_fetch_array($rel1)){
        //$options[] = array("value" => $rowCountry['lc_locid'], "text" => $level.$rowCountry['lc_txtname']);
        //echo "old_pid  ".$old_pid."<br>";
        //echo "rowCountry['intparantlocation']  ".$rowCountry['intparantlocation']."<br>";

        if ($row1[$parentid]  == $old_pid && $row1[$parentid] != 0){
            //echo "levelbefore".$level;
            $level = substr($level,0,strlen($level)-2);
            //echo "level".$level;
            $old_pid = $row1[$parentid];
        }
        if ($row1[$parentid] == 0)
        $level = "" ;
        $option_value = $row1[$id];
        $option_text = $level.$row1[$name];

        if($option_value==$selected_value)
        $selection = "selected='selected'";
        else
        $selection = "";

        echo "<option value=\"$option_value\" $selection>$option_text</option>\n";

        $sql2 = "SELECT t1.*, t2.v_title
        FROM ".$tbl." t1
        LEFT JOIN ".$tbl2." t2
        ON t1.".$id." = t2.i_".$foreign."_id
        WHERE t1.".$parentid." = '".$row1[$id]."'
        AND t1.".$statusfield." = '".$statusval."'
        ".$condition."
        GROUP BY i_".$foreign."_id
        ORDER BY t1.".$id." ASC";
        $rel2 = mysql_query($sql2);
        $num2 = mysql_num_rows($rel2);
        //echo $option_text.$old_pid."=>".$rowCountry1['intparantlocation']."<br>";
        if (($old_pid <= $row1[$parentid]) || $old_pid == 0){
            $level .= '- ';
            $old_pid = $row1[$parentid];
        }
        if ($num2>0){
            $this->getParentChildCombo($tbl,$tbl2,$id,$name,$parentid,$row1[$id],$level,$selected_value,$row1[$parentid],$statusfield,$statusval,$condition);
        }

    }
}

// for simple dropdown box
function getSimpleCombo($tbl,$id,$name,$selected='',$condition='',$statusfield='e_status',$statusval='active',$orderby='')
{
    $sql = "SELECT $id, $name FROM `".$tbl."`
    WHERE 1 ".$condition."
    AND ".$statusfield." = '".$statusval."'";

    if($orderby)
    $sql .= $orderby;

    //exit;
    $rel = mysql_query($sql);

    $option = "";
    //echo $selctval;
    while ($row = mysql_fetch_array($rel))
    {
        $select = '';
        if($row[$id] == $selected)
        {
            $select = "selected = 'selected'";
        }
        $option .= '<option value="'.$row[$id].'" '.$select.'>'.ucwords(str_replace('_',' ',$row[$name])).'</option>';
    }
    echo $option;
    //return $option;
}

// for simple dropdown box
function getSimpleComboLanguage($tbl,$id,$name,$selected='',$condition='',$statusfield='e_status',$statusval='active',$orderby='')
{
    $foreign = substr($tbl,4);

    $sql = "SELECT t1.".$id.", t2.".$name."
    FROM `".$tbl."` t1
    LEFT JOIN ".$tbl."_details t2
    ON t1.id = t2.i_".$foreign."_id
    WHERE 1 ".$condition."
    AND t1.".$statusfield." = '".$statusval."'
    GROUP BY i_".$foreign."_id ";

    if($orderby)
    $sql .= $orderby;
    else
    $sql .= " ORDER BY t1.".$id." ASC";
    //exit;
    $rel = mysql_query($sql);

    $option = "";
    //echo $selctval;
    while ($row = mysql_fetch_array($rel))
    {
        $select = '';
        if(is_array($selected)) {
            if(in_array($row[$id],$selected)) {
                $select = "selected = 'selected'";
            }
        }
        else {
            if($row[$id] == $selected) {
                $select = "selected = 'selected'";
            }
        }
        $option .= '<option value="'.$row[$id].'" '.$select.'>'.$row[$name].'</option>';
    }
    echo $option;
    //return $option;
}

// For radio buttons
function getRadioList($name,$radarray,$selval){
    $str = '';
    foreach($radarray as $key => $val){
        if($selval == $val) { $sel = 'checked="checked"'; }
        else { $sel = ''; }
        $str .= '<input type="radio" name="'.$name.'" value="'.$val.'" '.$sel.' />'.ucwords($val).' &nbsp; ';
    }
    echo $str;
}

// for checkbox lists
function getCheckboxListFromTable($name,$tbl,$tblid,$selval){

    global $dclass;
    $chkarray = $dclass->select("*",$tbl,""," ORDER BY ".$tblid." DESC"," GROUP BY ".$tblid."");


    $str = '';
    $cnt = 1;
    foreach($chkarray as $key => $val){
        $selvalarr = explode(',',$selval);
        $sel = '';
        foreach($selvalarr as $v) {
            if($v == $val[$tblid]) {
                $sel = 'checked="checked"';
            }
        }
        $str .= '<input type="checkbox" name="'.$name.'" value="'.$val[$tblid].'" '.$sel.' />'.ucwords($val['v_title']).' &nbsp; ';

        if($cnt%3 == 0) {
            $str .= '<br /><br />';
        }

        $cnt++;
    }
    echo $str;
}


// For dropdown
function getDropdownList($droparray,$selval){
    $str = '';
    foreach($droparray as $key => $val){
        if($selval == $val) { $sel = 'selected="selected"'; }
        else { $sel = ''; }
        $str .= '<option value="'.$val.'" '.$sel.' />'.ucwords($val).'</option>';
    }
    echo $str;
}

function getLinkUsingTable($table,$id) {
    global $dclass;
    if(SEO_FRIENDLY===true)
    {
        if($table == 'tbl_blog') {
            $row = $dclass->select("v_url",$table," AND id = '".$id."'");
            return substr($table,4).'/'.$row[0]['v_url'];
        }
        else {
            $row = $dclass->select("v_title",$table," AND id = '".$id."'");

            return substr($table,3).'/'.$this->seoText($row[0]['vName']).'-'.$id;
        }
    }
    else
    {
        if($table == 'tblpage') {
            $row = $dclass->select("vPageUrl",$table," AND iId = '".$id."'");
            return substr($table,3).'.php?id='.$row[0]['vPageUrl'];
        }
        else {
            return substr($table,3).'.php?id='.$id;
        }
    }
}

function getLinkUsingTableLanguage($table,$id) {
    global $dclass;
    global $language_id;
    if(SEO_FRIENDLY===true)
    {
        if($table == 'tbl_blog') {
            $row = $dclass->select("v_url,v_external_url,v_blog_category_id",$table," AND id = '".$id."'");


            if($row[0]['v_external_url'] == '' ) {
                $cat_id_arr = explode(",",$row[0]['v_blog_category_id']);

                $current_sql = $dclass->query("SELECT t1.*, t2.v_title FROM  tbl_menu t1 LEFT JOIN tbl_menu_details t2 ON t1.id = t2.i_menu_id WHERE t1.v_type = 'blog_category' AND t1.i_menu_id='".$cat_id_arr[0]."' AND t2.i_language_id = '".$language_id."'");
                $current_data = $dclass->fetchArray($current_sql);
                $cat_title = $dclass->select("*","tbl_blog_category_details"," AND i_blog_category_id = '".$current_data['i_menu_id']."' AND i_language_id='".$language_id."'");
                $hreflink = SITE_URL.'blog/'.strtolower($this->seoText($cat_title[0]['v_title'])).'-'.$current_data['i_menu_id'].'-'.$current_data['id'].'/'.$row[0]['v_url'].'/';
            }
            else {
                $hreflink = $row[0]['v_external_url'];
            }

            return $hreflink;
        }
        else if($table == 'tbl_cms') {
            return 'page/'.$id.'/';
        }
        else {
            $foreign = substr($table,4);
            $row = $dclass->select("v_title",$table.'_details'," AND i_".$foreign."_id = '".$id."' AND i_language_id = '".$language_id."'");
            return str_replace('_','/',substr($table,4)).'/'.$this->seoText($row[0]['v_title']).'-'.$id;
        }
    }
    else
    {
        if($table == 'tbl_blog') {
            $row = $dclass->select("v_url",$table," AND id = '".$id."'");
            return 'post.php?url='.$row[0]['v_url'];
        }
        else if($table == 'tbl_cms') {
            return 'page.php?id='.$id;
        }
        else {
            $foreign = substr($table,4);
            $row = $dclass->select("v_title",$table.'_details'," AND i_".$foreign."_id = '".$id."' AND i_language_id = '".$language_id."'");
            return str_replace('_','-',substr($table,4)).'.php?id='.$id;
        }
    }
}

function getLinkUsingTitle($title) {
    global $dclass;
    if(SEO_FRIENDLY===true)
    {
        return $this->seoText($title).'/';
    }
}

function getLinkUsingTitleFilename($table,$id,$title) {
    global $dclass;
    if(SEO_FRIENDLY===true) {
        return str_replace('_','/',substr($table,4)).'/'.$this->seoText($title).'-'.$id;
    }
    else {
        return str_replace('_','-',substr($table,4)).'.php?id='.$id;
    }
}


function seoText($str) {
    $str=trim(strtolower($str));
    $special_array=array('#','$','\'','"','?','&',':','!','%','&reg;','&trade;','(',')','/',',');
    $str=str_replace(' ','-',$str);
    foreach($special_array as $item)
    {
        $str=str_replace($item,'-',$str);
    }
    $str=str_replace('--','-',$str);
    $str=str_replace('---','-',$str);
    $str=str_replace('--','-',$str);
    $str=str_replace('--','-',$str);
    $str=str_replace('--','-',$str);
    return trim($str,'-');

}
function get_total_rec($table) {
    global $dclass;
    $row = $dclass->select("*",$table,"");

    return count($row);
}
function get_active_rec($table) {
    global $dclass;
    $row = $dclass->select("*",$table," AND e_status = 'active'");

    return count($row);
}
function get_inactive_rec($table) {
    global $dclass;
    $row = $dclass->select("*",$table," AND e_status = 'inactive'");

    return count($row);
}

function recently_view($id)
{
    $noduplicate = 1;
    //check for available package
    if (in_array($id,$_SESSION['r_view']))
    {
        //allow maximum	condition order
        $noduplicate = 0;
        //	$_SESSION['r_view'][$id]['qty']++;
    }
    // check for available package ends

    if($noduplicate) {
        if (!session_is_registered("r_view"))
        session_register("r_view");


        $_SESSION['r_view'][$id] = array('product_id'=>$id);
        $_SESSION['r_cnt'] = count($_SESSION['r_view']);

        /*********************************/
    }
}

// shopping cart add function starts
//function add_to_shopping_cart($id,$imagename,$title,$status,$hkd_price,$rmb_price)
//	{
//		global $_POST;
//
//		$noduplicate = 1;
//		//check for available package
//		for ($k=0;$k<=$_SESSION['cnt'];$k++)
//		{
//			if ($_SESSION['id_array'][$k] == $id)
//			{
//				//allow maximum	condition order
//				if($_SESSION['qty_array'][$k] ==  2){
//					$noduplicate = 0;
//				}else{
//					$noduplicate = 0;
//					$_SESSION['qty_array'][$k]++;
//				}
//			}
//		}
//		// check for available package ends
//
//		if($noduplicate) {
//			if (!session_is_registered("id_array"))
//				session_register("id_array");
//
//			if (!session_is_registered("image_array"))
//				session_register("image_array");
//
//			if (!session_is_registered("name_array"))
//				session_register("name_array");
//
//			if (!session_is_registered("status_array"))
//				session_register("status_array");
//
//			if (!session_is_registered("hkd_price_array"))
//				session_register("hkd_price_array");
//
//			if (!session_is_registered("rmb_price_array"))
//				session_register("rmb_price_array");
//
//			if (!session_is_registered("qty_array"))
//				session_register("qty_array");
//
//
//			if (!session_is_registered("cnt"))
//				session_register("cnt");
//
//
//			$cnt = $_SESSION['cnt'];
//
//
//			if(!isset($_SESSION['cnt']))
//				$cnt = 0;
//			else
//				$cnt++;
//
//			$_SESSION['id_array'][$cnt] = $id;
//			$_SESSION['image_array'][$cnt] = $imagename;
//			$_SESSION['name_array'][$cnt] = $title;
//			$_SESSION['status_array'][$cnt] = $status;
//			$_SESSION['hkd_price_array'][$cnt] = $hkd_price;
//			$_SESSION['rmb_price_array'][$cnt] = $rmb_price;
//			$_SESSION['qty_array'][$cnt] = 1;
//			$_SESSION['cnt'] = $cnt;
//
//			/*********************************/
//		}
//	}
// shopping cart add function ends








// shopping cart add function starts
// shopping cart add function starts
function add_to_shopping_cart($id,$title,$price,$qty,$image,$other_product,$currency)
{
    $noduplicate = 1;
    //check for available package
    if (in_array($id,$_SESSION['cart']))
    {
        //allow maximum	condition order
        $noduplicate = 0;
        $_SESSION['cart'][$id]['qty']++;
    }
    // check for available package ends

    if($noduplicate) {

        if (!isset($_SESSION["cart"])){
            //session_register("cart");
        }
        if (!isset($_SESSION["cnt"])){
            //session_register("cnt");
        }

        $subtotal = $price * $qty;
        $_SESSION['cart'][$id] = array('name'=>$title,'price'=> $price ,'qty'=>$qty,'sub_total'=>$subtotal ,'image'=>$image,'other_product'=>$other_product,'currency'=>$currency);
        $_SESSION['cnt'] = count($_SESSION['cart']);

        /*********************************/
    }

}
function remove_shopping_cart($id)
{
    //echo $_SESSION['cart'][$id];
    unset($_SESSION['cart'][$id]);
    session_unregister($_SESSION['cart'][$id]);
    $_SESSION['cnt'] = count($_SESSION['cart']);
    //echo $_SESSION['cnt'];

}
// shopping cart add function ends

function  update2Cart($idCount,$newQty){
    if ($idCount  != ''  && $idCount > 0) //update from cart product with productID == $update
    {
        $i=0;

        foreach($_SESSION['cart'] as $key=>$value){
            if($key == $idCount){

                //$_SESSION["cart_total"] = $newQty * $_SESSION['cart'][$idCount]['price'];
                $_SESSION['cart'][$idCount]['qty'] = $newQty;
                $_SESSION['cart'][$idCount]['sub_total'] = $newQty * $_SESSION['cart'][$idCount]['price'];

            }
        }

    }

}

function  emptyCart(){
    //completely clear shopping cart
    //clear cart
    unset($_SESSION["cart"]);


}
// shopping cart add function ends






/********************************* xSendding Mail To User For Login Info ***********************************/
function send_mail($to,$subject,$from,$message){
    //$to =  echo TO;
    //$subject = echo SUBJECT_MAIL;
    //$from = echo FROM;

    $msg = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>'.$subject.'</title>
    </head>

    <body>
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
    <td align="left" valign="top"><img src="'.SITE_URL.'images/logo.gif" width="180" align="absbottom" /></td>
    </tr>
    <tr>
    <td style="border:1px solid #999">
    <table width="100%" border="0" cellspacing="0" cellpadding="8">
    <tr>
    <td align="left" valign="top"></td>
    </tr>
    '.$message.'
    <tr>
    <td align="left" valign="top" style="color:#666666">'.TO_ENSURE.'</td>
    </tr>
    <tr>
    <td align="left" valign="top" style="color:#666666">'.LIVECOAL_ADDRESS.'</td>
    </tr>
    </table>

    </td>
    </tr>
    </table>
    </body>
    </html>';

    $headers = "From: " . $from . "\r\n";
    $headers .= "Reply-To: ". $from . "\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";


    /*echo $to.'<br />';
    echo $msg;
    exit;*/


    if (mail($to, $subject, $msg, $headers))
    return(1);
    else
    return(1);

}
// Random Password Generator
function assign_rand_value($num)
{
    // accepts 1 - 36
    switch($num)
    {
        case "1":
        $rand_value = "a";
        break;
        case "2":
        $rand_value = "b";
        break;
        case "3":
        $rand_value = "c";
        break;
        case "4":
        $rand_value = "d";
        break;
        case "5":
        $rand_value = "e";
        break;
        case "6":
        $rand_value = "f";
        break;
        case "7":
        $rand_value = "g";
        break;
        case "8":
        $rand_value = "h";
        break;
        case "9":
        $rand_value = "i";
        break;
        case "10":
        $rand_value = "j";
        break;
        case "11":
        $rand_value = "k";
        break;
        case "12":
        $rand_value = "l";
        break;
        case "13":
        $rand_value = "m";
        break;
        case "14":
        $rand_value = "n";
        break;
        case "15":
        $rand_value = "o";
        break;
        case "16":
        $rand_value = "p";
        break;
        case "17":
        $rand_value = "q";
        break;
        case "18":
        $rand_value = "r";
        break;
        case "19":
        $rand_value = "s";
        break;
        case "20":
        $rand_value = "t";
        break;
        case "21":
        $rand_value = "u";
        break;
        case "22":
        $rand_value = "v";
        break;
        case "23":
        $rand_value = "w";
        break;
        case "24":
        $rand_value = "x";
        break;
        case "25":
        $rand_value = "y";
        break;
        case "26":
        $rand_value = "z";
        break;
        case "27":
        $rand_value = "0";
        break;
        case "28":
        $rand_value = "1";
        break;
        case "29":
        $rand_value = "2";
        break;
        case "30":
        $rand_value = "3";
        break;
        case "31":
        $rand_value = "4";
        break;
        case "32":
        $rand_value = "5";
        break;
        case "33":
        $rand_value = "6";
        break;
        case "34":
        $rand_value = "7";
        break;
        case "35":
        $rand_value = "8";
        break;
        case "36":
        $rand_value = "9";
        break;
    }
    return $rand_value;
}
function get_rand_id($length)
{
    if($length>0)
    {
        $rand_id="";
        for($i=1; $i<=$length; $i++)
        {
            mt_srand((double)microtime() * 1000000);
            $num = mt_rand(1,36);
            $rand_id .= $this->assign_rand_value($num);
        }
    }
    return $rand_id;
}
//add to general count of the Home Page Start
function common_count($table,$field ="",$type=""){

    //MAKE QUERY TO WHICH IS BASE ON INPUT FIELD TYPE COND
    $currentInfo =  getdate(); // current date as array
    if($field =='amount'){
        // Provide Total Amount the no of recode in month year or total
        if($type =='total'){
            $sqlcount = "SELECT  SUM(f_amount + f_payment_charge + f_shipping ) AS sent , v_currency  FROM ".$table." WHERE 1 "." GROUP BY v_currency ";
        }else if($type == 'month'){
            $sqlcount = "SELECT  SUM(f_amount + f_payment_charge + f_shipping ) AS sent , v_currency  FROM ".$table." WHERE 1 AND MONTH(d_date) ='".$currentInfo['mon']."' GROUP BY v_currency";

        }else if($type == 'year'){
            $sqlcount = "SELECT  SUM(f_amount + f_payment_charge + f_shipping ) AS sent , v_currency FROM ".$table." WHERE 1 AND YEAR(d_date) ='".$currentInfo['year']."' GROUP BY v_currency";

        }
    }else if($type != ''){
        // Only Count the no of recode in month year or total
        if($type =='total'){
            $sqlcount = "SELECT  count(*) AS sent FROM ".$table." WHERE 1 ";
        }else if($type == 'month'){
            $sqlcount = "SELECT  count(*) AS sent FROM ".$table." WHERE 1 AND MONTH(d_date) ='".$currentInfo['mon']."'";
        }else if($type == 'year'){
            $sqlcount = "SELECT  count(*) AS sent FROM ".$table." WHERE 1 AND YEAR(d_date) ='".$currentInfo['year']."'";
        }
    }else{
        $sqlcount = "SELECT  count(*) AS sent FROM ".$table." WHERE 1 ";
    }
    //EXCUTE qUERY TO WHICH ISD GENERATED
    $dataCount = mysql_query($sqlcount);
    $result = array();
    $resultType = MYSQL_ASSOC;
    while($row = mysql_fetch_array($dataCount,$resultType)){
        $result[] = $row;

    }

    return($result);
}
function getRealIpAddr()
{
    if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
    {
        $ip=$_SERVER['HTTP_CLIENT_IP'];
    }
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
    {
        $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else
    {
        $ip=$_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

//  Calculate  The Rewards At  That  Product  Base  on User Consumption
function calcaluteTotalRewardsPoint ($proId,$fieldsset_id){
    global $dclass;
    //  set the  User Input
    //print_r($fieldsset_id);
    $user_input  = '';
    foreach  ($fieldsset_id	as $key  => $val){
        $rsFields =  $dclass->query(" SELECT * FROM tbl_fields WHERE  id  =  ".$key." AND refine_search='1'");
        if(!empty($rsFields)){
            $rowQuetion = mysql_fetch_assoc($rsFields);
            $user_input[$rowQuetion['caption']] = $val;
        }
    }
    //print_r($user_input);
    //print_r($user_input);
    //echo $proId."<br>";

    //  Result Set Of Calculation
    $result_set =  array();


    //  GEt  the  Product Info
    $ProductInfo = '' ;  //  Procuct value Set  On Edit
    if($proId != ''){
        $rsProduct  =  $dclass->select(" * " ,"tbl_product_option"," AND  product_id =".$proId);
        if(!empty($rsProduct)){
            foreach($rsProduct as  $rowProduct){
                $ProductInfo[$rowProduct['v_name']] =  $rowProduct['l_values'];
            }
        }else{
            $ProductInfo = '';
        }
    }
    $proiduct_points_config  = ''; //  Product Rewards On User Spend
    $proiduct_points_config['gas'] =  $ProductInfo['gas'];
    $proiduct_points_config['dinning']= $ProductInfo['dinning'];
    $proiduct_points_config['grocery']=$ProductInfo['grocery'];
    $proiduct_points_config['airfare']= $ProductInfo['airfare'];
    $proiduct_points_config['hotel'] =  $ProductInfo['hotel'];
    $proiduct_points_config['othersaving'] = $ProductInfo['othersaving'];
    $proiduct_points_config['remaining'] =  $ProductInfo['remaining'];

    $proiduct_points_config['freebag'] = $ProductInfo['freebag'];
    $proiduct_points_config['foreign_purchase'] =  $ProductInfo['foreign_purchase'];
    $proiduct_points_config['other_saving'] =  $ProductInfo['other_saving'];  //  Fix Saving Other Then Spending area

    $proiduct_points_config['annualFeeFirstYear'] =  $ProductInfo['annualFeeFirstYear'];
    $proiduct_points_config['annualFeeOngoingYear'] =  $ProductInfo['annualFeeOngoingYear'];

    $proiduct_points_config['value_per_point_default'] = $ProductInfo['value_per_point_default'];
    $proiduct_points_config['value_per_point_hotel'] = $ProductInfo['value_per_point_hotel'];
    $proiduct_points_config['value_per_point_cash'] = $ProductInfo['value_per_point_cash'];

    //print_r($proiduct_points_config);

    // Point Earned Via Spending
    $user_input['remaining'] = $user_input['Monthly Spend'] - ($user_input['> Gas']
    + $user_input['> Dining']
    + $user_input['> Grocery']
    + $user_input['> Airfare']
    + $user_input['> Hotel']
    + $user_input['othersaving']) ;


    $monthly_spend =  '';//  Monthly Rewards
    $monthly_spend['gas'] =  $proiduct_points_config['gas'] *  $user_input['> Gas'];
    $monthly_spend['dinning']= $proiduct_points_config['dinning'] * $user_input['> Dining'];
    $monthly_spend['grocery']= $proiduct_points_config['grocery'] *  $user_input['> Grocery'];
    $monthly_spend['airfare']= $proiduct_points_config['airfare'] *  $user_input['airfare'];
    $monthly_spend['hotel'] =  $proiduct_points_config['hotel'] * $user_input['> Hotel'];
    $monthly_spend['othersaving'] = $proiduct_points_config['othersaving'] *  $user_input['othersaving'];
    $monthly_spend['remaining'] =  $proiduct_points_config['remaining'] *  $user_input['remaining'];
    $total_monthly_spend  =   $monthly_spend['gas']
    + $monthly_spend['dinning']
    + $monthly_spend['grocery']
    + $monthly_spend['airfare']
    + $monthly_spend['hotel']
    + $monthly_spend['othersaving']
    + $monthly_spend['remaining'];

    $result_set['total_monthly_spend']	 =  $total_monthly_spend;

    $yearly_spend =  '';//  Monthly Rewards
    $yearly_spend['gas'] =  $proiduct_points_config['gas'] *  $user_input['> Gas'] * 12;
    $yearly_spend['dinning']= $proiduct_points_config['dinning'] * $user_input['> Dining'] * 12;
    $yearly_spend['grocery']= $proiduct_points_config['grocery'] *  $user_input['> Grocery'] * 12;
    $yearly_spend['airfare']= $proiduct_points_config['airfare'] *  $user_input['> Airfare'] * 12;
    $yearly_spend['hotel'] =  $proiduct_points_config['hotel'] * $user_input['> Hotel'] * 12;
    $yearly_spend['othersaving'] = $proiduct_points_config['othersaving'] *  $user_input['othersaving'] * 12;
    $yearly_spend['remaining'] =  $proiduct_points_config['remaining'] *  $user_input['remaining'] * 12;
    $total_yearly_spend = 	 $yearly_spend['gas']
    +	 $yearly_spend['dinning']
    +  $yearly_spend['grocery']
    +  $yearly_spend['airfare']
    +  $yearly_spend['hotel']
    +  $yearly_spend['othersaving']
    +  $yearly_spend['remaining'] ;
    $result_set['total_yearly_spend']  = $total_yearly_spend;

    // Point Earned Via Bonus
    $proiduct_points_config['signon']	=  $ProductInfo['signon'];
    $proiduct_points_config['threshold'] = $ProductInfo['threshold'];
    $proiduct_points_config['thresholdperiod'] = $ProductInfo['thresholdperiod'];
    if($proiduct_points_config['threshold'] !=  0 && $proiduct_points_config['thresholdperiod'] != 0)
    $monthly_threshold =  $proiduct_points_config['threshold'] / $proiduct_points_config['thresholdperiod'];
    else
    $monthly_threshold =  0;

    $result_set['monthly_threshold']=  $monthly_threshold;
    //  Bouns  Earned
    $b_onus_earned =  '';
    if( ( $total_monthly_spend >=  $monthly_threshold  ||  $proiduct_points_config['threshold'] == 0 ) && ($proiduct_points_config['signon'] !=  ''))
    $b_onus_earned =  $proiduct_points_config['signon'];
    else
    $b_onus_earned =  0 ;
    $result_set['b_onus_earned']=  $b_onus_earned;
    //  Annual Default Rewards
    $proiduct_points_config['annualRewards'] =  $ProductInfo['annualRewards'];
    $proiduct_points_config['annualThreshold'] =  $ProductInfo['annualThreshold'];
    if( $proiduct_points_config['annualRewards']  < 100)
    $annual_rewards =  $total_yearly_spend * $proiduct_points_config['annualRewards'];
    else
    $annual_rewards =   $proiduct_points_config['annualRewards'];

    $result_set['annual_rewards']=  $annual_rewards;

    if($proiduct_points_config['annualThreshold']  != 0   &&  $proiduct_points_config['annualThreshold']   != '' ){

        $temp =  $total_monthly_spend * 12;

        if($temp >= $proiduct_points_config['annualThreshold'] )
        $annual_b_onus_earned = $annual_rewards;
        else
        $annual_b_onus_earned = 0;
    }else {
        $annual_b_onus_earned = $annual_rewards;
    }
    $result_set['annual_b_onus_earned'] = $annual_b_onus_earned;
    //  Total Earned  Point First Year
    $total_point_earned_first_year =  $annual_b_onus_earned + $b_onus_earned + $total_yearly_spend   ;
    $result_set['total_point_earned_first_year'] = $total_point_earned_first_year;
    //  Total Earned  Point OnGoing Year
    $total_point_earned_ongoing_year = $annual_rewards + $total_yearly_spend ;
    $result_set['total_point_earned_ongoing_year'] = $total_point_earned_ongoing_year;
    // Bag  Saving
    $bag_saving  =  $proiduct_points_config['freebag'] *  $user_input['freebag'];
    $result_set['bag_saving'] =  $bag_saving;
    // Foreign purchase Saving
    $foreign_purchase_saving = $proiduct_points_config['foreign_purchase'] *  $user_input['Foreign Purchases (per year)'];
    $result_set['foreign_purchase_saving'] =  $foreign_purchase_saving;
    //Other Saving  Lounge access
    if($proiduct_points_config['other_saving'] != 0  &&  $proiduct_points_config['other_saving'] != ''){
        if( $user_input['other_saving'] == 'YES'  ){
            if($proiduct_points_config['other_saving'] ==  'YES')
            $other_saving  =  100;
            else
            $other_saving  =  100;
        }
        else
        $other_saving  = 100;
    }else
    $other_saving = 100;


    $result_set['other_saving']  =  $other_saving;

    //  Total Saving First  Year
    $total_default_saving_first_year  =  ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_default']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeFirstYear'];
    $total_hotel_saving_first_year  =  ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_hotel']) + $bag_saving + $foreign_purchase_saving + $other_saving  - $proiduct_points_config['annualFeeFirstYear'];
    $total_cash_saving_first_year  =   ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_cash']) + $bag_saving + $foreign_purchase_saving  - $proiduct_points_config['annualFeeFirstYear'];

    $result_set['total_default_saving_first_year']  =  $total_default_saving_first_year;
    $result_set['total_hotel_saving_first_year']  =  $total_hotel_saving_first_year;
    $result_set['total_cash_saving_first_year']  =  $total_cash_saving_first_year;

    //  Total Saving Ongoing Year
    $total_default_saving_ongoing_year  =  ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_default']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeOngoingYear'];
    $total_hotel_saving_ongoing_year  =  ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_hotel']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeOngoingYear'];
    $total_cash_saving_ongoing_year  =   ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_cash']) + $bag_saving + $foreign_purchase_saving  - $proiduct_points_config['annualFeeOngoingYear'];

    $result_set['total_default_saving_ongoing_year']  =  $total_default_saving_ongoing_year;
    $result_set['total_hotel_saving_ongoing_year']  =  $total_hotel_saving_ongoing_year;
    $result_set['total_cash_saving_ongoing_year']  =  $total_cash_saving_ongoing_year;


    // End Calculation
    //print_r($result_set);
    return ($result_set);
}
function calcaluteTotalRewardsPoint2 ($proId,$fieldsset_id){
    global $dclass;
    //  set the  User Input
    //print_r($fieldsset_id);
    $user_input  = '';
    foreach  ($fieldsset_id	as $key  => $val){
        $rsFields =  $dclass->query(" SELECT * FROM tbl_fields WHERE  id  =  ".$key." AND refine_search='1'");
        if(!empty($rsFields)){
            $rowQuetion = mysql_fetch_assoc($rsFields);
            $user_input[$rowQuetion['caption']] = $val;
        }
    }
    //print_r($user_input);
    //print_r($user_input);
    //echo $proId."<br>";

    //  Result Set Of Calculation
    $result_set =  array();


    //  GEt  the  Product Info
    $ProductInfo = '' ;  //  Procuct value Set  On Edit
    if($proId != ''){
        $rsProduct  =  $dclass->select(" * " ,"tbl_product_option"," AND  product_id =".$proId);
        if(!empty($rsProduct)){
            foreach($rsProduct as  $rowProduct){
                $ProductInfo[$rowProduct['v_name']] =  $rowProduct['l_values'];
            }
        }else{
            $ProductInfo = '';
        }
    }
    $proiduct_points_config  = ''; //  Product Rewards On User Spend
    $proiduct_points_config['gas'] =  $ProductInfo['gas'];
    $proiduct_points_config['dinning']= $ProductInfo['dinning'];
    $proiduct_points_config['grocery']=$ProductInfo['grocery'];
    $proiduct_points_config['airfare']= $ProductInfo['airfare'];
    $proiduct_points_config['hotel'] =  $ProductInfo['hotel'];
    $proiduct_points_config['othersaving'] = $ProductInfo['othersaving'];
    $proiduct_points_config['remaining'] =  $ProductInfo['remaining'];

    $proiduct_points_config['freebag'] = $ProductInfo['freebag'];
    $proiduct_points_config['foreign_purchase'] =  $ProductInfo['foreign_purchase'];
    $proiduct_points_config['other_saving'] =  $ProductInfo['other_saving'];  //  Fix Saving Other Then Spending area

    $proiduct_points_config['annualFeeFirstYear'] =  $ProductInfo['annualFeeFirstYear'];
    $proiduct_points_config['annualFeeOngoingYear'] =  $ProductInfo['annualFeeOngoingYear'];

    $proiduct_points_config['value_per_point_default'] = $ProductInfo['value_per_point_default'];
    $proiduct_points_config['value_per_point_hotel'] = $ProductInfo['value_per_point_hotel'];
    $proiduct_points_config['value_per_point_cash'] = $ProductInfo['value_per_point_cash'];

    //print_r($proiduct_points_config);

    // Point Earned Via Spending
    $user_input['remaining'] = $user_input['Monthly Spend'] - ($user_input['> Gas']
    + $user_input['> Dining']
    + $user_input['> Grocery']
    + $user_input['> Airfare']
    + $user_input['> Hotel']
    + $user_input['othersaving']) ;


    $monthly_spend =  '';//  Monthly Rewards
    $monthly_spend['gas'] =  $proiduct_points_config['gas'] *  $user_input['> Gas'];
    $monthly_spend['dinning']= $proiduct_points_config['dinning'] * $user_input['> Dining'];
    $monthly_spend['grocery']= $proiduct_points_config['grocery'] *  $user_input['> Grocery'];
    $monthly_spend['airfare']= $proiduct_points_config['airfare'] *  $user_input['airfare'];
    $monthly_spend['hotel'] =  $proiduct_points_config['hotel'] * $user_input['> Hotel'];
    $monthly_spend['othersaving'] = $proiduct_points_config['othersaving'] *  $user_input['othersaving'];
    $monthly_spend['remaining'] =  $proiduct_points_config['remaining'] *  $user_input['remaining'];
    $total_monthly_spend  =   $monthly_spend['gas']
    + $monthly_spend['dinning']
    + $monthly_spend['grocery']
    + $monthly_spend['airfare']
    + $monthly_spend['hotel']
    + $monthly_spend['othersaving']
    + $monthly_spend['remaining'];

    $result_set['total_monthly_spend']	 =  $total_monthly_spend;

    $yearly_spend =  '';//  Monthly Rewards
    $yearly_spend['gas'] =  $proiduct_points_config['gas'] *  $user_input['> Gas'] * 12;
    $yearly_spend['dinning']= $proiduct_points_config['dinning'] * $user_input['> Dining'] * 12;
    $yearly_spend['grocery']= $proiduct_points_config['grocery'] *  $user_input['> Grocery'] * 12;
    $yearly_spend['airfare']= $proiduct_points_config['airfare'] *  $user_input['> Airfare'] * 12;
    $yearly_spend['hotel'] =  $proiduct_points_config['hotel'] * $user_input['> Hotel'] * 12;
    $yearly_spend['othersaving'] = $proiduct_points_config['othersaving'] *  $user_input['othersaving'] * 12;
    $yearly_spend['remaining'] =  $proiduct_points_config['remaining'] *  $user_input['remaining'] * 12;
    $total_yearly_spend = 	 $yearly_spend['gas']
    +	 $yearly_spend['dinning']
    +  $yearly_spend['grocery']
    +  $yearly_spend['airfare']
    +  $yearly_spend['hotel']
    +  $yearly_spend['othersaving']
    +  $yearly_spend['remaining'] ;
    $result_set['total_yearly_spend']  = $total_yearly_spend;

    // Point Earned Via Bonus
    $proiduct_points_config['signon']	=  $ProductInfo['signon'];
    $proiduct_points_config['threshold'] = $ProductInfo['threshold'];
    $proiduct_points_config['thresholdperiod'] = $ProductInfo['thresholdperiod'];
    if($proiduct_points_config['threshold'] !=  0 && $proiduct_points_config['thresholdperiod'] != 0)
    $monthly_threshold =  $proiduct_points_config['threshold'] / $proiduct_points_config['thresholdperiod'];
    else
    $monthly_threshold =  0;

    $result_set['monthly_threshold']=  $monthly_threshold;
    //  Bouns  Earned
    $b_onus_earned =  '';
    if( ( $total_monthly_spend >=  $monthly_threshold  ||  $proiduct_points_config['threshold'] == 0 ) && ($proiduct_points_config['signon'] !=  ''))
    $b_onus_earned =  $proiduct_points_config['signon'];
    else
    $b_onus_earned =  0 ;
    $result_set['b_onus_earned']=  $b_onus_earned;
    //  Annual Default Rewards
    $proiduct_points_config['annualRewards'] =  $ProductInfo['annualRewards'];
    $proiduct_points_config['annualThreshold'] =  $ProductInfo['annualThreshold'];
    if( $proiduct_points_config['annualRewards']  < 100)
    $annual_rewards =  $total_yearly_spend * $proiduct_points_config['annualRewards'];
    else
    $annual_rewards =   $proiduct_points_config['annualRewards'];

    $result_set['annual_rewards']=  $annual_rewards;

    if($proiduct_points_config['annualThreshold']  != 0   &&  $proiduct_points_config['annualThreshold']   != '' ){

        $temp =  $total_monthly_spend * 12;

        if($temp >= $proiduct_points_config['annualThreshold'] )
        $annual_b_onus_earned = $annual_rewards;
        else
        $annual_b_onus_earned = 0;
    }else {
        $annual_b_onus_earned = $annual_rewards;
    }
    $result_set['annual_b_onus_earned'] = $annual_b_onus_earned;
    //  Total Earned  Point First Year
    $total_point_earned_first_year =  $annual_b_onus_earned + $b_onus_earned + $total_yearly_spend   ;
    $result_set['total_point_earned_first_year'] = $total_point_earned_first_year;
    //  Total Earned  Point OnGoing Year
    $total_point_earned_ongoing_year = $annual_rewards + $total_yearly_spend ;
    $result_set['total_point_earned_ongoing_year'] = $total_point_earned_ongoing_year;
    // Bag  Saving
    $bag_saving  =  $proiduct_points_config['freebag'] *  $user_input['freebag'];
    $result_set['bag_saving'] =  $bag_saving;
    // Foreign purchase Saving
    $foreign_purchase_saving = $proiduct_points_config['foreign_purchase'] *  $user_input['Foreign Purchases (per year)'];
    $result_set['foreign_purchase_saving'] =  $foreign_purchase_saving;
    //Other Saving  Lounge access
    if($proiduct_points_config['other_saving'] != 0  &&  $proiduct_points_config['other_saving'] != ''){
        if( $user_input['other_saving'] == 'YES'  ){
            if($proiduct_points_config['other_saving'] ==  'YES')
            $other_saving  =  100;
            else
            $other_saving  =  100;
        }
        else
        $other_saving  = 100;
    }else
    $other_saving = 100;


    $result_set['other_saving']  =  $other_saving;

    //  Total Saving First  Year
    $total_default_saving_first_year  =  ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_default']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeFirstYear'];
    $total_hotel_saving_first_year  =  ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_hotel']) + $bag_saving + $foreign_purchase_saving + $other_saving  - $proiduct_points_config['annualFeeFirstYear'];
    $total_cash_saving_first_year  =   ($total_point_earned_first_year *  $proiduct_points_config['value_per_point_cash']) + $bag_saving + $foreign_purchase_saving  - $proiduct_points_config['annualFeeFirstYear'];

    $result_set['total_default_saving_first_year']  =  $total_default_saving_first_year;
    $result_set['total_hotel_saving_first_year']  =  $total_hotel_saving_first_year;
    $result_set['total_cash_saving_first_year']  =  $total_cash_saving_first_year;

    //  Total Saving Ongoing Year
    $total_default_saving_ongoing_year  =  ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_default']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeOngoingYear'];
    $total_hotel_saving_ongoing_year  =  ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_hotel']) + $bag_saving + $foreign_purchase_saving + $other_saving - $proiduct_points_config['annualFeeOngoingYear'];
    $total_cash_saving_ongoing_year  =   ($total_point_earned_ongoing_year *  $proiduct_points_config['value_per_point_cash']) + $bag_saving + $foreign_purchase_saving  - $proiduct_points_config['annualFeeOngoingYear'];

    $result_set['total_default_saving_ongoing_year']  =  $total_default_saving_ongoing_year;
    $result_set['total_hotel_saving_ongoing_year']  =  $total_hotel_saving_ongoing_year;
    $result_set['total_cash_saving_ongoing_year']  =  $total_cash_saving_ongoing_year;


    // End Calculation
    //print_r($result_set);
    return ($result_set);
}

/***PArent  Child  Combo

$id  Which All Id You Want to Select
$table  =  Table NAme  DB
$parent_id =  Parent id Field NAme db
$parent_id_value  = Parent Id Value
$selected_value  Value MAy  be  array  Or Sigle One
$selectIdSet  =  Value Of Id Select Box
$eventSet  =  value Of Id Select Box

**/

function  getParentChildCombo2 ($table,$id,$print_id,$parent_id,$parent_value,$ORDERBY = '',$selected_id,$selectIdSet  ,$eventSet  ){
    if($selectIdSet ==  '')
    $selectIdSet =  "CategoryList";

    $tree = '<select name="'.$selectIdSet.'" id="'.$selectIdSet.'" '.$eventSet.' class="span6 m-wrap" >';

    if ($ORDERBY != '' )
    $result= mysql_query("SELECT * FROM $table WHERE $parent_id = $parent_value ORDER BY $ORDERBY ASC");
    else
    $result= mysql_query("SELECT * FROM $table WHERE $parent_id = $parent_value");



    $tree .= '<option value="">Choose a category</option>';

    while ($row = mysql_fetch_assoc($result))
    {
        $checkSub= mysql_query("SELECT * FROM $table WHERE $parent_id =".$row[$id]);
        $num_rows = mysql_num_rows($checkSub);
        if($num_rows > 0){
            $disable = 'disabled="disabled"';
        }else{
            $disable = '';
        }
        //  Selected Value  Check
        if($selected_id != ''){
            if(is_array($selected_id) ){
                if(in_array($row[$id], $selected_id) ){
                    $selectedText = 'selected="selected"';
                }else {
                    $selectedText = '';
                }
            }else{
                if ($selected_id ==  $row[$id])
                $selectedText = 'selected="selected"';
                else
                $selectedText = '';
            }
        }else {
            $selectedText =  '';
        }
        //  Selected Check End

        $tree .= '<option value="'.$row[$id].'" '.$selectedText.'  '.$disable1.' >';
        $tree .= $row[$print_id];
        $tree .= '</option>';
        $tree .= $this->getChild2($table,$id,$print_id,$parent_id,$row[$id],1,$ORDERBY,$selected_id);
    }


    $tree .= '</select>';

    return ($tree);

}

function getChild2($table,$id,$print_id,$parent_id,$parent_id_value,$level,$ORDERBY = '',$selected_id)
{
    $response = '';
    if($ORDERBY != '' )
    $query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value ORDER BY $ORDERBY ASC" ;
    else
    $query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value ";

    $result = mysql_query($query) or die ('Database Error (' . mysql_errno() . ') ' . mysql_error());

    while ($row = mysql_fetch_assoc($result))
    {
        $checkSub= mysql_query("SELECT * FROM $table WHERE $parent_id =".$row[$id]);
        $num_rows = mysql_num_rows($checkSub);
        if($num_rows > 0){
            $disable = 'disabled="disabled"';
        }else{
            $disable = '';
        }

        if($selected_id != ''){
            if(is_array($selected_id) ){
                if(in_array($row[$id], $selected_id) ){
                    $selectedText = 'selected="selected"';
                }else {
                    $selectedText = '';
                }
            }else{
                if ($selected_id ==  $row[$id])
                $selectedText = 'selected="selected"';
                else
                $selectedText = '';
            }
        }else {
            $selectedText =  '';
        }



        $response .= '<option value="'.$row[$id].'" '.$selectedText.' '.$disable.'>';
        for ($i = 0; $i < ($level-1); $i++) $response .= '&nbsp;&nbsp;&nbsp;&nbsp;';
        $response .= '&nbsp;&nbsp;-&nbsp;'.$row[$print_id];
        $response .= '</option>';
        $response .= $this->getChild2($table,$id,$print_id,$parent_id,$row[$id],$level+1,$ORDERBY,$selected_id);
    }
    return $response;
}



function  getParentChildCombo3 ($table,$id,$print_id,$parent_id,$parent_value,$ORDERBY = '',$selected_id,$selectIdSet  ,$eventSet  ){
    global $dclass;

    if($selectIdSet ==  '')
    $selectIdSet =  "CategoryList";

    $tree = '<select name="'.$selectIdSet.'" id="'.$selectIdSet.'" '.$eventSet.' class="span6 m-wrap" >';

    if ($ORDERBY != '' )
    $result = $dclass->Select($table,"*"," AND $parent_id = $parent_value ORDER BY $ORDERBY ASC");
    else
    $result = $dclass->Select($table,"*"," AND $parent_id = $parent_value");


    $tree .= '<option value="">Choose a category</option>';

    foreach($result as $row)
    {
        $checkSub = $dclass->Select($table,"*"," AND $parent_id = $row[$id]");

        $num_rows = count($checkSub);
        if($num_rows > 0){
            $disable = 'disabled="disabled"';
        }else{
            $disable = '';
        }
        //  Selected Value  Check
        if($selected_id != ''){
            if(is_array($selected_id) ){
                if(in_array($row[$id], $selected_id) ){
                    $selectedText = 'selected="selected"';
                }else {
                    $selectedText = '';
                }
            }else{
                if ($selected_id ==  $row[$id])
                $selectedText = 'selected="selected"';
                else
                $selectedText = '';
            }
        }else {
            $selectedText =  '';
        }
        //  Selected Check End

        $tree .= '<option value="'.$row[$id].'" '.$selectedText.'   >';
        $tree .= $row[$print_id];
        $tree .= '</option>';
        $tree .= $this->getChild3($table,$id,$print_id,$parent_id,$row[$id],1,$ORDERBY,$selected_id);
    }


    $tree .= '</select>';

    return ($tree);

}



function getChild3($table,$id,$print_id,$parent_id,$parent_id_value,$level,$ORDERBY = '',$selected_id)
{


    global $dclass;

    $response = '';
    if($ORDERBY != '' )
    //$query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value ORDER BY $ORDERBY ASC" ;

    $query = $dclass->Select($table,"*"," AND $parent_id = $parent_id_value ORDER BY $ORDERBY ASC");

    else
    //$query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value ";

    $query = $dclass->Select($table,"*"," AND $parent_id = $parent_id_value");


    //$result = mysql_query($query) or die ('Database Error (' . mysql_errno() . ') ' . mysql_error());

    //while ($row = mysql_fetch_assoc($result))
    foreach($query as $row)

    {
        //$checkSub= mysql_query("SELECT * FROM $table WHERE $parent_id =".$row[$id]);

        $checkSub = $dclass->Select($table,"*"," AND $parent_id = $row[$id]");

        $num_rows = count($checkSub);
        if($num_rows > 0){
            $disable = 'disabled="disabled"';
        }else{
            $disable = '';
        }

        if($selected_id != ''){
            if(is_array($selected_id) ){
                if(in_array($row[$id], $selected_id) ){
                    $selectedText = 'selected="selected"';
                }else {
                    $selectedText = '';
                }
            }else{
                if ($selected_id ==  $row[$id])
                $selectedText = 'selected="selected"';
                else
                $selectedText = '';
            }
        }else {
            $selectedText =  '';
        }



        $response .= '<option value="'.$row[$id].'" '.$selectedText.' >';
        for ($i = 0; $i < ($level-1); $i++) $response .= '&nbsp;&nbsp;&nbsp;&nbsp;';
        $response .= '&nbsp;&nbsp;-&nbsp;'.$row[$print_id];
        $response .= '</option>';
        $response .= $this->getChild21($table,$id,$print_id,$parent_id,$row[$id],$level+1,$ORDERBY,$selected_id);
    }
    return $response;
}

function getChild21($table,$id,$print_id,$parent_id,$parent_id_value,$level,$ORDERBY = '',$selected_id)
{
    global $dclass;

    $response = '';
    if($ORDERBY != '' )
    //$query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value AND cms_publish='1' ORDER BY $ORDERBY ASC" ;

    $query = $dclass->Select($table,"*"," AND $parent_id = $parent_id_value AND status='0' ORDER BY $ORDERBY ASC");

    else
    //$query = "SELECT * FROM ".$table." where $parent_id = $parent_id_value AND cms_publish='1' ";

    $query = $dclass->Select($table,"*"," AND $parent_id = $parent_id_value AND status='0'");


    //$result = mysql_query($query) or die ('Database Error (' . mysql_errno() . ') ' . mysql_error());

    //while ($row = mysql_fetch_assoc($result))
    foreach($query as $row)
    {

        //$checkSub= mysql_query("SELECT * FROM $table WHERE $parent_id =".$row[$id]);

        $checkSub = $dclass->Select($table,"*"," AND $parent_id = $row[$id]");

        $num_rows = count($checkSub);
        if($num_rows > 0){
            $disable = 'disabled="disabled"';
        }else{
            $disable = '';
        }

        if($selected_id != ''){
            if(is_array($selected_id) ){
                if(in_array($row[$id], $selected_id) ){
                    $selectedText = 'selected="selected"';
                }else {
                    $selectedText = '';
                }
            }else{
                if ($selected_id ==  $row[$id])
                $selectedText = 'selected="selected"';
                else
                $selectedText = '';
            }
        }else {
            $selectedText =  '';
        }



        $response .= '<option value="'.$row[$id].'" '.$selectedText.' '.$disable.'>';
        for ($i = 0; $i < ($level-1); $i++) $response .= '&nbsp;&nbsp;&nbsp;&nbsp;';
        $response .= '&nbsp;&nbsp;-&nbsp;'.$row[$print_id];
        $response .= '</option>';
        $response .= $this->getChild21($table,$id,$print_id,$parent_id,$row[$id],$level+1,$ORDERBY,$selected_id);
    }
    return $response;
}




/*
* -------- function arguments --------
*   $array ........ array of objects
*   $sortby ....... the object-key to sort by
*   $direction ... 'asc' = ascending
* --------
*/
function object_to_array($data)
{
    if (is_array($data) || is_object($data))
    {
        $result = array();
        foreach ($data as $key => $value)
        {
            $result[$key] = object_to_array($value);
        }
        return $result;
    }
    return $data;
}


function sort_arr($array, $sortby, $direction='asc') {

    $sortedArr = array();
    $tmp_Array = array();

    foreach($array as $k => $v) {
        $tmp_Array[] = $v[$sortby];
    }

    if($direction=='asc'){
        asort($tmp_Array);
    }else{
        arsort($tmp_Array);
    }

    foreach($tmp_Array as $k=>$tmp){
        $sortedArr[] = $array[$k];
    }

    return $sortedArr;

}

function getAge($dob){
    return floor((time() - strtotime($dob))/31556926);
}

function ordinal($number){
    if($number % 100 > 10 && $number %100 < 14){
        $suffix = "th";
    }else{
        switch($number % 10){
            case 0:
            $suffix = "th";
            break;

            case 1:
            $suffix = "st";
            break;

            case 2:
            $suffix = "nd";
            break;

            case 3:
            $suffix = "rd";
            break;

            default:
            $suffix = "th";
            break;
        }
    }
    return "${number}<SUP>$suffix</SUP>";
}

//Recursive function to get round wise matches
function getbracketmatches($teamcount, $matchres = array(), $mtcnt = 0){
    $mtcnt++;
    $teamcount = $matchres[$mtcnt - 1][1] + $teamcount;
    $firstroundmatch = $teamcount / 2;
    if($firstroundmatch == 1){
        $matchres[$mtcnt] = array((int)$firstroundmatch,$remainder);
        return $matchres;
    }else{
        $remainder = $teamcount % 2;
        $matchres[$mtcnt] = array((int)$firstroundmatch,$remainder);
        return $this->getbracketmatches((int)$firstroundmatch,$matchres,$mtcnt);
    }
}

function time_elapsed_B($secs){
    $bit = array(
        /*'year'        => $secs / 31556926 % 12,
        'week'        => $secs / 604800 % 52,
        'day'        => $secs / 86400 % 7,*/
        'hour'        => $secs / 3600 % 24,
        'minute'    => $secs / 60 % 60,
        'second'    => $secs % 60
    );

    foreach($bit as $k => $v){
        if($v > 9){
            $ret[] = $v.":";
        }else if($v >= 0 && $v < 10){
            $ret[] = "0".$v.":";
        }
    }

    if(count($ret) > 0){
        if(count($ret) > 1){
            array_splice($ret, count($ret)-1,0,'');
        }
        $ret[] = '';

    }else{

        $ret[] =  '';
    }
    return rtrim(join('', $ret),":");
}
function getAdminRole($role_id){
    global $dclass;
    $adminrole = $dclass->getvalue("tbl_usertype","name","usertype_id = :usertype_id",array("usertype_id" => $role_id));
    return $adminrole;
}
function getterms_of_use(){
    global $dclass;
    $terms_of_use = $dclass->getrow("tbl_cms","*","cms_id = :cms_id",array("cms_id" => 7));
    return $terms_of_use['cms_description'];
}
function getterms_and_conditions(){
    global $dclass;
    $terms_and_conditions = $dclass->getrow("tbl_cms","*","cms_id = :cms_id",array("cms_id" => 8));
    return $terms_and_conditions['cms_description'];
}
function add_commission($user_id,$plan_id,$vehicle_id){
    global $dclass;
    $user_info = $dclass->getrow("tbl_adminuser","usertype_id,addedbyuser_id","user_id = :user_id",array("user_id" => $user_id));
    $salesmancommission = $dclass->getrow("tbl_salesmancommission","commission_price","user_id = :user_id AND plan_id = :plan_id AND commission_type = :commission_type",array("user_id" => $user_id, "plan_id" => $plan_id, "commission_type" => 0));

    $datetime = date("Y-m-d H:i:s");

    $vehiclesales_array = array(
        "user_id" => $user_id,
        "vehicle_id" => $vehicle_id,
        "plan_id" => $plan_id,
        "commission_price" => $salesmancommission['commission_price'],
        "commission_type" => 0,
        "datetime" => $datetime
    );
    $dclass->insert("tbl_vehiclesales_detail","user_id, vehicle_id, plan_id, commission_price, commission_type, datetime",":user_id, :vehicle_id, :plan_id, :commission_price, :commission_type, :datetime",$vehiclesales_array);

    if($user_info['usertype_id'] == 1){
        $salesmancommission = $dclass->getrow("tbl_salesmancommission","commission_price","user_id = :user_id AND plan_id = :plan_id AND commission_type = :commission_type",array("user_id" => $user_info['addedbyuser_id'], "plan_id" => $plan_id, "commission_type" => 1));

        $vehiclesales_array = array(
            "user_id" => $user_info['addedbyuser_id'],
            "vehicle_id" => $vehicle_id,
            "plan_id" => $plan_id,
            "commission_price" => $salesmancommission['commission_price'],
            "commission_type" => 1,
            "datetime" => $datetime
        );
        $dclass->insert("tbl_vehiclesales_detail","user_id, vehicle_id, plan_id, commission_price, commission_type, datetime",":user_id, :vehicle_id, :plan_id, :commission_price, :commission_type, :datetime",$vehiclesales_array);
    }
}

function getsalesmanagerBySitemanager($siteManagerId){
    global $dclass;
    $salesmanagers = $dclass->select("tbl_adminuser","user_id"," AND addedbyuser_id = {$siteManagerId} AND usertype_id = 2");
    $salesmanager_str = "";
    if(!empty($salesmanagers)){
        $salesmanager_arr = array();
        foreach($salesmanagers as $salesmanager){
            $salesmanager_arr[] = $salesmanager['user_id'];
        }
        $salesmanager_str = implode(",",$salesmanager_arr);
    }
    return ($salesmanager_str);
}

function getsalesmanBysalesmanager($salesManagerIds){
    global $dclass;
    $salesmen = $dclass->select("tbl_adminuser","user_id"," AND addedbyuser_id IN ({$salesManagerIds}) AND usertype_id = 1");
    $salesman_str = "";
    if(!empty($salesmen)){
        $salesman_arr = array();
        foreach($salesmen as $salesman){
            $salesman_arr[] = $salesman['user_id'];
        }
        $salesman_str = implode(",",$salesman_arr);
    }
    return ($salesman_str);
}

function getDurationByServicetype($servicetype){
    $duration = "";
    if($servicetype == 1){
        $duration = "30 mins";
    }else if($servicetype == 2){
        $duration = "45 mins";
    }else if($servicetype == 3){
        $duration = "120 mins";
    }
    return ($duration);
}

function getAdminId(){
    global $dclass;
    $adminId = $dclass->getvalue("tbl_adminuser","user_id","usertype_id = :usertype_id",array("usertype_id" => 5));
    return ($adminId);
}

function read_contact_msg($receiver_id){
    global $dclass;
    $dclass->update("tbl_contact_admin","read_status = :read_status","receiver_id = :receiver_id",array("read_status" => "1", "receiver_id" => $receiver_id));
    return ("1");
}
function read_contact_msg_by_sitemngr($receiver_id,$sender_id){
    global $dclass;
    $dclass->update("tbl_contact_admin","read_status = :read_status","receiver_id = :receiver_id AND sender_id = :sender_id",array("read_status" => "1", "receiver_id" => $receiver_id, "sender_id" => $sender_id));
    return ("1");
}

function getServiceName($servicetype_id){
    global $dclass;
    $service_name = $dclass->getvalue("tbl_servicetype","name","servicetype_id = :servicetype_id",array("servicetype_id" => $servicetype_id));
    return($service_name);
}

function displayServiceChecklist($servicetype_id,$jobcard_id){
    global $dclass;
    $servicechecklists = $dclass->select("tbl_servicechecklist","*"," AND parent_id = 0 AND servicetype_id = {$servicetype_id}");
    $jobcard_checklist = array();
    if($jobcard_id != ""){
        $get_jobcard_checklists = $dclass->select("tbl_jobcard_detail","*"," AND jobcard_id = {$jobcard_id}");
        foreach($get_jobcard_checklists as $get_jobcard_checklist){
            $jobcard_checklist[] = $get_jobcard_checklist['servicechecklistdetail_id'];
        }
    }
    $service_name = $this->getServiceName($servicetype_id);


    $output = '<table class="service_type_table" style="width:780px;border-collapse:collapse;" border="1">';

    $output .= '<tr>';
    $output .= '<td class="pad-zero">';
    $output .= '<table style="border-collapse:collapse;" border="1" width="702">';
    $output .= '<tr>';
    $output .= '<th class="text-center" style="background-color: #cc0000;color:#fff;width:100%;">'.$service_name.' Service</th>';
    $output .= '</tr>';
    $output .= '</table>';
    $output .= '</td>';
    $output .= '</tr>';

    foreach($servicechecklists as $servicechecklist){
        $servicechecklistdetails = $dclass->select("tbl_servicechecklist","*"," AND parent_id = {$servicechecklist['servicechecklist_id']}");
        //echo "<pre>";print_r($servicechecklistdetails);echo "</pre>";

        $output .= '<tr>';
        $output .= '<td colspan="3" class="redtd" style="background-color: #cc0000;color: #fff;">'.$servicechecklist['name'].'</td>';
        $output .= '</tr>';
        $output .= '<tr>';
        $output .= '<td colspan="3">';
        $output .= '<table style="width:780px;float:left;border-collapse:collapse;" border="1">';
        foreach($servicechecklistdetails as $servicechecklistdetail){
            $servicechecklistvalues = $dclass->select("tbl_servicechecklistdetail","*"," AND servicechecklist_id = {$servicechecklistdetail['servicechecklist_id']}");
            $checked1 = "";
            $checked2 = "";
            $checked3 = "";
            $td_bg1 = "";
            $td_bg2 = "";
            $td_bg3 = "";

            if(count($servicechecklistvalues) == 1){
                if($servicechecklistvalues[0]['checklist_value'] != ""){
                    $checked1 = 'checked="checked"';
                    $td_bg1 = 'background-color:#ffc000';
                }
                if($servicechecklistvalues[1]['checklist_value'] != ""){
                    $checked2 = 'checked="checked"';
                    $td_bg2 = 'background-color:#ffc000';
                }
                if($servicechecklistvalues[2]['checklist_value'] != ""){
                    $checked3 = 'checked="checked"';
                    $td_bg3 = 'background-color:#ffc000';
                }
            }
            if($servicechecklistvalues[1]['servicechecklistdetail_id'] == "90"){
                $checked2 = 'checked="checked"';
                $td_bg2 = 'background-color:#ffc000';
            }
            if (in_array($servicechecklistvalues[0]['servicechecklistdetail_id'], $jobcard_checklist)){
                $checked1 = 'checked="checked"';
                $td_bg1 = 'background-color:#ffc000';
            }
            if (in_array($servicechecklistvalues[1]['servicechecklistdetail_id'], $jobcard_checklist)){
                $checked2 = 'checked="checked"';
                $td_bg2 = 'background-color:#ffc000';
            }
            if (in_array($servicechecklistvalues[2]['servicechecklistdetail_id'], $jobcard_checklist)){
                $checked3 = 'checked="checked"';
                $td_bg3 = 'background-color:#ffc000';
            }
            if($servicechecklistvalues[0]['checklist_value'] != ""){
                $class1 = 'light_gray_td';
            }else{
                $class1 = 'dark_gray_td';
            }
            if($servicechecklistvalues[1]['checklist_value'] != ""){
                $class2 = 'light_gray_td';
            }else{
                $class2 = 'dark_gray_td';
            }
            if($servicechecklistvalues[2]['checklist_value'] != ""){
                $class3 = 'light_gray_td';
            }else{
                $class3 = 'dark_gray_td';
            }


            $output .= '<tr>';
            $output .= '<td style="width:30%">'.$servicechecklistdetail['name'].'</td>';
            $output .= '<td style="width:20%;'.$td_bg1.'" checklist-id="'.$servicechecklistvalues[0]['servicechecklistdetail_id'].'" class="'.$class1.'" checklist-group-id="'.$servicechecklistdetail['servicechecklist_id'].'">';
            if($servicechecklistvalues[0]['checklist_value'] != ""){
                $output .= $servicechecklistvalues[0]['checklist_value'];
            }
            $output .= '</td>';
            $output .= '<td style="width:20%;'.$td_bg2.'" checklist-id="'.$servicechecklistvalues[1]['servicechecklistdetail_id'].'" class="'.$class2.'" checklist-group-id="'.$servicechecklistdetail['servicechecklist_id'].'">';
            if($servicechecklistvalues[1]['checklist_value'] != ""){
                $output .= $servicechecklistvalues[1]['checklist_value'];
            }
            $output .= '</td>';
            $output .= '<td style="width:20%;'.$td_bg3.'" checklist-id="'.$servicechecklistvalues[2]['servicechecklistdetail_id'].'" class="'.$class3.'" checklist-group-id="'. $servicechecklistdetail['servicechecklist_id'].'">';
            if($servicechecklistvalues[2]['checklist_value'] != ""){
                $output .= $servicechecklistvalues[2]['checklist_value'];
            }
            $output .= '</td>';
            $output .= '</tr>';
        }
        $output .= '</table>';
        $output .= '</td>';
        $output .= '</tr>';
    }
    $output .= '</table>';
    return($output);
}

function displayJobcardImages($jobcard_id){
    global $dclass;
    $sitelink = $dclass->getvalue("tbl_setting","l_values"," v_name = :v_name",array("v_name" => 'SITELINK'));
    $jobcardimages = $dclass->select("tbl_jobcardimages","*"," AND jobcard_id = {$jobcard_id}");
    $output .= '<div class="full-width">';
    foreach($jobcardimages as $jobcardimage){
        $output .= '<span style="margin:0 10px 10px 0;float:left;"><img src="'.$sitelink.'imgs/jobcard/'.$jobcardimage['imagename'].'" width="150" /></span>';
    }
    $output .= "</div>";
    return($output);
}
function getSitemanagerByCustomer($customer_id){
    global $dclass;
    $customer_addedby_id = $dclass->getvalue("tbl_customer","addedbyuser_id"," user_id = :user_id",array("user_id" => $customer_id));
    $addedby_user_info = $dclass->getrow("tbl_adminuser","addedbyuser_id,usertype_id"," user_id = :user_id",array("user_id" => $customer_addedby_id));
    if($addedby_user_info['usertype_id'] == "1"){
        $addedby_user_info1 = $dclass->getrow("tbl_adminuser","addedbyuser_id,usertype_id"," user_id = :user_id",array("user_id" => $addedby_user_info['addedbyuser_id']));
        $sitemanager_id = $addedby_user_info1['addedbyuser_id'];
    }else{
        $sitemanager_id = $addedby_user_info['addedbyuser_id'];
    }
    return ($sitemanager_id);
}
}
