<?php header('Access-Control-Allow-Origin: *');
require_once '../include/DbHandler.php';
require_once '../include/PassHash.php';
require '.././libs/Slim/Slim.php';

\Slim\Slim::registerAutoloader();

$app = new \Slim\Slim(array(
    'debug' => true
));

require ('CorsSlim.php');
$corsOptions = array(
    "origin" => "*",
    "exposeHeaders" => array("Content-Type", "X-Requested-With", "X-authentication", "X-client"),
    "allowMethods" => array('GET', 'POST', 'PUT', 'DELETE', 'OPTIONS')
);

$cors = new \CorsSlim\CorsSlim($corsOptions);

$app->add($cors);
$user_id = NULL;
$api_key = NULL;
$site_url = 'http://kwmapp.opaldemo.com';

function authenticate(\Slim\Route $route) {
	//echo "Hee";die();
    // Getting request headers
    //$headers = apache_request_headers();
    $headers = $_SERVER;
    $response = array();
    $app = \Slim\Slim::getInstance();
    //print_r($_SERVER);
	//print_r($headers);
    // Verifying Authorization Header
    if (isset($headers['REDIRECT_HTTP_AUTHORIZATION'])) {
        $db = new DbHandler();
		global $api_key;
		//global $api_key;
        // get the api key
        $api_key = $headers['REDIRECT_HTTP_AUTHORIZATION'];
		//echo $api_key;
        // validating api key
        if (!$db->isValidApiKey($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
             //get user primary key id
            $user_id = $db->getUserId($api_key);
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * ----------- METHODS WITHOUT AUTHENTICATION ---------------------------------
 */
/**
 * User Registration
 * url - /register
 * method - POST
 * params - name, email, password
 */
$app->post('/register', function() use ($app) {
            // check for required params
            verifyRequiredParams(array('name', 'email', 'password'));

            $response = array();

            // reading post params
            $name = $app->request->post('name');
            $email = $app->request->post('email');
            $password = $app->request->post('password');

            // validating email address
            validateEmail($email);

            $db = new DbHandler();
            $res = $db->createUser($name, $email, $password);

            if ($res == USER_CREATED_SUCCESSFULLY) {
                $response["error"] = false;
                $response["message"] = "You are successfully registered";
            } else if ($res == USER_CREATE_FAILED) {
                $response["error"] = true;
                $response["message"] = "Oops! An error occurred while registereing";
            } else if ($res == USER_ALREADY_EXISTED) {
                $response["error"] = true;
                $response["message"] = "Sorry, this email already existed";
            }
            // echo json response
            echoRespnse(201, $response);
        });

/**
 * User Login
 * url - /login
 * method - POST
 * params - email, password
 */
$app->post('/login', function() use ($app) {
            // check for required params
			$json = $app->request->getBody();
			$data = json_decode($json, true);

			//die();
			// reading post params
            $email = $data['email'];
            $password = $data['password'];

            verifyRequiredParams(array('email', 'password'));


            $response = array();

            $db = new DbHandler();

            // check for correct email and password
            if ($db->checkLogin($email, $password)) {
                // get the user by email

                $user = $db->getUserByEmail($email);

                if ($user != NULL) {
					$api_key=$db->generateApiKey();

					$db->updateApikey($user['emailaddress'],$api_key);
					//print_r($user);
                    $response["error"] = false;
                    $response['firstname'] = $user['firstname'];
                    $response['lastname'] = $user['lastname'];
                    $response['emailaddress'] = $user['emailaddress'];
					$response['api_key'] = $api_key;
					$response['userImage'] = $user['userImage'];
                } else {
                    // unknown error occurred
                    $response['error'] = true;
                    $response['message'] = "An error occurred. Please try again";
                }
            } else {
                // user credentials are wrong
                $response['error'] = true;
                $response['message'] = 'Login failed. Incorrect credentials';
            }

            echoRespnse(200, $response);
        });
/**
 * Update api_key to NULL
 * method POST
 * params - api_key
 * url - /logout
 */
$app->post('/logout',  function() {
            //echo "Hello"; die();
            $headers = apache_request_headers();
            //print_r($headers);
            $response = array();
            if (isset($headers['Authorization'])) {
                $db = new DbHandler();
                $api_key = $headers['Authorization'];
                $val = $db->updateApikey('',$api_key);
                if($val){
                    $response["error"] = false;
                }else{
                    $response["error"] = true;
                }
            }else{
                $response["error"] = true;
            }
            $response["error"] = false;
            //print_r($response);
            echoRespnse(200, $response);

        });
/*
 * ------------------------ METHODS WITH AUTHENTICATION ------------------------
 */

/**
 * Listing all tasks of particual user
 * method GET
 * url /tasks
 */
$app->get('/warningLights', 'authenticate', function() {
            $response = array();
            $db = new DbHandler();

            // fetching all user tasks
            $result = $db->getWarningLights();

            $response["error"] = false;
            $response["warningLights"] = array();

            // looping through result and preparing tasks array
            while ($warningLights = $result->fetch_assoc()) {
                $tmp = array();
                $tmp["cms_id"] = $warningLights["cms_id"];
                $tmp["cms_title"] = $warningLights["cms_title"];
                $tmp["cms_icon"] = $warningLights["cms_icon"];
				$tmp["cms_description"] = strip_tags($warningLights["cms_description"]);
                array_push($response["warningLights"], $tmp);
            }
			//print_r($response);
            echoRespnse(200, $response);
        });

/**
 * Listing single task of particual user
 * method GET
 * url /tasks/:id
 * Will return 404 if the task doesn't belongs to user
 */
$app->get('/warningLights/:id', 'authenticate', function($cms_id) {
            $response = array();
            $db = new DbHandler();

            // fetch task
            $result = $db->getWarningLight($cms_id);

            if ($result != NULL) {
                $response["error"] = false;
                $response["cms_id"] = $result["cms_id"];
                $response["cms_title"] = $result["cms_title"];
                $response["cms_description"] = $result["cms_description"];
                $response["cms_icon"] = $result["cms_icon"];
                echoRespnse(200, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "The requested resource doesn't exists";
                echoRespnse(404, $response);
            }
        });
/**
 * Get All Customer Data
 * method GET
 * url /getCustomer
 * Will return 404 if the task doesn't belongs to user
 */
$app->get('/getCustomer', 'authenticate', function() {
            $response = array();
            $db = new DbHandler();
			global $user_id;
            // fetch task
            $result = $db->getCustomer($user_id);
			//print_r($result);
			//die();
            if ($result != NULL) {
                $response["error"] = false;

                $data = $result->fetch_assoc();
				$response["customer"] = $data;

                echoRespnse(200, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "The requested resource doesn't exists";
                echoRespnse(404, $response);
            }
        });
/**
 * Listing all Customer Car
 * method GET
 * url /tasks
 */
$app->get('/getCustomerCar', 'authenticate', function() {
            $response = array();
            $db = new DbHandler();
			global $user_id;
			//echo $user_id;die();
            // fetching all user tasks
            $result = $db->getCustomerCar($user_id);

            $response["error"] = false;
            $response["cars"] = $result;

            // looping through result and preparing tasks array

			//print_r($response);
            echoRespnse(200, $response);
        });

/**
 * Creating new Location in db
 * method POST
 * params - lat,Lon
 * url - /loackLocation/
 */
$app->post('/loackLocation', 'authenticate', function() use ($app) {
            // check for required params

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            verifyRequiredParams(array('lat', 'lan', 'minutes'));
            $response = array();
			global $user_id;
			global $api_key;

			//echo "Tes".$message;
			//echo "<br/>".$user_id;
            //die();
            $db = new DbHandler();


			$datetime = date('Y-m-d H:i:s', strtotime("+".$request_params['minutes']." minutes"));
            // creating new task
            $task_id = $db->createLockLocation($user_id, $request_params['lat'], $request_params['lan'], $datetime, $api_key);

            if ($task_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Location saved successfully";
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Failed to save data. Please try again";
                echoRespnse(200, $response);
            }
        });

		/**
 * Creating new Location in db
 * method GET
 * params -
 * url - /getCarLocation/
 */
$app->get('/getCarLocation', 'authenticate', function() {

            $response = array();
			global $user_id;
			global $api_key;

            $db = new DbHandler();

			$response["car_location"] = array();
            $result = $db->getCarLocation($user_id, $api_key);

            if ($result != NULL) {
                $response["error"] = false;
				while ($car_location = $result->fetch_assoc()) {
					$tmp = array();
					$tmp["latitude"] = $car_location["latitude"];
					$tmp["longitude"] = $car_location["longitude"];
					$tmp["end_datetime"] = $car_location["end_datetime"];
					array_push($response["car_location"], $tmp);
				}

                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Failed to save data. Please try again";
                echoRespnse(200, $response);
            }
        });
/**
 * Creating new Inquiry in db
 * method POST
 * params - name
 * url - /customerinquiry/
 */
$app->post('/customerinquiry', 'authenticate', function() use ($app) {
            // check for required params

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            verifyRequiredParams(array('description'));
			$message = $request_params['description'];
            $response = array();
			global $user_id;

			//echo "Tes".$message;
			//echo "<br/>".$user_id;
            //die();
            $db = new DbHandler();

            // creating new task
            $task_id = $db->createCustomerInquiry($user_id, $message);

            if ($task_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Inquiry created successfully";
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Failed to create online Inquiry. Please try again";
                echoRespnse(200, $response);
            }
        });

/**
 * Creating new Inquiry in db
 * method POST
 * params - name
 * url - /customerinquiry/


 */
 $app->post('/updateCustomerPhoto', 'authenticate', function() use ($app) {
            // check for required params

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            //verifyRequiredParams(array('$json'));
			//echo $json;die();
            $response = array();
			global $user_id;
            $db = new DbHandler();
			$profilepic = $request_params;

            // creating new task
            $customer_id = $db->updateCustomerPhoto($user_id, $profilepic);
            if ($customer_id != NULL) {
				rename('../tmp/'.$profilepic, '../../imgs/customer/'.$profilepic);
                $response["error"] = false;
                $response["message"] = "Profile Successfully Updated";
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Error!!! Please try again";
                echoRespnse(200, $response);
            }
        });


$app->post('/updateCustomer', 'authenticate', function() use ($app) {
            // check for required params

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email'));
            $response = array();
			global $user_id;
            $db = new DbHandler();
            // creating new task
            $customer_id = $db->updateCustomer($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email']);
            if ($customer_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Profile Successfully Updated";
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Error!!! Please try again";
                echoRespnse(200, $response);
            }
        });

		$app->post('/getAvailableDateTime', 'authenticate', function() use ($app) {

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			$current_date = $request_params;
			$date = new DateTime($current_date);
			$date->modify('+1 day');
			$match_database_date = $date->format('Y-m-d');
			$response = array();
			global $user_id;
            $db = new DbHandler();
			$data = $db->getAvailableDateTime($match_database_date, $user_id);
			$response["error"] = false;
			$response["event"] = $data;
            echoRespnse(200, $response);

		});
		$app->get('/getMyService', 'authenticate', function() use ($app) {
			global $user_id;
            $db = new DbHandler();
			$data = $db->getMyService($user_id);
			$response["error"] = false;
			$response["booking"] = $data;
            echoRespnse(200, $response);

		});
		$app->get('/getMyBooking', 'authenticate', function() use ($app) {

			global $user_id;
            $db = new DbHandler();
			$data = $db->getMyBooking($user_id);
			$response["error"] = false;
			$response["booking"] = $data;
            echoRespnse(200, $response);

		});

		/**
 * Creating new Inquiry in db
 * method POST
 * params - name
 * url - /customerinquiry/
 */
$app->post('/createBooking', 'authenticate', function() use ($app) {
            // check for required params

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            verifyRequiredParams(array('car', 'car_time'));
            $response = array();
			global $user_id;
            $db = new DbHandler();

			//Create New Booking
			$vehicle_id = $request_params['car'];
			$booking_c_time = $request_params['car_time'];


			//die();
			$location_address = $request_params['address'];
			$pickup_time = $request_params['pickup_time'];
			$dropoff_time = $request_params['dropoff_time'];
			$plan_id = $request_params['plan_id'];
			$getTotalService = $db->getTotalService($vehicle_id);
			$service_id = $db->getServiceId($plan_id, $getTotalService);

			//$service_id = 1;
			//echo "test".$plan_id;die();
			if($service_id != "" && $service_id > 0 && $service_id != NULL){
				$duration = $db->GetServiceDuration($service_id);				//die();
				$tz = new DateTimeZone('Etc/GMT+12');
				$date = new DateTime($booking_c_time);
				$date->setTimezone($tz);
				$date->modify('+1 day');
				$booking_time = $date->format('Y-m-d H:i:s');

				$date->add(new DateInterval('PT' . (int)$duration . 'M'));
				$booking_end_time = $date->format('Y-m-d H:i:s');


				$booking_id = $db->insertBooking($service_id, $user_id, $vehicle_id, $booking_time, $location_address, $pickup_time, $dropoff_time, $duration, $booking_end_time );
				$response["error"] = false;
                $response["message"] = "Booking done successfully";
                echoRespnse(201, $response);
			}else{
				$response["error"] = true;
                $response["message"] = "You have reached the maximum number of Allowed services. Please contact sales Manager";
                echoRespnse(200, $response);
			}
        });
/**
 * Show Customer Feedback
 * method GET
 * params -
 * url - /customerFeedback/
 */
$app->get('/customerFeedback', 'authenticate', function() {


			global $user_id, $site_url;
            $db = new DbHandler();
            // creating new task

			$admin_user = $db->getSitemanagerByCustomer($user_id);
			$admin_user_array = $db->getAdminUser($admin_user);
			//$response["sales_manager"] = $admin_user_array;

			$customer_data_result = $db->getCustomer($user_id);
			$customer_data = $customer_data_result->fetch_assoc();


            $result = $db->getUserFeedback($user_id);
			$response["feedback"] = array();
			if ($result) {
				// looping through result and preparing tasks array
				while ($feedback = $result->fetch_assoc()) {
					//print_r($feedback);
					$tmp = array();
					if($feedback['send_by'] == "1"){ // Customer

						$tmp["position"] = 'right';
						$tmp["senderName"] = 'Me';
						if($customer_data['profilepic'] == "" || $customer_data['profilepic'] == NULL){
							$profilepic = 'no-profile.jpg';
						}else{
							$profilepic = $customer_data['profilepic'];
						}
						$tmp["imgs"] = $site_url.'/imgs/customer/'.$profilepic;

					}else{ // Site Manager
						$tmp["position"] = 'left';
						$tmp["senderName"] = $admin_user_array['firstname'];
						if($admin_user_array['profilepic'] == "" || $admin_user_array['profilepic'] == NULL){
							$profilepic = 'no-profile.jpg';
						}else{
							$profilepic = $admin_user_array['profilepic'];
						}
						$tmp["imgs"] = $site_url.'/imgs/user/'.$profilepic;
					}
					//$tmp["sender_id"] = $feedback["sender_id"];
					//$tmp["cms_title"] = $feedback["cms_title"];
					//$tmp["receiver_id"] = $feedback["receiver_id"];
					//$tmp["send_by"] = $feedback['send_by'];
					$tmp["message"] = $feedback['message'];
					$tmp["conversation_datetime"] = $feedback['conversation_datetime'];
					$tmp["conversion_id"] = $feedback['conversation_id'];
					array_push($response["feedback"], $tmp);
				}

                $response["error"] = false;
                //$response["message"] = $result;
                echoRespnse(201, $response);
            } else {
                $response["error"] = false;
                //$response["message"] = "Error!!! Please try again";
                echoRespnse(200, $response);
            }
        });

/**
 * Creating new Message in db
 * method POST
 * params - name
 * url - /sendMessage/
 */
$app->post('/sendMessage', 'authenticate', function() use ($app) {

			$json = $app->request->getBody();
			$request_params = json_decode($json, true);
			//print_r($request_params);
            verifyRequiredParams(array('message'));
            $response = array();
			global $user_id;
			$db = new DbHandler();

			$sender_id = $user_id;
			$admin_user = $db->getSitemanagerByCustomer($user_id);
			$admin_user_array = $db->getAdminUser($admin_user);
			$receiver_id = $admin_user_array['user_id'];
			$send_by = 1;
			$conversation_datetime = date('Y-m-d H:i:s');
            if($request_params['conversion_id'] == 0){
				$convesation_id = $db->insertconversion($sender_id, $receiver_id, $conversation_datetime, '0');
			}else{
				$convesation_id = $request_params['conversion_id'];
			}
            // creating new task
            $customer_id = $db->insertMessage($sender_id, $receiver_id, $request_params['message'], $convesation_id , $conversation_datetime, $send_by);
            if ($customer_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Message send succesfully";
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Error!!! Please try again";
                echoRespnse(200, $response);
            }
        });

/**
 * Creating new task in db
 * method POST
 * params - name
 * url - /tasks/
 */
$app->post('/tasks', 'authenticate', function() use ($app) {
            // check for required params
            verifyRequiredParams(array('task'));

            $response = array();
            $task = $app->request->post('task');

            global $user_id;
            $db = new DbHandler();

            // creating new task
            $task_id = $db->createTask($user_id, $task);

            if ($task_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Task created successfully";
                $response["task_id"] = $task_id;
                echoRespnse(201, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Failed to create task. Please try again";
                echoRespnse(200, $response);
            }
        });

/**
 * Updating existing task
 * method PUT
 * params task, status
 * url - /tasks/:id
 */
$app->put('/tasks/:id', 'authenticate', function($task_id) use($app) {
            // check for required params
            verifyRequiredParams(array('task', 'status'));

            global $user_id;
            $task = $app->request->put('task');
            $status = $app->request->put('status');

            $db = new DbHandler();
            $response = array();

            // updating task
            $result = $db->updateTask($user_id, $task_id, $task, $status);
            if ($result) {
                // task updated successfully
                $response["error"] = false;
                $response["message"] = "Task updated successfully";
            } else {
                // task failed to update
                $response["error"] = true;
                $response["message"] = "Task failed to update. Please try again!";
            }
            echoRespnse(200, $response);
        });

/**
 * Deleting task. Users can delete only their tasks
 * method DELETE
 * url /tasks
 */
$app->delete('/tasks/:id', 'authenticate', function($task_id) use($app) {
            global $user_id;

            $db = new DbHandler();
            $response = array();
            $result = $db->deleteTask($user_id, $task_id);
            if ($result) {
                // task deleted successfully
                $response["error"] = false;
                $response["message"] = "Task deleted succesfully";
            } else {
                // task failed to delete
                $response["error"] = true;
                $response["message"] = "Task failed to delete. Please try again!";
            }
            echoRespnse(200, $response);
        });

/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields) {
    $error = false;
    $error_fields = "";
    $request_params = array();
    //$request_params = $_REQUEST;
    // Handling PUT request params
	$app = \Slim\Slim::getInstance();
	$json = $app->request->getBody();
	$request_params = json_decode($json, true);


    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
       // $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * Validating email address
 */
function validateEmail($email) {
    $app = \Slim\Slim::getInstance();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["error"] = true;
        $response["message"] = 'Email address is not valid';
        echoRespnse(400, $response);
        $app->stop();
    }
}
/**
 * Echoing json response to client
 * @param String $status_code Http response code
 * @param Int $response Json response
 */
function echoRespnse($status_code, $response) {
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);

    // setting response content type to json
    $app->contentType('application/json');

    echo json_encode($response);
}
$app->notFound(function () use ($app) {
	$headers = apache_request_headers();

    print_r($headers);
});
$app->run();
?>
