<?php header('Access-Control-Allow-Origin: *');
require_once '../include/DbHandler-technicians.php';
require_once '../include/PassHash.php';
require '.././libs/Slim/Slim.php';
require_once('../../admin/generate_pdf/html2pdf/html2pdf.class.php');


\Slim\Slim::registerAutoloader();

$app = new \Slim\Slim(array(
    'debug' => true
));

require ('CorsSlim.php');
$corsOptions = array(
  //"origin" => "*",
  "exposeHeaders" => array("Content-Type", "X-Requested-With", "X-authentication", "X-client"),
  "allowMethods" => array('GET', 'POST', 'PUT', 'DELETE', 'OPTIONS')
);

$cors = new \CorsSlim\CorsSlim($corsOptions);
$app->add($cors);
$user_id = NULL;
$api_key = NULL;
$site_url = 'http://kwmapp.opaldemo.com';
function authenticate(\Slim\Route $route) {
	//echo "Hee";die();
    // Getting request headers
    //$headers = apache_request_headers();
    $headers = $_SERVER;
    $response = array();
    $app = \Slim\Slim::getInstance();
    //print_r($_SERVER);
	//print_r($headers);
    // Verifying Authorization Header
    if (isset($headers['REDIRECT_HTTP_AUTHORIZATION'])) {
        $db = new DbHandler();
		global $api_key;
		//global $api_key;
        // get the api key
        $api_key = $headers['REDIRECT_HTTP_AUTHORIZATION'];
		//echo $api_key;
        // validating api key
        if (!$db->isValidApiKey($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
             //get user primary key id
            $user_id = $db->getUserId($api_key);
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * User Login
 * url - /login
 * method - POST
 * params - email, password
 */
$app->post('/login', function() use ($app) {
    // check for required params
    $json = $app->request->getBody();
    $data = json_decode($json, true); 
    //die();
    // reading post params
    $email = $data['email'];
    $password = $data['password'];
    verifyRequiredParams(array('email', 'password'));
    $response = array();
    $db = new DbHandler();
    // check for correct email and password
    if ($db->checkLogin($email, $password)) {
        // get the user by email
	$user = $db->getUserByEmail($email);
	if ($user != NULL) {
            $api_key=$db->generateApiKey();
            $db->updateApikey($user['emailaddress'],$api_key);
            //print_r($user);
			$date = new DateTime($user['userContract']);
			$userRegisterDate = $date->format('d/m/Y'); 
            $response["error"] = false;
            $response['firstname'] = $user['firstname'];
            $response['lastname'] = $user['lastname'];
            $response['emailaddress'] = $user['emailaddress'];
            $response['api_key'] = $api_key;
            $response['userImage'] = $user['userImage'];
			$response['userRegisterDate'] = $userRegisterDate;
			$response['userContract'] = $user['userContract'];
        } else {
            // unknown error occurred
            $response['error'] = true;
            $response['message'] = "An error occurred. Please try again";
        }
    } else {
    // user credentials are wrong
    $response['error'] = true;
    $response['message'] = 'Login failed. Incorrect credentials';
    }
			//print_r($response);die();
    echoRespnse(200, $response);
});








$app->post('/getBookCalendar', 'authenticate', function() use ($app) {

			$json = $app->request->getBody();
			$request_params = json_decode($json, true); 
			$current_date = $request_params;
			$date = new DateTime($current_date);
			$date->modify('+1 day');
			$match_database_date = $date->format('Y-m-d');
			$response = array();
			global $user_id;
            $db = new DbHandler();
			$data = $db->getBookCalendar($match_database_date, $user_id);
			$response["error"] = false;
			$response["event"] = $data;
            echoRespnse(200, $response);

		});


		$app->post('/getLastTwoService', 'authenticate', function() use ($app) {

			$json = $app->request->getBody();
			$request_params = json_decode($json, true); 
			$vehicle_id = $request_params;
			$response = array();
			global $user_id;
            $db = new DbHandler();
			$data = $db->getLastTwoService($vehicle_id);
			$response["error"] = false;
			$response["event"] = $data;
            echoRespnse(200, $response);

		});




/**
 * Update api_key to NULL
 * method POST
 * params - api_key
 * url - /logout
 */
$app->post('/logout', function() {
    //echo "Hello"; die();
    $headers = apache_request_headers();
    //print_r($headers);
    $response = array();
    if (isset($headers['Authorization'])) {
        $db = new DbHandler();
        $api_key = $headers['Authorization'];
        $val = $db->updateApikey('',$api_key);
        if($val){
            $response["error"] = false;
        }else{
            $response["error"] = true;
        }
    }else{
        $response["error"] = true;
    }
    $response["error"] = false;
    //print_r($response);
    echoRespnse(200, $response);
			
});

/*
 * Here we create function for fetch all jobs of technician 
 */
$app->get('/getAlljobs', 'authenticate', function()  use ($app) {
    global $user_id;
    $db = new DbHandler();
    $jobsdata = $db->fetchAlljobs($user_id);
    
	$response["jobs"] = array();
    // looping through result and preparing tasks array
    while ($jobs = $jobsdata->fetch_assoc()) {
        $tmp = array();
        $tmp["scheduledatetime"] = date('Y-m-d',strtotime($jobs["scheduledatetime"]));
        $tmp["plateno"] = $jobs["plateno"];
        $tmp["model"] = $jobs["model"];
		$tmp["name"] = $jobs["name"];
		$tmp["booking_id"] = $jobs["booking_id"];
        array_push($response["jobs"], $tmp);
    }
    if(empty($response)){
        $response["error"] = false	;
        $response["message"] = "No jobs found.";
        echoRespnse(200, $response);
    }else{
        $response["error"] = false;
        echoRespnse(200, $response);
    }
});        
/*
 * End
 */

 /**
 * Creating new Inquiry in db
 * method POST
 * params - name
 * url - /customerinquiry/
 */
$app->post('/updateAdmin', 'authenticate', function() use ($app) {
            // check for required params
			
			$json = $app->request->getBody();
			$request_params = json_decode($json, true); 
			//print_r($request_params);
            verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email', 'BankAccountName', 'BankAccountNo', 'Bank' ));
            $response = array();
			global $user_id;
            $db = new DbHandler();
            // creating new task
            $customer_id = $db->updateAdmin($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email'], $request_params['BankAccountName'], $request_params['BankAccountNo'], $request_params['Bank']);
            if ($customer_id != NULL) {
                $response["error"] = false;
                $response["message"] = "Profile Successfully Updated";
                echoRespnse(201, $response);
            } else {
               $response["error"] = false;
                $response["message"] = "Profile Successfully Updated";
                echoRespnse(200, $response);
            }            
        });
 /**
 * Listing all getAdmindata
 * method GET
 * url /getAdmindata          
 */
$app->get('/getAdmindata', 'authenticate', function() {
            $response = array();
            $db = new DbHandler();
			global $user_id;
			//echo $user_id;die();
            // fetching all user tasks
            $result = $db->getAdmindata($user_id);

            $response["error"] = false;
            $response["admin"] = $result;

            // looping through result and preparing tasks array
            
			//print_r($response);die();
            echoRespnse(200, $response);
        });

/*
 * Here we create new function for fetch parts of order.
 */
$app->get('/getAllpartsorder', 'authenticate', function()  {
    global $user_id;
    $db = new DbHandler();
    $jobsdata = $db->fetchAllpartsorder($user_id);
    //$response_data = $jobsdata->fetch_assoc();
    
    if(empty($jobsdata)){
        $response["error"] = false;
        $response["message"] = "No parts order found.";
        echoRespnse(200, $response);
    }else{
        $response["error"] = false;
		$response["parts"] = $jobsdata;
        echoRespnse(200, $response);
    }
});

/*
 * Here we create new function for fetch parts of order.
 */
$app->get('/getHome', 'authenticate', function()  {
    global $user_id;
    $db = new DbHandler();
	//echo $id;
    $homedata = $db->getHome($user_id);
    
    if(empty($homedata)){
        $response["error"] = false;
        $response["message"] = "No parts order found.";
        echoRespnse(200, $response);
    }else{
        $response["error"] = false;
		$response["homeData"] = $homedata;
        echoRespnse(200, $response);
    }
});
/*
 * Here we create new function for fetch parts of order.
 */
$app->get('/getLastService/:id', 'authenticate', function($id)  {
    global $user_id;
    $db = new DbHandler();
	//echo $id;
    $jobsdata = $db->getLastService($id);
    
    if(empty($jobsdata)){
        $response["error"] = false;
        $response["message"] = "No parts order found.";
		$response["parts"] = $jobsdata;
        echoRespnse(200, $response);
    }else{
        $response["error"] = false;
		$response["parts"] = $jobsdata;
        echoRespnse(200, $response);
    }
});     
/*
 * End
 */

/**
 * Listing all tasks of particual user
 * method GET
 * url /tasks          
 */
$app->get('/getTeam', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    // fetching all user tasks
    $result = $db->getTeam();

    $response["error"] = false;
    $response["team"] = array();
    // looping through result and preparing tasks array
    while ($teams = $result->fetch_assoc()) {
        $tmp = array();
        $tmp["position"] = $teams["name"];
        $tmp["name"] = $teams["firstname"]." ".$teams["lastname"];
        $tmp["phone"] = $teams["mobilenumber"];
        array_push($response["team"], $tmp);
    }
    echoRespnse(200, $response);
});

/**
 * Listing single task of particual user
 * method GET
 * url /tasks/:id
 * Will return 404 if the task doesn't belongs to user
 */
$app->get('/warningLights/:id', 'authenticate', function($cms_id) {
            $response = array();
            $db = new DbHandler();

            // fetch task
            $result = $db->getWarningLight($cms_id);

            if ($result != NULL) {
                $response["error"] = false;
                $response["cms_id"] = $result["cms_id"];
                $response["cms_title"] = $result["cms_title"];
                $response["cms_description"] = $result["cms_description"];
                $response["cms_icon"] = $result["cms_icon"];
                echoRespnse(200, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "The requested resource doesn't exists";
                echoRespnse(404, $response);
            }
});


/*
 * here we create function for individual job
 */
$app->get('/getindividualjob/:id', 'authenticate', function($job_id)  {
    global $user_id;
    $db = new DbHandler();
    $individual_job_details = $db->fetchindividualjob($job_id);
    $response["error"] = false;
    echoRespnse(201, $individual_job_details);
});


/*
 * here we fetch the technician contract history
 */
$app->post('/getContracthistory', 'authenticate', function()  use ($app) {
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $response = $db->fetchcontracthistory($user_id);
    if(!empty($response)){
        $response["error"] = false;
        echoRespnse(201, $response);
    }else{
        $response["error"] = false;
        $response["message"] = "There is no contract details are available.";
        echoRespnse(201, $response);
    }
});

/*
 *  End
*/

/*
 * here we fetch the technician contract history
 */
$app->post('/updateJobCardDetail', 'authenticate', function()  use ($app) {

	$json = $app->request->getBody();
	$request_params = json_decode($json, true); 
	
    $response = array();
    global $user_id;

    $db = new DbHandler();
    $response1 = $db->updateJobCardDetail($request_params);
    if($response1){
        $response["error"] = false;
        echoRespnse(201, $response);
    }else{
        $response["error"] = false;
        $response["message"] = "There is no contract details are available.";
        echoRespnse(201, $response);
    }
});

$app->post('/jobCardPause', 'authenticate', function()  use ($app, $id) {

	$json = $app->request->getBody();
	$request_params = json_decode($json, true); 
	//print_r($request_params);
    $response = array();
    global $user_id;

    $db = new DbHandler();
    $response1 = $db->jobCardPause($request_params);
    if($response1){
        $response["error"] = false;
        echoRespnse(201, $response);
    }else{
        $response["error"] = false;
        $response["message"] = "There is no contract details are available.";
        echoRespnse(201, $response);
    }
});
$app->post('/jobCardComplete', 'authenticate', function()  use ($app, $id) {

	$json = $app->request->getBody();
	$request_params = json_decode($json, true); 
	//print_r($request_params);
    $response = array();
    global $user_id;

    $db = new DbHandler();
    $response1 = $db->jobCardComplete($request_params);
    if($response1){
        $response["error"] = false;
        echoRespnse(201, $response);
    }else{
        $response["error"] = false;
        $response["message"] = "There is no contract details are available.";
        echoRespnse(201, $response);
    }
});
/*
 *  Here we create function for update information
 */

$app->post('/updateCustomer', 'authenticate', function() use ($app) {
    // check for required params
        $json = $app->request->getBody();
        $request_params = json_decode($json, true); 
    //print_r($request_params);
        verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email'));
        $response = array();
        global $user_id;
        $db = new DbHandler();
    // creating new task
        $customer_id = $db->updateCustomer($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email']);
        if ($customer_id != NULL) {
            $response["error"] = false;
            $response["message"] = "Profile Successfully Updated";
            echoRespnse(201, $response);
        } else {
            $response["error"] = true;
            $response["message"] = "Error!!! Please try again";
            echoRespnse(200, $response);
        }            
});

/*
 * End
 */







/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields) {
    $error = false;
    $error_fields = "";
    $request_params = array();
    //$request_params = $_REQUEST;
    // Handling PUT request params
	$app = \Slim\Slim::getInstance();
	$json = $app->request->getBody();
	$request_params = json_decode($json, true); 
	
	
    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
       // $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * Validating email address
 */
function validateEmail($email) {
    $app = \Slim\Slim::getInstance();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["error"] = true;
        $response["message"] = 'Email address is not valid';
        echoRespnse(400, $response);
        $app->stop();
    }
}
/**
 * Echoing json response to client
 * @param String $status_code Http response code
 * @param Int $response Json response
 */
function echoRespnse($status_code, $response) {
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);
 
    // setting response content type to json
    $app->contentType('application/json');
 
    echo json_encode($response);
}
$app->notFound(function () use ($app) {
	$headers = apache_request_headers();
	
    print_r($headers);
});
$app->run();
?>