<?php

/**
 * Class to handle all db operations
 * This class will have CRUD methods for database tables
 *
 * @author Ravi Tamada
 * @link URL Tutorial link
 */
class DbHandler {
    private $conn;
    function __construct() {
        require_once dirname(__FILE__) . '/DbConnect.php';
        // opening db connection
        $db = new DbConnect();
        $this->conn = $db->connect();
    }
    /** Opal
     * Checking user login
     * @param String $email User login email id
     * @param String $password User login password
     * @return boolean User login status success/fail
     */
    public function checkLogin($email, $password) {
        // fetching user by email
        $stmt = $this->conn->prepare("SELECT password FROM tbl_adminuser WHERE emailaddress = ? AND status = 1");

        $stmt->bind_param("s", $email);

        $stmt->execute();

        $stmt->bind_result($password_hash);

        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            // Found user with the email
            // Now verify the password

            $stmt->fetch();

            $stmt->close();

            if (PassHash::check_password($password_hash, $password)) {
                // User password is correct
                return TRUE;
            } else {
                // user password is incorrect
                return FALSE;
            }
        } else {
            $stmt->close();

            // user not existed with the email
            return FALSE;
        }
    }

    /** Opal
     * Checking for duplicate user by email address
     * @param String $email email to check in db
     * @return boolean
     */
    private function isUserExists($email) {
        $stmt = $this->conn->prepare("SELECT id from tbl_customer WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
        $stmt->close();
        return $num_rows > 0;
    }

    /** Opal
     * Fetching user by email
     * @param String $email User email id
     */
    public function getUserByEmail($email) {
        $stmt = $this->conn->prepare("SELECT firstname, lastname, emailaddress, api_key, profilepic, registration_date, contract FROM tbl_adminuser WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
		//print_r($stmt);
        if ($stmt->execute()) {
            // $user = $stmt->get_result()->fetch_assoc();
            $stmt->bind_result($firstname, $lastname, $emailaddress, $api_key, $profilepic, $registration_date, $contract);
            $stmt->fetch();																									
            $user = array();
            $user["firstname"] = $firstname;
            $user["lastname"] = $lastname;
            $user["emailaddress"] = $emailaddress;
			$user["userRegisterDate"] = $registration_date;
			$user["userContract"] = $contract;
            $user["api_key"] = $api_key;
			if($profilepic == NULL || $profilepic == ""){
				$user["userImage"] = 'no-profile.jpg';
			}else{
				$user["userImage"] = $profilepic;
			}
			//print_r($user);
            $stmt->close();
            return $user;
        } else {
            return NULL;
        }
    }

	public function getBookCalendar($date, $user_id){
	//echo "SELECT b.bookingdatetime, b.vehicle_id, b.bookingendtime, v.plateno, v.model, v.make, b.booking_id, b.servicetype_id  FROM tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND j.booking_id = b.booking_id  AND  b.bookingdatetime LIKE '".$date."%' and b.technician_id =".$user_id." GROUP BY b.booking_id";
		$stmt = $this->conn->prepare("SELECT b.bookingdatetime, b.vehicle_id, b.bookingendtime, v.plateno, v.model, v.make, b.booking_id, b.servicetype_id  FROM tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND  b.bookingdatetime LIKE '".$date."%' and b.technician_id =".$user_id." GROUP BY b.booking_id");
        //$stmt->bind_param("s", $date);
        $stmt->execute();
        $bank_data = $stmt->get_result();
		$return_arrray=array();
        while ($bank = $bank_data->fetch_assoc()) {
			$tmp = array();
			$tmp['starttime'] = $bank['bookingdatetime'];
			$tmp['endtime'] = $bank['bookingendtime'];
			$tmp['plateno'] = $bank['plateno'];
			$tmp['model'] = $bank['model'];
			$tmp['make'] = $bank['make'];
			
			$service_type_query =  $this->conn->prepare("SELECT name FROM tbl_servicetype WHERE servicetype_id = ? "); 
            $service_type_query->bind_param("i",$bank['servicetype_id']);
            $service_type_query->execute();
            $service_type_query_result = $service_type_query->get_result();
            $service_type_query_data  = $service_type_query_result->fetch_assoc();
            $service_name = $service_type_query_data['name'];
			$tmp['service_type'] = $service_name;
			$tmp['booking_id'] = $bank['booking_id'];
			$tmp['vehicle_id'] = $bank['vehicle_id'];
			array_push($return_arrray, $tmp);
		}
		//print_r($return_arrray);die();
		return $return_arrray;
	}

	public function getLastTwoService($vehicle_id){
	//echo "SELECT b.bookingdatetime, b.bookingendtime, jc.oilfilter_number, jc.airfilter_number, jc.odometerreading, jc.notes FROM `tbl_job` as j, tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND j.booking_id = b.booking_id AND jc.booking_id=b.booking_id and v.vehicle_id =".$vehicle_id." GROUP BY b.booking_id LIMIT 1,2";
		$stmt = $this->conn->prepare("SELECT b.bookingdatetime, b.bookingendtime, jc.oilfilter_number, jc.airfilter_number, jc.odometerreading, jc.notes, b.servicetype_id, jc.engineoil_amount FROM tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND jc.booking_id=b.booking_id and v.vehicle_id = ? AND b.job_status = 4 GROUP BY b.booking_id LIMIT 0,2");
        $stmt->bind_param("i", $vehicle_id);
        $stmt->execute();
        $bank_data = $stmt->get_result();
		$return_arrray=array();
        while ($bank = $bank_data->fetch_assoc()) {
			$tmp = array();
			$date = new DateTime($bank['bookingendtime']);
			$match_database_date = $date->format('Y-m-d');
			$tmp['booking_date'] = $match_database_date;
			$tmp['oilfilter_number'] = $bank['oilfilter_number'];
			$tmp['airfilter_number'] = $bank['airfilter_number'];
			$tmp['odometerreading'] = $bank['odometerreading'];
			$tmp['notes'] = $bank['notes'];
			$tmp['engineoil_amount'] = $bank['engineoil_amount'];
			$service_type_query =  $this->conn->prepare("SELECT name FROM tbl_servicetype WHERE servicetype_id = ? "); 
            $service_type_query->bind_param("i",$bank['servicetype_id']);
            $service_type_query->execute();
            $service_type_query_result = $service_type_query->get_result();
            $service_type_query_data  = $service_type_query_result->fetch_assoc();
            $service_name = $service_type_query_data['name'];
			$tmp['service_type'] = $service_name;
			array_push($return_arrray, $tmp);
		}
		//print_r($return_arrray);die();
		return $return_arrray;
	}

	public function getHome($user_id){
		$today_date = date('Y-m-d');
		$stmt = $this->conn->prepare("SELECT COUNT(*) as todayService FROM `tbl_booking` where bookingdatetime LIKE '".$today_date."%' and technician_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($todayService);
        $stmt->store_result();
        $stmt->fetch();
        $stmt->close();

		$stmt = $this->conn->prepare("SELECT AVG(total_time) as totalMiniusAvg FROM `tbl_booking` where job_status = 4 AND servicetype_id = 1 and technician_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($totalMiniusAvg);
        $stmt->store_result();
        $stmt->fetch();
        $stmt->close();

		$stmt = $this->conn->prepare("SELECT AVG(total_time) as totalMediusAvg FROM `tbl_booking` where job_status = 4 AND servicetype_id = 2 and technician_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($totalMediusAvg);
        $stmt->store_result();
        $stmt->fetch();
        $stmt->close();

		$stmt = $this->conn->prepare("SELECT AVG(total_time) as totalMaxiusAvg FROM `tbl_booking` where job_status = 4 AND servicetype_id = 3 and technician_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($totalMaxiusAvg);
        $stmt->store_result();
        $stmt->fetch();
        $stmt->close();

		$stmt = $this->conn->prepare("SELECT AVG(total_time) as totalavg FROM `tbl_booking` where job_status = 4  and technician_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->bind_result($totalavg);
        $stmt->store_result();
        $stmt->fetch();
        $stmt->close();

		$myarray['todayService'] = $todayService;
		$myarray['totalMiniusAvg'] = (float)$totalMiniusAvg;
		$myarray['totalMediusAvg'] = (float)$totalMediusAvg;
		$myarray['totalMaxiusAvg'] = (float)$totalMaxiusAvg;
		$myarray['totalavg'] = (float)$totalavg;

		return $myarray;

	}

	public function getLastService($vehicle_id){
	//echo $vehicle_id;
	//echo "SELECT b.bookingdatetime, b.bookingendtime, jc.oilfilter_number, jc.airfilter_number, jc.odometerreading, jc.notes FROM `tbl_job` as j, tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND j.booking_id = b.booking_id AND jc.booking_id=b.booking_id and v.vehicle_id =".$vehicle_id." GROUP BY b.booking_id LIMIT 1,2";
		$stmt = $this->conn->prepare("SELECT b.bookingdatetime, b.bookingendtime, jc.oilfilter_number, jc.airfilter_number, jc.odometerreading, jc.notes, b.servicetype_id, jc.engineoil_amount FROM tbl_jobcard as jc, tbl_booking as b, tbl_vehicle as v WHERE b.vehicle_id = v.vehicle_id AND jc.booking_id=b.booking_id and v.vehicle_id = ? AND (b.job_status = 3 OR b.job_status = 4 OR b.job_status = 1 OR b.job_status = 2) GROUP BY b.booking_id LIMIT 0,2");
        $stmt->bind_param("i", $vehicle_id);
        $stmt->execute();
        $bank_data = $stmt->get_result();
		$return_arrray=array();
        while ($bank = $bank_data->fetch_assoc()) {
			$tmp = array();
			$date = new DateTime($bank['bookingendtime']);
			$match_database_date = $date->format('Y-m-d');
			$tmp['booking_date'] = $match_database_date;
			$tmp['oilfilter_number'] = $bank['oilfilter_number'];
			$tmp['airfilter_number'] = $bank['airfilter_number'];
			$tmp['odometerreading'] = $bank['odometerreading'];
			$tmp['notes'] = $bank['notes'];
			$tmp['engineoil_amount'] = $bank['engineoil_amount'];
			$service_type_query =  $this->conn->prepare("SELECT name FROM tbl_servicetype WHERE servicetype_id = ? "); 
            $service_type_query->bind_param("i",$bank['servicetype_id']);
            $service_type_query->execute();
            $service_type_query_result = $service_type_query->get_result();
            $service_type_query_data  = $service_type_query_result->fetch_assoc();
            $service_name = $service_type_query_data['name'];
			$tmp['service_type'] = $service_name;
			array_push($return_arrray, $tmp);
		}
		//print_r($return_arrray);die();
		return $return_arrray;
	}
    /** Opal
     * Fetching user api key
     * @param String $user_id user id primary key in user table
     */
    public function getApiKeyById($user_id) {
        $stmt = $this->conn->prepare("SELECT api_key FROM tbl_customer WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        if ($stmt->execute()) {
            // $api_key = $stmt->get_result()->fetch_assoc();
            // TODO
            $stmt->bind_result($api_key);
            $stmt->close();
            return $api_key;
        } else {
            return NULL;
        }
    }

    

    /** Opal
     *  Generating random Unique MD5 String for user Api key 
     */
    public function generateApiKey() {
        return md5(uniqid(rand(), true));
    }
	/** Opal 
	* Update the Api Key in customer table
	**/
	public function updateApikey($emailaddress = '', $api_key){
		if($emailaddress != ""){
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser set api_key = ? WHERE emailaddress = ?");
			$stmt->bind_param("ss", $api_key, $emailaddress);
			$result = $stmt->execute();
			$stmt->close();
		}else{
			//echo $api_key;
			$key = NULL;
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser SET api_key = ? WHERE api_key = ?");
			$stmt->bind_param("is", $key, $api_key);			
			$result = $stmt->execute();
			$stmt->close();
			
		}
		return $result;
       
	}
    /** Opal
     * Fetching user id by api key
     * @param String $api_key user api key
     */
    public function getUserId($api_key) {
        $stmt = $this->conn->prepare("SELECT user_id FROM tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        if ($stmt->execute()) {
            $stmt->bind_result($user_id);
            $stmt->fetch();
            // TODO
            // $user_id = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            return $user_id;
        } else {
            return NULL;
        }
    }
    public function getTeam(){
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` as a, tbl_usertype as u where a.usertype_id = u.usertype_id AND a.status =1 ");
        $result = $stmt->execute();
        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
        $team_data = $stmt->get_result();
        $stmt->close();
        return $team_data;
    }
    /**
     * Fetching all user tasks
     * @param String $user_id id of the user
    */
    public function getWarningLights() {
        $stmt = $this->conn->prepare("SELECT * FROM tbl_cms where warning_lights = '1' AND status = '1'");
        $stmt->execute();
        $warningLights = $stmt->get_result();
        $stmt->close();
        return $warningLights;
    }
    /* Here we fetch all jobs for the technition */
    public function fetchAlljobs($user_id){
		
        $stmt = $this->conn->prepare("SELECT b.scheduledatetime,c.plateno, c.model, d.name, b.booking_id FROM tbl_booking b LEFT JOIN tbl_vehicle c on c.vehicle_id = b.vehicle_id join tbl_servicetype d on d.servicetype_id = b.servicetype_id WHERE b.technician_id = ? AND (b.job_status = 0 OR b.job_status = 1 OR b.job_status = 2)"); 
        $stmt->bind_param("i",$user_id);
        $result = $stmt->execute();
        $response = $stmt->get_result();
        $stmt->close();
        return $response;
    }


    /* End */
    /**
     * Fetching single task
     * @param String $task_id id of the task
     */
    public function getWarningLight($cms_id) {
        $stmt = $this->conn->prepare("SELECT cms_id, cms_title, cms_description, cms_icon from tbl_cms WHERE cms_id = ?");
        $stmt->bind_param("i", $cms_id);
        if ($stmt->execute()) {
            $res = array();
            $stmt->bind_result($cms_id, $cms_title, $cms_description, $cms_icon);
            // TODO
            // $task = $stmt->get_result()->fetch_assoc();
            $stmt->fetch();
            $res["cms_id"] = $cms_id;
            $res["cms_title"] = $cms_title;
            $res["cms_description"] = $cms_description;
            $res["cms_icon"] = $cms_icon;
            $stmt->close();
            return $res;
        } else {
            return NULL;
        }
    }

    public function saveTechnician($user_id,$type,$first_name,$last_name,$date_of_birth,$gender,$mobile_no,$address,$email_address,$driver_licence_no,$driver_licence_expiry_date,$driving_licence_proof,$profile_pic_name,$bank_account_name,$bank_account_no,$bank_name,$payment_frequency,$payment_day,$hourly_rate,$technicians_signature,$status,$declarationcontent,$signature_proof){
        $registration_date = date("Y-m-d H:i:s");
        $password = base64_encode("123456");
        $date_of_birth = date("Y-m-d",strtotime($date_of_birth));
        $driver_licence_expiry_date = date("Y-m-d",strtotime($driver_licence_expiry_date));
        $save_query = $this->conn->prepare("INSERT INTO tbl_adminuser (addedbyuser_id,usertype_id,firstname,lastname,emailaddress,password,dateofborth,mobilenumber,address,drivinglicencenumber,drivinglicenceexpiredate,drivinglicencefile1,profilepic,declarationcontent,gender,status,registration_date,signature_proof) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $save_query->bind_param("iisssssssssssssiss",$user_id,$type,$first_name,$last_name,$email_address,$password,$date_of_birth,$mobile_no,$address,$driver_licence_no,$driver_licence_expiry_date,$driving_licence_proof,$profile_pic_name,$declarationcontent,$gender,$status,$registration_date,$signature_proof);
        
        if($save_query->execute()){
            $technician_id = $this->conn->insert_id;;
            // other information will store in bank account table
            $bank_info_query = $this->conn->prepare("INSERT INTO tbl_bankaccountdetail (user_id,accountname,accountnumber,bankname,paymentfrequency,paymentday,hourly_rate) VALUES (?,?,?,?,?,?,?)");
            $bank_info_query->bind_param('issssss',$technician_id,$bank_account_name,$bank_account_no,$bank_name,$payment_frequency,$payment_day,$hourly_rate);
            $bank_info_query->execute();
            $bank_info_query->close();
            $save_query->close();
            return "1";
        }else{
            $save_query->close();
            return "2";
        }
    }

    public function getAllFeedback($user_id){
        $stmt = $this->conn->prepare("select u.firstname ,c.conversation_datetime,c.conversation_id from tbl_adminuser as u right join tbl_conversation as c on u.user_id = c.sender_id where c.sender_id = ? OR c.receiver_id = ?");
        $stmt->bind_param("is",$user_id,$user_id);
        $stmt->execute();
        $response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
    public function get_conversation($conversation_id){
        $stmt = $this->conn->prepare("select m.*,u.firstname as sendername,a.firstname as receivername from tbl_message as m left join tbl_adminuser as u on u.user_id = m.sender_id left join tbl_adminuser as a on a.user_id = m.receiver_id where conversation_id = ?");
        $stmt->bind_param("i",$conversation_id);
        $stmt->execute();
        $response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
    public function sent_message($conversation_id,$message,$sender_id,$receiver_id,$send_by,$conversation_datetime){
        $stmt = $this->conn->prepare("INSERT INTO tbl_message (conversation_id,sender_id,receiver_id,message,send_by,conversation_datetime) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("iiisis",$conversation_id,$sender_id,$receiver_id,$message,$send_by,$conversation_datetime); 
        if($stmt->execute()){
            $stmt->close();
            return 1;
        }else{
            return 2;   
        }
    }

    public function chk_record_exist($table,$field,$email){
        $check_query = $this->conn->prepare("SELECT user_id FROM tbl_adminuser WHERE emailaddress = ?");
        $check_query->bind_param("s",$email);
        $check_query->execute();
        $user_data = $check_query->get_result();
        if($user_data->num_rows > 0){
            return 1;
        }else{
            return 0;
        }
    }

	public function getAdmindata($admin_id){
		$stmt = $this->conn->prepare("SELECT accountname, accountnumber, bankname, emailaddress, mobilenumber, address, address2 FROM `tbl_adminuser` as a, tbl_bankaccountdetail as b WHERE a.user_id = ? AND b.user_id=a.user_id AND b.user_type = 1");
		$stmt->bind_param("i", $admin_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$admin_data_res = $stmt->get_result();
		$admin_data = $admin_data_res->fetch_assoc();
		return $admin_data;
	}
	function updateAdmin($user_id, $addressLine1, $addressLine2, $mobile, $email, $accountname, $accountnumber, $bankname){
		//$result = $this->getCustomer($user_id);
		//$data = $result->fetch_assoc();
		$user_type = 1;
		//print_r($data);
		//die();
		$stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
		$stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
        $stmt->execute();
		$stmt->close();
		
		
		$stmt = $this->conn->prepare("UPDATE  tbl_adminuser set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
        $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
		
		$stmt = $this->conn->prepare("UPDATE  tbl_bankaccountdetail set accountname = ?, accountnumber = ?, bankname = ? WHERE user_id = ?");
        $stmt->bind_param("sssi", $accountname, $accountnumber, $bankname, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}

    public function fetchAllpartsorder($user_id){
		$dateTo =  date("Y-m-d")." 00:00:00";
        $dateFrom = date("Y-m-d",strtotime(date("Y-m-d", strtotime($dateTo))." + 1 day"))." 23:59:59";

		//echo "SELECT b.*,c.* FROM tbl_jobcard a left join tbl_booking b on b.booking_id = a.booking_id join tbl_vehicle c on c.vehicle_id = b.vehicle_id WHERE b.technician_id = ? AND b.job_status NOT IN(3,4) AND b.scheduledatetime BETWEEN ? AND ? ";
        $stmt = $this->conn->prepare("SELECT b.*,c.*, a.* FROM tbl_jobcard a left join tbl_booking b on b.booking_id = a.booking_id join tbl_vehicle c on c.vehicle_id = b.vehicle_id WHERE b.technician_id = ? AND b.job_status NOT IN(3,4) AND b.scheduledatetime BETWEEN ? AND ? ");
        $stmt->bind_param("iss",$user_id,$dateTo,$dateFrom);
        $result = $stmt->execute();
        $response = $stmt->get_result();
		$myarray['parts_order'] = array();
		while($allservices_query_data = $response->fetch_assoc()){
            //print_r($allservices_query_data);
			$tmp = array();

			$stmt1 = $this->conn->prepare("SELECT b.*,c.*, a.* FROM tbl_jobcard a left join tbl_booking b on b.booking_id = a.booking_id join tbl_vehicle c on c.vehicle_id = b.vehicle_id WHERE b.vehicle_id = ? AND b.job_status IN(3,4) LIMIT 0, 1");
			$stmt1->bind_param("i",$allservices_query_data['vehicle_id']);
			$result1 = $stmt1->execute();
			$data = $stmt1->get_result();
			//print_r($data);
			while($allservices_query_data1 = $data->fetch_assoc()){
				$tmp['airfilter_number'] = $allservices_query_data1['airfilter_number'];
				$tmp['oilfilter_number'] = $allservices_query_data1['oilfilter_number'];
			}

			
			$tmp['plateno'] = $allservices_query_data['plateno'];
			$tmp['model'] = $allservices_query_data['model'];
			$date = new DateTime($allservices_query_data['scheduledatetime']);
			$match_database_date = $date->format('Y-m-d');
			$tmp['scheduledatetime'] = $match_database_date ;
			$tmp['vehicle_id'] = $allservices_query_data['vehicle_id'];
			//$tmp['selected_option'] = $allservices_query_data['selected_option'];
				array_push($myarray['parts_order'],$tmp);
        }

        $stmt->close();
        return $myarray;
    }
	public function updateJobCardDetail($data){
		$stmt = $this->conn->prepare("UPDATE  tbl_jobcard_detail set selected_option = ? WHERE jobcard_detail_id = ?");
        $stmt->bind_param("si", $data['selected_option'], $data['jobcard_detail_id']);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();

		$stmt = $this->conn->prepare("SELECT booking_id FROM tbl_jobcard WHERE jobcard_id =? ");
        $stmt->bind_param("i", $data['jobcard_id']);
        $stmt->execute();
        $stmt->bind_result($booking_id);
		$stmt->store_result();
		$stmt->fetch();
		$stmt->close();
	
		$stmt2 = $this->conn->prepare("SELECT * FROM tbl_job_time WHERE booking_id = ? AND end_time is NULL");
        $stmt2->bind_param("i", $booking_id);
        if ($stmt2->execute()) {

			$stmt2->store_result();
			$num_rows = $stmt2->num_rows;
			if($num_rows <= 0){
				$start_time = date('Y-m-d H:i:s');
				$stmt1 = $this->conn->prepare("INSERT INTO tbl_job_time (booking_id, start_time) VALUES (?, ?)");
				$stmt1->bind_param("is", $booking_id, $start_time);
				$stmt1->execute();
				$num_affected_rows = $stmt1->affected_rows;
				$stmt1->close();


				
			}
			$status = 1;
			$stmt1 = $this->conn->prepare("UPDATE tbl_booking SET job_status = ? WHERE booking_id =?");
			$stmt1->bind_param("si", $status, $booking_id);
			$stmt1->execute();
			$num_affected_rows = $stmt1->affected_rows;
			$stmt1->close();
		}
		$stmt2->close();

        return $num_affected_rows > 0;
	
	}
    public function fetchindividualjob($booking_id){
        $myarray['service_parts'] = array();
        $myarray['service_provide'] = array();
        $todays_date = date("Y-m-d");
        
        // Here we fetch the vehicle id of booking  
            $allbooing_data = $this->conn->prepare("SELECT b.vehicle_id, b.servicetype_id, jc.jobcard_id, odometerreading, notes, oilfilter_number, airfilter_number, engineoil_amount, breakfluid_amount, clutchfluid_amount, coolant_amount, job_card_images FROM tbl_booking b, tbl_jobcard jc WHERE  b.booking_id = jc.booking_id and b.booking_id = ? "); 
            $allbooing_data->bind_param("i",$booking_id);
            $result_vehicledata = $allbooing_data->execute();
            $vehil_result = $allbooing_data->get_result();
            $vehicledata  = $vehil_result->fetch_assoc();
            $vehicle_id = $vehicledata['vehicle_id'];
			$servicetype_id = $vehicledata['servicetype_id'];
			$jobcard_id = $vehicledata['jobcard_id'];
			$myarray["odometerreading"] = $vehicledata['odometerreading'];
			$myarray["notes"] = $vehicledata['notes'];
			$myarray["oilfilter_number"] = $vehicledata['oilfilter_number'];
			$myarray["engineoil_amount"] = $vehicledata['engineoil_amount'];
			$myarray["breakfluid_amount"] = $vehicledata['breakfluid_amount'];
			$myarray["clutchfluid_amount"] = $vehicledata['clutchfluid_amount'];
			$myarray["coolant_amount"] = $vehicledata['coolant_amount'];
			$myarray["job_card_images"] = $vehicledata['job_card_images'];
			$myarray["airfilter_number"] = $vehicledata['airfilter_number'];
			$myarray["vehicle_id"] = $vehicledata['vehicle_id'];
            // here we fetch service type name 
            $service_type_query =  $this->conn->prepare("SELECT name FROM tbl_servicetype WHERE servicetype_id = ? "); 
            $service_type_query->bind_param("i",$servicetype_id);
            $service_type_query->execute();
            $service_type_query_result = $service_type_query->get_result();
            $service_type_query_data  = $service_type_query_result->fetch_assoc();
            $service_name = $service_type_query_data['name'];
        // End 
            
        // accoding to service id we fetch all service 
            $allservices_query = $this->conn->prepare("SELECT * FROM tbl_jobcard_detail WHERE jobcard_id = ? "); 
            $allservices_query->bind_param("i",$jobcard_id);
            $allservices_query->execute();
            $allservices_query_result = $allservices_query->get_result();
            while($allservices_query_data = $allservices_query_result->fetch_assoc()){
                //print_r($allservices_query_data);
				$tmp = array();
				$tmp['jobcard_detail_id'] = $allservices_query_data['jobcard_detail_id'];
				$tmp['jobcard_id'] = $allservices_query_data['jobcard_id'];
				$tmp['service_type_name'] = $allservices_query_data['service_type_name'];
				$tmp['service_type_options'] = explode(",",$allservices_query_data['service_type_options']);
				$tmp['parent_id'] = $allservices_query_data['parent_id'];
				$tmp['selected_option'] = $allservices_query_data['selected_option'];
				 array_push($myarray['service_provide'],$tmp);
            }
            /*if(! empty($allservices)){
                foreach($allservices as $servicetype){
                    $parent_id = $servicetype['parent_id'];
                    if($parent_id == 0){
                        $service_parent_name = $servicetype['name'];
                        $servicechecklist_id = $servicetype['servicechecklist_id'];
                        // here we fetch all sub category
                        $allsubservice_query = $this->conn->prepare("SELECT * FROM tbl_servicechecklist WHERE parent_id = ? "); 
                        $allsubservice_query->bind_param("i",$servicechecklist_id);
                        $allsubservice_query->execute();
                        $allsubservice_result = $allsubservice_query->get_result();
						$l = 0;
                        while($allsubservice_data  = $allsubservice_result->fetch_assoc()){
                            $servicechecklist_id = $allsubservice_data['servicechecklist_id'];
                            $subservicename =  $allsubservice_data['name'];
                            // Here we fetch all the service checklist details accoing to service list
                                $service_check_details_query = $this->conn->prepare("SELECT * FROM tbl_servicechecklistdetail WHERE servicechecklist_id = ? "); 
                                $service_check_details_query->bind_param("i",$servicechecklist_id);
                                $service_check_details_query->execute();
                                $service_check_details_result = $service_check_details_query->get_result();
                                while($servcedetails  = $service_check_details_result->fetch_assoc()){
                                    $myservicedata[$l][$service_parent_name][$subservicename][] = $servcedetails['checklist_value'];
                                }
                            // End 
                            //$myservicedata[$service_parent_name][] = $allsubservice_data['name'];
                        }   
                        // End 
                    }
                }
            }  */ 
            //echo "<pre>";print_r($myservicedata);exit;
            //array_push($myarray['service_provide'],$myservicedata);
            // End 
        // End     
            
        // here we fetch the current vehicle service vehicle details 
            $vehiclinfo_query = $this->conn->prepare("SELECT * FROM tbl_vehicle WHERE vehicle_id = ? "); 
            $vehiclinfo_query->bind_param("i",$vehicle_id);
            $vehiclinfo_query->execute();
            $vehicleinfo_result = $vehiclinfo_query->get_result();
            $vehicleinfo = $vehicleinfo_result->fetch_assoc();
            $myarray["plat_no"] = $vehicleinfo['plateno'];
            $myarray["model"] = $vehicleinfo['model'];
            $myarray["service_type"] = $service_name;
			$myarray["service_type_id"] = $servicetype_id;
		
        // End 
        
        
        
        
        
        // Here we fetch the all vehicle booking data
           /* $allvehicle_booing_query = $this->conn->prepare("SELECT * FROM tbl_booking WHERE vehicle_id = ? AND DATE(bookingdatetime) != ? ORDER BY booking_id LIMIT 0,2"); 
            $allvehicle_booing_query->bind_param("is",$vehicle_id,$todays_date);
            $allvehicle_id_exe = $allvehicle_booing_query->execute();
            $vehicle_result = $allvehicle_booing_query->get_result();
            while($vehicle_data = $vehicle_result->fetch_assoc()){
                 $myvehicl_array []=  $vehicle_data;
            }
            foreach($myvehicl_array as $vehicledata){
                $bookingid = $vehicledata['booking_id'];
                // here we fetch booking detials  data
                    $seduledata_query = $this->conn->prepare("SELECT bookingdatetime FROM tbl_booking WHERE booking_id = ? "); 
                    $seduledata_query->bind_param("i",$bookingid);
                    $result = $seduledata_query->execute();

                    $mybookingdata = $seduledata_query->get_result();
                    $data = $mybookingdata->fetch_assoc();
                    $bookingdatetime = date("Y-m-d",strtotime($data['bookingdatetime']));
                // End 

                // Here we fetch the job card detials
                    $data_querystmt = $this->conn->prepare("SELECT * FROM tbl_jobcard WHERE booking_id = ?");
                    $data_querystmt->bind_param("i",$bookingid);
                    $data_result = $data_querystmt->execute();
                    $myvehicle_result = $data_querystmt->get_result();
                    $vehicledata = $myvehicle_result->fetch_assoc();

                    $engineoil_amount = $vehicledata['engineoil_amount'];
                    $oilfilter_number = $vehicledata['oilfilter_number'];
                    $airfilter_number = $vehicledata['airfilter_number'];
                // End     

                    $myvehicledata[$bookingdatetime]['engineoil_amount'] = $engineoil_amount;
                    $myvehicledata[$bookingdatetime]['oilfilter_number'] = $oilfilter_number;
                    $myvehicledata[$bookingdatetime]['airfilter_number'] = $airfilter_number;
                    array_push($myarray['service_parts'],$myvehicledata);
            }*/
            //echo "<pre>----";print_r($myarray);exit;

			$stmt2 = $this->conn->prepare("SELECT * FROM tbl_job_time WHERE booking_id = ? AND end_time is NULL");
			$stmt2->bind_param("i", $booking_id);
			if ($stmt2->execute()) {

				$stmt2->store_result();
				$num_rows = $stmt2->num_rows;
				if($num_rows <= 0){
					$start_time = date('Y-m-d H:i:s');
					$stmt1 = $this->conn->prepare("INSERT INTO tbl_job_time (booking_id, start_time) VALUES (?, ?)");
					$stmt1->bind_param("is", $booking_id, $start_time);
					$stmt1->execute();
					$num_affected_rows = $stmt1->affected_rows;
					$stmt1->close();


				
				}
				$status = 1;
				$stmt1 = $this->conn->prepare("UPDATE tbl_booking SET job_status = ? WHERE booking_id =?");
				$stmt1->bind_param("si", $status, $booking_id);
				$stmt1->execute();
				$num_affected_rows = $stmt1->affected_rows;
				$stmt1->close();
			}
            return $myarray;
        // End
    }
	public function jobCardComplete($data){
		$booking_id = $data['booking_id'];
		$odometer = $data['odometer'];
		$notes = $data['notes'];
		$oilfilter_no = $data['oilfilter_no'];
		$airfilter_no = $data['airfilter_no'];
		$engineoil = $data['engineoil'];
		$brakerfluid_amount = $data['brakerfluid_amount'];
		$clutch_amount = $data['clutch_amount'];
		$coolant_amount = $data['coolant_amount'];

		$job_card_images = '';

		$stmt1 = $this->conn->prepare("UPDATE tbl_jobcard SET odometerreading=?, notes=?, oilfilter_number=?, airfilter_number=?, engineoil_amount=?, breakfluid_amount=?, clutchfluid_amount=?, coolant_amount= ?, job_card_images=?  WHERE booking_id =?");
		$stmt1->bind_param("sssssssssi", $odometer, $notes, $oilfilter_no, $airfilter_no, $engineoil, $brakerfluid_amount, $clutch_amount, $coolant_amount, $job_card_images, $booking_id);
		$stmt1->execute();
		$num_affected_rows = $stmt1->affected_rows;
		$stmt1->close();

		$stmt2 = $this->conn->prepare("SELECT job_time_id, start_time FROM tbl_job_time WHERE booking_id = ? AND end_time is NULL");
		$stmt2->bind_param("i", $booking_id);
		if ($stmt2->execute()) {
			$stmt2->bind_result($job_time_id, $start_time);
            $stmt2->fetch();
			//echo $job_time_id;die();
			$stmt2->close();
			if($job_time_id != ""){
				$datetime = date('Y-m-d H:i:s');
				$date_a = (new DateTime($datetime))->getTimestamp() ;
				$date_b = (new DateTime($start_time))->getTimestamp() ;

				$tota_time = abs(($date_a - $date_b)/60);
				//$tota_time = $interval->format('%i');

				$stmt1 = $this->conn->prepare("UPDATE tbl_job_time SET end_time = ?, total_time=? WHERE job_time_id = ?");
				$stmt1->bind_param("ssi", $datetime, $tota_time, $job_time_id);
				$stmt1->execute();
				$num_affected_rows = $stmt1->affected_rows;
				$stmt1->close();

				$stmt4 = $this->conn->prepare("SELECT sum(total_time) as all_total FROM tbl_job_time WHERE booking_id = ?");
				$stmt4->bind_param("i", $booking_id);
				$stmt4->execute();
				$stmt4->bind_result($all_total);
				$stmt4->fetch();
				//echo $job_time_id;die();
				$stmt4->close();
			}
		}
		


		$status = 3;
		$stmt1 = $this->conn->prepare("UPDATE tbl_booking SET job_status = ?, total_time=? WHERE booking_id =?");
		$stmt1->bind_param("ssi", $status,	$all_total, $booking_id);
		$stmt1->execute();
		$num_affected_rows = $stmt1->affected_rows;
		$stmt1->close();
	}
	public function jobCardPause($data)
	{
		$booking_id = $data['booking_id'];
		$odometer = $data['odometer'];
		$notes = $data['notes'];
		$oilfilter_no = $data['oilfilter_no'];
		$airfilter_no = $data['airfilter_no'];
		$engineoil = $data['engineoil'];
		$brakerfluid_amount = $data['brakerfluid_amount'];
		$clutch_amount = $data['clutch_amount'];
		$coolant_amount = $data['coolant_amount'];

		$status = 2;
		$stmt1 = $this->conn->prepare("UPDATE tbl_booking SET job_status = ? WHERE booking_id =?");
		$stmt1->bind_param("si", $status, $booking_id);
		$stmt1->execute();
		$num_affected_rows = $stmt1->affected_rows;
		$stmt1->close();

		$stmt2 = $this->conn->prepare("SELECT job_time_id, start_time FROM tbl_job_time WHERE booking_id = ? AND end_time is NULL");
		$stmt2->bind_param("i", $booking_id);
		if ($stmt2->execute()) {
			$stmt2->bind_result($job_time_id, $start_time);
            $stmt2->fetch();
			//echo $job_time_id;die();
			$stmt2->close();
			if($job_time_id != ""){
				$datetime = date('Y-m-d H:i:s');
				$date_a = (new DateTime($datetime))->getTimestamp() ;
				$date_b = (new DateTime($start_time))->getTimestamp() ;

				$tota_time = abs(($date_a - $date_b)/60);

				$stmt1 = $this->conn->prepare("UPDATE tbl_job_time SET end_time = ?, total_time=? WHERE job_time_id = ?");
				$stmt1->bind_param("ssi", $datetime, $tota_time, $job_time_id);
				$stmt1->execute();
				$num_affected_rows = $stmt1->affected_rows;
				$stmt1->close();
			}
		}
		$job_card_images = '';

		$stmt1 = $this->conn->prepare("UPDATE tbl_jobcard SET odometerreading=?, notes=?, oilfilter_number=?, airfilter_number=?, engineoil_amount=?, breakfluid_amount=?, clutchfluid_amount=?, coolant_amount= ?, job_card_images=?  WHERE booking_id =?");
		$stmt1->bind_param("sssssssssi", $odometer, $notes, $oilfilter_no, $airfilter_no, $engineoil, $brakerfluid_amount, $clutch_amount, $coolant_amount, $job_card_images, $booking_id);
		$stmt1->execute();
		$num_affected_rows = $stmt1->affected_rows;
		$stmt1->close();

		return true;


	}
    // Here we fetch the contract hoistory
    public function fetchcontracthistory($user_id){
        $allcontact = $this->conn->prepare("SELECT * FROM tbl_adminuser WHERE addedbyuser_id = ? ");
        $allcontact->bind_param("i", $user_id);
        $allcontact->execute();
        $allcontact_data = $allcontact->get_result();
        while($data = $allcontact_data->fetch_assoc()){
            $all_contactor[] = $data;
        }
        return $all_contactor;
    }
    // End 

    public function get_all_inquiry(){
        $stmt = $this->conn->prepare("select * from tbl_inquiry");
        $stmt->execute();
        $response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
    
    // Here  we  create the function to update details
    public function updateCustomer($user_id, $addressLine1, $addressLine2, $mobile, $email){
        $result = $this->getCustomer($user_id);
        $data = $result->fetch_assoc();
        $user_type = 0;
        $stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
        $stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
        $stmt->execute();
        $stmt->close();
	$stmt = $this->conn->prepare("UPDATE  tbl_customer set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
        $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
    }
    // End
    
    
    public function isValidApiKey($api_key) {
        $stmt = $this->conn->prepare("SELECT emailaddress from tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
        //echo $num_rows;
        $stmt->close();
        return $num_rows > 0;
    }
    
}