<?php

/**
 * Class to handle all db operations
 * This class will have CRUD methods for database tables
 *
 * @author Ravi Tamada
 * @link URL Tutorial link
 */
class DbHandler {

    private $conn;

    function __construct() {
        require_once dirname(__FILE__) . '/DbConnect.php';
        // opening db connection
        $db = new DbConnect();
        $this->conn = $db->connect();
    }

    /* ------------- `users` table method ------------------ */

    /**
     * Creating new user
     * @param String $name User full name
     * @param String $email User login email id
     * @param String $password User login password
     */
    public function createUser($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof1, $profilepic, $addedbyuser_id, $home) {
			$date = date('Y-m-d H:i:s');
            // insert query
            $stmt = $this->conn->prepare("INSERT INTO tbl_customer(firstname, lastname, dateofborth, gender, mobilenumber, address, address2, emailaddress, drivinglicencenumber, drivinglicenceexpiredate, drivinglicencefile1, drivinglicencefile2, profilepic, addedbyuser_id, homenumber, registration_date, status) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 2)");
            $stmt->bind_param("sssssssssssssiss", $firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof1, $profilepic, $addedbyuser_id, $home, $date);

            $result = $stmt->execute();
			//print_r($result);
			$last_id = $stmt->insert_id;
            $stmt->close();

            // Check for successful insertion
            if ($result) {
                // User successfully inserted
                return $last_id;
            } else {
                // Failed to create user
                return USER_CREATE_FAILED;
            }
       

        //return $response;
    }
	
	
	public function updateRegisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id){
		
		$enginetype_id = $this->getEngineId($category, $enginType);
		$plan_data = $this->getPlanData($enginetype_id, $term, $type);
		//print_r($plan_data);
		if($paymentFrequency == "Fortnightly"){
			$plan_price = $plan_data['price']*2;
		}else{
			$plan_price = $plan_data['price'];
		}
		$status = 2;
		$stmt2 = $this->conn->prepare("INSERT INTO tbl_vehicle(user_id, category_id, enginetype_id, plan_id, plateno, make, model, year, vin, color, fuel, paymentfrequency, paymentday, status) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$stmt2->bind_param("iiiisssssssssi", $customer_id, $category, $enginetype_id, $plan_data['plan_id'], $plate_no, $make, $model, $year, $vin, $color, $fuel, $paymentFrequency, $paymentDay, $status);
		$result = $stmt2->execute();
		$vehicle_id = $stmt2->insert_id;
		$stmt2->close();
		// Check for successful insertion
		if ($result) {
			$data_return['vehicle_id'] = $vehicle_id;
			$data_return['plan_price'] = $plan_price;
			$data_return['plan_id'] = $plan_data['plan_id'];
			// User successfully inserted
			return $data_return;
		} else {
			// Failed to create user
			return USER_CREATE_FAILED;
		}
	}

	public function updateRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount, $customer_id, $vehicle_id)
	{
		$stmt2 = $this->conn->prepare("INSERT INTO tbl_bankaccountdetail(user_id, accountname, accountnumber, bankname, ddamount, multicar_discount, ddstartdate, ddenddate, vehicle_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$stmt2->bind_param("issssssss", $customer_id, $BankAccountName, $BankAccountNo, $Bank, $ddAmount, $multicar_discount, $ddStartDate, $ddEndDate, $vehicle_id);
		$result = $stmt2->execute();
		//echo $stmt2->errno;
		$stmt2->close();
		return $result;
		
	}
	// here Mohit create a function insert data into bank payment table
	public function insertBankpayment($bankaccountdetail_id,$duedate,$ddamount){
		$bankpayment_statement = $this->conn->prepare("INSERT INTO tbl_bank_payment(bankaccountdetail_id,payment_due_date,payment_amount,payment_status) values (?,?,?,?)");
		$bankpayment_statement->bind_param($bankaccountdetail_id,$duedate,$ddamount,'0');
		$bankpayment_statement->close();
		return $result;
	}
	// End 
	public function getVehicleCustomerLastId($customer_id){
		$stmt = $this->conn->prepare("SELECT vehicle_id FROM tbl_vehicle WHERE  user_id = ? ORDER BY vehicle_id DESC LIMIT 0,1");
        $stmt->bind_param("i", $customer_id);
		if ($stmt->execute()) {
			$stmt->bind_result($vehicle_id);
			$stmt->fetch();
			$stmt->close();
			return $vehicle_id;
		}
	}
	public function updateSign($customer_id, $sign){
		$stmt = $this->conn->prepare("UPDATE tbl_customer SET contract_sign = ? WHERE user_id = ?");
		$stmt->bind_param("si", $sign, $customer_id);			
		$result = $stmt->execute();
		$stmt->close();
			
	}
	
	public function updateContract($customer_id, $sign){
		$stmt = $this->conn->prepare("UPDATE tbl_customer SET contract_filename = ? WHERE user_id = ?");
		$stmt->bind_param("si", $sign, $customer_id);			
		$result = $stmt->execute();
		$stmt->close();
			
	}
	
	public function customerRegisterComplete($customer_id, $user_id){
		$stmt = $this->conn->prepare("UPDATE tbl_customer SET status = 1 WHERE user_id = ?");
		$stmt->bind_param("i", $customer_id);			
		$result = $stmt->execute();
		$stmt->close();
		$stmt = $this->conn->prepare("SELECT vehicle_id, plan_id FROM tbl_vehicle WHERE user_id = ? AND status = 2");
        $stmt->bind_param("i", $customer_id);
        if ($stmt->execute()) {
			//echo "eee";
			$result1 = $stmt->get_result();
			//print_r($result1);
            while($vehicle_data = $result1->fetch_assoc()){
				
				$stmt_bank = $this->conn->prepare("SELECT ddstartdate, ddenddate FROM tbl_bankaccountdetail WHERE vehicle_id = ?");
				$stmt_bank->bind_param("i", $vehicle_data['vehicle_id']);
				$stmt_bank->execute();
				$stmt_bank->bind_result($ddstartdate, $ddenddate);
				$stmt_bank->fetch();
				$stmt_bank->close();
				
				$stmtins = $this->conn->prepare("INSERT INTO tbl_vehicleplandetail (user_id, vehicle_id, plan_id, start_date, end_date) VALUES (?, ?, ?, ?, ?)");
				$stmtins->bind_param("iiiss", $customer_id,  $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $ddstartdate, $ddenddate);
				$result = $stmtins->execute();
				$stmtins->close();
				
				
				$user_info = $this->getAdminUser($user_id);
				$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 0");
				$stmtcom->bind_param("ii", $user_id, $vehicle_data['plan_id']);
				$stmtcom->execute();
				$stmtcom->bind_result($commission_price);
				$stmtcom->fetch();
				$stmtcom->close();
				$datetime = date("Y-m-d H:i:s");
				
				$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 0, ?)");
				$stmtcomins->bind_param("iiiss", $user_id, $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price, $datetime);
				$stmtcomins->execute();
				if($user_info['usertype_id'] == 1){
					$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 1");
					$stmtcom->bind_param("ii", $user_info['addedbyuser_id'], $vehicle_data['plan_id']);
					$stmtcom->execute();
					$stmtcom->bind_result($commission_price_manager);
					$stmtcom->fetch();
					$stmtcom->close();
					
					$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 1, ?)");
					$stmtcomins->bind_param("iiiss", $user_info['addedbyuser_id'], $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price_manager, $datetime);
					$stmtcomins->execute();
				}
				
			}
			$stmt->close();
			$stmt = $this->conn->prepare("UPDATE tbl_vehicle SET status = 1 WHERE user_id = ?");
			$stmt->bind_param("i", $customer_id);			
			$result = $stmt->execute();
			$stmt->close();
            // TODO
            return $result;
        } else {
            return NULL;
        }
		
		
	}
    /** Opal
     * Checking user login
     * @param String $email User login email id
     * @param String $password User login password
     * @return boolean User login status success/fail
     */
    public function checkLogin($email, $password) {
        // fetching user by email
        $stmt = $this->conn->prepare("SELECT password FROM tbl_adminuser WHERE emailaddress = ? AND status = 1");

        $stmt->bind_param("s", $email);

        $stmt->execute();

        $stmt->bind_result($password_hash);

        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            // Found user with the email
            // Now verify the password

            $stmt->fetch();

            $stmt->close();

            if (PassHash::check_password($password_hash, $password)) {
                // User password is correct
                return TRUE;
            } else {
                // user password is incorrect
                return FALSE;
            }
        } else {
            $stmt->close();

            // user not existed with the email
            return FALSE;
        }
    }

    /** Opal
     * Checking for duplicate user by email address
     * @param String $email email to check in db
     * @return boolean
     */
    private function isUserExists($email) {
        $stmt = $this->conn->prepare("SELECT id from tbl_customer WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
        $stmt->close();
        return $num_rows > 0;
    }

    /** Opal
     * Fetching user by email
     * @param String $email User email id
     */
    public function getUserByEmail($email) {
        $stmt = $this->conn->prepare("SELECT firstname, lastname, emailaddress, api_key, profilepic FROM tbl_adminuser WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
		//print_r($stmt);
        if ($stmt->execute()) {
            // $user = $stmt->get_result()->fetch_assoc();
            $stmt->bind_result($firstname, $lastname, $emailaddress, $api_key, $profilepic);
            $stmt->fetch();																									
            $user = array();
            $user["firstname"] = $firstname;
            $user["lastname"] = $lastname;
            $user["emailaddress"] = $emailaddress;
            $user["api_key"] = $api_key;
			if($profilepic == NULL || $profilepic == ""){
				$user["userImage"] = 'no-profile.jpg';
			}else{
				$user["userImage"] = $profilepic;
			}
			//print_r($user);
            $stmt->close();
            return $user;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Fetching user api key
     * @param String $user_id user id primary key in user table
     */
    public function getApiKeyById($user_id) {
        $stmt = $this->conn->prepare("SELECT api_key FROM tbl_customer WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        if ($stmt->execute()) {
            // $api_key = $stmt->get_result()->fetch_assoc();
            // TODO
            $stmt->bind_result($api_key);
            $stmt->close();
            return $api_key;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Fetching user id by api key
     * @param String $api_key user api key
     */
    public function getUserId($api_key) {
        $stmt = $this->conn->prepare("SELECT user_id FROM tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        if ($stmt->execute()) {
            $stmt->bind_result($user_id);
            $stmt->fetch();
            // TODO
            // $user_id = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            return $user_id;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Validating user api key
     * If the api key is there in db, it is a valid key
     * @param String $api_key user api key
     * @return boolean
     */
    public function isValidApiKey($api_key) {
        $stmt = $this->conn->prepare("SELECT emailaddress from tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
		//echo $num_rows;
        $stmt->close();
        return $num_rows > 0;
    }

    /** Opal
     *  Generating random Unique MD5 String for user Api key 
     */
    public function generateApiKey() {
        return md5(uniqid(rand(), true));
    }
	/** Opal 
	* Update the Api Key in customer table
	**/
	public function updateApikey($emailaddress = '', $api_key){
		if($emailaddress != ""){
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser set api_key = ? WHERE emailaddress = ?");
			$stmt->bind_param("ss", $api_key, $emailaddress);
			$result = $stmt->execute();
			$stmt->close();
		}else{
			//echo $api_key;
			$key = NULL;
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser SET api_key = ? WHERE api_key = ?");
			$stmt->bind_param("is", $key, $api_key);			
			$result = $stmt->execute();
			$stmt->close();
			
		}
		return $result;
       
	}
    /* ------------- `tasks` table method ------------------ */

    /**
     * Creating new task
     * @param String $user_id user id to whom task belongs to
     * @param String $task task text
     */
    public function createTask($user_id, $task) {
        $stmt = $this->conn->prepare("INSERT INTO tasks(task) VALUES(?)");
        $stmt->bind_param("s", $task);
        $result = $stmt->execute();
        $stmt->close();

        if ($result) {
            // task row created
            // now assign the task to user
            $new_task_id = $this->conn->insert_id;
            $res = $this->createUserTask($user_id, $new_task_id);
            if ($res) {
                // task created successfully
                return $new_task_id;
            } else {
                // task failed to create
                return NULL;
            }
        } else {
            // task failed to create
            return NULL;
        }
    }

    /**
     * Fetching single task
     * @param String $task_id id of the task
     */
    public function getWarningLight($cms_id) {
        $stmt = $this->conn->prepare("SELECT cms_id, cms_title, cms_description, cms_icon from tbl_cms WHERE cms_id = ?");
        $stmt->bind_param("i", $cms_id);
        if ($stmt->execute()) {
            $res = array();
            $stmt->bind_result($cms_id, $cms_title, $cms_description, $cms_icon);
            // TODO
            // $task = $stmt->get_result()->fetch_assoc();
            $stmt->fetch();
            $res["cms_id"] = $cms_id;
            $res["cms_title"] = $cms_title;
            $res["cms_description"] = $cms_description;
            $res["cms_icon"] = $cms_icon;
            $stmt->close();
            return $res;
        } else {
            return NULL;
        }
    }

    /**
     * Fetching all user tasks
     * @param String $user_id id of the user
     */
    public function getWarningLights() {
        $stmt = $this->conn->prepare("SELECT * FROM tbl_cms where warning_lights = '1' AND status = '1'");
        $stmt->execute();
        $warningLights = $stmt->get_result();
        $stmt->close();
        return $warningLights;
    }

    /**
     * Updating task
     * @param String $task_id id of the task
     * @param String $task task text
     * @param String $status task status
     */
    public function updateTask($user_id, $task_id, $task, $status) {
        $stmt = $this->conn->prepare("UPDATE tasks t, user_tasks ut set t.task = ?, t.status = ? WHERE t.id = ? AND t.id = ut.task_id AND ut.user_id = ?");
        $stmt->bind_param("siii", $task, $status, $task_id, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
    }

    /**
     * Deleting a task
     * @param String $task_id id of the task to delete
     */
    public function deleteTask($user_id, $task_id) {
        $stmt = $this->conn->prepare("DELETE t FROM tasks t, user_tasks ut WHERE t.id = ? AND ut.task_id = t.id AND ut.user_id = ?");
        $stmt->bind_param("ii", $task_id, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
    }

    /* ------------- `user_tasks` table method ------------------ */

    /**
     * Function to assign a task to user
     * @param String $user_id id of the user
     * @param String $task_id id of the task
     */
    public function createUserTask($user_id, $task_id) {
        $stmt = $this->conn->prepare("INSERT INTO user_tasks(user_id, task_id) values(?, ?)");
        $stmt->bind_param("ii", $user_id, $task_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
        $stmt->close();
        return $result;
    }
	
	/* ------------- `tbl_inquiry` table method ------------------ */

    /**
     * Function to assign a task to user
     * @param String $user_id id of the user
     * @param String $task_id id of the task
     */
    public function createCustomerInquiry($user_id, $description) {
		$today_date = date('Y-m-d');
        $stmt = $this->conn->prepare("INSERT INTO tbl_inquiry (sender_id, message, inquiry_date) values(?, ?, ?)");
		//print_r($stmt);
        $stmt->bind_param("iss", $user_id, $description, $today_date);
		//echo "Hello";die();
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
        $stmt->close();
        return $result;
    }
	
	/* ------------- `tbl_customer` table method ------------------ */

    /**
     * Function get All data of Customer
     * @param String $user_id id of the user
     */
    public function getCustomer($user_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_customer` WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	
	public function getVehicle($vehicle_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_vehicle` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $vehicle_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getBankData($vehicle_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_bankaccountdetail` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $vehicle_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getEngineData($enginetype_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_enginetype` WHERE enginetype_id = ?");
        $stmt->bind_param("i", $enginetype_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getCategoryData($category_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_category` WHERE category_id = ?");
        $stmt->bind_param("i", $category_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getPlanDataDis($plan_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_plan` WHERE plan_id = ?");
        $stmt->bind_param("i", $plan_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	
	/**
     * Fetching all Customer Cars
     * @param String $user_id id of the user
     */
    public function getCustomerCar($user_id) {
		$today_date = date('Y-m-d');
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_vehicle` as v, tbl_vehicleplandetail as vp WHERE v.vehicle_id = vp.vehicle_id AND v.user_id = ? AND vp.end_date >= ?");
        $stmt->bind_param("is", $user_id, $today_date );
        $result = $stmt->execute();
        $cars_data = $stmt->get_result();
		$final_cars = array();
		while ($cars =  $cars_data->fetch_assoc()) {
                $tmp = array();
				$bank_detail = $this->getBankAccount($cars['vehicle_id']);
				//print_r($bank_detail);
				//die();
				$tmp["payment_frequency"] = $bank_detail['paymentfrequency'];
				$tmp["payment_day"] = $bank_detail['paymentday'];
				$tmp["payment_amount"] = $bank_detail['ddamount'];
				$plan_detail = $this->getPlan($cars['plan_id']);
                $tmp["plateno"] = $cars["plateno"];
                $tmp["make"] = $cars["make"];
                $tmp["model"] = $cars["model"];
				$tmp["year"] = $cars["year"];
				$tmp["color"] = $cars["color"];

				//$date_diff = date_diff($next_serrvice, date_create($today_date));
				$nodays=(strtotime($cars["next_service_date"]) - strtotime($today_date))/ (60 * 60 * 24); 
				$tmp["nextservice"] = (int)$nodays;
				if($nodays >= 0){
					$tmp["nextservicetext"] = "Before Service";
				}else{
					$tmp["nextservicetext"] = "Overdue";
				}
				$tmp["plan_type"] = $plan_detail['planname'];
				$tmp["term"] = $plan_detail['duration'];
				$tmp["renewal_date"] = date("d-m-Y", strtotime($cars["end_date"]));
				
                array_push($final_cars, $tmp);
            }
        $stmt->close();
        return $final_cars;
    }
	
	/**
     * Get Last Booking Details 
     * @param String $car_id of the user
     */
    public function getLastBooking($car_id) {
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_booking` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
		if($num_rows > 0){
			
		}else{
			
		}

    }
	
	/**
     * Get Bank Account Details 
     * @param String $car_id of the user
     */
    public function getBankAccount($car_id) {
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_bankaccountdetail` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $car_id);
        $stmt->execute();
        $bank_data = $stmt->get_result();
		$return_arrray=array();
        while ($bank = $bank_data->fetch_assoc()) {
			$return_arrray['ddamount'] = $bank['ddamount'];
			$return_arrray['paymentfrequency'] = $bank['paymentfrequency'];
			$return_arrray['paymentday'] = $bank['paymentday'];
		}
		//print_r($return_arrray);die();
		return $return_arrray;

    }
	public function getPlan($plan_id){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plan` WHERE plan_id = ?");
        $stmt->bind_param("i", $plan_id);
        $stmt->execute();
		$plan_data = $stmt->get_result();
		$return_arrray=array();
        while($plan = $plan_data->fetch_assoc()) {
			$return_arrray['planname'] = $plan['planname'];
			$return_arrray['duration'] = $plan['duration'];
		}
		//print_r($return_arrray);
		return $return_arrray;
	}
	public function getPlanData($enginetype_id, $term, $type){
		//echo $enginetype_id."::".$term."::".$type;
		$stmt = $this->conn->prepare("SELECT cp.* FROM `tbl_plan` as p, tbl_categoriesplan as cp WHERE p.plan_id = cp.plan_id AND cp.enginetype_id = ? AND p.duration = ? AND p.planname = ?");
        $stmt->bind_param("iss", $enginetype_id, $term, $type);
        $stmt->execute();
		$plan_data = $stmt->get_result();
		$return_arrray=array();
        while($plan = $plan_data->fetch_assoc()) {
			$return_arrray['plan_id'] = $plan['plan_id'];
			$return_arrray['price'] = $plan['price'];
		}
		//print_r($return_arrray);
		return $return_arrray;
	}
	
	
	  /* ------------- `tbl_user_car_location` table method ------------------ */

    /**
     * Creating New Location
     * @param String $user_id user id to whom task belongs to
     * @param String $task task text
     */
    public function createLockLocation($user_id, $lat, $lan, $datetime, $api_key) {
		
        $stmt = $this->conn->prepare("INSERT INTO tbl_user_car_location (user_id, latitude, longitude, end_datetime, authorization_key) VALUES (?, ?, ?, ?, ?)");
		//echo "".$user_id."=".$lat."=".$lan."=".$datetime."=".$api_key;
		$stmt->bind_param("issss", $user_id, $lat, $lan, $datetime, $api_key);
        $result = $stmt->execute();
		

        $stmt->close();

        if ($result) {
            return true;
        } else {
            return NULL;
        }
    }
	/** Opal
     * Check if there is car already registred
     * If the api key is there in db
     * @param String $api_key user api key
     * @return boolean
     */
    public function getCarLocation($user_id, $api_key) {
        $stmt = $this->conn->prepare("SELECT * from tbl_user_car_location WHERE authorization_key = ? AND user_id = ? ORDER BY user_car_location_id DESC LIMIT 0,1");
        $stmt->bind_param("si", $api_key, $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	
	public function getCategory() {
        $stmt = $this->conn->prepare("SELECT * from tbl_category WHERE status = 1");
        $stmt->execute();
        $result = $stmt->get_result();
        
		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	
	public function getEngine($category_id) {
        $stmt = $this->conn->prepare("SELECT * from tbl_enginetype WHERE status = 1 AND category_id = ?");
        $stmt->bind_param("i", $category_id);

		$stmt->execute();
        $result = $stmt->get_result();
        
		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	public function getEngineId($category_id, $enginName) {
        $stmt = $this->conn->prepare("SELECT enginetype_id from tbl_enginetype WHERE status = 1 AND category_id = ? AND name = ?");
        $stmt->bind_param("is", $category_id, $enginName);

		$stmt->execute();
        $result = $stmt->get_result();
        while($engine = $result->fetch_assoc()){
			$enginetype_id = $engine['enginetype_id'];
		}
		//echo $num_rows;
        $stmt->close();
        return $enginetype_id;
    }
	
	public function getCost($engine_id) {
                
		$stmt = $this->conn->prepare("SELECT duration from tbl_plan GROUP BY duration");
		$stmt->execute();
        $plan_duration = $stmt->get_result();
		$stmt->close();
		$response["costs"] = array();
		while($duration = $plan_duration->fetch_assoc()){
			//print_r($duration);
			$tmp = array();
			$stmt = $this->conn->prepare("SELECT * from tbl_categoriesplan as cp, tbl_plan as p WHERE cp.plan_id = p.plan_id AND cp.enginetype_id = ? AND p.duration=?");
			$stmt->bind_param("is", $engine_id,$duration['duration'] );
			$stmt->execute();
			$tmp['duration'] = $duration['duration'];
			$result = $stmt->get_result();
			$stmt->close();
			while($costPlan = $result->fetch_assoc()){
				$tmp['price'.$costPlan['planname']] = $costPlan['price'];
			
			}
			array_push($response["costs"], $tmp);
		}
		
		$response["error"] = false;
		$stmt = $this->conn->prepare("SELECT e.name as engine_name, c.name as category_name from tbl_enginetype as e, tbl_category as c WHERE e.category_id = c.category_id AND e.enginetype_id = ?");
		$stmt->bind_param("i", $engine_id);
		$stmt->execute();
		$engine_result = $stmt->get_result();
		$stmt->close();
		while($engine_row = $engine_result->fetch_assoc()){
			//print_r($engine_row);
			$response["name"] = $engine_row['category_name'].' '.$engine_row['engine_name'];
		}
		//print_r($response);
		return $response;
    }
	
	
	function updateCustomer($user_id, $addressLine1, $addressLine2, $mobile, $email){
		$result = $this->getCustomer($user_id);
		$data = $result->fetch_assoc();
		$user_type = 0;
		//print_r($data);
		//die();
		$stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
		$stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
        $stmt->execute();
		$stmt->close();
		
		
		$stmt = $this->conn->prepare("UPDATE  tbl_customer set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
        $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	function updateAdmin($user_id, $addressLine1, $addressLine2, $mobile, $email, $accountname, $accountnumber, $bankname){
		//$result = $this->getCustomer($user_id);
		//$data = $result->fetch_assoc();
		$user_type = 1;
		//print_r($data);
		//die();
		$stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
		$stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
        $stmt->execute();
		$stmt->close();
		
		
		$stmt = $this->conn->prepare("UPDATE  tbl_adminuser set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
        $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
		
		$stmt = $this->conn->prepare("UPDATE  tbl_bankaccountdetail set accountname = ?, accountnumber = ?, bankname = ? WHERE user_id = ?");
        $stmt->bind_param("sssi", $accountname, $accountnumber, $bankname, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	function getSitemanagerByCustomer($user_id){
		
		$stmt = $this->conn->prepare("SELECT addedbyuser_id FROM `tbl_customer` WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$customer_data_res = $stmt->get_result();
		$customer_data = $customer_data_res->fetch_assoc();
        $stmt->close();
		//print_r($customer_data);die();
		$stmt = $this->conn->prepare("SELECT addedbyuser_id,usertype_id FROM `tbl_adminuser` WHERE user_id = ?");
        $stmt->bind_param("i", $customer_data['addedbyuser_id']);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$customer_sales_man_res = $stmt->get_result();
        $stmt->close();
		$customer_sales_man = $customer_sales_man_res->fetch_assoc();
		if($customer_sales_man['usertype_id'] == "1"){

			$stmt = $this->conn->prepare("SELECT addedbyuser_id,usertype_id FROM `tbl_adminuser` WHERE user_id = ?");
			$stmt->bind_param("i", $customer_sales_man['addedbyuser_id']);
			$result = $stmt->execute();
			if (false === $result) {
				die('execute() failed: ' . htmlspecialchars($stmt->error));
			}
			$customer_sales_manager_res = $stmt->get_result();
			$customer_sales_manager = $customer_sales_manager_res->fetch_assoc();
			$stmt->close();
			$sitemanager_id = $customer_sales_manager['addedbyuser_id'];
		}else{
			$sitemanager_id = $customer_sales_man['addedbyuser_id'];
		}
		return $sitemanager_id;
	}
	
	public function getUserFeedback($user_id){
		$sender_id = $user_id;
		$receiver_id = $this->getSitemanagerByCustomer($user_id);
		
		$stmt = $this->conn->prepare("SELECT conversation_id FROM `tbl_conversation` WHERE ((sender_id = ? AND receiver_id = ?) OR (sender_id = ? AND receiver_id = ?)) AND status = 0");
        $stmt->bind_param("iiii", $sender_id, $receiver_id, $receiver_id, $sender_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$check_conversation_res = $stmt->get_result();
		$check_conversation = $check_conversation_res->fetch_assoc();
        $stmt->close();
		if(!empty($check_conversation)){

			$conversation_id = $check_conversation['conversation_id'];
			$stmt = $this->conn->prepare("SELECT * FROM `tbl_message` WHERE conversation_id = ? ORDER BY conversation_datetime ASC");
			$stmt->bind_param("i", $conversation_id);
			$result = $stmt->execute();

			if (false === $result) {
				die('execute() failed: ' . htmlspecialchars($stmt->error));
			}
			$conversation = $stmt->get_result();
			$stmt->close();
			return $conversation;
		}		
	}
	public function getAdminUser($admin_id){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` WHERE user_id = ?");
		$stmt->bind_param("i", $admin_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$customer_sales_manager_res = $stmt->get_result();
		$customer_sales_manager = $customer_sales_manager_res->fetch_assoc();
		return $customer_sales_manager;
	}
	
	public function getAdmindata($admin_id){
		$stmt = $this->conn->prepare("SELECT accountname, accountnumber, bankname, emailaddress, mobilenumber, address, address2 FROM `tbl_adminuser` as a, tbl_bankaccountdetail as b WHERE a.user_id = ? AND b.user_id=a.user_id AND b.user_type = 1");
		$stmt->bind_param("i", $admin_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$admin_data_res = $stmt->get_result();
		$admin_data = $admin_data_res->fetch_assoc();
		return $admin_data;
	}
	
	
	function insertMessage($sender_id, $receiver_id, $message, $conversation_id, $conversation_datetime, $send_by){
		$stmt = $this->conn->prepare("INSERT INTO `tbl_message`(`conversation_id`, `sender_id`, `receiver_id`, `message`, `send_by`, `conversation_datetime`) VALUES (?, ?, ?, ?, ?, ?)");
		$stmt->bind_param("iiisss", $conversation_id, $sender_id, $receiver_id, $message, $send_by, $conversation_datetime);
        $result = $stmt->execute();
        $stmt->close();

        if ($result) {
            return true;
        } else {
            return NULL;
        }
	}
	public function getTeam(){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` as a, tbl_usertype as u where a.usertype_id = u.usertype_id AND a.status =1 ");
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$team_data = $stmt->get_result();
		$stmt->close();
		return $team_data;
	}
	
	public function getCarApi($plate_no){
		//echo $plate_no;
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plateno_detail` WHERE plateno = ?");
		$stmt->bind_param("s", $plate_no);
		
		$result = $stmt->execute();
		$team_data_array = $stmt->get_result();
		//$stmt->store_result();
		//echo $num_rows = $stmt->num_rows;//die();
		
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		
		if($team_data_array->num_rows  > 0){
			//echo "Here";
			//print_r($team_data_array);
			//$team_data_array = $stmt->get_result();
			while ($data = $team_data_array->fetch_assoc()) {
				$team_data['id'] = $data['id'];
				$team_data['plateno'] = $data['plateno'];
				$team_data['make'] = $data['make'];
				$team_data['model'] = $data['model'];
				$team_data['year'] = $data['year'];
				$team_data['vin'] = $data['vin'];
				$team_data['color'] = $data['color'];
				$team_data['fuel'] = $data['fuel'];
			}
			//print_r($team_data);
			$stmt->close();
			return $team_data;
		}else{
			//echo "there";die();
			$url = "https://www.carjam.co.nz/api/car/?plate=".$plate_no."&key=3E8F37594613B3520503DF926666C7E9505B42D5";
		
			$xml = simplexml_load_file($url);
			//echo "<pre>";print_r($xml->idh->vehicle);echo "</pre>";
			
			$make = $xml->idh->vehicle->make;
			$model = $xml->idh->vehicle->model;
			$year = $xml->idh->vehicle->year_of_manufacture;
			$vin = $xml->idh->vehicle->vin;
			$color = $xml->idh->vehicle->main_colour;
			$fuel = $xml->idh->vehicle->fuel_type;
			if($make != ""){
				
				$stmt = $this->conn->prepare("INSERT INTO `tbl_plateno_detail`(`plateno`, `make`, `model`, `year`, `vin`, `color`, `fuel`) VALUES (?, ?, ?, ?, ?, ?, ?)");
				$stmt->bind_param("sssssss", $plate_no, $make, $model, $year, $vin, $color, $fuel);
				$result = $stmt->execute();
				$stmt->close();
				$stmt = $this->conn->prepare("SELECT * FROM `tbl_plateno_detail` WHERE plateno = ?");
				$stmt->bind_param("s", $plate_no);
				
				$result = $stmt->execute();
				$team_data_array = $stmt->get_result();
				//$stmt->store_result();
				//echo $num_rows = $stmt->num_rows;//die();
				
				if (false === $result) {
					die('execute() failed: ' . htmlspecialchars($stmt->error));
				}
				while ($data = $team_data_array->fetch_assoc()) {
					$team_data['id'] = $data['id'];
					$team_data['plateno'] = $data['plateno'];
					$team_data['make'] = $data['make'];
					$team_data['model'] = $data['model'];
					$team_data['year'] = $data['year'];
					$team_data['vin'] = $data['vin'];
					$team_data['color'] = $data['color'];
					$team_data['fuel'] = $data['fuel'];
				}
				//print_r($team_data);
				$stmt->close();
				return $team_data;
			}else{
				return "Error";
			}
			
		}
		
	}
	
	public function getCategoryId($getCategoryId){
		//echo $plate_no;
		$param = "%,".$getCategoryId.",%";
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_category` WHERE make LIKE ?");
		$stmt->bind_param("s",$param );
		
		$result = $stmt->execute();
		$team_data_array = $stmt->get_result();
		
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		if($team_data_array->num_rows  > 0){
			//echo "Here";
			//print_r($team_data_array);
			//$team_data_array = $stmt->get_result();
			while ($data = $team_data_array->fetch_assoc()) {
				$team_data['category_id'] = $data['category_id'];
				
			}
			//print_r($team_data);
			$stmt->close();
			return $team_data;
		}
	}
	public function getCommissionTable($user_id){
		
		
		$stmt = $this->conn->prepare("SELECT duration from tbl_plan GROUP BY duration ORDER BY plan_id");
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$plan_durations = $stmt->get_result();
		$stmt->close();
		$response["error"] = false;
		$response["commissionTable"] = array();
		while ($plan_duration = $plan_durations->fetch_assoc()) {
                $tmp = array();
                $tmp["duration"] = $plan_duration["duration"];
				$stmt = $this->conn->prepare("SELECT planname from tbl_plan GROUP BY planname ORDER BY plan_id");
				$result = $stmt->execute();
				if (false === $result) {
					die('execute() failed: ' . htmlspecialchars($stmt->error));
				}
				$plan_names = $stmt->get_result();
				$stmt->close();
				while ($plan_name = $plan_names->fetch_assoc()) {
					$stmt = $this->conn->prepare("SELECT b.* FROM tbl_plan a left join tbl_salesmancommission b on a.plan_id = b.plan_id WHERE b.user_id = ? AND a.duration = ? AND a.planname = ? AND b.commission_type = 0");
					$stmt->bind_param("iss", $user_id, $plan_duration['duration'],$plan_name['planname']);
					$result = $stmt->execute();
					if (false === $result) {
						die('execute() failed: ' . htmlspecialchars($stmt->error));
					}
					$commissionValues = $stmt->get_result();
					$stmt->close();
					//$tmp[$plan_name["planname"]] = $plan_name["planname"];

					while($commissionValue = $commissionValues->fetch_assoc())
					{
						$tmp[$plan_name["planname"]] = $commissionValue["commission_price"];
					}
					
				}
				//$tmp["commission_price"] = $commissionValue["commission_price"];

                array_push($response["commissionTable"], $tmp);
            }
		
		//print_r($response);
		return $response;
	}
	
	public function getMyCommission($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;
		
		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;
			
			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0 OR commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 0 OR commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();
			
			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0 OR commission_type = 1) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();
					
			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;
			
			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission, 2, '.', '');
			$tmp['loss'] = number_format($total_week_loss_commission, 2, '.', '');
			$tmp['totalSales'] = number_format($total_yearly_commission, 2, '.', '');
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission, 2, '.', '');
		$tmp['loss'] = number_format($grand_total_loss_commission, 2, '.', '');
		$tmp['totalSales'] = number_format($grand_total_yearly_commission, 2, '.', '');
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	
	public function getMySales($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;
		
		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;
			
			$stmt = $this->conn->prepare("SELECT count(*) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0 OR commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT count(*) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 0 OR commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();
			
			$stmt = $this->conn->prepare("SELECT count(*) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0 OR commission_type = 1) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();
					
			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;
			
			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission);
			$tmp['loss'] = number_format($total_week_loss_commission);
			$tmp['totalSales'] = number_format($total_yearly_commission);
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission);
		$tmp['loss'] = number_format($grand_total_loss_commission);
		$tmp['totalSales'] = number_format($grand_total_yearly_commission);
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	public function getPendingApplication($user_id){
		$stmt = $this->conn->prepare("SELECT registration_date, firstname, lastname, address, address2, user_id FROM tbl_customer WHERE addedbyuser_id = ? AND status = 2");
		$stmt->bind_param("i", $user_id);
		$stmt->execute();
		$return_arrray['error'] = false;
		$return_arrray['customerData'] = array();
		$pending_application = $stmt->get_result();
		while($row_pending_application = $pending_application->fetch_assoc()){
			$tmp = array();
			$tmp['applicationDate'] = date('Y-m-d', strtotime($row_pending_application['registration_date']));
			$tmp['name'] = $row_pending_application['firstname']." ".$row_pending_application['lastname'];
			$tmp['address'] = $row_pending_application['address'];
			$tmp['address2'] = $row_pending_application['address2'];
			$tmp['customerId'] = $row_pending_application['user_id'];
			array_push($return_arrray['customerData'], $tmp);
		}
		return $return_arrray;
	}
	public function getAllPlan(){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plan`");
        $stmt->execute();
		$plan_data = $stmt->get_result();
		return $plan_data;
	}
}
?>
