<?php

/**
 * Class to handle all db operations
 * This class will have CRUD methods for database tables
 *
 * @author Ravi Tamada
 * @link URL Tutorial link
 */
class DbHandler {

    private $conn;

    function __construct() {
        require_once dirname(__FILE__) . '/DbConnect.php';
        // opening db connection
        $db = new DbConnect();
        $this->conn = $db->connect();
    }

    /* ------------- `users` table method ------------------ */

    /**
     * Creating new user
     * @param String $name User full name
     * @param String $email User login email id
     * @param String $password User login password
     */
    public function createUser($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $addedbyuser_id, $home) {
			$date = date('Y-m-d H:i:s');
            // insert query
            $stmt = $this->conn->prepare("INSERT INTO tbl_customer(firstname, lastname, dateofborth, gender, mobilenumber, address, address2, emailaddress, drivinglicencenumber, drivinglicenceexpiredate, drivinglicencefile1, drivinglicencefile2, profilepic, addedbyuser_id, homenumber, registration_date, status) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 2)");
            $stmt->bind_param("sssssssssssssiss", $firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $addedbyuser_id, $home, $date);

            $result = $stmt->execute();
			//print_r($result);
			$last_id = $stmt->insert_id;
            $stmt->close();

            // Check for successful insertion
            if ($result) {
                // User successfully inserted
                return $last_id;
            } else {
                // Failed to create user
                return USER_CREATE_FAILED;
            }


        //return $response;
    }

    // here mohit create update function for customer
    public function updateUserinfo($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home,$json_userid){
        // update query
        $stmt_user_update = $this->conn->prepare("UPDATE tbl_customer SET firstname = ?,lastname = ?,dateofborth = ?,gender = ?,mobilenumber = ?,address = ?,address2 = ?,emailaddress = ?,drivinglicencenumber = ?,drivinglicenceexpiredate = ?,drivinglicencefile1 = ?,drivinglicencefile2 = ?,profilepic = ?,homenumber = ? WHERE user_id = ? ");
        $stmt_user_update->bind_param("ssssssssssssssi",$firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $home,$json_userid);
        $result = $stmt_user_update->execute();
        $stmt_user_update->close();
    }
    // end

    // here we create function to check vehicle is present or not
    public function checkuserVehicle($json_userid,$plate_no){
        // select query
        $check_vehicl = $this->conn->prepare("SELECT vehicle_id FROM tbl_vehicle WHERE user_id = ? AND plateno = ?");
        $check_vehicl->bind_param("is",$json_userid,$plate_no);
        if ($check_vehicl->execute()) {
            $check_vehicl->bind_result($vehicle_id);
            $check_vehicl->fetch();
            $check_vehicl->close();
            return $vehicle_id;
	}
    }
    // End

    // here we check function to bank account detail id is present or onot
    public function checkUserbankDetails($json_userid,$vehicle_id){
        $check_vehicl = $this->conn->prepare("SELECT bankaccountdetail_id FROM tbl_bankaccountdetail WHERE user_id = ? AND vehicle_id = ?");
        $check_vehicl->bind_param("ii",$json_userid,$vehicle_id);
        if ($check_vehicl->execute()) {
            $check_vehicl->bind_result($bankaccountdetail_id);
            $check_vehicl->fetch();
            $check_vehicl->close();
            return $bankaccountdetail_id;
	}
    }
    // End


	public function updateRegisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id){

		$enginetype_id = $this->getEngineId($category, $enginType);
		$plan_data = $this->getPlanData($enginetype_id, $term, $type);
		//print_r($plan_data);
		if($paymentFrequency == "Fortnightly"){
			$plan_price = $plan_data['price']*2;
		}else{
			$plan_price = $plan_data['price'];
		}
		$status = 2;
		$stmt2 = $this->conn->prepare("INSERT INTO tbl_vehicle(user_id, category_id, enginetype_id, plan_id, plateno, make, model, year, vin, color, fuel, paymentfrequency, paymentday, status) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$stmt2->bind_param("iiiisssssssssi", $customer_id, $category, $enginetype_id, $plan_data['plan_id'], $plate_no, $make, $model, $year, $vin, $color, $fuel, $paymentFrequency, $paymentDay, $status);
		$result = $stmt2->execute();
		$vehicle_id = $stmt2->insert_id;
		$stmt2->close();
		// Check for successful insertion
		if ($result) {
			$data_return['vehicle_id'] = $vehicle_id;
			$data_return['plan_price'] = $plan_price;
			$data_return['plan_id'] = $plan_data['plan_id'];
			// User successfully inserted
			return $data_return;
		} else {
			// Failed to create user
			return USER_CREATE_FAILED;
		}
	}
        // Here mohit create function for update vehicle information
        public function updateUserregisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay,$json_userid, $vehicle_id){
            $enginetype_id = $this->getEngineId($category, $enginType);

            $plan_data = $this->getPlanData($enginetype_id, $term, $type);
            if($paymentFrequency == "Fortnightly"){
                $plan_price = $plan_data['price']*2;
            }else{
				$plan_price = $plan_data['price'];
            }
            $stat_vehicle_update = $this->conn->prepare("UPDATE tbl_vehicle SET plan_id = ? ,plateno = ?,make = ?,model = ?,year = ?,vin = ?,color = ?,fuel = ?,plan_id = ?,category_id = ?,enginetype_id = ?,paymentfrequency = ?,paymentday = ? WHERE vehicle_id = ? ");
            $stat_vehicle_update->bind_param("isssssssiiissi",$plate_id,$plate_no,$make,$model,$year,$vin,$color,$fuel,$plan_data['plan_id'],$category,$enginetype_id,$paymentFrequency,$paymentDay, $vehicle_id);
            $result = $stat_vehicle_update->execute();
            $stat_vehicle_update->close();
            return $plan_price;
        }
        // End

        // Here we Fetch user information
        public function getUserinfo($user_id){
            $userinfo_data = $this->conn->prepare(" SELECT c.*,v.*,b.* FROM `tbl_customer` as c join `tbl_vehicle` as v join `tbl_bankaccountdetail` as b where c.user_id = ? group by c.user_id ");
            $userinfo_data->bind_param("i",$user_id);
            $userinfo_data->execute();
            $userinfo = $userinfo_data->get_result();
            $userinfo_data->close();
            return $userinfo;
        }
        // End

        public function updateRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount, $customer_id, $vehicle_id)
	{
            $stmt2 = $this->conn->prepare("INSERT INTO tbl_bankaccountdetail(user_id, accountname, accountnumber, bankname, ddamount, multicar_discount, ddstartdate, ddenddate, vehicle_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt2->bind_param("issssssss", $customer_id, $BankAccountName, $BankAccountNo, $Bank, $ddAmount, $multicar_discount, $ddStartDate, $ddEndDate, $vehicle_id);
            $result = $stmt2->execute();

            $stmt2->close();
            return $result;

	}
        // here we check the existing user or not
        public function checkUsertable($mobile){
            $check_vehicl = $this->conn->prepare("SELECT user_id FROM tbl_customer WHERE mobilenumber = ?");
            $check_vehicl->bind_param("s",$mobile);
            if ($check_vehicl->execute()) {
                $check_vehicl->bind_result($user_id);
                $check_vehicl->fetch();
                $check_vehicl->close();
                return $user_id;
            }
        }
        // End

        // here mohir create function for update tbl_bankaccountdetail info
        public function updateUserRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount,$chek_bank_userdetails){
            $update_bank_info = $this->conn->prepare("UPDATE tbl_bankaccountdetail SET accountname = ?,accountnumber = ?,bankname = ?,ddstartdate = ?,ddenddate = ?,ddamount = ?,multicar_discount = ? WHERE bankaccountdetail_id = ?");
            $update_bank_info->bind_param("sssssssi",$BankAccountName,$BankAccountNo,$Bank,$ddStartDate,$ddEndDate,$ddAmount,$multiCarDiscount,$chek_bank_userdetails);
            $result = $update_bank_info->execute();
            $update_bank_info->close();
        }

        // end

     public function getPendingVehicleCustomer($customer_id){
		$stmt = $this->conn->prepare("SELECT vehicle_id FROM tbl_vehicle WHERE  user_id = ? AND  status = 2");
		$stmt->bind_param("i", $customer_id);

		if ($stmt->execute()) {
			$result1 = $stmt->get_result();
			$vehicle_data1 =  array();
            while($vehicle_data = $result1->fetch_assoc())
			{
				$tmp = array();
				$tmp['id']= $vehicle_data['vehicle_id'];
				array_push($vehicle_data1, $tmp);
			}
			$stmt->close();

			return $vehicle_data1;
		}
	}

	public function deleteCar($vehicle_id, $customer_id){
		$stmt = $this->conn->prepare("DELETE  FROM tbl_vehicle WHERE vehicle_id = ?");
        $stmt->bind_param("i", $vehicle_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();

		$stmt = $this->conn->prepare("DELETE FROM tbl_bankaccountdetail  WHERE vehicle_id = ? AND user_id = ?");
        $stmt->bind_param("ii", $vehicle_id, $customer_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();

        return $num_affected_rows > 0;
	}

	public function getVehicleCustomerLastId($customer_id){
		$stmt = $this->conn->prepare("SELECT vehicle_id FROM tbl_vehicle WHERE  user_id = ? ORDER BY vehicle_id DESC LIMIT 0,1");
        $stmt->bind_param("i", $customer_id);
		if ($stmt->execute()) {
			$stmt->bind_result($vehicle_id);
			$stmt->fetch();
			$stmt->close();
			return $vehicle_id;
		}
	}
	public function updateSign($vehicle_id, $sign){
		$stmt = $this->conn->prepare("UPDATE tbl_vehicle SET contract_sign = ? WHERE vehicle_id = ?");
		$stmt->bind_param("si", $sign, $vehicle_id);
		$result = $stmt->execute();
		$stmt->close();

	}

	public function insertRoute($user_id, $lat, $lan){
		$stmt = $this->conn->prepare("INSERT INTO tbl_route (user_id, lat, lan) VALUES (?,?,?)");
		$stmt->bind_param("iss", $user_id, $lat, $lan);
		$result = $stmt->execute();
		$stmt->close();
	}

	public function updateContract($vehicle_id, $sign){
		$stmt = $this->conn->prepare("UPDATE tbl_vehicle SET contract_filename = ? WHERE vehicle_id = ?");
		$stmt->bind_param("si", $sign, $vehicle_id);
		$result = $stmt->execute();
		$stmt->close();

	}

    public function getVehicleCustid($vehicle_id){
        $stmt = $this->conn->prepare("SELECT user_id FROM tbl_vehicle WHERE vehicle_id = ? ");
        $stmt->bind_param("i", $vehicle_id);
        $stmt->execute();
        $stmt->bind_result($user_id);
        $stmt->fetch();
        $stmt->close();
        return $user_id;
    }


    public function customerRegisterCompleteNew($customer_id, $user_id){


		$stmt = $this->conn->prepare("UPDATE tbl_customer SET status = 1 WHERE user_id = ?");
		$stmt->bind_param("i", $customer_id);
		$result = $stmt->execute();
		$stmt->close();
		$stmt = $this->conn->prepare("SELECT vehicle_id, plan_id, paymentfrequency FROM tbl_vehicle WHERE user_id = ? AND status = 2");
        $stmt->bind_param("i", $customer_id);
        if ($stmt->execute()) {
			//echo "eee";

			$result1 = $stmt->get_result();
			//print_r($result1);
			while($vehicle_data = $result1->fetch_assoc()){
				$stmt_bank = $this->conn->prepare("SELECT ddstartdate, ddenddate,bankaccountdetail_id, ddamount, multicar_discount FROM tbl_bankaccountdetail WHERE vehicle_id = ?");
				$stmt_bank->bind_param("i", $vehicle_data['vehicle_id']);
				$stmt_bank->execute();
				$stmt_bank->bind_result($ddstartdate, $ddenddate, $bankaccountdetail_id, $ddamount, $multicar_discount);
				$stmt_bank->fetch();
				$stmt_bank->close();

				$stmtins = $this->conn->prepare("INSERT INTO tbl_vehicleplandetail (user_id, vehicle_id, plan_id, start_date, end_date) VALUES (?, ?, ?, ?, ?)");
				$stmtins->bind_param("iiiss", $customer_id,  $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $ddstartdate, $ddenddate);
				$result = $stmtins->execute();
				$stmtins->close();


				$user_info = $this->getAdminUser($user_id);
				$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 0");
				$stmtcom->bind_param("ii", $user_id, $vehicle_data['plan_id']);
				$stmtcom->execute();
				$stmtcom->bind_result($commission_price);
				$stmtcom->fetch();
				$stmtcom->close();
				$datetime = date("Y-m-d H:i:s");

				$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 0, ?)");
				$stmtcomins->bind_param("iiiss", $user_id, $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price, $datetime);
				$stmtcomins->execute();
				if($user_info['usertype_id'] == 1){
					$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 1");
					$stmtcom->bind_param("ii", $user_info['addedbyuser_id'], $vehicle_data['plan_id']);
					$stmtcom->execute();
					$stmtcom->bind_result($commission_price_manager);
					$stmtcom->fetch();
					$stmtcom->close();

					$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 1, ?)");
					$stmtcomins->bind_param("iiiss", $user_info['addedbyuser_id'], $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price_manager, $datetime);
					$stmtcomins->execute();

					$payment_frequency = $vehicle_data['paymentfrequency'];
					// Here we add entry on bank payment table
					if(isset($payment_frequency) && $payment_frequency == 'Weekly'){
						$add_days = "7";
					}else if(isset($payment_frequency) && $payment_frequency == 'Fortnightly'){
						$add_days = "14";
					}else if(isset($payment_frequency) && $payment_frequency == 'Monthly'){
						$add_days = "30";
					}
					$date1 = new DateTime($ddstartdate);
					$date2 = new DateTime($ddenddate);
					$interval = $date1->diff($date2);
					$topaldays = $interval->days;

					for($i=1;$i<=$topaldays;$i=$i+$add_days){
						if($i == 1){
							$duedate = $ddstartdate;
						}else{
							$duedate = date('Y-m-d', strtotime($duedate.'+'.$add_days.' days'));
						}
						$final_amount_pay = $ddamount - ($ddamount * (int)$multicar_discount/100);
						$stmtcomins1 = $this->conn->prepare("INSERT INTO tbl_bank_payment (bankaccountdetail_id, payment_due_date, payment_amount, payment_status ) VALUES (?, ?, ?, '0')");
						$stmtcomins1->bind_param("iss", $bankaccountdetail_id, $duedate, $final_amount_pay);
						$stmtcomins1->execute();
					}
				}

			}
			$stmt->close();
			$stmt = $this->conn->prepare("UPDATE tbl_vehicle SET status = 1 WHERE user_id = ? AND status = 2");
			$stmt->bind_param("i", $customer_id);
			$result = $stmt->execute();
			$stmt->close();
				// TODO
			return $result;
		} else {
			return NULL;
		}


	}

        // here we create new complet register function
        public function newcustomerRegisterComplete($customer_id, $user_id){
            $stmt = $this->conn->prepare("UPDATE tbl_customer SET status = 1 WHERE user_id = ?");
            $stmt->bind_param("i", $customer_id);
            $result = $stmt->execute();
            $stmt->close();

            $stmt = $this->conn->prepare("SELECT vehicle_id, plan_id FROM tbl_vehicle WHERE user_id = ? AND status = 2");
            $stmt->bind_param("i", $customer_id);
            if ($stmt->execute()) {
                //echo "eee";
                $result1 = $stmt->get_result();
                //print_r($result1);
                while($vehicle_data = $result1->fetch_assoc()){
                    $stmt_bank = $this->conn->prepare("SELECT ddstartdate, ddenddate FROM tbl_bankaccountdetail WHERE vehicle_id = ?");
                    $stmt_bank->bind_param("i", $vehicle_data['vehicle_id']);
                    $stmt_bank->execute();
                    $stmt_bank->bind_result($ddstartdate, $ddenddate);
                    $stmt_bank->fetch();
                    $stmt_bank->close();

                    $stmtins = $this->conn->prepare("INSERT INTO tbl_vehicleplandetail (user_id, vehicle_id, plan_id, start_date, end_date) VALUES (?, ?, ?, ?, ?)");
                    $stmtins->bind_param("iiiss", $customer_id,  $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $ddstartdate, $ddenddate);
                    $result = $stmtins->execute();
                    $stmtins->close();


                    $user_info = $this->getAdminUser($user_id);
                    $stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 0");
                    $stmtcom->bind_param("ii", $user_id, $vehicle_data['plan_id']);
                    $stmtcom->execute();
                    $stmtcom->bind_result($commission_price);
                    $stmtcom->fetch();
                    $stmtcom->close();
                    $datetime = date("Y-m-d H:i:s");

                    $stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 0, ?)");
                    $stmtcomins->bind_param("iiiss", $user_id, $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price, $datetime);
                    $stmtcomins->execute();

                    if($user_info['usertype_id'] == 1){
                            $stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 1");
                            $stmtcom->bind_param("ii", $user_info['addedbyuser_id'], $vehicle_data['plan_id']);
                            $stmtcom->execute();
                            $stmtcom->bind_result($commission_price_manager);
                            $stmtcom->fetch();
                            $stmtcom->close();

                            $stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 1, ?)");
                            $stmtcomins->bind_param("iiiss", $user_info['addedbyuser_id'], $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price_manager, $datetime);
                            $stmtcomins->execute();
                    }

		}
                $stmt->close();
                $stmt = $this->conn->prepare("UPDATE tbl_vehicle SET status = 1 WHERE user_id = ?");
                $stmt->bind_param("i", $customer_id);
                $result = $stmt->execute();
                $stmt->close();
                // TODO
                return $result;
            } else {
                return NULL;
            }
        }
        // End


	public function customerRegisterComplete($customer_id, $user_id){
		$stmt = $this->conn->prepare("UPDATE tbl_customer SET status = 1 WHERE user_id = ?");
		$stmt->bind_param("i", $customer_id);
		$result = $stmt->execute();
		$stmt->close();
		$stmt = $this->conn->prepare("SELECT vehicle_id, plan_id FROM tbl_vehicle WHERE user_id = ? AND status = 2");
                $stmt->bind_param("i", $customer_id);
                if ($stmt->execute()) {
			//echo "eee";
			$result1 = $stmt->get_result();
			//print_r($result1);
                        while($vehicle_data = $result1->fetch_assoc()){

				$stmt_bank = $this->conn->prepare("SELECT ddstartdate, ddenddate FROM tbl_bankaccountdetail WHERE vehicle_id = ?");
				$stmt_bank->bind_param("i", $vehicle_data['vehicle_id']);
				$stmt_bank->execute();
				$stmt_bank->bind_result($ddstartdate, $ddenddate);
				$stmt_bank->fetch();
				$stmt_bank->close();

				$stmtins = $this->conn->prepare("INSERT INTO tbl_vehicleplandetail (user_id, vehicle_id, plan_id, start_date, end_date) VALUES (?, ?, ?, ?, ?)");
				$stmtins->bind_param("iiiss", $customer_id,  $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $ddstartdate, $ddenddate);
				$result = $stmtins->execute();
				$stmtins->close();


				$user_info = $this->getAdminUser($user_id);
				$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 0");
				$stmtcom->bind_param("ii", $user_id, $vehicle_data['plan_id']);
				$stmtcom->execute();
				$stmtcom->bind_result($commission_price);
				$stmtcom->fetch();
				$stmtcom->close();
				$datetime = date("Y-m-d H:i:s");

				$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 0, ?)");
				$stmtcomins->bind_param("iiiss", $user_id, $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price, $datetime);
				$stmtcomins->execute();
				if($user_info['usertype_id'] == 1){
					$stmtcom = $this->conn->prepare("SELECT commission_price FROM tbl_salesmancommission WHERE user_id = ? AND plan_id = ? AND commission_type = 1");
					$stmtcom->bind_param("ii", $user_info['addedbyuser_id'], $vehicle_data['plan_id']);
					$stmtcom->execute();
					$stmtcom->bind_result($commission_price_manager);
					$stmtcom->fetch();
					$stmtcom->close();

					$stmtcomins = $this->conn->prepare("INSERT INTO tbl_vehiclesales_detail (user_id, vehicle_id, plan_id, commission_price, commission_type, datetime) VALUES (?, ?, ?, ?, 1, ?)");
					$stmtcomins->bind_param("iiiss", $user_info['addedbyuser_id'], $vehicle_data['vehicle_id'], $vehicle_data['plan_id'], $commission_price_manager, $datetime);
					$stmtcomins->execute();
				}

			}
			$stmt->close();
			$stmt = $this->conn->prepare("UPDATE tbl_vehicle SET status = 1 WHERE user_id = ?");
			$stmt->bind_param("i", $customer_id);
			$result = $stmt->execute();
			$stmt->close();
            // TODO
            return $result;
        } else {
            return NULL;
        }


    }


    /** Opal
     * Checking user login
     * @param String $email User login email id
     * @param String $password User login password
     * @return boolean User login status success/fail
     */
    public function checkLogin($email, $password) {
        // fetching user by email
        $stmt = $this->conn->prepare("SELECT password FROM tbl_adminuser WHERE emailaddress = ? AND status = 1");

        $stmt->bind_param("s", $email);

        $stmt->execute();

        $stmt->bind_result($password_hash);

        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            // Found user with the email
            // Now verify the password

            $stmt->fetch();

            $stmt->close();

            if (PassHash::check_password($password_hash, $password)) {
                // User password is correct
                return TRUE;
            } else {
                // user password is incorrect
                return FALSE;
            }
        } else {
            $stmt->close();

            // user not existed with the email
            return FALSE;
        }
    }

    /** Opal
     * Checking for duplicate user by email address
     * @param String $email email to check in db
     * @return boolean
     */
    private function isUserExists($email) {
        $stmt = $this->conn->prepare("SELECT id from tbl_customer WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
        $stmt->close();
        return $num_rows > 0;
    }

    /** Opal
     * Fetching user by email
     * @param String $email User email id
     */
    public function getUserByEmail($email) {
        $stmt = $this->conn->prepare("SELECT firstname, lastname, emailaddress, api_key, profilepic, registration_date, contract, user_id FROM tbl_adminuser WHERE emailaddress = ?");
        $stmt->bind_param("s", $email);
		//print_r($stmt);
        if ($stmt->execute()) {
            // $user = $stmt->get_result()->fetch_assoc();
            $stmt->bind_result($firstname, $lastname, $emailaddress, $api_key, $profilepic, $registration_date, $contract, $user_id );
            $stmt->fetch();
            $user = array();
            $user["firstname"] = $firstname;
            $user["lastname"] = $lastname;
            $user["emailaddress"] = $emailaddress;
            $user["api_key"] = $api_key;
			$user["userRegisterDate"] = $registration_date;
			$user["userContract"] = $contract;
			$user["user_id"] = $user_id;
			if($profilepic == NULL || $profilepic == ""){
				$user["userImage"] = 'no-profile.jpg';
			}else{
				$user["userImage"] = $profilepic;
			}
			//print_r($user);
            $stmt->close();
            return $user;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Fetching user api key
     * @param String $user_id user id primary key in user table
     */
    public function getApiKeyById($user_id) {
        $stmt = $this->conn->prepare("SELECT api_key FROM tbl_customer WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        if ($stmt->execute()) {
            // $api_key = $stmt->get_result()->fetch_assoc();
            // TODO
            $stmt->bind_result($api_key);
            $stmt->close();
            return $api_key;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Fetching user id by api key
     * @param String $api_key user api key
     */
    public function getUserId($api_key) {
        $stmt = $this->conn->prepare("SELECT user_id FROM tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        if ($stmt->execute()) {
            $stmt->bind_result($user_id);
            $stmt->fetch();
            // TODO
            // $user_id = $stmt->get_result()->fetch_assoc();
            $stmt->close();
            return $user_id;
        } else {
            return NULL;
        }
    }

    /** Opal
     * Validating user api key
     * If the api key is there in db, it is a valid key
     * @param String $api_key user api key
     * @return boolean
     */
    public function isValidApiKey($api_key) {
        $stmt = $this->conn->prepare("SELECT emailaddress from tbl_adminuser WHERE api_key = ?");
        $stmt->bind_param("s", $api_key);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
		//echo $num_rows;
        $stmt->close();
        return $num_rows > 0;
    }

    /** Opal
     *  Generating random Unique MD5 String for user Api key
     */
    public function generateApiKey() {
        return md5(uniqid(rand(), true));
    }
	/** Opal
	* Update the Api Key in customer table
	**/
	public function updateApikey($emailaddress = '', $api_key){
		if($emailaddress != ""){
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser set api_key = ? WHERE emailaddress = ?");
			$stmt->bind_param("ss", $api_key, $emailaddress);
			$result = $stmt->execute();
			$stmt->close();
		}else{
			//echo $api_key;
			$key = NULL;
			$stmt = $this->conn->prepare("UPDATE tbl_adminuser SET api_key = ? WHERE api_key = ?");
			$stmt->bind_param("is", $key, $api_key);
			$result = $stmt->execute();
			$stmt->close();

		}
		return $result;

	}
    /* ------------- `tasks` table method ------------------ */

    /**
     * Creating new task
     * @param String $user_id user id to whom task belongs to
     * @param String $task task text
     */
    public function createTask($user_id, $task) {
        $stmt = $this->conn->prepare("INSERT INTO tasks(task) VALUES(?)");
        $stmt->bind_param("s", $task);
        $result = $stmt->execute();
        $stmt->close();

        if ($result) {
            // task row created
            // now assign the task to user
            $new_task_id = $this->conn->insert_id;
            $res = $this->createUserTask($user_id, $new_task_id);
            if ($res) {
                // task created successfully
                return $new_task_id;
            } else {
                // task failed to create
                return NULL;
            }
        } else {
            // task failed to create
            return NULL;
        }
    }

    /**
     * Fetching single task
     * @param String $task_id id of the task
     */
    public function getWarningLight($cms_id) {
        $stmt = $this->conn->prepare("SELECT cms_id, cms_title, cms_description, cms_icon from tbl_cms WHERE cms_id = ?");
        $stmt->bind_param("i", $cms_id);
        if ($stmt->execute()) {
            $res = array();
            $stmt->bind_result($cms_id, $cms_title, $cms_description, $cms_icon);
            // TODO
            // $task = $stmt->get_result()->fetch_assoc();
            $stmt->fetch();
            $res["cms_id"] = $cms_id;
            $res["cms_title"] = $cms_title;
            $res["cms_description"] = $cms_description;
            $res["cms_icon"] = $cms_icon;
            $stmt->close();
            return $res;
        } else {
            return NULL;
        }
    }

    /**
     * Fetching all user tasks
     * @param String $user_id id of the user
     */
    public function getWarningLights() {
        $stmt = $this->conn->prepare("SELECT * FROM tbl_cms where warning_lights = '1' AND status = '1'");
        $stmt->execute();
        $warningLights = $stmt->get_result();
        $stmt->close();
        return $warningLights;
    }

    /**
     * Updating task
     * @param String $task_id id of the task
     * @param String $task task text
     * @param String $status task status
     */
    public function updateTask($user_id, $task_id, $task, $status) {
        $stmt = $this->conn->prepare("UPDATE tasks t, user_tasks ut set t.task = ?, t.status = ? WHERE t.id = ? AND t.id = ut.task_id AND ut.user_id = ?");
        $stmt->bind_param("siii", $task, $status, $task_id, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
    }

    /**
     * Deleting a task
     * @param String $task_id id of the task to delete
     */
    public function deleteTask($user_id, $task_id) {
        $stmt = $this->conn->prepare("DELETE t FROM tasks t, user_tasks ut WHERE t.id = ? AND ut.task_id = t.id AND ut.user_id = ?");
        $stmt->bind_param("ii", $task_id, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
    }

    /* ------------- `user_tasks` table method ------------------ */

    /**
     * Function to assign a task to user
     * @param String $user_id id of the user
     * @param String $task_id id of the task
     */
    public function createUserTask($user_id, $task_id) {
        $stmt = $this->conn->prepare("INSERT INTO user_tasks(user_id, task_id) values(?, ?)");
        $stmt->bind_param("ii", $user_id, $task_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
        $stmt->close();
        return $result;
    }

	/* ------------- `tbl_inquiry` table method ------------------ */

    /**
     * Function to assign a task to user
     * @param String $user_id id of the user
     * @param String $task_id id of the task
     */
    public function createCustomerInquiry($user_id, $description) {
		$today_date = date('Y-m-d');
        $stmt = $this->conn->prepare("INSERT INTO tbl_inquiry (sender_id, message, inquiry_date) values(?, ?, ?)");
		//print_r($stmt);
        $stmt->bind_param("iss", $user_id, $description, $today_date);
		//echo "Hello";die();
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
        $stmt->close();
        return $result;
    }

	/* ------------- `tbl_customer` table method ------------------ */

    /**
     * Function get All data of Customer
     * @param String $user_id id of the user
     */
    public function getCustomer($user_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_customer` WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }

	public function getVehicle($vehicle_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_vehicle` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $vehicle_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getPlateId($plateno) {
        $stmt = $this->conn->prepare("SELECT id FROM `tbl_plateno_detail` WHERE plateno = ?");
        $stmt->bind_param("s", $plateno);
        $result = $stmt->execute();
		$stmt->bind_result($id);
        // TODO
        // $task = $stmt->get_result()->fetch_assoc();
        $stmt->fetch();
       $stmt->close();
        return $id;
    }
	public function getBankData($vehicle_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_bankaccountdetail` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $vehicle_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getEngineData($enginetype_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_enginetype` WHERE enginetype_id = ?");
        $stmt->bind_param("i", $enginetype_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getCategoryData($category_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_category` WHERE category_id = ?");
        $stmt->bind_param("i", $category_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function getPlanDataDis($plan_id) {
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_plan` WHERE plan_id = ?");
        $stmt->bind_param("i", $plan_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$response = $stmt->get_result();
        $stmt->close();
        return $response;
    }

	/**
     * Fetching all Customer Cars
     * @param String $user_id id of the user
     */
    public function getCustomerCar($user_id) {
		$today_date = date('Y-m-d');
        $stmt = $this->conn->prepare("SELECT * FROM `tbl_vehicle` as v, tbl_vehicleplandetail as vp WHERE v.vehicle_id = vp.vehicle_id AND v.user_id = ? AND vp.end_date >= ?");
        $stmt->bind_param("is", $user_id, $today_date );
        $result = $stmt->execute();
        $cars_data = $stmt->get_result();
		$final_cars = array();
		while ($cars =  $cars_data->fetch_assoc()) {
                $tmp = array();
				$bank_detail = $this->getBankAccount($cars['vehicle_id']);
				//print_r($bank_detail);
				//die();
				$tmp["payment_frequency"] = $bank_detail['paymentfrequency'];
				$tmp["payment_day"] = $bank_detail['paymentday'];
				$tmp["payment_amount"] = $bank_detail['ddamount'];
				$plan_detail = $this->getPlan($cars['plan_id']);
                $tmp["plateno"] = $cars["plateno"];
                $tmp["make"] = $cars["make"];
                $tmp["model"] = $cars["model"];
				$tmp["year"] = $cars["year"];
				$tmp["color"] = $cars["color"];

				//$date_diff = date_diff($next_serrvice, date_create($today_date));
				$nodays=(strtotime($cars["next_service_date"]) - strtotime($today_date))/ (60 * 60 * 24);
				$tmp["nextservice"] = (int)$nodays;
				if($nodays >= 0){
					$tmp["nextservicetext"] = "Before Service";
				}else{
					$tmp["nextservicetext"] = "Overdue";
				}
				$tmp["plan_type"] = $plan_detail['planname'];
				$tmp["term"] = $plan_detail['duration'];
				$tmp["renewal_date"] = date("d-m-Y", strtotime($cars["end_date"]));

                array_push($final_cars, $tmp);
            }
        $stmt->close();
        return $final_cars;
    }

	/**
     * Get Last Booking Details
     * @param String $car_id of the user
     */
    public function getLastBooking($car_id) {
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_booking` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->store_result();
        $num_rows = $stmt->num_rows;
		if($num_rows > 0){

		}else{

		}

    }

	/**
     * Get Bank Account Details
     * @param String $car_id of the user
     */
    public function getBankAccount($car_id) {
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_bankaccountdetail` WHERE vehicle_id = ?");
        $stmt->bind_param("i", $car_id);
        $stmt->execute();
        $bank_data = $stmt->get_result();
		$return_arrray=array();
        while ($bank = $bank_data->fetch_assoc()) {
			$return_arrray['ddamount'] = $bank['ddamount'];
			$return_arrray['paymentfrequency'] = $bank['paymentfrequency'];
			$return_arrray['paymentday'] = $bank['paymentday'];
		}
		//print_r($return_arrray);die();
		return $return_arrray;

    }
	public function getPlan($plan_id){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plan` WHERE plan_id = ?");
        $stmt->bind_param("i", $plan_id);
        $stmt->execute();
		$plan_data = $stmt->get_result();
		$return_arrray=array();
        while($plan = $plan_data->fetch_assoc()) {
			$return_arrray['planname'] = $plan['planname'];
			$return_arrray['duration'] = $plan['duration'];
		}
		//print_r($return_arrray);
		return $return_arrray;
	}
    public function getPlanData($enginetype_id, $term, $type){
		//echo $enginetype_id."::".$term."::".$type;
		$stmt = $this->conn->prepare("SELECT cp.* FROM `tbl_plan` as p, tbl_categoriesplan as cp WHERE p.plan_id = cp.plan_id AND cp.enginetype_id = ? AND p.duration = ? AND p.planname = ?");
        $stmt->bind_param("iss", $enginetype_id, $term, $type);
        $stmt->execute();
		$plan_data = $stmt->get_result();
		$return_arrray=array();
        while($plan = $plan_data->fetch_assoc()) {
			$return_arrray['plan_id'] = $plan['plan_id'];
			$return_arrray['price'] = $plan['price'];
		}
		//print_r($return_arrray);
		return $return_arrray;
	}

	public function insertSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $drive_proof1, $drive_proof2, $profilepic){
		$date = date('Y-m-d H:i:s');


        // insert query
		$user_type_id = 1;
		$status = 2;
        $stmt = $this->conn->prepare("INSERT INTO tbl_adminuser(`addedbyuser_id`, `usertype_id`, `firstname`, `lastname`, `emailaddress`, `dateofborth`, `mobilenumber`, `address`, `address2`, `drivinglicencenumber`, `drivinglicenceexpiredate`, `drivinglicencefile1`, `drivinglicencefile2`, `profilepic`, `gender`, `status`, registration_date) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iisssssssssssssis", $user_id, $user_type_id, $first_name, $last_name, $email_address, $date_of_birth, $mobile_no, $adddress, $address2, $driver_licence_no, $driver_licence_expiry_date, $drive_proof1, $drive_proof2, $profilepic, $gender, $status, $date);

        $result = $stmt->execute();
		//print_r($result);
		$last_id = $stmt->insert_id;
        $stmt->close();

		$user_type = 1;
		$vehicle_id = 0;

		$stmt = $this->conn->prepare("INSERT INTO tbl_bankaccountdetail(`user_id`, `vehicle_id`, `accountname`, `accountnumber`, `bankname`, `paymentfrequency`, `paymentday`, `status`, `user_type`) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iisssssss", $last_id, $vehicle_id, $bank_account_name, $bank_account_no, $bank_name, $payment_frequency, $payment_day, $status, $user_type);

        $result = $stmt->execute();
        $stmt->close();

        // Check for successful insertion
        if ($result) {
            // User successfully inserted
            return $last_id;
        } else {
            // Failed to create user
            return USER_CREATE_FAILED;
        }
	}
	public function updateSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $drive_proof1, $drive_proof2, $profilepic, $update_user_id){
		$date = date('Y-m-d H:i:s');
            // insert query
			$user_type_id = 1;
			$status = 2;
            $stmt = $this->conn->prepare("UPDATE tbl_adminuser SET addedbyuser_id = ?, usertype_id= ?, firstname= ?, lastname=?, emailaddress=?, dateofborth=?, mobilenumber=?, address=?, address2=?, drivinglicencenumber=?, drivinglicenceexpiredate=?, drivinglicencefile1=?, drivinglicencefile2=?, profilepic=?, gender=?, status=?, registration_date=? WHERE user_id = ?");
            $stmt->bind_param("iisssssssssssssssi", $user_id, $user_type_id, $first_name, $last_name, $email_address, $date_of_birth, $mobile_no, $adddress, $address2, $driver_licence_no, $driver_licence_expiry_date, $drive_proof1, $drive_proof2, $profilepic, $gender, $status, $date, $update_user_id);
            $result = $stmt->execute();
            $stmt->close();

			$user_type = 1;
			$vehicle_id = 0;

			$stmt = $this->conn->prepare("UPDATE tbl_bankaccountdetail SET accountname=?, accountnumber=?, bankname=?, paymentfrequency=?, paymentday=?, status=?, user_type=? WHERE user_id = ? AND vehicle_id = 0");
            $stmt->bind_param("sssssssi",  $bank_account_name, $bank_account_no, $bank_name, $payment_frequency, $payment_day, $status, $user_type, $update_user_id);

            $result = $stmt->execute();
            $stmt->close();

            // Check for successful insertion
            if ($result) {
                // User successfully inserted
                return $update_user_id;
            } else {
                // Failed to create user
                return USER_CREATE_FAILED;
            }
	}
	  /* ------------- `tbl_user_car_location` table method ------------------ */

    /**
     * Creating New Location
     * @param String $user_id user id to whom task belongs to
     * @param String $task task text
     */
    public function createLockLocation($user_id, $lat, $lan, $datetime, $api_key) {

        $stmt = $this->conn->prepare("INSERT INTO tbl_user_car_location (user_id, latitude, longitude, end_datetime, authorization_key) VALUES (?, ?, ?, ?, ?)");
		//echo "".$user_id."=".$lat."=".$lan."=".$datetime."=".$api_key;
		$stmt->bind_param("issss", $user_id, $lat, $lan, $datetime, $api_key);
        $result = $stmt->execute();


        $stmt->close();

        if ($result) {
            return true;
        } else {
            return NULL;
        }
    }
	/** Opal
     * Check if there is car already registred
     * If the api key is there in db
     * @param String $api_key user api key
     * @return boolean
     */
    public function getCarLocation($user_id, $api_key) {
        $stmt = $this->conn->prepare("SELECT * from tbl_user_car_location WHERE authorization_key = ? AND user_id = ? ORDER BY user_car_location_id DESC LIMIT 0,1");
        $stmt->bind_param("si", $api_key, $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	public function getCategoryByMake($make) {
        $stmt = $this->conn->prepare("SELECT * from tbl_category WHERE make LIKE '%".$make."%'");
		//$stmt->bind_param("s", $make);
        $stmt->execute();
        $result = $stmt->get_result();
        $response_data = array();
        while($category = $result->fetch_assoc()){
			$tmp = array();
			$tmp['name'] = $category['name'];
			$tmp['id'] = $category['category_id'];
			array_push($response_data, $tmp);
		}
		//echo $num_rows;
		//print_r($response_data);
		//echo $num_rows;
        $stmt->close();
        return $response_data;
    }
	public function getCategory() {
        $stmt = $this->conn->prepare("SELECT * from tbl_category WHERE status = 1");
        $stmt->execute();
        $result = $stmt->get_result();

		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	public function getPlanFromYear($year){
		$stmt = $this->conn->prepare("SELECT * from tbl_plan WHERE duration = ?");
        $stmt->bind_param("s", $year);

		$stmt->execute();
        $result = $stmt->get_result();
        $response_data = array();
        while($category = $result->fetch_assoc()){
			$tmp = array();
			$tmp['name'] = $category['planname'];
			array_push($response_data, $tmp);
		}
		//echo $num_rows;
		//print_r($response_data);
		//echo $num_rows;
        $stmt->close();
        return $response_data;
	}
	public function getEngineTypeByCategory($category_id){
		$stmt = $this->conn->prepare("SELECT * from tbl_enginetype WHERE status = 1 AND category_id = ?");
        $stmt->bind_param("i", $category_id);

		$stmt->execute();
        $result = $stmt->get_result();
        $response_data = array();
        while($category = $result->fetch_assoc()){
			$tmp = array();
			$tmp['name'] = $category['name'];
			//$tmp['id'] = $category['category_id'];
			array_push($response_data, $tmp);
		}
		//echo $num_rows;
		//print_r($response_data);
		//echo $num_rows;
        $stmt->close();
        return $response_data;
	}
	public function getEngine($category_id) {
        $stmt = $this->conn->prepare("SELECT * from tbl_enginetype WHERE status = 1 AND category_id = ?");
        $stmt->bind_param("i", $category_id);

		$stmt->execute();
        $result = $stmt->get_result();

		//echo $num_rows;
        $stmt->close();
        return $result;
    }
	public function getEngineId($category_id, $enginName) {
	//echo $category_id.",".$enginName."<br>";
        $stmt = $this->conn->prepare("SELECT enginetype_id from tbl_enginetype WHERE status = 1 AND category_id = ? AND name = ?");
        $stmt->bind_param("is", $category_id, $enginName);

		$stmt->execute();
        $result = $stmt->get_result();
        while($engine = $result->fetch_assoc()){
			$enginetype_id = $engine['enginetype_id'];
		}
		//echo $num_rows;
        $stmt->close();
        return $enginetype_id;
    }

	public function getCost($engine_id) {

		$stmt = $this->conn->prepare("SELECT duration from tbl_plan GROUP BY duration");
		$stmt->execute();
        $plan_duration = $stmt->get_result();
		$stmt->close();
		$response["costs"] = array();
		while($duration = $plan_duration->fetch_assoc()){
			//print_r($duration);
			$tmp = array();
			$stmt = $this->conn->prepare("SELECT * from tbl_categoriesplan as cp, tbl_plan as p WHERE cp.plan_id = p.plan_id AND cp.enginetype_id = ? AND p.duration=?");
			$stmt->bind_param("is", $engine_id,$duration['duration'] );
			$stmt->execute();
			$tmp['duration'] = $duration['duration'];
			$result = $stmt->get_result();
			$stmt->close();
			while($costPlan = $result->fetch_assoc()){
				$tmp['price'.$costPlan['planname']] = $costPlan['price'];

			}
			array_push($response["costs"], $tmp);
		}

		$response["error"] = false;
		$stmt = $this->conn->prepare("SELECT e.name as engine_name, c.name as category_name from tbl_enginetype as e, tbl_category as c WHERE e.category_id = c.category_id AND e.enginetype_id = ?");
		$stmt->bind_param("i", $engine_id);
		$stmt->execute();
		$engine_result = $stmt->get_result();
		$stmt->close();
		while($engine_row = $engine_result->fetch_assoc()){
			//print_r($engine_row);
			$response["name"] = $engine_row['category_name'].' '.$engine_row['engine_name'];
		}
		//print_r($response);
		return $response;
    }


	function updateCustomer($user_id, $addressLine1, $addressLine2, $mobile, $email){
            $result = $this->getCustomer($user_id);
            $data = $result->fetch_assoc();
            $user_type = 0;
            //print_r($data);
            //die();
            $stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
            $stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
            $stmt->execute();
            $stmt->close();


            $stmt = $this->conn->prepare("UPDATE  tbl_customer set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
            $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
            $stmt->execute();
            $num_affected_rows = $stmt->affected_rows;
            $stmt->close();
            return $num_affected_rows > 0;
	}
	function addFolloup($adddress, $email, $followupDate, $lan, $lat, $name, $phone, $user_id){
		$stmt = $this->conn->prepare("INSERT INTO `tbl_followup`(`user_id`, `name`, `emailaddress`, `phone`, `address`, `latitude`, `longitude`, `followup_datetime`) VALUES (?,?,?,?,?,?,?,?)");
        $stmt->bind_param("isssssss", $user_id, $name, $email, $phone, $adddress, $lat, $lan, $followupDate);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	function getFollowup($user_id){

		$stmt = $this->conn->prepare("SELECT * FROM `tbl_followup` WHERE user_id = ?");
		$stmt->bind_param("i", $user_id);
		$stmt->execute();
		$folloupdata = $stmt->get_result();
		$stmt->close();
		//print_r($folloupdata);
		$followup = array();
		while($home_row = $folloupdata->fetch_assoc()){
			$tmp = array();
			$tmp['followup_id'] = $home_row['followup_id'];
			$tmp['name'] = $home_row['name'];
			$tmp['emailaddress'] = $home_row['emailaddress'];
			$tmp['phone'] = $home_row['phone'];
			$tmp['address'] = $home_row['address'];
			$tmp['followup_datetime'] = $home_row['followup_datetime'];
			 array_push($followup, $tmp);

			//print_r($engine_row);
			//$response["name"] = $engine_row['category_name'].' '.$engine_row['engine_name'];
		}
		//print_r($response);
		return $followup;
	}
	function removeFollowup($id){
		$stmt = $this->conn->prepare("DELETE  FROM `tbl_followup` WHERE followup_id = ?");
		$stmt->bind_param("i", $id);
		$stmt->execute();
		return true;
	}
	function getHome($user_id){
		$response = array();
		$current_date = date('Y-m-d');
		//echo "SELECT * FROM `tbl_targetarea` WHERE start_date <= '".$current_date."' AND end_date >= '".$current_date."' AND user_id = ?";exit;
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_targetarea` WHERE start_date <= '".$current_date."' AND end_date >= '".$current_date."' AND user_id = ?");
		$stmt->bind_param("i", $user_id);
		$stmt->execute();
		$home_result = $stmt->get_result();
		$stmt->close();
		while($home_row = $home_result->fetch_assoc()){
			$response['notes'] = $home_row['notes'];
			$response['norrth_cord'] = $home_row['norrth_cord'];
			$response['south_cord'] = $home_row['south_cord'];
			$response['east_cord'] = $home_row['east_cord'];
			$response['west_cord'] = $home_row['west_cord'];
			$center_cord1 = ($home_row['norrth_cord'] + $home_row['south_cord']) /2;
			$center_cord2 = ($home_row['east_cord'] + $home_row['west_cord']) /2;
			$response['center_cord1'] = $center_cord1;
			$response['center_cord2'] = $center_cord2;

			//print_r($engine_row);
			//$response["name"] = $engine_row['category_name'].' '.$engine_row['engine_name'];
		}
		//print_r($response);
		return $response;
	}
	function getTrack($track_id){

		//echo "SELECT * FROM `tbl_targetarea` WHERE start_date <= '".$current_date."' AND end_date >= '".$current_date."' AND user_id = ?";
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_targetarea` WHERE targetarea_id = ?");
		$stmt->bind_param("i", $track_id);
		$stmt->execute();
		$home_result = $stmt->get_result();
		$stmt->close();
		//print_r($home_result);
		while($home_row = $home_result->fetch_assoc()){
			$response['notes'] = $home_row['notes'];
			$response['norrth_cord'] = $home_row['norrth_cord'];
			$response['south_cord'] = $home_row['south_cord'];
			$response['east_cord'] = $home_row['east_cord'];
			$response['west_cord'] = $home_row['west_cord'];
			$response['fromdate'] = $home_row['start_date'];
			$response['todate'] = $home_row['end_date'];
			$response['user_id'] = $home_row['user_id'];
			$center_cord1 = ($home_row['norrth_cord'] + $home_row['south_cord']) /2;
			$center_cord2 = ($home_row['east_cord'] + $home_row['west_cord']) /2;
			$response['center_cord1'] = $center_cord1;
			$response['center_cord2'] = $center_cord2;

			//print_r($engine_row);
			//$response["name"] = $engine_row['category_name'].' '.$engine_row['engine_name'];
		}
		//print_r($response);
		return $response;
	}

	function updateAdmin($user_id, $addressLine1, $addressLine2, $mobile, $email, $accountname, $accountnumber, $bankname){
		//$result = $this->getCustomer($user_id);
		//$data = $result->fetch_assoc();
		$user_type = 1;
		//print_r($data);
		//die();
		$stmt = $this->conn->prepare("INSERT INTO tbl_contactdetails (user_id, address1, address2, mobile, email, user_type) VALUES (?, ?, ?, ?, ?, ?) ");
		$stmt->bind_param("issssi", $user_id, $addressLine1, $addressLine2, $mobile, $email, $user_type);
        $stmt->execute();
		$stmt->close();


		$stmt = $this->conn->prepare("UPDATE  tbl_adminuser set address = ?, address2 = ?, emailaddress = ?, mobilenumber= ? WHERE user_id = ?");
        $stmt->bind_param("ssssi", $addressLine1, $addressLine2, $email, $mobile, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();

		$stmt = $this->conn->prepare("UPDATE  tbl_bankaccountdetail set accountname = ?, accountnumber = ?, bankname = ? WHERE user_id = ?");
        $stmt->bind_param("sssi", $accountname, $accountnumber, $bankname, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	function getSitemanagerByCustomer($user_id){

		$stmt = $this->conn->prepare("SELECT addedbyuser_id FROM `tbl_customer` WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$customer_data_res = $stmt->get_result();
		$customer_data = $customer_data_res->fetch_assoc();
        $stmt->close();
		//print_r($customer_data);die();
		$stmt = $this->conn->prepare("SELECT addedbyuser_id,usertype_id FROM `tbl_adminuser` WHERE user_id = ?");
        $stmt->bind_param("i", $customer_data['addedbyuser_id']);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$customer_sales_man_res = $stmt->get_result();
        $stmt->close();
		$customer_sales_man = $customer_sales_man_res->fetch_assoc();
		if($customer_sales_man['usertype_id'] == "1"){

			$stmt = $this->conn->prepare("SELECT addedbyuser_id,usertype_id FROM `tbl_adminuser` WHERE user_id = ?");
			$stmt->bind_param("i", $customer_sales_man['addedbyuser_id']);
			$result = $stmt->execute();
			if (false === $result) {
				die('execute() failed: ' . htmlspecialchars($stmt->error));
			}
			$customer_sales_manager_res = $stmt->get_result();
			$customer_sales_manager = $customer_sales_manager_res->fetch_assoc();
			$stmt->close();
			$sitemanager_id = $customer_sales_manager['addedbyuser_id'];
		}else{
			$sitemanager_id = $customer_sales_man['addedbyuser_id'];
		}
		return $sitemanager_id;
	}

	public function getUserFeedback($user_id){
		$sender_id = $user_id;
		$receiver_id = $this->getSitemanagerByCustomer($user_id);

		$stmt = $this->conn->prepare("SELECT conversation_id FROM `tbl_conversation` WHERE ((sender_id = ? AND receiver_id = ?) OR (sender_id = ? AND receiver_id = ?)) AND status = 0");
        $stmt->bind_param("iiii", $sender_id, $receiver_id, $receiver_id, $sender_id);
        $result = $stmt->execute();

        if (false === $result) {
            die('execute() failed: ' . htmlspecialchars($stmt->error));
        }
		$check_conversation_res = $stmt->get_result();
		$check_conversation = $check_conversation_res->fetch_assoc();
        $stmt->close();
		if(!empty($check_conversation)){

			$conversation_id = $check_conversation['conversation_id'];
			$stmt = $this->conn->prepare("SELECT * FROM `tbl_message` WHERE conversation_id = ? ORDER BY conversation_datetime ASC");
			$stmt->bind_param("i", $conversation_id);
			$result = $stmt->execute();

			if (false === $result) {
				die('execute() failed: ' . htmlspecialchars($stmt->error));
			}
			$conversation = $stmt->get_result();
			$stmt->close();
			return $conversation;
		}
	}
	public function getAdminUser($admin_id){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` WHERE user_id = ?");
		$stmt->bind_param("i", $admin_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$customer_sales_manager_res = $stmt->get_result();
		$customer_sales_manager = $customer_sales_manager_res->fetch_assoc();
		return $customer_sales_manager;
	}

	public function getAdmindata($admin_id){
		$stmt = $this->conn->prepare("SELECT accountname, accountnumber, bankname, emailaddress, mobilenumber, address, address2 FROM `tbl_adminuser` as a, tbl_bankaccountdetail as b WHERE a.user_id = ? AND b.user_id=a.user_id AND b.user_type = 1");
		$stmt->bind_param("i", $admin_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$admin_data_res = $stmt->get_result();
		$admin_data = $admin_data_res->fetch_assoc();
		return $admin_data;
	}


	function insertMessage($sender_id, $receiver_id, $message, $conversation_id, $conversation_datetime, $send_by){
		$stmt = $this->conn->prepare("INSERT INTO `tbl_message`(`conversation_id`, `sender_id`, `receiver_id`, `message`, `send_by`, `conversation_datetime`) VALUES (?, ?, ?, ?, ?, ?)");
		$stmt->bind_param("iiisss", $conversation_id, $sender_id, $receiver_id, $message, $send_by, $conversation_datetime);
        $result = $stmt->execute();
        $stmt->close();

        if ($result) {
            return true;
        } else {
            return NULL;
        }
	}
	public function getTeam(){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` as a, tbl_usertype as u where a.usertype_id = u.usertype_id AND a.status =1 ");
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$team_data = $stmt->get_result();
		$stmt->close();
		return $team_data;
	}
	public function getSalesMan($user_id){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` where addedbyuser_id = ? AND status =1 ");
		$stmt->bind_param("i", $user_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$team_data = $stmt->get_result();
		$stmt->close();
		return $team_data;
	}

	public function getCarApi($plate_no){
		//echo $plate_no;
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plateno_detail` WHERE plateno = ?");
		$stmt->bind_param("s", $plate_no);

		$result = $stmt->execute();
		$team_data_array = $stmt->get_result();
		//$stmt->store_result();
		//echo $num_rows = $stmt->num_rows;//die();

		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}

		if($team_data_array->num_rows  > 0){
			//echo "Here";
			//print_r($team_data_array);
			//$team_data_array = $stmt->get_result();
			while ($data = $team_data_array->fetch_assoc()) {
				$team_data['id'] = $data['id'];
				$team_data['plateno'] = $data['plateno'];
				$team_data['make'] = $data['make'];
				$team_data['model'] = $data['model'];
				$team_data['year'] = $data['year'];
				$team_data['vin'] = $data['vin'];
				$team_data['color'] = $data['color'];
				$team_data['fuel'] = $data['fuel'];
			}
			//print_r($team_data);
			$stmt->close();
			return $team_data;
		}else{
			//echo "there";die();
			$url = "https://www.carjam.co.nz/api/car/?plate=".$plate_no."&key=3E8F37594613B3520503DF926666C7E9505B42D5";

			$xml = simplexml_load_file($url);
			//echo "<pre>";print_r($xml->idh->vehicle);echo "</pre>";

			$make = $xml->idh->vehicle->make;
			$model = $xml->idh->vehicle->model;
			$year = $xml->idh->vehicle->year_of_manufacture;
			$vin = $xml->idh->vehicle->vin;
			$color = $xml->idh->vehicle->main_colour;
			$fuel = $xml->idh->vehicle->fuel_type;
			if($make != ""){

				$stmt = $this->conn->prepare("INSERT INTO `tbl_plateno_detail`(`plateno`, `make`, `model`, `year`, `vin`, `color`, `fuel`) VALUES (?, ?, ?, ?, ?, ?, ?)");
				$stmt->bind_param("sssssss", $plate_no, $make, $model, $year, $vin, $color, $fuel);
				$result = $stmt->execute();
				$stmt->close();
				$stmt = $this->conn->prepare("SELECT * FROM `tbl_plateno_detail` WHERE plateno = ?");
				$stmt->bind_param("s", $plate_no);

				$result = $stmt->execute();
				$team_data_array = $stmt->get_result();
				//$stmt->store_result();
				//echo $num_rows = $stmt->num_rows;//die();

				if (false === $result) {
					die('execute() failed: ' . htmlspecialchars($stmt->error));
				}
				while ($data = $team_data_array->fetch_assoc()) {
					$team_data['id'] = $data['id'];
					$team_data['plateno'] = $data['plateno'];
					$team_data['make'] = $data['make'];
					$team_data['model'] = $data['model'];
					$team_data['year'] = $data['year'];
					$team_data['vin'] = $data['vin'];
					$team_data['color'] = $data['color'];
					$team_data['fuel'] = $data['fuel'];
				}
				//print_r($team_data);
				$stmt->close();
				return $team_data;
			}else{
				return "Error";
			}

		}

	}

	public function getCategoryId($getCategoryId){
		//echo $plate_no;
		$param = "%,".$getCategoryId.",%";
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_category` WHERE make LIKE ?");
		$stmt->bind_param("s",$param );

		$result = $stmt->execute();
		$team_data_array = $stmt->get_result();

		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		if($team_data_array->num_rows  > 0){
			//echo "Here";
			//print_r($team_data_array);
			//$team_data_array = $stmt->get_result();
			while ($data = $team_data_array->fetch_assoc()) {
				$team_data['category_id'] = $data['category_id'];

			}
			//print_r($team_data);
			$stmt->close();
			return $team_data;
		}
	}

	public function getCommissionTable($user_id){


		$stmt = $this->conn->prepare("SELECT duration from tbl_plan GROUP BY duration ORDER BY plan_id");
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$plan_durations = $stmt->get_result();
		$stmt->close();
		$response["error"] = false;
		$response["commissionTable"] = array();
		while ($plan_duration = $plan_durations->fetch_assoc()) {
                $tmp = array();
                $tmp["duration"] = $plan_duration["duration"];
				$stmt = $this->conn->prepare("SELECT planname from tbl_plan GROUP BY planname ORDER BY plan_id");
				$result = $stmt->execute();
				if (false === $result) {
					die('execute() failed: ' . htmlspecialchars($stmt->error));
				}
				$plan_names = $stmt->get_result();
				$stmt->close();
				while ($plan_name = $plan_names->fetch_assoc()) {
					$stmt = $this->conn->prepare("SELECT b.* FROM tbl_plan a left join tbl_salesmancommission b on a.plan_id = b.plan_id WHERE b.user_id = ? AND a.duration = ? AND a.planname = ? AND b.commission_type = 0");
					$stmt->bind_param("iss", $user_id, $plan_duration['duration'],$plan_name['planname']);
					$result = $stmt->execute();
					if (false === $result) {
						die('execute() failed: ' . htmlspecialchars($stmt->error));
					}
					$commissionValues = $stmt->get_result();
					$stmt->close();
					//$tmp[$plan_name["planname"]] = $plan_name["planname"];

					while($commissionValue = $commissionValues->fetch_assoc())
					{
						$tmp[$plan_name["planname"]] = $commissionValue["commission_price"];
					}

				}
				//$tmp["commission_price"] = $commissionValue["commission_price"];

                array_push($response["commissionTable"], $tmp);
            }

		//print_r($response);
		return $response;
	}
	public function getManagementCommissionTable($user_id){


		$stmt = $this->conn->prepare("SELECT duration from tbl_plan GROUP BY duration ORDER BY plan_id");
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$plan_durations = $stmt->get_result();
		$stmt->close();
		$response["error"] = false;
		$response["commissionTable"] = array();
		while ($plan_duration = $plan_durations->fetch_assoc()) {
                $tmp = array();
                $tmp["duration"] = $plan_duration["duration"];
				$stmt = $this->conn->prepare("SELECT planname from tbl_plan GROUP BY planname ORDER BY plan_id");
				$result = $stmt->execute();
				if (false === $result) {
					die('execute() failed: ' . htmlspecialchars($stmt->error));
				}
				$plan_names = $stmt->get_result();
				$stmt->close();
				while ($plan_name = $plan_names->fetch_assoc()) {
					$stmt = $this->conn->prepare("SELECT b.* FROM tbl_plan a left join tbl_salesmancommission b on a.plan_id = b.plan_id WHERE b.user_id = ? AND a.duration = ? AND a.planname = ? AND b.commission_type = 1");
					$stmt->bind_param("iss", $user_id, $plan_duration['duration'],$plan_name['planname']);
					$result = $stmt->execute();
					if (false === $result) {
						die('execute() failed: ' . htmlspecialchars($stmt->error));
					}
					$commissionValues = $stmt->get_result();
					$stmt->close();
					//$tmp[$plan_name["planname"]] = $plan_name["planname"];

					while($commissionValue = $commissionValues->fetch_assoc())
					{
						$tmp[$plan_name["planname"]] = $commissionValue["commission_price"];
					}

				}
				//$tmp["commission_price"] = $commissionValue["commission_price"];

                array_push($response["commissionTable"], $tmp);
            }

		//print_r($response);
		return $response;
	}
	public function getMyCommission($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 0) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();

			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;

			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission, 2, '.', '');
			$tmp['loss'] = number_format($total_week_loss_commission, 2, '.', '');
			$tmp['totalSales'] = number_format($total_yearly_commission, 2, '.', '');
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission, 2, '.', '');
		$tmp['loss'] = number_format($grand_total_loss_commission, 2, '.', '');
		$tmp['totalSales'] = number_format($grand_total_yearly_commission, 2, '.', '');
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	public function getManagementCommission($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();

			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;

			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission, 2, '.', '');
			$tmp['loss'] = number_format($total_week_loss_commission, 2, '.', '');
			$tmp['totalSales'] = number_format($total_yearly_commission, 2, '.', '');
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission, 2, '.', '');
		$tmp['loss'] = number_format($grand_total_loss_commission, 2, '.', '');
		$tmp['totalSales'] = number_format($grand_total_yearly_commission, 2, '.', '');
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	public function getMySales($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;

			$stmt = $this->conn->prepare("SELECT count(*) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT count(*) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 0 ) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT count(*) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 0) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();

			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;

			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission);
			$tmp['loss'] = number_format($total_week_loss_commission);
			$tmp['totalSales'] = number_format($total_yearly_commission);
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission);
		$tmp['loss'] = number_format($grand_total_loss_commission);
		$tmp['totalSales'] = number_format($grand_total_yearly_commission);
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}

	public function getTeamCommission($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 1) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();

			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;

			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission, 2, '.', '');
			$tmp['loss'] = number_format($total_week_loss_commission, 2, '.', '');
			$tmp['totalSales'] = number_format($total_yearly_commission, 2, '.', '');
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission, 2, '.', '');
		$tmp['loss'] = number_format($grand_total_loss_commission, 2, '.', '');
		$tmp['totalSales'] = number_format($grand_total_yearly_commission, 2, '.', '');
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	public function getTeamSales($user_id){

		$return_arrray = array();

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		// Get My Team

		$stmt = $this->conn->prepare("SELECT * FROM `tbl_adminuser` as a, tbl_usertype as u where a.usertype_id = u.usertype_id AND a.status =1 AND addedbyuser_id = ?");
		$stmt->bind_param("i", $user_id);
		$result = $stmt->execute();
		if (false === $result) {
			die('execute() failed: ' . htmlspecialchars($stmt->error));
		}
		$team_data = $stmt->get_result();
		$stmt->close();

		$planAll = $this->getAllPlan();
		$tmp['userName'] = '';
		while($planRow = $planAll->fetch_assoc()){

			$tmp["plan".$planRow['plan_id']] = $planRow['duration']." ".$planRow['planname'];
		}
		$tmp['total'] = "Total";
		array_push($return_arrray['myCommission'], $tmp);
		while($userRow = $team_data->fetch_assoc()){
			$tmp = array();
			$tmp['userName'] = $userRow['firstname']." ".$userRow['lastname'];
			$planAll = $this->getAllPlan();
			$row_total = 0;
			while($planRow = $planAll->fetch_assoc()){

				$stmt = $this->conn->prepare("SELECT count(*) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1)  AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
				$stmt->bind_param("iiss", $userRow['user_id'], $planRow['plan_id'], $start_year, $end_year);
				$stmt->execute();
				$stmt->bind_result($total_yearly_commission);
				$stmt->fetch();
				$stmt->close();
				$tmp["plan".$planRow['plan_id']] = (int)$total_yearly_commission;
				$row_total += (int)$total_yearly_commission;

			}
			$tmp['total'] = $row_total;
			array_push($return_arrray['myCommission'], $tmp);
		}


		/*$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission);
		$tmp['loss'] = number_format($grand_total_loss_commission);
		$tmp['totalSales'] = number_format($grand_total_yearly_commission);
		array_push($return_arrray['myCommission'], $tmp);*/
		return $return_arrray;
	}

	public function getTotalCommission($user_id){
		$planAll = $this->getAllPlan();
		$return_arrray = array();
		$grand_total_week_commission = 0;
		$grand_total_loss_commission = 0;
		$grand_total_yearly_commission = 0;

		$year1 = date('Y') - 1; // Get current year and subtract 1
		$year2 = date('Y');
		if(date('m') >= 10){
			$year1 = date('Y');
			$year2 = date('Y') + 1;
		}
		$start_year = date("Y-m-d",mktime(0, 0, 0, 10, 1, $year1));
		$end_year = date("Y-m-d",mktime(0, 0, 0, 9, 30, $year2));
		$return_arrray["error"] = false;
		$return_arrray['myCommission'] = array();
		while($planRow = $planAll->fetch_assoc()){
			$total_week_commission = 0;
			$total_week_loss_commission = 0;
			$total_yearly_commission = 0;

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1 OR commission_type = 0) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_week_loss_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 3) AND (commission_type = 1 OR commission_type = 0) AND d.start_date >= DATE(NOW()) - INTERVAL 7 DAY GROUP BY c.plan_id");
			$stmt->bind_param("ii", $user_id, $planRow['plan_id']);
			$stmt->execute();
			$stmt->bind_result($total_week_loss_commission);
			$stmt->fetch();
			$stmt->close();

			$stmt = $this->conn->prepare("SELECT SUM(commission_price) as total_yearly_commission FROM tbl_customer a left join tbl_vehicle b on a.user_id = b.user_id join tbl_plan c on b.plan_id = c.plan_id join tbl_vehicleplandetail d on d.vehicle_id = b.vehicle_id join tbl_vehiclesales_detail e on e.vehicle_id = b.vehicle_id WHERE e.user_id = ? AND c.plan_id = ?  AND (b.status = 1) AND (commission_type = 1 OR commission_type = 0) AND (d.start_date BETWEEN ? AND ?) GROUP BY c.plan_id");
			$stmt->bind_param("iiss", $user_id, $planRow['plan_id'], $start_year, $end_year);
			$stmt->execute();
			$stmt->bind_result($total_yearly_commission);
			$stmt->fetch();
			$stmt->close();

			$grand_total_week_commission += $total_week_commission;
			$grand_total_loss_commission += $total_week_loss_commission;
			$grand_total_yearly_commission += $total_yearly_commission;

			$tmp = array();
			$tmp['planName'] = $planRow['duration']." ".$planRow['planname'];
			$tmp['weekSales'] = number_format($total_week_commission, 2, '.', '');
			$tmp['loss'] = number_format($total_week_loss_commission, 2, '.', '');
			$tmp['totalSales'] = number_format($total_yearly_commission, 2, '.', '');
			array_push($return_arrray['myCommission'], $tmp);

		}
		$tmp = array();
		$tmp['planName'] = 'Total';
		$tmp['weekSales'] = number_format($grand_total_week_commission, 2, '.', '');
		$tmp['loss'] = number_format($grand_total_loss_commission, 2, '.', '');
		$tmp['totalSales'] = number_format($grand_total_yearly_commission, 2, '.', '');
		array_push($return_arrray['myCommission'], $tmp);
		return $return_arrray;
	}
	public function getPendingApplication($user_id){
		$stmt = $this->conn->prepare("SELECT registration_date, firstname, lastname, address, address2, user_id FROM tbl_customer WHERE addedbyuser_id = ? AND status = 2");
		$stmt->bind_param("i", $user_id);
		$stmt->execute();
		$return_arrray['error'] = false;
		$return_arrray['customerData'] = array();
		$pending_application = $stmt->get_result();
		while($row_pending_application = $pending_application->fetch_assoc()){
			$tmp = array();
			$tmp['applicationDate'] = date('Y-m-d', strtotime($row_pending_application['registration_date']));
			$tmp['name'] = $row_pending_application['firstname']." ".$row_pending_application['lastname'];
			$tmp['address'] = $row_pending_application['address'];
			$tmp['address2'] = $row_pending_application['address2'];
			$tmp['customerId'] = $row_pending_application['user_id'];
			array_push($return_arrray['customerData'], $tmp);
		}
		return $return_arrray;
	}
	public function getJobApplication($user_id){
		$stmt = $this->conn->prepare("SELECT registration_date, firstname, lastname, mobilenumber, user_id FROM tbl_adminuser WHERE addedbyuser_id = ? AND status = 2");
		$stmt->bind_param("i", $user_id);
		$stmt->execute();
		$return_arrray['error'] = false;
		$return_arrray['jobApplicationData'] = array();
		$pending_application = $stmt->get_result();
		while($row_pending_application = $pending_application->fetch_assoc()){
			$tmp = array();
			$tmp['applicationDate'] = date('Y-m-d', strtotime($row_pending_application['registration_date']));
			$tmp['name'] = $row_pending_application['firstname']." ".$row_pending_application['lastname'];
			$tmp['mobilenumber'] = $row_pending_application['mobilenumber'];
			$tmp['admin_user_id'] = $row_pending_application['user_id'];
			array_push($return_arrray['jobApplicationData'], $tmp);
		}
		return $return_arrray;
	}
	public function insertTrack($request_params){
		$stmt = $this->conn->prepare("INSERT INTO  tbl_targetarea (user_id, notes, norrth_cord, south_cord, east_cord, west_cord, start_date, end_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		$stmt->bind_param("isssssss",$request_params['id'],$request_params['notes'],$request_params['norrth_cord'],$request_params['south_cord'],$request_params['east_cord'],$request_params['west_cord'],$request_params['fromdate'],$request_params['todate']);
		$stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	public function updateTrack($request_params){
		$stmt = $this->conn->prepare("UPDATE  tbl_targetarea SET  user_id = ?, notes = ?, norrth_cord =?, south_cord =?, east_cord=?, west_cord=?, start_date=?, end_date =? WHERE targetarea_id = ? ");
		$stmt->bind_param("isssssssi",$request_params['id'],$request_params['notes'],$request_params['norrth_cord'],$request_params['south_cord'],$request_params['east_cord'],$request_params['west_cord'],$request_params['fromdate'],$request_params['todate'], $request_params['main_id']);
		$stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	public function viewTargetArea($date, $oneuser, $user_id){
		if($oneuser == "All"){
			$teams = $this->getSalesMan($user_id);
			//print_r($teams);
			$date = str_replace('"', '', $date);
			$date_arr = explode("T", $date);
			//$date = date('Y-m-d', strtotime($date));
			//print_r($date_arr);
			$return_arrray['trackroute'] = array();

			while ($team = $teams->fetch_assoc()) {
				//echo "SELECT * FROM  tbl_targetarea WHERE user_id = ".$team['user_id']." AND start_date <= '".$date_arr[0]."' AND end_date <= '".$date_arr[0]."'";
				$stmt = $this->conn->prepare("SELECT * FROM  tbl_targetarea WHERE user_id = ? AND start_date <= '".$date_arr[0]."' AND end_date >= '".$date_arr[0]."'");
				$stmt->bind_param("i",$team['user_id']);
				$stmt->execute();
				$trackRoute = $stmt->get_result();
				while($track = $trackRoute->fetch_assoc()){
					$tmp = array();

					$tmp['fromdate'] = date('d-m-Y', strtotime($track['start_date']));
					$tmp['todate'] = date('d-m-Y', strtotime($track['end_date']));
					$tmp['id'] = $track['targetarea_id'];
					$tmp['notes'] = $track['notes'];
					$tmp['name'] = $team['firstname']." ".$team['lastname'];
					array_push($return_arrray['trackroute'], $tmp);
				}
			}
			$stmt = $this->conn->prepare("SELECT * FROM  tbl_targetarea WHERE user_id = ? AND start_date <= '".$date_arr[0]."' AND end_date >= '".$date_arr[0]."'");
			$stmt->bind_param("i",$user_id);
			$stmt->execute();
			$trackRoute = $stmt->get_result();
			//print_r($trackRoute);
			//echo "test";
			while($track = $trackRoute->fetch_assoc()){
				$tmp = array();
				$getData = $this->getAdminUser($user_id);
				//print_r($getData);
				$tmp['fromdate'] = date('d-m-Y', strtotime($track['start_date']));
				$tmp['todate'] = date('d-m-Y', strtotime($track['end_date']));
				$tmp['id'] = $track['targetarea_id'];
				$tmp['notes'] = $track['notes'];
				$tmp['name'] = $getData['firstname']." ".$getData['lastname'];
				array_push($return_arrray['trackroute'], $tmp);
			}
		}else{
			$stmt = $this->conn->prepare("SELECT * FROM  tbl_targetarea WHERE user_id = ? AND start_date <= '".$date_arr[0]."' AND end_date >= '".$date_arr[0]."'");
			$stmt->bind_param("i",$oneuser);
			$stmt->execute();
			$trackRoute = $stmt->get_result();
			//print_r($trackRoute);
			//echo "test";
			while($track = $trackRoute->fetch_assoc()){
				$tmp = array();
				$getData = $this->getAdminUser($user_id);
				//print_r($getData);
				$tmp['fromdate'] = date('d-m-Y', strtotime($track['start_date']));
				$tmp['todate'] = date('d-m-Y', strtotime($track['end_date']));
				$tmp['id'] = $track['targetarea_id'];
				$tmp['notes'] = $track['notes'];
				$tmp['name'] = $getData['firstname']." ".$getData['lastname'];
				array_push($return_arrray['trackroute'], $tmp);
			}
		}

		return $return_arrray;
	}

	public function addSalesmanCommission($user_id){

		//$stmt = $this->conn->prepare("SELECT * from tbl_salesmancommission where user_id = ".$user_id." AND commission_type = 0");
		//$stmt->execute();

		$stmt1 = $this->conn->prepare("SELECT * from tbl_salesmancommission where user_id = 0 AND commission_type = 0");
		$stmt1->execute();

		$getCommissionData = $stmt1->get_result();
		while($getCommission = $getCommissionData->fetch_assoc()){

			$stmt = $this->conn->prepare("INSERT INTO tbl_salesmancommission (user_id, plan_id, commission_price, commission_type) VALUES (?,?,?,'0')");
			$stmt->bind_param("iis",$user_id, $getCommission['plan_id'], $getCommission['commission_price']);
			$stmt->execute();
		}
	}
	public function updateStaffStatusSign($sign, $user_id){
		$stmt = $this->conn->prepare("UPDATE tbl_bankaccountdetail SET status= 1 WHERE user_id = ? AND vehicle_id = 0");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
		$registration_date = date('Y-m-d');
		$registration_end_date = date('Y-m-d', strtotime('+1 years'));
		$stmt = $this->conn->prepare("UPDATE tbl_adminuser SET signature_proof= ?, registrationend_date = ?, registration_date = ?, status= 1  WHERE user_id = ?");
        $stmt->bind_param("sssi", $sign, $registration_date, $registration_end_date, $user_id);
        $stmt->execute();
        $num_affected_rows = $stmt->affected_rows;
        $stmt->close();
        return $num_affected_rows > 0;
	}
	public function getSalesmanData($id){
		$stmt = $this->conn->prepare("SELECT * FROM tbl_adminuser as a, tbl_bankaccountdetail as b WHERE a.user_id = b.user_id AND b.user_id = ? AND b.vehicle_id = 0  AND a.status = 2");
		$stmt->bind_param("i", $id);
		$stmt->execute();
		$return_arrray['error'] = false;
		//$return_arrray['jobApplicationData'] = array();
		$pending_application = $stmt->get_result();
		while($row_pending_application = $pending_application->fetch_assoc()){
			$account_no  = explode("-", $row_pending_application["accountnumber"]);
			$return_arrray["user_id"] = $row_pending_application["user_id"];
			$return_arrray["first_name"] = $row_pending_application["firstname"];
			$return_arrray["last_name"] = $row_pending_application["lastname"];
			$return_arrray["date_of_birth"] = $row_pending_application["dateofborth"];
			$return_arrray["gender"] = $row_pending_application["gender"];
			$return_arrray["mobile_no"] = $row_pending_application["mobilenumber"];
			$return_arrray["address"] = $row_pending_application["address"];
			$return_arrray["address2"] = $row_pending_application["address2"];
			$return_arrray["email_address"] = $row_pending_application["emailaddress"];
			$return_arrray["driver_licence_no"] = $row_pending_application["drivinglicencenumber"];
			$return_arrray["driver_licence_expiry_date"] = $row_pending_application["drivinglicenceexpiredate"];
			$return_arrray["bank_account_name"] = $row_pending_application["accountname"];
			$return_arrray["bank_name"] = $row_pending_application["bankname"];
			$return_arrray["bank_account_no1"] = $account_no[0];
			$return_arrray["bank_account_no2"] = $account_no[1];
			$return_arrray["bank_account_no3"] = $account_no[2];
			$return_arrray["bank_account_no4"] = $account_no[3];
			$return_arrray["payment_frequency"] = $row_pending_application["paymentfrequency"];
			$return_arrray["payment_day"] = $row_pending_application["paymentday"];
			$return_arrray["nzlProof1"] = $row_pending_application["drivinglicencefile1"];
			$return_arrray["nzlProof2"] = $row_pending_application["drivinglicencefile2"];
			$return_arrray["profilepic"] = $row_pending_application["profilepic"];
			$return_arrray["contract"] = $row_pending_application["contract"];
		}
		return $return_arrray;
	}
	public function getAllPlan(){
		$stmt = $this->conn->prepare("SELECT * FROM `tbl_plan`");
        $stmt->execute();
		$plan_data = $stmt->get_result();
		return $plan_data;
	}
	public function incident_detail_data($incidentid){
        $all_conversations = $this->conn->prepare("select d.*,u.firstname as sendername,a.firstname as receivername,u.profilepic from tbl_incidentreport as i left join tbl_incidentreport_detail as d on i.incidentreport_id = d.incidentreport_id left join tbl_adminuser as u on u.user_id = d.sender_id left join tbl_adminuser as a on a.user_id = d.receiver_id where d.incidentreport_id = ?");
        $all_conversations->bind_param("i",$incidentid);
        $result = $all_conversations->execute();
        $response = $all_conversations->get_result();
        $all_conversations->close();
        return $response;
    }
	public function insert_incident_details($incidentmsg,$incidentid,$user_id){
        $current_date = date("Y-m-d H:m:s");
        $receiver_id = 6;
        $stmt = $this->conn->prepare("INSERT INTO tbl_incidentreport_detail (incidentreport_id,sender_id,receiver_id,incident_detail,incidentreport_datetime) VALUES (?,?,?,?,?)");
        $stmt->bind_param("iiiss",$incidentid,$user_id,$receiver_id,$incidentmsg,$current_date);
        if($stmt->execute()){
            return 1;
        }else{
            return 0;
        }
    }
	public function getall_incident_logs($user_id){
        $stmt = $this->conn->prepare("SELECT incidentreport_id,incident_datetime,incident_location,incident_people FROM tbl_incidentreport WHERE admin_id = ?");
        $stmt->bind_param("i",$user_id);
        $result = $stmt->execute();
        $response = $stmt->get_result();
        $stmt->close();
        return $response;
    }
	public function store_incident($user_id,$incidentdate,$incidenttime,$incidentlocation,$incidentperson,$incidentdetails){
        $current_date_time  = date("Y-m-d h:i:s");
        $incident_date_time = $incidentdate.$incidenttime;
        $store_incident = date("Y-m-d h:i:s",strtotime($incident_date_time));

        $stmt = $this->conn->prepare("INSERT INTO tbl_incidentreport (admin_id,incident_datetime,incident_location,incident_people,incident_details,report_datetime) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("isssss",$user_id,$store_incident,$incidentlocation,$incidentperson,$incidentdetails,$current_date_time);
        if($stmt->execute()){
            $stmt->close();
            return 0;
        }else{
            $stmt->close();
            return 1;
        }
    }
	public function getSalesManRoute($id, $date, $from_time, $to_time, $user_global_id){


		if($id == "All"){
			if($from_time != "" && $to_time != ""){
				$from_date = $date." ".$from_time.":00";
				$to_date = $date." ".$to_time.":59";
				$str = " inserttime >= '".$from_date."' AND inserttime <= '".$to_date."'";
			}else{
				$str = "inserttime LIKE '".$date."%'";

			}
			$team_data = array();
			$teams = $this->getSalesMan($user_global_id);
			while ($team = $teams->fetch_assoc()) {
                $tmp = array();
				$tmp['route'] = array();
                $tmp["name"] = $team["firstname"]." ".$team["lastname"];
				$tmp["color"] = $this->rand_color();
				$stmt = $this->conn->prepare("SELECT * FROM  tbl_route WHERE user_id = ? AND ".$str);
				$stmt->bind_param("i",$team['user_id']);
				$result = $stmt->execute();
				$response = $stmt->get_result();
				//$team_data['route'] = array();
				while($row = $response->fetch_assoc()){
					$tmp1 = array();
					$tmp1['lat'] = $row['lat'];
					$tmp1['lan'] = $row['lan'];
					array_push($tmp['route'], $tmp1);
				}
				$stmt->close();
                array_push($team_data, $tmp);
            }
			return $team_data;
		}else{
			$route = array();
			//echo "SELECT * FROM  tbl_route WHERE user_id = 1 AND inserttime LIKE '".$date."%'";
			if($from_time != "" && $to_time != ""){
				$from_date = $date." ".$from_time.":00";
				$to_date = $date." ".$to_time.":59";
				$stmt = $this->conn->prepare("SELECT * FROM  tbl_route WHERE user_id = ? AND inserttime >= '".$from_date."' AND inserttime <= '".$to_date."'");
			}else{
				$stmt = $this->conn->prepare("SELECT * FROM  tbl_route WHERE user_id = ? AND inserttime LIKE '".$date."%'");

			}
			$stmt->bind_param("i",$id);
			$result = $stmt->execute();
			$response = $stmt->get_result();

			while($row = $response->fetch_assoc()){
				$tmp = array();
				$tmp['lat'] = $row['lat'];
				$tmp['lan'] = $row['lan'];
				array_push($route, $tmp);

			}
			$stmt->close();
			return $route;
		}


	}
	function rand_color() {
    return sprintf('#%06X', mt_rand(0, 0xFFFFFF));
	}
	public function getCenter($id, $date){
		//echo "SELECT * FROM  tbl_route WHERE user_id = 1 AND inserttime LIKE '".$date."%'";
		$stmt = $this->conn->prepare("SELECT AVG(lat) as lat, AVG(lan) as lan FROM  tbl_route WHERE user_id = ? AND inserttime LIKE '".$date."%'");
        $stmt->bind_param("i",$id);
        $result = $stmt->execute();
        $response = $stmt->get_result();

		$center = array();
		while($row = $response->fetch_assoc()){
			$tmp = array();
			$tmp['lat'] = $row['lat'];
			$tmp['lan'] = $row['lan'];
			array_push($center, $tmp);

		}
		$stmt->close();
		return $center;
	}
}
?>
