<?php
    include("../config/configuration.php");
    $load = new loader();
    $objPages = $load->includeclasses("sitemanager");
    $label = "scan";
    $dclass = new database();
    $gnrl = new general;
    
    if(!$gnrl->checkLogin()){
        $gnrl->redirectTo("index.php?msg=logfirst");
    }
    
    $load->includeother("header");
?>
<link rel="stylesheet" href="../css/responsive-table.css">
<div class="page-content full_page_content">
    <div id="portlet-config" class="modal hide">
        <div class="modal-header">
            <button data-dismiss="modal" class="close" type="button"></button>
            <h3>portlet Settings</h3>
        </div>
        <div class="modal-body">
            <p>Here will be a configuration form</p>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span12">
                <h3 class="page-title">&nbsp;<small></small></h3>
            </div>
        </div>
		<?php $load->includeother("left_sidebar_site_manager"); ?>
		<div class="span9">
			<div class="row-fluid">
				<div class="span12">
					<?php if(isset($_REQUEST['script']) && $_REQUEST['script'] == "view"){ ?>
						<div class="portlet box light-grey">
							<div class="portlet-title">
								<div class="caption"><i class="icon-globe"></i> <?php echo "Scan"; ?> </div>
								<div class="tools"><a href="javascript:;" class="collapse"></a></div>
							</div>
							<div class="portlet-body form display_data">
								<div class="table-fix">
									<?php if(isset($_SESSION["msg"])){ ?>
										<div class="alert alert-success">
											<button data-dismiss="alert" class="close"></button>
											<?php echo $_SESSION["msg"]; unset($_SESSION["msg"]); ?>
										</div>
									<?php } 
										$customer_data = $objPages->getCustomerData($_REQUEST['customer_id']);
										$vehicles = $objPages->getVehiclesByCustomer($_REQUEST['customer_id']);
										//echo "<pre>";print_r($vehicles);echo "</pre>";
									?>
									<div class="span12">
										<img src="../imgs/customer/<?php echo $customer_data['profilepic']; ?>" width="150" />
									</div>
									<div class="span12">
										<label class="span3">Customer's Name</label>
										<span>test</span>
									</div>
									<div class="span12">
										<label class="span3">Address</label>
										<span><?php echo $customer_data['address'].", ".$customer_data['address2']; ?></span>
									</div>
									<div class="span12">
										<label class="span3">Mobile</label>
										<span><?php echo $customer_data['mobilenumber']; ?></span>
									</div>
									<div class="span12">
										<label class="span3">Email</label>
										<span><?php echo $customer_data['emailaddress']; ?></span>
									</div>
									<?php 
									foreach($vehicles as $vehicle){ 
										$btn_title = "";
										$next_booking_date = "";
										$extra_class = "";
										$check_vehicle = $dclass->getrow("tbl_booking","*","vehicle_id = :vehicle_id",array("vehicle_id"=>$vehicle['vehicle_id'])," ORDER BY bookingdatetime DESC");
										$plan_expiry_date = $dclass->getvalue("tbl_vehicleplandetail","end_date","vehicle_id = :vehicle_id",array("vehicle_id" => $vehicle['vehicle_id']));
										//echo "<pre>";print_r($plan_expiry_date);echo "</pre>";
										$plan_expiry_date;
										if(time() > strtotime($plan_expiry_date)){
											$btn_title = "Plan Expired";
										}else if(!empty($check_vehicle)){
											if(strtotime($check_vehicle['bookingdatetime']) >= time()){
												$btn_title = "Booked";
												$extra_class = "veh_booked";
											}else{
												$next_booking_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($check_vehicle['bookingdatetime'])) . " + 6 month"));
												$secs = strtotime($next_booking_date) - time();
												$btn_title = round(abs($secs / 86400));
												if(time() > strtotime($next_booking_date)){
													$btn_title .= " Days Overdue";
												}else{
													$btn_title .= " Days To Go";
												}
											}
										}else{
											$next_booking_date = date("Y-m-d",strtotime(date("Y-m-d", strtotime($customer_data['registration_date'])) . " + 3 month"));
											$secs = strtotime($next_booking_date) - time();
											$btn_title = round(abs($secs / 86400));
											if(time() > strtotime($next_booking_date)){
												$btn_title .= " Days Overdue";
											}else{
												$btn_title .= " Days To Go";
											}
										}
									?>
										<div class="span5 margin-tb-10">
											<div class="vehicle_detail_main">
												<div class="vehicle_reg_num <?php echo $extra_class; ?>" booking_id = "<?php echo $check_vehicle['booking_id']; ?>"><span><?php echo $vehicle['plateno']; ?></span></div>
												<div class="vehicle_name"><?php echo $vehicle['make']." ".$vehicle['model']; ?></div>
												<div class="btn blue <?php echo $extra_class; ?>" booking_id = "<?php echo $check_vehicle['booking_id']; ?>"><?php echo $btn_title; ?></div>
											</div>
										</div>
									<?php } ?>
									<div class="full-width margin-tb-10" id="booked_veh_detail"></div>
								</div>
							</div>
						</div>
					<?php
					}else{ ?>
						<div class="portlet box light-grey">
							<div class="portlet-title">
								<div class="caption"><i class="icon-globe"></i> <?php echo "Scan"; ?> </div>
								<div class="tools"><a href="javascript:;" class="collapse"></a></div>
							</div>
							<div class="portlet-body">
								<div class="table-fix">
									<?php if(isset($_SESSION["msg"])){ ?>
										<div class="alert alert-success">
											<button data-dismiss="alert" class="close"></button>
											<?php echo $_SESSION["msg"]; unset($_SESSION["msg"]); ?>
										</div>
									<?php } ?>
									<form name="frm" id="frm" method="post"> 
										
										<div class="table-toolbar">
											
										</div>
										
									</form>
								</div>
							</div>
						</div>
					<?php } ?>
		</div>
		</div>
</div>
    </div>
</div>

<?php $load->includeother("footer"); ?>
<script src="assets/scripts/jquery.validationEngine.js"></script>
<script src="assets/scripts/jquery.validationEngine-en.js"></script>
<script src="assets/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
<script src="assets/scripts/app.js" type="text/javascript"></script>
<script src="assets/scripts/index.js" type="text/javascript"></script>
<script src="assets/scripts/tasks.js" type="text/javascript"></script>
<script type="text/javascript" src="inc/js/common.js"></script>
<script type="text/javascript">
    $(document).ready(function (){
        $("#userlist").validationEngine();
        
        $("#example").dataTable({
            "aaSorting": [[1,"desc"]]
        });
		
		$(document).on("click",".veh_booked",function(){
			var booking_id = $(this).attr("booking_id");
			
			$.ajax({
				type: "POST",
				url: "inc/ajax_call/booked_vehicle_detail.php",
				data: { booking_id : booking_id},
				success: function(res){
					$("#booked_veh_detail").html(res);
				}
			});
		});
        
    });
    
</script>
