<?php header('Access-Control-Allow-Origin: *');
require_once '../include/DbHandler-sitemanager.php';
require_once '../include/PassHash.php';
require '.././libs/Slim/Slim.php';
require_once('../../admin/generate_pdf/html2pdf/html2pdf.class.php');


\Slim\Slim::registerAutoloader();

$app = new \Slim\Slim(array(
    'debug' => true
));

require ('CorsSlim.php');
$corsOptions = array(
  //"origin" => "*",
  "exposeHeaders" => array("Content-Type", "X-Requested-With", "X-authentication", "X-client"),
  "allowMethods" => array('GET', 'POST', 'PUT', 'DELETE', 'OPTIONS')
);

$cors = new \CorsSlim\CorsSlim($corsOptions);
$app->add($cors);
$user_id = NULL;
$api_key = NULL;
$site_url = 'http://kwmapp.opaldemo.com';
function authenticate(\Slim\Route $route) {
	//echo "Hee";die();
    // Getting request headers
    //$headers = apache_request_headers();
    $headers = $_SERVER;
    $response = array();
    $app = \Slim\Slim::getInstance();
    //print_r($_SERVER);
	//print_r($headers);
    // Verifying Authorization Header
    if (isset($headers['REDIRECT_HTTP_AUTHORIZATION'])) {
        $db = new DbHandler();
		global $api_key;
		//global $api_key;
        // get the api key
        $api_key = $headers['REDIRECT_HTTP_AUTHORIZATION'];
		//echo $api_key;
        // validating api key
        if (!$db->isValidApiKey($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
             //get user primary key id
            $user_id = $db->getUserId($api_key);
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}
// Here we create sign up  for Technicians
$app->post('/techniciansRegistrations', function() use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true); 
    global $user_id;
    $first_name             = $data['first_name'];
    $last_name              = $data['last_name'];
    $date_of_birth           = $data['date_of_birth'];
    $gender                 = $data['gender'];
    $mobile_no              = $data['mobile_no'];
    $address                = $data['address'];
    $email_address          = $data['email_address'];
    $driver_licence_no      = $data['driver_licence_no'];
    $driver_licence_expiry_date = $data['driver_licence_expiry_date'];
    $driving_licence_proof      = $data['driving_licence_proof'];
    $profile_pic_name           = $data['profile_pic_name'];
    $bank_account_name          = $data['bank_account_name'];
    $bank_account_no            = $data['bank_account_no'];
    $bank_name              = $data['bank_name'];
    $payment_frequency      =  $data['payment_frequency']; //"weekly"
    $payment_day            = $data['payment_day'];//"Wednesday"
    $hourly_rate            = $data['hourly_rate'];
    $technicians_signature  = $data['technicians_signature'];
    $click_btn = $data['submit_btn'];
    $declarationcontent = $data['declarationcontent'];
    $signature_proof = $data['signature_proof'];
    $technicians_id = $data['technicians_id'];
    $type = 4;
    if($click_btn == 'save'){
        $status = "2";
    }else{
        $status = "1";
    }
    $db = new DbHandler();
    // Here we check email address is already exist or not
    $chk_user = $db->chk_record_exist("tbl_adminuser","emailaddress",$email_address,$technicians_id);
    if($chk_user == 1){
        $response['error'] = true;
        $response['message'] = "Email address is already exist.";
        echoRespnse(200, $response);
    }else{
        $return_val = $db->saveTechnician($user_id,$type,$first_name,$last_name,$date_of_birth,$gender,$mobile_no,$address,$email_address,$driver_licence_no,$driver_licence_expiry_date,$driving_licence_proof,$profile_pic_name,$bank_account_name,$bank_account_no,$bank_name,$payment_frequency,$payment_day,$hourly_rate,$technicians_signature,$status,$declarationcontent,$signature_proof);
        if($return_val != "error"){
                if($gender == 0){
                    $gender_view = "Male";
                }else{
                    $gender_view = "Female";
                }
                // here we send mail to admin as we Technicians 
                $html = '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780">
                <tr>
                    <td>
                        <table cellspacing="0"  cellpadding="0" border="0" width="780">
                                <td style="font-size:14px;padding:10px 10px">
                                    <img id="logo" src="http://kwmapp.opaldemo.com/images/logo.png" alt="Logo" class="CToWUd" border="0">
                                </td>
                        
                            </table>
                    </td>
                </tr>
                
                <tr>
                <td>
                        <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                            <tr>
                                <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
                    width: 100%">Technicians details</td>
                            </tr>
                        </table>
                            </td>
                        </tr>
                        
                <tr>
                    <td>
                        <table cellspacing="0"  cellpadding="0" border="0" width="780">	
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">First name : </td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$first_name.'</td>
                            </tr>
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Last name :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$last_name.'</td>
                            </tr>
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Date of birth :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$date_of_birth.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Gender :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$gender_view.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Mobile no :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$mobile_no.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Address :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$address.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Email address :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$email_address.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Drivers Licence No :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$driver_licence_no.'</td>
                            </tr>
                            
                            <tr>
                                <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Drivers Licence Expiry Date :</td>	 
                                <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$driver_licence_expiry_date.'</td>
                            </tr>
                            
                        </table>
                    </td>
                </tr>
                
                <tr>
                <td>
                        <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                            <tr>
                                <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
                    width: 100%">Bank Details</td>
                            </tr>
                        </table>
                            </td>
                        </tr>
                        
                        
                        <tr>
                            <td>
                                <table cellspacing="0"  cellpadding="0" border="0" width="780">
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank Account Name :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$bank_account_name.'</td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank Account Number :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$bank_account_no.'</td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$bank_name.'</td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Payment Frequency :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$payment_frequency.'</td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Payment Day :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$payment_day.'</td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Hourly Rate :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$hourly_rate.'</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <tr>
                <td>
                        <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                            <tr>
                                <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
                    width: 100%">Declaration</td>
                            </tr>
                        </table>
                            </td>
                        </tr>
                        
                        <tr>
                            <td>
                                <table cellspacing="0"  cellpadding="0" border="0" width="780">
                                    <tr>
                                        <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Declaration :</td>	 
                                        <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">'.$declarationcontent.'</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
            </table>';
            $subject = "New Technicians Register.";
            $headers = "From: KWM App <info@kwmapp.com>" . "\r\n";
            $headers  = $headers . "MIME-Version: 1.0" . "\r\n" .
                    "Content-type: text/html; charset=iso-8859-1";
            if(mail($email_address, $subject,$html,$headers)){
                $response['error'] = false;
                $response['technicians_id'] = 1;
                $response['message'] = "Technician information successfully inserted.";
            }
        }else{
            $response['error'] = true;
            $response['message'] = "An error occurred. Please try again.";
        }
        echoRespnse(200, $response);
    }
    
});
// end 

//  get all feedback from customer
$app->post('/getAllFeedback', function() use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true); 
    global $user_id;
    $user_id = 4;
    $db = new DbHandler();
    $get_feedback = $db->getAllFeedback($user_id);
    $response = array();
    while($feedback = $get_feedback->fetch_assoc()){
        $temp_array = array();
        $temp_array['firstname'] = $feedback['firstname'];
        $temp_array['conversation_id'] = $feedback['conversation_id'];
        $temp_array['conversation_datetime'] = $feedback['conversation_datetime'];
        array_push($response,$temp_array);
    }
    $response["error"] = false;
    echoRespnse(200, $response);
});
// end 

// get conversation details 
$app->post('/getConversationdetails', function() use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true); 
    $conversation_id = $data['conversation_id'];
    $db = new DbHandler();
    $get_conversation_details = $db->get_conversation($conversation_id);
    $response = array();
    while($conversation = $get_conversation_details->fetch_assoc()){
        $temp_array = array();
        $temp_array['sender_id'] = $conversation['sender_id'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['message'] = $conversation['message'];
        $temp_array['conversation_datetime'] = $conversation['conversation_datetime'];
        $temp_array['sendername'] = $conversation['sendername'];
        $temp_array['receivername'] = $conversation['receivername'];
        array_push($response,$temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end 

// sent message from front side
$app->post('/sentMessage', function() use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true); 
    $conversation_id = $data['conversation_id'];
    $message = $data['message'];
    $sender_id = $data['sender_id'];
    $receiver_id = $data['receiver_id'];    
    $send_by = 0;
    $conversation_datetime = date("Y-m-d H:m:i");
    $db = new DbHandler();
    $send_details = $db->sent_message($conversation_id,$message,$sender_id,$receiver_id,$send_by,$conversation_datetime);
    if($send_details == 1){
        $response['error'] = false;
        $get_conversation_details = $db->get_conversation($conversation_id);
        $response = array();
        while($conversation = $get_conversation_details->fetch_assoc()){
            $temp_array = array();
            $temp_array['sender_id'] = $conversation['sender_id'];
            $temp_array['receiver_id'] = $conversation['receiver_id'];
            $temp_array['message'] = $conversation['message'];
            $temp_array['conversation_datetime'] = $conversation['conversation_datetime'];
            $temp_array['sendername'] = $conversation['sendername'];
            $temp_array['receivername'] = $conversation['receivername'];
            array_push($response,$temp_array);
        }
        echoRespnse(200, $response);
    }else{
        $response['error'] = true;
        $response['message'] = "There is some error.please try again";
        echoRespnse(200, $response);
    }
});
// end



$app->post('/getAllinquiry', function() use ($app) {
    $db = new DbHandler();
    $all_inquiry = $db->get_all_inquiry();
    $response['error'] = false;
    $response = array();
    while($conversation = $all_inquiry->fetch_assoc()){
        $temp_array = array();
        $temp_array['sender_id'] = $conversation['sender_id'];
        $temp_array['message'] = $conversation['message'];
        $temp_array['inquiry_date'] = $conversation['inquiry_date'];
        array_push($response,$temp_array);
    }
    echoRespnse(200, $response);
});

/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields) {
    $error = false;
    $error_fields = "";
    $request_params = array();
    //$request_params = $_REQUEST;
    // Handling PUT request params
	$app = \Slim\Slim::getInstance();
	$json = $app->request->getBody();
	$request_params = json_decode($json, true); 
	
	
    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
       // $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * Validating email address
 */
function validateEmail($email) {
    $app = \Slim\Slim::getInstance();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["error"] = true;
        $response["message"] = 'Email address is not valid';
        echoRespnse(400, $response);
        $app->stop();
    }
}
/**
 * Echoing json response to client
 * @param String $status_code Http response code
 * @param Int $response Json response
 */
function echoRespnse($status_code, $response) {
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);
 
    // setting response content type to json
    $app->contentType('application/json');
 
    echo json_encode($response);
}
$app->notFound(function () use ($app) {
	$headers = apache_request_headers();
	
    print_r($headers);
});
$app->run();
?>