<?php header('Access-Control-Allow-Origin: *');

require_once '../../admin/generate_pdf/html2pdf/html2pdf.class.php';

require_once '../include/DbHandler-sitemanager.php';
require_once '../include/PassHash.php';
require '.././libs/Slim/Slim.php';
require_once '../../admin/generate_pdf/html2pdf/html2pdf.class.php';



\Slim\Slim::registerAutoloader();

$app = new \Slim\Slim(array(
    'debug' => true,
));

require 'CorsSlim.php';
$corsOptions = array(
    //"origin" => "*",
    "exposeHeaders" => array("Content-Type", "X-Requested-With", "X-authentication", "X-client"),
    "allowMethods" => array('GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'),
);

$cors = new \CorsSlim\CorsSlim($corsOptions);
$app->add($cors);
$user_id = null;
$api_key = null;
$site_url = 'http://kwmapp.opaldemo.com';
function authenticate(\Slim\Route $route)
{
    //echo "Hee";die();
    // Getting request headers
    //$headers = apache_request_headers();
    $headers = $_SERVER;
    $response = array();
    $app = \Slim\Slim::getInstance();
    //print_r($_SERVER);
    //print_r($headers);
    // Verifying Authorization Header
    if (isset($headers['REDIRECT_HTTP_AUTHORIZATION'])) {
        $db = new DbHandler();
        global $api_key;
        //global $api_key;
        // get the api key
        $api_key = $headers['REDIRECT_HTTP_AUTHORIZATION'];
        //echo $api_key;
        // validating api key
        if (!$db->isValidApiKey($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
            //get user primary key id
            $user_id = $db->getUserId($api_key);
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * User Login
 * url - /login
 * method - POST
 * params - email, password
 */
$app->post('/login', function () use ($app) {
    // check for required params
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    //die();
    // reading post params
    $email = $data['email'];
    $password = $data['password'];
    verifyRequiredParams(array('email', 'password'));
    $response = array();
    $db = new DbHandler();
    // check for correct email and password
    if ($db->checkLogin($email, $password)) {
        // get the user by email
        $user = $db->getUserByEmail($email);
        if ($user != null) {
            $api_key = $db->getApiKeyByEmail($email);
            if ($api_key == null) {
                $api_key = $db->generateApiKey($user['emailaddress']);
                $db->updateApikey($user['emailaddress'], $api_key);
            }

            //print_r($user);
            $response["error"] = false;
            $response['firstname'] = $user['firstname'];
            $response['lastname'] = $user['lastname'];
            $response['emailaddress'] = $user['emailaddress'];
            $response['api_key'] = $api_key;
            $response['userImage'] = $user['userImage'];
        } else {
            // unknown error occurred
            $response['error'] = true;
            $response['message'] = "An error occurred. Please try again";
        }
    } else {
        // user credentials are wrong
        $response['error'] = true;
        $response['message'] = 'Login failed. Incorrect credentials';
    }
    //print_r($response);die();
    echoRespnse(200, $response);
});
// get all the team members of current technicians
$app->get('/gettechnicianTeam', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_teams = $db->getallmembers($user_id);
    $response = array();
    while ($team_members = $all_teams->fetch_assoc()) {
        $tmp = array();
        $user_id = $team_members["user_id"];
        $cheparent_user = $db->get_my_members($user_id);
        $tmp["registration_date"] = date('Y-m-d', strtotime($team_members["registration_date"]));
        $tmp["name"] = $team_members["firstname"];
        $tmp["roles"] = $team_members["rolename"];
        $tmp["phone"] = $team_members["mobilenumber"];
        $tmp["userid"] = $team_members["user_id"];
        array_push($response, $tmp);
        if (!empty($cheparent_user)) {
            foreach ($cheparent_user as $data) {
                array_push($response, $data);
            }
        }

    }
    // echo "<pre>";print_r($response);exit;
    echoRespnse(200, $response);
});
// End

// Get search specific team members
$app->post('/searchCurrentteam','authenticate',function () use ($app) {
    $json = $app->request->getBody();
    $db = new DbHandler();
    $data = json_decode($json, true);
    $searchdata = $data['searchdata'];
    global $user_id;
    $all_teams = $db->search_team_members($user_id,$searchdata);
    echo "<pre>";print_r($all_teams);exit;
    $response = array();
    while ($team_members = $all_teams->fetch_assoc()) {
        $tmp = array();
        $user_id = $team_members["user_id"];
        $cheparent_user = $db->get_my_members($user_id);
        $tmp["registration_date"] = date('Y-m-d', strtotime($team_members["registration_date"]));
        $tmp["name"] = $team_members["firstname"];
        $tmp["roles"] = $team_members["rolename"];
        $tmp["phone"] = $team_members["mobilenumber"];
        $tmp["userid"] = $team_members["user_id"];
        array_push($response, $tmp);
        if (!empty($cheparent_user)) {
            foreach ($cheparent_user as $data) {
                array_push($response, $data);
            }
        }
    }
    echoRespnse(200, $response);
});


// end 

$app->post('/Searchdata', function () use ($app) {
    $json = $app->request->getBody();
    $db = new DbHandler();
    $data = json_decode($json, true);
    $searchString = $data['searchString'];
    $search_result = $db->search_data($searchString);
    $response['searchresult'] = array();
    if ($search_result->num_rows > 0) {
        while ($search_data = $search_result->fetch_assoc()) {
            $temp = array();
            $temp['user_id'] = $search_data['user_id'];
            $temp['name'] = $search_data['firstname'] . " " . $search_data['lastname'];
            $temp['mobilenumber'] = $search_data['mobilenumber'];
            $temp['plateno'] = $search_data['plateno'];
            array_push($response['searchresult'], $temp);
        }
        $response['error'] = false;
    }
    echoRespnse(200, $response);
});

// Here we store incident data to table
$app->post('/storeincident', 'authenticate', function () use ($app) {
    global $user_id;
    $json = $app->request->getBody();
    $db = new DbHandler();
    $data = json_decode($json, true);

    $incidentdate = $data['incidentdate'];
    $incidenttime = $data['incidenttime'];
    $incidentlocation = $data['incidentlocation'];
    $incidentperson = $data['incidentperson'];
    $incidentdetails = $data['incidentdetails'];
    $store_incident = $db->store_incident($user_id, $incidentdate, $incidenttime, $incidentlocation, $incidentperson, $incidentdetails);
    if ($store_incident == 0) {
        $response['error'] = false;
        $response['msg'] = "Incident information store successfully.";
    } else {
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error to store information.";
    }
    echoRespnse(200, $response);
});
// End

// Get all incident perticular site manager
$app->get('/getincidentLogs', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_incident = $db->getall_incident_logs($user_id);
    $response['incidentlogs'] = array();
    while ($incident_log = $all_incident->fetch_assoc()) {
        $temp = array();
        $temp['incidentreport_id'] = $incident_log['incidentreport_id'];
        $temp['incident_datetime'] = date("d/m/y", strtotime($incident_log['incident_datetime']));
        $temp['incident_location'] = $incident_log['incident_location'];
        $temp['incident_people'] = $incident_log['incident_people'];
        array_push($response['incidentlogs'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});

// End

// Get all Last Month customer record
$app->get('/getLastmonthCustomer', 'authenticate', function () use ($app) {
    $db = new DbHandler();
    $all_new_customer = $db->get_new_customer();
    $response['newcustomer'] = array();
    while ($customer = $all_new_customer->fetch_assoc()) {
        $temp = array();
        $temp['registration_date'] = date("d-m-y", strtotime($customer['registration_date']));
        $temp['customername'] = $customer['firstname'] . " " . $customer['lastname'];
        $temp['mobilenumber'] = $customer['mobilenumber'];
        $temp['status'] = $customer['welcome_status'];
        $temp['userid'] = $customer['user_id'];
        array_push($response['newcustomer'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

// Get all past teams
$app->get('/gettechnicianpastTeam', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_past_teams = $db->getall_past_members($user_id);
    $response["pastteammember"] = array();
    while ($pastteammember = $all_past_teams->fetch_assoc()) {
        $temp = array();
        $temp["registration_date"] = date('Y-m-d', strtotime($pastteammember["registration_date"]));
        $temp["name"] = $pastteammember["firstname"];
        $temp["roles"] = $pastteammember["rolename"];
        $temp["phone"] = $pastteammember["mobilenumber"];
        $temp["registrationend_date"] = $pastteammember["registrationend_date"];
        $temp["userid"] = $pastteammember["user_id"];
        array_push($response["pastteammember"], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});

// End

// Here we fetch all job applications data
$app->get('/getAlljobapplications', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_job_applications = $db->get_job_applications();
    $response["jobapplications"] = array();
    while ($job_applications = $all_job_applications->fetch_assoc()) {
        $temp = array();
        $temp['regdate'] = date("d/m/y", strtotime($job_applications['registration_date']));
        $temp['name'] = $job_applications['firstname'] . " " . $job_applications['lastname'];
        $temp['mobilenumber'] = $job_applications['mobilenumber'];
        $temp['user_id'] = $job_applications['user_id'];
        $temp['rolename'] = $job_applications['rolename'];
        
        array_push($response["jobapplications"], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

$app->get('/getSalesmanData/:id', 'authenticate', function($id) {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getSalesmanData($id);
    echoRespnse(200, $result);
});


$app->post('/getLastTwoService', 'authenticate', function() use ($app) {

    $json = $app->request->getBody();
    $request_params = json_decode($json, true); 
    $vehicle_id = $request_params;
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $data = $db->getLastTwoService($vehicle_id);
    $response["error"] = false;
    $response["event"] = $data;
    echoRespnse(200, $response);

});



// Here we fetch all vehicle information
$app->get('/getAllvehicle', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_vehicle_data = $db->getallvehicle();
    $response['vehicle_data'] = array();
    while ($vehicledata = $all_vehicle_data->fetch_assoc()) {
        $tmp = array();
        $tmp['vehicle_id'] = $vehicledata['vehicle_id'];
        $tmp['plateno'] = $vehicledata['plateno'];
        $tmp['make'] = $vehicledata['make'];
        $tmp['model'] = $vehicledata['model'];
        array_push($response['vehicle_data'], $tmp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});
// End

// Here we provide options for serach cars
$app->post('/getCarSearchResult', function () use ($app) {
    $db = new DbHandler();
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $serachData = $data['serachData'];
    $serach_info = $db->get_car_data($serachData);
    $response['vehicle_data'] = array();
    while($search = $serach_info->fetch_assoc()){
        $temp = array();
        $tmp['vehicle_id'] = $search['vehicle_id'];
        $tmp['plateno'] = $search['plateno'];
        $tmp['make'] = $search['make'];
        $tmp['model'] = $search['model'];
        array_push($response['vehicle_data'],$tmp);
    }
    $response['error'] = false;
    echoRespnse(200,$response);
});
// end 

// Here we fetch vehicle details information
$app->post('/getVehicledetails', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $vehicle_id = $data['vehicle_id'];
    $db = new DbHandler();

    $get_vehicle_data = $db->get_vehicle_detail_data($vehicle_id);
    $response['vehicleinfo'] = array();
    while ($vehicleinfo = $get_vehicle_data->fetch_assoc()) {
        $tmp_array = array();
        $tmp_array['signupdate'] = $vehicleinfo['signupdate'];
        $tmp_array['renewaldate'] = $vehicleinfo['renewaldate'];
        $tmp_array['make'] = $vehicleinfo['make'];
        $tmp_array['model'] = $vehicleinfo['model'];
        $tmp_array['categoryname'] = $vehicleinfo['categoryname'];
        $tmp_array['enginetypename'] = $vehicleinfo['enginetypename'];
        $tmp_array['type'] = $vehicleinfo['type'];
        $tmp_array['term'] = $vehicleinfo['term'];
        $tmp_array['special_benefits'] = $vehicleinfo['special_benefits'];
        $getdate_last_service = $db->getLastService($vehicle_id);
        $vehicleservice = $db->getTotalServiceApplayonvehicle($vehicle_id);
        $tmp_array['vehicle_services'] = $vehicleservice;
        $tmp_array['lastservicedate'] = $getdate_last_service;
        $tmp_array['nextservicedate'] = $vehicleinfo['next_service_date'];
        array_push($response['vehicleinfo'], $tmp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end

// Here we fetch vehicle information accoding to plat no
$app->post('/getVehicledetailsPlatno', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $plateno    = $data['plateno'];
    $db = new DbHandler();
    $vehicle_id = $db->get_vehicle_id($plateno);
    
    if(isset($vehicle_id) && $vehicle_id != ''){
        $get_vehicle_data = $db->get_vehicle_detail_data($vehicle_id);
        $response['vehicleinfo'] = array();
        while ($vehicleinfo = $get_vehicle_data->fetch_assoc()) {
            $tmp_array = array();
            $tmp_array['signupdate'] = $vehicleinfo['signupdate'];
            $tmp_array['renewaldate'] = $vehicleinfo['renewaldate'];
            $tmp_array['make'] = $vehicleinfo['make'];
            $tmp_array['model'] = $vehicleinfo['model'];
            $tmp_array['categoryname'] = $vehicleinfo['categoryname'];
            $tmp_array['enginetypename'] = $vehicleinfo['enginetypename'];
            $tmp_array['type'] = $vehicleinfo['type'];
            $tmp_array['term'] = $vehicleinfo['term'];
            $tmp_array['special_benefits'] = $vehicleinfo['special_benefits'];
            $getdate_last_service = $db->getLastService($vehicle_id);
            $vehicleservice = $db->getTotalServiceApplayonvehicle($vehicle_id);
            $tmp_array['vehicle_services'] = $vehicleservice;
            $tmp_array['lastservicedate'] = $getdate_last_service;
            $tmp_array['nextservicedate'] = $vehicleinfo['next_service_date'];
            $tmp_array['plan_id'] = $vehicleinfo['plan_id'];
            $tmp_array['vehicle_id'] = $vehicleinfo['vehicle_id'];
            
            
            array_push($response['vehicleinfo'], $tmp_array);
        }
        $response['error'] = false;
    }else{
        $response['error'] = true;
        $response['msg'] = "No data found";
    }   
    echoRespnse(200, $response);
});
// End 


// Here we create a new booking 
$app->post('/createBooking', 'authenticate', function() use ($app) {
    // check for required params
    
    $json = $app->request->getBody();
    $request_params = json_decode($json, true); 
    //print_r($request_params);
    // verifyRequiredParams(array('car', 'car_time'));
    $response = array();
    global $user_id;
    $db = new DbHandler();

    //Create New Booking
    $vehicle_id = $request_params['vehicle_id'];
    $booking_c_time = $request_params['car_time'];

    
    //die();
    $location_address = $request_params['address'];
    $pickup_time = $request_params['pickup_time'];
    $dropoff_time = $request_params['dropoff_time'];
    $plan_id = $request_params['plan_id'];
    $getTotalService = $db->getTotalService($vehicle_id);
    $service_id = $db->getServiceId($plan_id, $getTotalService);

    //$service_id = 1;
    //echo "test".$plan_id;die();
    if($service_id != "" && $service_id > 0 && $service_id != NULL){
        $duration = $db->GetServiceDuration($service_id);				//die();
        $tz = new DateTimeZone('Etc/GMT+12');
        $date = new DateTime($booking_c_time);
        $date->setTimezone($tz);
        $date->modify('+1 day');
        $booking_time = $date->format('Y-m-d H:i:s');

        $date->add(new DateInterval('PT' . (int)$duration . 'M'));
        $booking_end_time = $date->format('Y-m-d H:i:s');


        $booking_id = $db->insertBooking($service_id, $user_id, $vehicle_id, $booking_time, $location_address, $pickup_time, $dropoff_time, $duration, $booking_end_time );
        $response["error"] = false;
        $response["message"] = "Booking done successfully";
        echoRespnse(201, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "You have reached the maximum number of Allowed services. Please contact sales Manager";
        echoRespnse(200, $response);
    }   
});

// End 



// get all service history of customer
$app->post('/getServicehistory', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $customer_id = $data['customer_id'];
    $db = new DbHandler();
    $service_history_data = $db->get_service_history($customer_id);
    $response['servicehistory'] = array();
    while ($service_history = $service_history_data->fetch_assoc()) {
        $temp = array();
        $temp['bookingdatetime'] = date("d/m/y", strtotime($service_history['bookingdatetime']));
        $temp['pdfname'] = $service_history['pdfname'];
        $temp['make'] = $service_history['make'];
        $temp['model'] = $service_history['model'];
        $temp['plateno'] = $service_history['plateno'];
        array_push($response['servicehistory'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});

// end

// get contract information of user
$app->post('/getContractdetails', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $user_id = $data['user_id'];
    $db = new DbHandler();
    $get_contract_details = $db->user_contract_details($user_id);
    $response['usercontractinfo'] = array();

    $contract_details = $get_contract_details->fetch_assoc();
    $response['error'] = false;
    $response['usercontractinfo']['registration_date'] = date("d-m-Y H:m:s", strtotime($contract_details['registration_date']));
    $response['usercontractinfo']['customername'] = $contract_details['firstname'] . " " . $contract_details['lastname'];
    $response['usercontractinfo']['customeraddress'] = $contract_details['address'] . " " . $contract_details['address2'];
    $response['usercontractinfo']['mobilenumber'] = $contract_details['mobilenumber'];
    $response['usercontractinfo']['email'] = $contract_details['emailaddress'];
    $response['usercontractinfo']['dob'] = date("d-m-Y", strtotime($contract_details['dateofborth']));
    $response['usercontractinfo']['gender'] = ($contract_details['gender'] == 0 ? 'Male' : 'Female');
    $response['usercontractinfo']['platno'] = $contract_details['plateno'];
    $response['usercontractinfo']['category'] = $contract_details['categoryname'];
    $response['usercontractinfo']['enginetypename'] = $contract_details['enginetypename'];
    $response['usercontractinfo']['type'] = $contract_details['planname'];
    $response['usercontractinfo']['term'] = $contract_details['duration'];
    $response['usercontractinfo']['specialbenefits'] = $contract_details['special_benefits'];
    echoRespnse(200, $response);

});
// End

$app->post('/changeWelcomeStatus', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $db = new DbHandler();
    $user_id = $data['user_id'];
    $welcome_status = $data['welcome_status'];
    $change_status = $db->change_welcome_status($user_id, $welcome_status);
    if ($change_status == 1) {
        $response['error'] = false;
        $response['msg'] = "Status updated successfully.";
    } else {
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error in update status.!Please try again.";
    }
    echoRespnse(200, $response);
});

// Get all jobs which is in progress
$app->get('/getJobinprogress', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $job_in_progressdata = $db->get_job_in_progress();
    $response['jobinprogress'] = array();
    while ($job_in_progress = $job_in_progressdata->fetch_assoc()) {
        $tmp = array();
        $tmp['starttime'] = date("H:m:s", strtotime($job_in_progress['scheduledatetime']));
        $tmp['plate'] = $job_in_progress['plateno'];
        $tmp['servicename'] = $job_in_progress['servicename'];
        $tmp['technitionname'] = $job_in_progress['technitionname'];
        $tmp['total_time'] = $job_in_progress['total_time'];
        array_push($response['jobinprogress'], $tmp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

// Get all technitions
$app->get('/getalltechnitions', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $all_technitions = $db->get_all_technitions($user_id);
    $response['mytechnitions'] = array();
    while ($mytechnitions = $all_technitions->fetch_assoc()) {
        $temp = array();
        $temp['user_id'] = $mytechnitions['user_id'];
        $temp['technitionsname'] = $mytechnitions['firstname'] . " " . $mytechnitions['lastname'];
        array_push($response['mytechnitions'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

// get prevois date of specific date
$app->post('/getPrevoisdate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $currentdate = $data['currentdate'];
    $label = $data['label'];
    if($label == 'previous'){
        $new_date = date("d-m-Y",strtotime('-1 day',strtotime($currentdate)));
    }else if($label == 'next'){
        $new_date = date("d-m-Y",strtotime('+1 day',strtotime($currentdate)));
    }
    $response['newdate'] = $new_date;
    echoRespnse(200,$response);
});
// end

// store technician hours information
$app->post('/StoretechnicianHours', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $reportdate = $data['reportdate'];
    $techniciandata = $data['techniciandata'];
    $store_data = $db->store_technician_hours($user_id,$reportdate,$techniciandata);
    $response = array();
    if($store_data == 1){
        $response['error'] = false;
        $response['msg'] = "Technician Hours added successfully.";
    }else{
        $response['error'] = false;
        $response['msg'] = "Oops,there is some error.";
    }
    echoRespnse(200,$response);
});
// End 

// Here we get the time diffrence
$app->post('/GettheTimediffrence', function () use ($app) {
    $db = new DbHandler();
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $starttime = $data['starttime'];
    $endtime = $data['finishtime'];
    
    if($starttime != '' && $endtime != ''){
        $datetime1 = new DateTime('2011-01-03'.$starttime);
        $datetime2 = new DateTime('2011-01-03'.$endtime);
        $interval = $datetime1->diff($datetime2);
        $elapsed = $interval->format('%H:%i');
        $response['difference'] = $elapsed;
        echoRespnse(200,$response);
    }
});    
// End 
$app->post('/getAllmyVehicle', function () use ($app) {
    $db = new DbHandler();
    $json = $app->request->getBody();
    $userid = str_replace('"', '', $json);
    $get_vehicle_details = $db->get_my_vehicles($userid);
    $response = array();
    $response['vehicledata'] = array();
    $current_date = date("Y-m-d");
    while($vehicle = $get_vehicle_details->fetch_assoc()){
        $temp_array = array();
        $temp_array['vehicle_id'] = $vehicle['vehicle_id'];
        $temp_array['make'] = $vehicle['make'];
        $temp_array['model'] = $vehicle['model'];
        $temp_array['plateno'] = $vehicle['plateno'];
        $temp_array['booking_id'] = $vehicle['booking_id'];
        

        if(isset($vehicle['booking_id']) && $vehicle['booking_id'] != ''){
            $temp_array['booked'] = "yes";
            $temp_array['remaing_days'] = '';
        }else{
            $temp_array['booked'] = "no";
            if($current_date >= $vehicle['next_service_date']){
                $datetime1 = date_create($current_date);
                $datetime2 = date_create($vehicle['next_service_date']);
                $interval = date_diff($datetime1,$datetime2);
                $elapsed = $interval->format('%d');
                $temp_array['remaing_days'] = $elapsed." Over due days";
            }else{
                $datetime1 = date_create($vehicle['next_service_date']);
                $datetime2 = date_create($current_date);
                $interval = date_diff($datetime1,$datetime2);
                $elapsed = $interval->format('%d');
                $temp_array['remaing_days'] = $elapsed." Days To Go";
            }
        }
        
        array_push($response['vehicledata'],$temp_array);
    }
    $response['error'] = false;
    echoRespnse(200,$response);

});

// Get Booked vehicle information
$app->post('/getVehicleBookedinfo', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $booking_id = $data['booking_id'];
    $get_vehicle_booking_data = $db->get_vehicle_booking_info($booking_id);
    $response = array();
    $response['vehicledata'] = array();
    $get_vehicle_booking = $get_vehicle_booking_data->fetch_assoc();

    $response['vehicledata']['servicetype'] = $get_vehicle_booking['servicetype_id'];
    $response['vehicledata']['scheduledatetime'] = $get_vehicle_booking['scheduledatetime'];
    $response['vehicledata']['duration'] = $get_vehicle_booking['duration'];
    $response['vehicledata']['specialbenefits'] = $get_vehicle_booking['specialbenefits'];
    $response['vehicledata']['carpickuptime'] = $get_vehicle_booking['carpickuptime'];
    $response['vehicledata']['cardropofftime'] = $get_vehicle_booking['cardropofftime'];
    $response['vehicledata']['location'] = $get_vehicle_booking['location'];
    $response['vehicledata']['servicetypename'] = $get_vehicle_booking['servicetypename'];
    
    
    

    $response['error'] = false;
    echoRespnse(200,$response);
});

// end 


// Get all technitions with its completed job count
$app->get('/gettechnitionscompletedwork', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $get_technitions_completed_jobs = $db->get_technitions_completed_jobs($user_id);
    $response["copletedjobs"] = array();
    while ($get_allcompleted_jobs = $get_technitions_completed_jobs->fetch_assoc()) {
        $temp = array();
        $temp["user_id"] = $get_allcompleted_jobs["user_id"];
        $temp["technitions_name"] = $get_allcompleted_jobs["firstname"] . " " . $get_allcompleted_jobs["lastname"];
        $temp["total_service_completed"] = $get_allcompleted_jobs["total_service_completed"];
        array_push($response["copletedjobs"], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end

// assign job to technitions update query
$app->post('/assignjobtotechnitions', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $booking_id = $data['booking_id'];
    $technician_id = $data['technician_id'];
    $db = new DbHandler();
    $update_info = $db->assign_job_technitions($booking_id, $technician_id);
    if ($update_info == 1) {
        $response["error"] = false;
        $response["message"] = "Successfully job assign to technitions.";
    } else {
        $response["error"] = true;
        $response["message"] = "Oops,there is some error.";
    }
    echoRespnse(200, $response);
});
// End

// Get historical jobs
$app->get('/gethistoricalJobs', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $historicalJobs_list = $db->get_all_historicaljob();
    $response['historicalJobs'] = array();
    while ($historicalJobs = $historicalJobs_list->fetch_assoc()) {
        $temp = array();
        $temp['startdate'] = date("d-m-Y", strtotime($historicalJobs['startdate']));
        $temp['plateno'] = $historicalJobs['plateno'];
        $temp['name'] = $historicalJobs['firstname'];
        $temp['pdfname'] = $historicalJobs['pdfname'];
        array_push($response['historicalJobs'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});

// End

// Here we fetch completed jobs
$app->get('/getcompletedJobs', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $completedJobs_list = $db->get_all_completedjob();
    $response['getcompletedJobs'] = array();
    while ($completedJobs = $completedJobs_list->fetch_assoc()) {
        $temp = array();
        $temp['booking_id'] = $completedJobs['booking_id'];
        $temp['startdate'] = date("d/m/Y", strtotime($completedJobs['startdate']));
        $temp['plateno'] = $completedJobs['plateno'];
        $temp['name'] = $completedJobs['name'];
        $temp['technicianname'] = $completedJobs['technicianname'];
        array_push($response['getcompletedJobs'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

// $app->get('/getindividualjob/:id', 'authenticate', function($job_id)  {
//     global $user_id;
//     $db = new DbHandler();
//     $individual_job_details = $db->fetchindividualjob($job_id);
//     $response["error"] = false;
//     echoRespnse(201, $individual_job_details);
// });

// here we fetch job assign
$app->get('/getjobnotassign', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $not_assign_job_list = $db->get_all_not_assign_job();
    $response['getnotassignjob'] = array();
    while ($not_assign_jobs = $not_assign_job_list->fetch_assoc()) {
        $temp = array();
        $temp['booking_id'] = $not_assign_jobs['booking_id'];
        $temp['vehicle_id'] = $not_assign_jobs['vehicle_id'];
        $temp['plateno'] = $not_assign_jobs['plateno'];
        $temp['name'] = $not_assign_jobs['name'];
        array_push($response['getnotassignjob'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End

// Get user specific use information  pass userid
$app->post('/getUserinfo', function () use ($app) {
    $json = $app->request->getBody();
    $userid = $json;
    $db = new DbHandler();
    $userinfo_data = $db->get_user_info($userid);
    $response = array();
    while ($user_data = $userinfo_data->fetch_assoc()) {
        $tmp = array();
        $tmp['name'] = $user_data["firstname"] . " " . $user_data["lastname"];
        $tmp['role'] = $user_data["rolename"];
        $tmp['dateofcommence'] = date("Y-m-d");
        $tmp['dob'] = $user_data["dateofborth"];
        if ($user_data["gender"] == 0) {
            $gender = "Male";
        } else if ($user_data["gender"] == 1) {
            $gender = "Female";
        }
        // get user past details info
        $user_past_details = $db->user_past_info($userid);
        $tmp['user_past_info'] = $user_past_details;
        // end
        $tmp['registration_date'] = date("Y-m-d", strtotime($user_data['registration_date']));
        $tmp['gender'] = $gender;
        $tmp['address'] = $user_data["address"];
        $tmp['mobile'] = $user_data["mobilenumber"];
        $tmp['email'] = $user_data["emailaddress"];
        $tmp['registrationend_date'] = $user_data["registrationend_date"];
        $tmp['userid'] = $user_data["user_id"];
        $tmp['profilepic'] = $user_data["profilepic"];
        array_push($response, $tmp);
    }
    $response["error"] = false;
    echoRespnse(200, $response);
});
// End

// get customer information
$app->post('/getCustomerinfo', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $userid1 = str_replace('"', '', $json);
    $db = new DbHandler();
    $userinfo_data = $db->get_customer_info($userid1);
	//print_r( $userinfo_data);
    $response = array();
    while ($user_data = $userinfo_data->fetch_assoc()) {
        $tmp = array();
        $tmp['name'] = $user_data["firstname"] . " " . $user_data["lastname"];
        $tmp['registration_date'] = date("Y-m-d", strtotime($user_data['registration_date']));
        $tmp['address'] = $user_data["address"];
        $tmp['mobile'] = $user_data["mobilenumber"];
        $tmp['email'] = $user_data["emailaddress"];
        $tmp['userid'] = $user_data["user_id"];
        $tmp['profilepic'] = $user_data["profilepic"];
        array_push($response, $tmp);
    }
    $response["error"] = false;
    echoRespnse(200, $response);
}); 

// end 

// Here we create sign up  for Technicians
$app->post('/techniciansRegistrations', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $first_name = $data['first_name'];
    $last_name = $data['last_name'];
    $date_of_birth = $data['date_of_birth'];
    $gender = $data['gender'];
    $mobile_no = $data['mobile_no'];
    $address = $data['address'];
    $email_address = $data['email_address'];
    $driver_licence_no = $data['driver_licence_no'];
    $driver_licence_expiry_date = $data['driver_licence_expiry_date'];
    $driving_licence_proof = $data['driving_licence_proof'];
    $profile_pic_name = $data['profile_pic_name'];
    $bank_account_name = $data['bank_account_name'];
    $bank_account_no = $data['bank_account_no'];
    $bank_name = $data['bank_name'];
    $payment_frequency = "weekly";
    $payment_day = "Wednesday";
    $hourly_rate = $data['hourly_rate'];
    $technicians_signature = $data['technicians_signature'];
    $click_btn = $data['submit_btn'];
    $declarationcontent = $data['declarationcontent'];
    $signature_proof = $data['signature_proof'];
    $technician_id = $data['technician_id'];
    $type = 4;
    if ($click_btn == 'save') {
        $status = "2";
    } else {
        $status = "1";
    }
    $db = new DbHandler();
    // Here we check email address is already exist or not

    if (isset($technician_id) && $technician_id != '') {
        $chk_user = $db->chk_record_exist("tbl_adminuser", "emailaddress", $email_address, $technician_id);
        if ($chk_user == 1) {
            $response['error'] = false;
            $response['message'] = "Email address is already exist.";
        } else {
            $update_return_val = $db->saveTechnician($user_id, $type, $first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $email_address, $driver_licence_no, $driver_licence_expiry_date, $driving_licence_proof, $profile_pic_name, $bank_account_name, $bank_account_no, $bank_name, $payment_frequency, $payment_day, $hourly_rate, $technicians_signature, $status, $declarationcontent, $signature_proof, $technician_id);
            if ($update_return_val == 3) {
                $response['error'] = false;
                $response['technician_id'] = $technician_id;
                $response['message'] = "Technician information successfully updated.";
            } else {
                $response['error'] = true;
                $response['message'] = "There is some error on update.";
            }
        }
    } else {
        $chk_user = $db->chk_record_exist("tbl_adminuser", "emailaddress", $email_address, $technician_id);
        if ($chk_user == 1) {
            $response['error'] = false;
            $response['message'] = "Email address is already exist.";
        } else {
            $return_val = $db->saveTechnician($user_id, $type, $first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $email_address, $driver_licence_no, $driver_licence_expiry_date, $driving_licence_proof, $profile_pic_name, $bank_account_name, $bank_account_no, $bank_name, $payment_frequency, $payment_day, $hourly_rate, $technicians_signature, $status, $declarationcontent, $signature_proof, $technician_id);
            if ($return_val != 'error') {
                $response['error'] = false;
                $response['technician_id'] = $return_val;
                $response['message'] = "Technician information successfully inserted.";
            }
        }
    }

    // Send email to new technitions
    // here we send mail to admin as we Technicians
    if ($gender == 0) {
        $gender_view = "Male";
    } else {
        $gender_view = "Female";
    }
    $html = '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780">
    <tr>
        <td>
            <table cellspacing="0"  cellpadding="0" border="0" width="780">
                    <td style="font-size:14px;padding:10px 10px">
                        <img id="logo" src="http://kwmapp.opaldemo.com/images/logo.png" alt="Logo" class="CToWUd" border="0">
                    </td>

                </table>
        </td>
    </tr>

    <tr>
    <td>
            <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                <tr>
                    <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
        width: 100%">Technicians details</td>
                </tr>
            </table>
                </td>
            </tr>

    <tr>
        <td>
            <table cellspacing="0"  cellpadding="0" border="0" width="780">
                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">First name : </td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $first_name . '</td>
                </tr>
                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Last name :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $last_name . '</td>
                </tr>
                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Date of birth :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $date_of_birth . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Gender :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $gender_view . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Mobile no :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $mobile_no . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Address :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $address . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Email address :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $email_address . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Drivers Licence No :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $driver_licence_no . '</td>
                </tr>

                <tr>
                    <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Drivers Licence Expiry Date :</td>
                    <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $driver_licence_expiry_date . '</td>
                </tr>

            </table>
        </td>
    </tr>

    <tr>
    <td>
            <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                <tr>
                    <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
        width: 100%">Bank Details</td>
                </tr>
            </table>
                </td>
            </tr>


            <tr>
                <td>
                    <table cellspacing="0"  cellpadding="0" border="0" width="780">
                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank Account Name :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $bank_account_name . '</td>
                        </tr>

                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank Account Number :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $bank_account_no . '</td>
                        </tr>

                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Bank :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $bank_name . '</td>
                        </tr>

                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Payment Frequency :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $payment_frequency . '</td>
                        </tr>

                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Payment Day :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $payment_day . '</td>
                        </tr>

                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Hourly Rate :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $hourly_rate . '</td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr>
    <td>
            <table border="0"  cellpadding="0" cellspacing="0" style=" float: left;width: 780px">
                <tr>
                    <td style="background: #bb0303;color: #fff;padding: 10px 0 10px 10px;margin: 20px 0px;font-size: 20px;  float: left;
        width: 100%">Declaration</td>
                </tr>
            </table>
                </td>
            </tr>

            <tr>
                <td>
                    <table cellspacing="0"  cellpadding="0" border="0" width="780">
                        <tr>
                            <td style="font-size:14px;padding:10px 10px;color:rgb(46, 109, 164);border-bottom:1px solid hsl(208, 56%, 41%)">Declaration :</td>
                            <td style="font-size:14px;border-bottom:1px solid hsl(208, 56%, 41%)">' . $declarationcontent . '</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>';
    $subject = "New Technicians Register.";
    $headers = "From: KWM App <info@kwmapp.com>" . "\r\n";
    $headers = $headers . "MIME-Version: 1.0" . "\r\n" .
        "Content-type: text/html; charset=iso-8859-1";
    if ($click_btn != 'save') {
        mail($email_address, $subject, $html, $headers);
    }
    // End

    echoRespnse(200, $response);

});
// end

// Here we update status of booking to confirm and notes
$app->post('/updateNotestatus', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $notes = $data['notes'];
    $booking_id = $data['booking_id'];
    $db = new DbHandler();
    $update_record = $db->updateBookingStatus($notes,$booking_id);
    if ($update_record == 1) {

        // Here we generate job card pdf file
        $get_jobcard_basic_info = $db->get_jobcardinfo($booking_id);
        $jobcard_data = $get_jobcard_basic_info->fetch_assoc();
        
        $technician_id = $jobcard_data['user_id'];
        $getsite_manager_name = $db->get_site_manager_name($technician_id);
        
        
        $address = " Address : 27 West Street,Hamilton 3204";
        $address .= "<br><br>Phone : (07) 847 6245";
        $address .= "<br><br>Email : accounts@kwmotors.co.nz";
        $address .= "<br><br>Website : www.kwmotors.co.nz";
        $address .= "<br><br>GST No. : 105 659 776";

        $content = '<!DOCTYPE html><html><head></head><body>';
        $content .= '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780" style="border-collapse:collapse;">';
        $content .= '<tr>';
        $content .= '<td>';
        $content .= '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780" style="border-collapse:collapse;">';
        $content .= '<tr>';
        $content .= '<td style="width:60%"><img src="http://kwmapp.opaldemo.com/images/logo.png" /></td>';
        $content .= '<td style="width:40%;">' . $address . '</td>';
        $content .= '</tr>';
        $content .= '<tr><td colspan="2">&nbsp;</td></tr>';
        $content .= '<tr style="height: 50px;font-weight: bold;margin:20px;">';
        $content .= '<td colspan="2" style="text-align: center;">JOB CARD</td>';
        $content .= '</tr>';
        $content .= '<tr><td colspan="2">&nbsp;</td></tr>';
        $content .= '</table>';
        $content .= '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780" style="border-collapse:collapse;">';
        $content .= '<tr>';
        $content .= '<td style="width:390px">';
        $content .= '<table border="1" style="border-collapse:collapse;">';
        $content .= '<tr>';
        $content .= '<th colspan="2" style="text-align:center;padding:10px">SERVICE DETAILS</th>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px;height:5px;"><b>Date</b></td>';
        $content .= '<td style="padding:10px;height:5px;">' . date("d-m-Y") . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px;height:5px;"><b>Booking Time</b></td>';
        $content .= '<td style="padding:10px;height:5px;">' . date("d-m-Y H:i:s", strtotime($jobcard_data['bookingdatetime'])) . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px;height:5px;"><b>Completion Time</b></td>';
        $content .= '<td style="padding:10px;height:5px;">' . date("d-m-Y", strtotime($jobcard_data['bookingendtime'])).'</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px;height:5px;"><b>Technician</b></td>';
        $content .= '<td style="padding:10px;height:5px;">' . $jobcard_data['firstname'] . ' ' . $jobcard_data['lastname'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px;height:20px;"><b>Site Manager</b></td>';
        $content .= '<td style="padding:10px;height:20px;">' . $getsite_manager_name . '</td>';
        $content .= '</tr>';

        // $content .= '<tr>';
        // $content .= '<td style="padding:10px" colspan="2"> &nbsp;</td>';
        // $content .= '</tr>';

        
        $content .= '</table>';
        $content .= '</td>';
        $content .= '<td style="width:390px">';
        $content .= '<table border="1" style="border-collapse:collapse;">';
        $content .= '<tr>';
        $content .= '<th colspan="2" style="text-align:center;padding:10px">VEHICLE DETAILS</th>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Registration No</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['vehicle_id'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>VIN No</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['vin'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Make</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['make'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Model</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['model'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Year</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['year'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Color</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['color'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td style="padding:10px"><b>Odometer</b></td>';
        $content .= '<td style="padding:10px">' . $jobcard_data['odometerreading'] . ' km</td>';
        $content .= '</tr>';
        $content .= '</table>';
        $content .= '</td>';
        $content .= '</tr>';
        $content .= '<tr><td>&nbsp;</td></tr>';
        $content .= '</table>';
    
        $content .= $db->displayServiceChecklist($booking_id);
         //$jobcard_data['servicetype_id'], $jobcard_data['jobcard_id']

        $content .= '<table cellspacing="0" cellpadding="0" border="0" width="780">';
        $content .= '<tr><td>&nbsp;</td></tr>';
        $content .= '<tr>';
        $content .= '<th><b>Notes</b></th>';
        $content .= '</tr>';
        $content .= '<tr>';
        $content .= '<td>' . $jobcard_data['notes'] . '</td>';
        $content .= '</tr>';
        $content .= '<tr><td>&nbsp;</td></tr>';
        $content .= '</table>';
        $content .= '<table cellspacing="0" cellpadding="0" border="0" align="center" width="780">';
        $content .= '<tr><td>&nbsp;</td></tr>';
        $content .= '<tr>';
        $content .= '<td>';

        $content .= $db->displayJobcardImages($booking_id);

        $content .= '</td>';
        $content .= '</tr>';
        $content .= '</table>';
        $content .= '</td>';
        $content .= '</tr>';
        $content .= '<tr><td>&nbsp;</td></tr>';
        $content .= '</table>';
        $content .= '</body></html>';

        ob_start();
        $filename = "job_card_pdf_" . $booking_id . ".pdf";
        $path = "../../imgs/jobcard/pdf/" . $filename;
        try {
            $html2pdf = new HTML2PDF('P', 'A4', 'en');
            $html2pdf->pdf->SetDisplayMode('fullpage');
            $html2pdf->WriteHTML($content);
            $html2pdf->Output($path, 'F');
        } catch (HTML2PDF_exception $e) {
            echo $e;
            exit;
        }
        // Here we update pdf file name into job card table
        $update_pdf = $db->updatejobcard_pdf($jobcard_data['jobcard_id'],$filename) ;
        // End 

        // End
        $response['error'] = false;
        $response['msg'] = "Service confirmed successfully.";
    } else {
        $response['error'] = true;
        $response['msg'] = "There is some error in service confirmed.";
    }
    echoRespnse(200, $response);

});
// End

//  get all feedback from customer
$app->get('/getAllFeedback', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();

    $get_feedback = $db->getAllFeedback($user_id);
    $response["feedback"] = array();
    while ($feedback = $get_feedback->fetch_assoc()) {
        $temp_array = array();
        $temp_array['firstname'] = $feedback['firstname'];
        $temp_array['senderid'] = $feedback['user_id'];
        $temp_array['conversation_id'] = $feedback['conversation_id'];
        $temp_array['conversation_date'] = date("d/m/Y", strtotime($feedback['conversation_datetime']));
        $temp_array['conversation_time'] = date("H:i:s", strtotime($feedback['conversation_datetime']));
        array_push($response["feedback"], $temp_array);
    }
    $response["error"] = false;
    echoRespnse(200, $response);
});
// end

// get conversation details
$app->post('/getConversationdetails', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $conversation_id = $data['conversation_id'];
    $db = new DbHandler();
    $get_conversation_details = $db->get_conversation($conversation_id);
    $response['conversation'] = array();
    while ($conversation = $get_conversation_details->fetch_assoc()) {
        $temp_array = array();

        if ($conversation['send_by'] == "0") { // Customer
            $temp_array["position"] = 'right';
            $temp_array["senderName"] = 'Me';

        } else { // Site Manager
            $temp_array["position"] = 'left';
            $temp_array["senderName"] = $conversation['sendername'];
        }

        if ($conversation['profilepic'] == "" || $conversation['profilepic'] == null) {
            $profilepic = 'no-profile.jpg';
        } else {
            $profilepic = $conversation['profilepic'];
        }
        $temp_array["imgs"] = $profilepic;

        $temp_array["message"] = $conversation['message'];
        $temp_array["conversation_datetime"] = $conversation['conversation_datetime'];
        $temp_array["conversion_id"] = $conversation['conversation_id'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['sender_id'] = $conversation['sender_id'];
        array_push($response['conversation'], $temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end

// Here we fetch the enquiry details information
$app->post('/getenquiryConversationdetails', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $inquiryid = $data['inquiryid'];
    $db = new DbHandler();
    $get_conversation_details = $db->get_enquiry_conversation($inquiryid);
    // echo "<pre>";print_r($get_conversation_details);exit;
    $response['conversation'] = array();
    while($conversation = $get_conversation_details->fetch_assoc()){
        $temp_array = array();
        if ($conversation['send_by'] == "0") { // site_manager
            $temp_array["position"] = 'right';
            $temp_array["senderName"] = 'Me';
            $get_profile_pic = $db->get_image_sitemanager($conversation['sender_id'],'0');
            
            if ($get_profile_pic == "" || $get_profile_pic == null) {
                $profilepic = 'http://kwmapp.opaldemo.com/imgs/user/no-profile.jpg';
            } else {
                $profilepic = 'http://kwmapp.opaldemo.com/imgs/user/'.$get_profile_pic;
            }
        }else{
            $temp_array["position"] = 'left';
            $reveiver_name = $db->get_customer_name($conversation['sender_id']);
            $temp_array["senderName"] = $reveiver_name;

            $get_profile_pic = $db->get_image_sitemanager($conversation['sender_id'],'1');
            
            if ($get_profile_pic == "" || $get_profile_pic == null) {
                $profilepic = 'http://kwmapp.opaldemo.com/imgs/user/no-profile.jpg';
            } else {
                $profilepic = 'http://kwmapp.opaldemo.com/imgs/customer/'.$get_profile_pic;
            }
        }
        $temp_array["imgs"] = $profilepic;
        $temp_array["message"] = $conversation['message'];
        $temp_array["conversation_datetime"] = $conversation['inquiry_message_date_time'];
        $temp_array["inquiry_id"] = $conversation['inquiry_id'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['sender_id'] = $conversation['sender_id'];
        array_push($response['conversation'], $temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// End 

// here we send msg to admin in incident chat
$app->post('/sendincidentMessage', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $incidentmsg = $data['incidentmsg'];
    $incidentid = $data['incidentid'];
    $store_data = $db->insert_incident_details($incidentmsg, $incidentid, $user_id);
    if ($store_data == 1) {
        $response['error'] = false;
    } else {
        $response['error'] = true;
    }
    echoRespnse(200, $response);
});
// end


// Send replay to customer
$app->post('/replaytoCustomer', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $mssage = $data['mssage'];
    $senderid = $data['senderid'];
    $inquiryid = $data['inquiryid'];
    $store_data = $db->insert_enquery_details($mssage,$senderid,$user_id,$inquiryid);
    if ($store_data == 1) {
        $response['error'] = false;
    } else {
        $response['error'] = true;
    }
    echoRespnse(200, $response);
});

// end 


// here we store the Improvement information
$app->post('/storeImprovement', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $improvementdate = $data['improvementdate'];
    $shortcomingdetail = $data['shortcomingdetail'];
    $proposedplan = $data['proposedplan'];
    $recorddetail = $data['recorddetail'];
    $store_data = $db->store_improvement($user_id,$improvementdate, $shortcomingdetail, $proposedplan, $recorddetail);
    if ($store_data == 1) {
        $response['error'] = false;
        $response['msg'] = "Report successfully sent to the administrator.";
    } else {
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error to sent report to administrator.";
    }
    echoRespnse(200, $response);
});
// end

$app->get('/getAllImprovementReports', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $get_all_pending_improvements = $db->get_pending_improvements($user_id);
    $response = array();
    $response['improvementslist'] = array();
    while($record = $get_all_pending_improvements->fetch_assoc()){
        $temp = array();
        $temp['recordimprovement_id'] = $record['recordimprovement_id'];
        $temp['proposedplan']  = $record['proposedplan'];
        $temp['recorddetail']  = $record['recorddetail'];
        $temp['createddate'] = date("d-m-Y",strtotime($record['recorddate']));  
        array_push($response['improvementslist'],$temp);
    }
    $response['error'] = false;
    echoRespnse(200,$response);
});



// Here we store request purchase information into table
$app->post('/storerequestpurchase', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $improvementdate = $data['improvementdate'];
    $proposedpurchase = $data['proposedpurchase'];
    $proposedpurchasereason = $data['proposedpurchasereason'];
    $requestpurdetail = $data['requestpurdetail'];
    $store_data = $db->store_request_purchase($user_id, $improvementdate, $proposedpurchase, $proposedpurchasereason, $requestpurdetail);
    if ($store_data == 1) {
        $response['error'] = false;
        $response['msg'] = "Report successfully sent to the administrator.";
    } else {
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error to sent report to administrator.";
    }
    echoRespnse(200, $response);
});
// End

// Store notes information
$app->post('/adddefaultNotes', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $notes = $data['notes'];
    $paymentid = $data['paymentid'];
    $store_info = $db->store_notes_default($user_id, $notes, $paymentid);
    if ($store_info == 1) {
        $response['error'] = false;
        $response['msg'] = "Notes successfully added.";
    } else {
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error in add notes..!";
    }
    echoRespnse(200, $response);
});

// End


// Here we genrate excel file of service report
$app->post('/generateExcel',function () use ($app) {

    
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    // echo "<pre>";print_r($data);exit;

    $useremailid = $data['useremailid'];
    $reportname  = $data['reportname'];

    if($reportname == 'Daily'){
        $first_col_name = "Date";
    }else if($reportname == 'Hourly'){
        $first_col_name = "Hours";
    }else if($reportname == 'Weekly'){
        $first_col_name = "Week";
    }

    $filename = 'service_report_'.time().'.csv'; 
    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");

    $file = fopen('../../imgs/reports/'.$filename, 'w');
    $todays_date = date("d-m-Y");
    $todaysdate = array($todays_date);
    fputcsv($file,$todaysdate);

    $length_data = count($data['actual_date']) - 1;
    $start_date = $data['actual_date'][0];
    $end_date  = $data['actual_date'][$length_data];

    $date_from_to = array($first_col_name,$start_date,$end_date);
    fputcsv($file,$date_from_to);
    $site_name = array("Site Name","27 West St,Hamilton");
    fputcsv($file,$site_name);

    $site_name_bold = array("","","Service Report","","");
    fputcsv($file,$site_name_bold);
    $header = array($first_col_name,"Minimus","Medius","Maximus","Total"); 
    fputcsv($file, $header);

    $final_array = array();
    
    $k=0;
    foreach($data['actual_date'] as $current_date){
        $total = 0;
        $temp_array = array();
        $temp_array[] = $current_date;
        $temp_array[] = $data['service_completed'][0]['data'][$k]; // Minimus
        $temp_array[] = $data['service_completed'][1]['data'][$k]; // Medius
        $temp_array[] = $data['service_completed'][2]['data'][$k]; // Maximus
        $total =  $data['service_completed'][0]['data'][$k] + $data['service_completed'][2]['data'][$k] + $data['service_completed'][3]['data'][$k];
        $temp_array[]  = $total;
        array_push($final_array,$temp_array);
    $k++;}

    if(!empty($final_array)){
        foreach($final_array as $service_data){
            fputcsv($file,$service_data); 
        }
    }

    fclose($file); 


    // Here we send the attachment mail to login user
    $to = $useremailid;
    $from = 'info@kwmapp.com';
    $fromName = 'KWM App';
    $subject = $reportname.' Service Report'; 
    $file = '../../imgs/reports/'.$filename;
    $htmlContent = '<h3>'.$reportname.' Service Report.</h3>';
    $headers = "From: $fromName"." <".$from.">";
    $semi_rand = md5(time()); 
    $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x"; 
    $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\""; 
    $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
    "Content-Transfer-Encoding: 7bit\n\n" . $htmlContent . "\n\n"; 

    //preparing attachment
    if(!empty($file) > 0){
        if(is_file($file)){
            $message .= "--{$mime_boundary}\n";
            $fp =    @fopen($file,"rb");
            $data =  @fread($fp,filesize($file));
            @fclose($fp);
            $data = chunk_split(base64_encode($data));
            $message .= "Content-Type: application/octet-stream; name=\"".basename($file)."\"\n" . 
            "Content-Description: ".basename($file)."\n" .
            "Content-Disposition: attachment;\n" . " filename=\"".basename($file)."\"; size=".filesize($file).";\n" . 
            "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
        }
    }
    $message .= "--{$mime_boundary}--";
    $returnpath = "-f" . $from;

    //send email
    if(@mail($to, $subject, $message, $headers, $returnpath)){
        $response['msg'] = $reportname." service report successfully send to your email address.";
        echoRespnse(200,$response);
    }else{
        $response['msg'] = "Oops,there is some error in sending an email please try again.";
        echoRespnse(200,$response);
    } 
    // End 
});
// End 

// Here we create parts reports csv file
$app->post('/partsReportgenerateExcel',function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $useremailid = $data['useremailid'];
    $reportname  = $data['reportname'];
    $db = new DbHandler();
    if($reportname == 'Daily'){
        $first_col_name = "Date";
    }else if($reportname == 'Hourly'){
        $first_col_name = "Hours";
    }else if($reportname == 'Weekly'){
        $first_col_name = "Week";
    }

    $filename = 'parts_report_'.time().'.csv';

    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");

    $file = fopen('../../imgs/reports/partsreports/'.$filename, 'w');
    $todays_date = date("d-m-Y");
    $todaysdate = array($todays_date);
    fputcsv($file,$todaysdate);

    $length_data = count($data['actual_date']) - 1;
    $start_date = $data['actual_date'][0];
    $end_date  = $data['actual_date'][$length_data];

    $date_from_to = array($first_col_name,$start_date,$end_date);
    fputcsv($file,$date_from_to);
    $site_name = array("Site Name","27 West St,Hamilton");
    fputcsv($file,$site_name);

    $site_name_bold = array("","","Parts Report","","");
    fputcsv($file,$site_name_bold);
    $header = array($first_col_name,"Engine Oil","Brake Fluid","Trans Fluid","Coolant","Oli Filters","Air Filters"); 
    fputcsv($file, $header);
    
    $final_array = array();
    
    $k=0;
    foreach($data['actual_date'] as $current_date){
        $total = 0;
        $temp_array = array();
        $temp_array[] = $current_date;
        $temp_array[] = $data['service_completed'][0]['data'][$k]; // Engine Oil
        $temp_array[] = $data['service_completed'][1]['data'][$k]; // Brake Fluid
        $temp_array[] = $data['service_completed'][2]['data'][$k]; // Trans Fluid
        $temp_array[] = $data['service_completed'][3]['data'][$k]; // Coolant
        $temp_array[] = $data['service_completed'][4]['data'][$k]; // Oil Filters
        $temp_array[] = $data['service_completed'][5]['data'][$k]; // Air Filters
        array_push($final_array,$temp_array);
    $k++;}

    if(!empty($final_array)){
        foreach($final_array as $service_data){
            fputcsv($file,$service_data); 
        }
    }
    fclose($file); 
    // here we send mail to login user id
    $content = '<h3>'.$reportname.' Parts Service Report.</h3>';
    $foldername = "partsreports";
    $sub = $reportname.' Parts Service Report'; 
    $sendmail = $db->sendAttachmentmail($useremailid,$reportname,$filename,$sub,$content,$foldername);
    if($sendmail == 1){
        $response['msg'] = $reportname." Parts service report successfully send to your email address.";
        echoRespnse(200,$response);
    }else{
        $response['msg'] = "Oops,there is some error in sending an email please try again.";
        echoRespnse(200,$response);
    }
    // end 
});
// End 

// Here we generate csv file for perticular Technician 
$app->post('/TechniciangenerateExcel',function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $useremailid = $data['useremailid'];
    $reportname  = $data['reportname'];
    $technician_name = $data['technician_name'];
    $db = new DbHandler();
    if($reportname == 'Daily'){
        $first_col_name = "Date";
    }else if($reportname == 'Hourly'){
        $first_col_name = "Hours";
    }else if($reportname == 'Weekly'){
        $first_col_name = "Week";
    }
    $filename = 'Technician_report_'.time().'.csv';

    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");

    $file = fopen('../../imgs/reports/technician/'.$filename, 'w');
    $todays_date = date("d-m-Y");
    $todaysdate = array($todays_date);
    fputcsv($file,$todaysdate);

    $length_data = count($data['actual_date']) - 1;
    $start_date = $data['actual_date'][0];
    $end_date  = $data['actual_date'][$length_data];

    $date_from_to = array($first_col_name,$start_date,$end_date);
    fputcsv($file,$date_from_to);
    $site_name = array("Site Name","27 West St,Hamilton");
    fputcsv($file,$site_name);

    $site_name = array("Technician Report",$technician_name);
    fputcsv($file,$site_name);


    $site_name_bold = array("","","Technician Report","","");
    fputcsv($file,$site_name_bold);
    $header = array($first_col_name,"Minimus","Medius","Maximus","Total"); 
    fputcsv($file, $header);
    $final_array = array();
    
    $k=0;
    foreach($data['actual_date'] as $current_date){
        $total = 0;
        $temp_array = array();
        $temp_array[] = $current_date;
        $temp_array[] = $data['service_completed'][0]['data'][$k]; // Minimus
        $temp_array[] = $data['service_completed'][1]['data'][$k]; // Medius
        $temp_array[] = $data['service_completed'][2]['data'][$k]; // Maximus
        $total =  $data['service_completed'][0]['data'][$k] + $data['service_completed'][2]['data'][$k] + $data['service_completed'][3]['data'][$k];
        $temp_array[]  = $total;
        array_push($final_array,$temp_array);
    $k++;}

    if(!empty($final_array)){
        foreach($final_array as $service_data){
            fputcsv($file,$service_data); 
        }
    }
    fclose($file); 
    // here we send mail to login user id
    $content = '<h3>'.$reportname.' Technician Report.</h3>';
    $foldername = "technician";
    $sub = $reportname.' Technician Report'; 
    $sendmail = $db->sendAttachmentmail($useremailid,$reportname,$filename,$sub,$content,$foldername);
    if($sendmail == 1){
        $response['msg'] = $reportname." Technician report successfully send to your email address.";
        echoRespnse(200,$response);
    }else{
        $response['msg'] = "Oops,there is some error in sending an email please try again.";
        echoRespnse(200,$response);
    }
    // end
    

});

// End 

// Here we generate site productivity csv
$app->post('/siteproductivitycsv','authenticate',function () use ($app) {
    global $user_id;
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $useremailid = $data['useremailid'];
    $reportname  = $data['reportname'];
    $db = new DbHandler();

    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];

    $all_technitions = $db->get_all_technitions($user_id);
    $mytechnitions_id = array();
    while ($technitions = $all_technitions->fetch_assoc()) {
        $mytechnitions_id[] = $technitions['user_id'];
    }
    $technitions_comma_seprated = implode(",",$mytechnitions_id);
    $site_productivity_data = array();
    
    if($reportname == 'Daily'){
        $first_col_name = "Date";
        if (isset($pass_start_date) && isset($pass_end_date)) {
            $date = date("Y-m-d", strtotime($pass_end_date));
            $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
        } else {
            $date = date("Y-m-d");
            $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
        }
        $startTime = strtotime($seven_days_before_date);
        $endTime = strtotime($date);

        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            $get_data = $db->get_daily_site_productivity($my_date,$technitions_comma_seprated);
            while($data = $get_data->fetch_assoc()){
                $temp_data = array();
                $temp_data[] = $my_date;
                $temp_data[] = $data['servicename'];
                $temp_data[] = $data['firstname']." ".$data['lastname'];
                $temp_data[] = $data['starttime'];
                $temp_data[] = $data['finishtime'];
                $temp_data[] = $data['timetaken'];
                array_push($site_productivity_data,$temp_data);
            }
        }


    }else if($reportname == 'Hourly'){
        $first_col_name = "Hours";
        if($pass_start_date != '' && $pass_end_date != ''){
            $seven_days_before_date = $pass_start_date;
            $date = $pass_end_date;
        }else{
            $seven_days_before_date = $pass_start_date;
            $date = "";
        }
        
        
        for ($i = 8; $i <= 17; $i++) {
            $start_time = $i . ":00:00";
            $end_time = ($i + 1) . ":00:00";
            $each_data = $db->get_hourly_site_productivity($start_time, $end_time,$pass_start_date, $pass_end_date,$technitions_comma_seprated);
            while($data = $each_data->fetch_assoc()){
                $temp_data = array();
                $temp_data[] = $i.":00";
                $temp_data[] = $data['servicename'];
                $temp_data[] = $data['firstname']." ".$data['lastname'];
                $temp_data[] = $data['starttime'];
                $temp_data[] = $data['finishtime'];
                $temp_data[] = $data['timetaken'];
                array_push($site_productivity_data,$temp_data);
            }
            
        }

    }else if($reportname == 'Weekly'){
        $first_col_name = "Week";

        
        
        $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
        if (isset($pass_start_date) && isset($pass_end_date)) {
            $startTime = strtotime($pass_start_date);
            $endTime = strtotime($pass_end_date);
            
            $seven_days_before_date = $pass_start_date;
            $date = $pass_end_date;

        } else {
            $date = date("Y-m-d");
            $startTime = strtotime($three_month_before_date);
            $endTime = strtotime($date);
            $seven_days_before_date = $three_month_before_date;
            $date = $date;
        }
        

        $k = 1;
        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);

            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                $each_count = $db->get_weekly_site_productivity($start_date, $end_date,$technitions_comma_seprated);
                while($data = $each_count->fetch_assoc()){
                    $temp_data = array();
                    $temp_data[] = $k;
                    $temp_data[] = $data['servicename'];
                    $temp_data[] = $data['firstname']." ".$data['lastname'];
                    $temp_data[] = $data['starttime'];
                    $temp_data[] = $data['finishtime'];
                    $temp_data[] = $data['timetaken'];
                    array_push($site_productivity_data,$temp_data);
                }
                $k++;
                
            }
        }
        

    }

    // Here we generate site productivity csv file
    
    // echo "<pre>";print_r($site_productivity_data);exit;
    $filename = 'site_productivity_report_'.time().'.csv';
    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");

    $file = fopen('../../imgs/reports/siteproductivity/'.$filename, 'w');
    $todays_date = date("d-m-Y");
    $todaysdate = array($todays_date);
    fputcsv($file,$todaysdate);

    $length_data = count($data['actual_date']) - 1;
    $start_date = $data['actual_date'][0];
    $end_date  = $data['actual_date'][$length_data];

    $date_from_to = array("Date",$seven_days_before_date,$date);
    fputcsv($file,$date_from_to);
    $site_name = array("Site Name","27 West St,Hamilton");
    fputcsv($file,$site_name);

    
    $site_name_bold = array("","","Site Productivity Report","","");
    fputcsv($file,$site_name_bold);
    $header = array($first_col_name,"type of service","Technician","Start time","Finish time","Time Taken"); 
    fputcsv($file, $header);
    if(!empty($site_productivity_data)){
        foreach($site_productivity_data as $site){
            fputcsv($file, $site);
        }
    }
    
    fclose($file); 
    // here we send mail to login user id
    $content = '<h3>Site Productivity Report.</h3>';
    $foldername = "siteproductivity";
    $sub = 'Site Productivity Report'; 
    $reportname = "Site productivity";
    $sendmail = $db->sendAttachmentmail($useremailid,$reportname,$filename,$sub,$content,$foldername);
    if($sendmail == 1){
        $response['msg'] = "Site productivity successfully send to your email address.";
        echoRespnse(200,$response);
    }else{
        $response['msg'] = "Oops,there is some error in sending an email please try again.";
        echoRespnse(200,$response);
    }
    // end


    

});

// End 

// Here we generate technicianperfomance
$app->post('/technicianperfomancecsv','authenticate',function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $useremailid = $data['useremailid'];
    $reportname  = $data['reportname'];
    $db = new DbHandler();

    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $technician_id = $data['technician_id'];
    $technician_name = $data['technician_name'];
    $technician_productivity_data = array();
    if($reportname == "Daily"){
        $first_col_name = "Date";
        if (isset($pass_start_date) && isset($pass_end_date)) {
            $date = date("Y-m-d", strtotime($pass_end_date));
            $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
            $start_from_date = $pass_start_date;
            $start_to_date   = $pass_end_date;
        } else {
            $date = date("Y-m-d");
            $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));

            $start_from_date = $seven_days_before_date;
            $start_to_date   = $date;

        }
        $startTime = strtotime($seven_days_before_date);
        $endTime = strtotime($date);
        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            $get_data = $db->get_daily_technician_productivity($my_date,$technician_id);
            while($data = $get_data->fetch_assoc()){
                $temp_data = array();
                $temp_data[] = $my_date;
                $temp_data[] = $data['servicename'];
                $temp_data[] = $data['firstname']." ".$data['lastname'];
                $temp_data[] = $data['starttime'];
                $temp_data[] = $data['finishtime'];
                $temp_data[] = $data['timetaken'];
                array_push($technician_productivity_data,$temp_data);
            }

        }
    }else if($reportname == "Weekly"){
        $first_col_name = "Week";
        $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
        if (isset($pass_start_date) && isset($pass_end_date)) {
            $startTime = strtotime($pass_start_date);
            $endTime = strtotime($pass_end_date);
            
            $start_from_date = $pass_start_date;
            $start_to_date = $pass_end_date;

        } else {
            $date = date("Y-m-d");
            $startTime = strtotime($three_month_before_date);
            $endTime = strtotime($date);
            $start_from_date = $three_month_before_date;
            $start_to_date = $date;
        }
        
        $k = 1;
        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);
            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                $each_count = $db->get_weekly_technician_productivity($start_date, $end_date,$technician_id);
                while($data = $each_count->fetch_assoc()){
                    $temp_data = array();
                    $temp_data[] = $k;
                    $temp_data[] = $data['servicename'];
                    $temp_data[] = $data['firstname']." ".$data['lastname'];
                    $temp_data[] = $data['starttime'];
                    $temp_data[] = $data['finishtime'];
                    $temp_data[] = $data['timetaken'];
                    array_push($technician_productivity_data,$temp_data);
                }
                $k++;

            }

        }

    }
    // Here we genrate csv file
    $filename = 'technician_productivity_'.time().'.csv';
    header("Content-Description: File Transfer"); 
    header("Content-Disposition: attachment; filename=$filename"); 
    header("Content-Type: application/csv; ");

    $file = fopen('../../imgs/reports/technician_productivity/'.$filename, 'w');
    $todays_date = date("d-m-Y");
    $todaysdate = array($todays_date);
    fputcsv($file,$todaysdate);

    

    $date_from_to = array("Date",$start_from_date,$start_to_date);
    fputcsv($file,$date_from_to);
    $site_name = array("Site Name","27 West St,Hamilton");
    fputcsv($file,$site_name);

    $technician_name_data = array("Technician Name",$technician_name);
    fputcsv($file,$technician_name_data);

    
    $site_name_bold = array("","","Technician Productivity Report","","");
    fputcsv($file,$site_name_bold);
    $header = array($first_col_name,"type of service","Technician","Start time","Finish time","Time Taken"); 
    fputcsv($file, $header);
    if(!empty($technician_productivity_data)){
        foreach($technician_productivity_data as $site){
            fputcsv($file, $site);
        }
    }
    
    fclose($file); 
    // here we send mail to login user id
    $content = '<h3>Technician productivity report.</h3>';
    $foldername = "technician_productivity";
    $sub = 'Technician productivity report'; 
    $reportname = "Technician productivity";
    $sendmail = $db->sendAttachmentmail($useremailid,$reportname,$filename,$sub,$content,$foldername);
    if($sendmail == 1){
        $response['msg'] = "Technician productivity successfully send to your email address.";
        echoRespnse(200,$response);
    }else{
        $response['msg'] = "Oops,there is some error in sending an email please try again.";
        echoRespnse(200,$response);
    }
    // end

    // End 

});

// End 

$app->post('/TechnicianSignup', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;
    $db = new DbHandler();

    $json = $app->request->getBody();
    $request_params = json_decode($json, true); 

    $user_id_insert = $request_params['user_id'];
    $first_name = $request_params['first_name'];
    $last_name = $request_params['last_name'];
    $date_of_birth = $request_params['date_of_birth'];
    $gender = $request_params['gender'];
    $mobile_no = $request_params['mobile_no'];
    $address = $request_params['address'];
    $address2 = $request_params['address2'];
    $email_address = $request_params['email_address'];
    $driver_licence_no = $request_params['driver_licence_no'];
    $driver_licence_expiry_date = $request_params['driver_licence_expiry_date'];
    $bank_account_name = $request_params['bank_account_name'];
    $bank_name = $request_params['bank_name'];
    $bank_account_no1 = $request_params['bank_account_no1'];
    $bank_account_no2 = $request_params['bank_account_no2'];
    $bank_account_no3 = $request_params['bank_account_no3'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $payment_frequency = $request_params['payment_frequency'];
    $payment_day = $request_params['payment_day'];
    $contract = $request_params['contract'];
    $bank_account_no = $bank_account_no1."-".$bank_account_no2."-".$bank_account_no3."-".$bank_account_no4;
    $nzlProof1 = $request_params['nzlProof1'];
    $nzlProof2 = $request_params['nzlProof2'];
    $profilepic = $request_params['profilepic'];
    $datetime = $request_params['datetime'];
    $hourly_rate = $request_params['hourly_rate'];
    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                        $nzlProof1 = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                        $nzlProof2 = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                        $profilepic = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
            }
        }
    }

    if($user_id_insert == ""){
        //Insert user
        $user_id_insert  = $db->insertTechnician($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic,$hourly_rate);
    }else{
        //Update Signup
        $user_id_insert  = $db->updateTechnician($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic, $user_id_insert,$hourly_rate);
    }


    if ($user_id_insert<=0) {
        $response["error"] = true;
        $response["message"] = "Oops! An error occurred while registereing";
    } else {
        $response["error"] = false;
        $response["user_id_insert"] = $user_id_insert;
        $response["contract"] = $contract;
        $response["nzlProof2"] = $nzlProof2;
        $response["nzlProof1"] = $nzlProof1;
        $response["profilepic"] = $profilepic;
    }/**/
    // echo json response
    echoRespnse(201, $response);


});

$app->post('/completeSalesmanRegistraton/:id', 'authenticate', function($customer_id)  use ($app) {
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $json = $app->request->getBody();
    $request_params = json_decode($json, true); 
    $user_id_insert = $request_params['user_id'];
    $first_name = $request_params['first_name'];
    $last_name = $request_params['last_name'];
    $date_of_birth = $request_params['date_of_birth'];
    $gender = $request_params['gender'];
    $mobile_no = $request_params['mobile_no'];
    $address = $request_params['address'];
    $address2 = $request_params['address2'];
    $email_address = $request_params['email_address'];
    $driver_licence_no = $request_params['driver_licence_no'];
    $driver_licence_expiry_date = $request_params['driver_licence_expiry_date'];
    $bank_account_name = $request_params['bank_account_name'];
    $bank_name = $request_params['bank_name'];
    $bank_account_no1 = $request_params['bank_account_no1'];
    $bank_account_no2 = $request_params['bank_account_no2'];
    $bank_account_no3 = $request_params['bank_account_no3'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $payment_frequency = $request_params['payment_frequency'];
    $payment_day = $request_params['payment_day'];
    $contract = $request_params['contract'];
    $bank_account_no = $bank_account_no1."-".$bank_account_no2."-".$bank_account_no3."-".$bank_account_no4;
    $nzlProof1 = $request_params['nzlProof1'];
    $nzlProof2 = $request_params['nzlProof2'];
    $profilepic = $request_params['profilepic'];
    $datetime = $request_params['datetime'];
    $hourly_rate = $request_params['hourly_rate'];

    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                        $nzlProof1 = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                        $nzlProof2 = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                        $profilepic = $file;
                        rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
            }
        }
    }

    if($user_id_insert == ""){
        //Insert user
        $user_id_insert  = $db->insertTechnician($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic,$hourly_rate);
    }else{
        //Update Signup
        $user_id_insert  = $db->updateTechnician($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $address, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic, $user_id_insert,$hourly_rate);
    }
    if($request_params['signature'] != ""){
        list($type, $imageData) = explode(';', $request_params['signature']);
        list($x,$extension) = explode('/',$type);
        list($y,$imageData)      = explode(',', $imageData);
        $fileName = $user_id_insert.'.'.$extension;
        $imageData = base64_decode($imageData);

        file_put_contents("../../imgs/user/sign/".$fileName, $imageData);
    }

    // $result = $db->addSalesmanCommission($user_id_insert);
    $result = $db->updateStaffStatusSign($fileName, $user_id_insert);
    if($result){
        $response["error"] = false;
        $response["message"] = "Salesman succesfully registered";
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Error!! Please try again";
        echoRespnse(200, $response);
    }

    
});


// here we update customer status
$app->post('/updateCustomerstatus', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $userid = $data['userid'];
    $update_status = $db->update_user_status($userid);
    if ($update_status == 1) {
        $response['error'] = false;
        $response['msg'] = "Notes successfully added.";
    } else {
        $response['error'] = true;
        $response['msg'] = "some error in lock account.";
    }
    echoRespnse(200, $response);

});
// end

// Here we store the opening hours information
$app->post('/storeOpeningHoursinfo', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $response = array();
    $mon_to_fri_time = $data['basicinfo']['montime'].":::".$data['basicinfo']['fritime'];
    $saturday_time  = $data['basicinfo']['satfrom'].":::".$data['basicinfo']['satto'];
    $opening_hours = $db->update_opening_hours($user_id,$mon_to_fri_time,$saturday_time,$data['totalHolidays']);
    if($opening_hours == 1){
        $response['error'] = false;
        $response['msg'] = "Opening hours information successfully updated.";
    }else{
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error.";
    }
    echoRespnse(200,$response);
});
// End 

// here we fetch opening hours information 
$app->get('/storeOpeningHoursinfo', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $response = array();
    $response['basicinfo'] = array();
    $response['holidays_info'] = array();
    $fetch_basic_info = $db->get_opening_hours_info($user_id);
    $info = $fetch_basic_info->fetch_assoc();
    $mon_fir_time = explode(":::",$info['mon_to_fri_time']);
    $sat_from_to_time = explode(":::",$info['saturday_time']);

    $response['basicinfo']['mon_from_time'] = $mon_fir_time[0];
    $response['basicinfo']['mon_to_time'] = $mon_fir_time[1];
    $response['basicinfo']['sat_from_time'] = $sat_from_to_time[0];
    $response['basicinfo']['sat_to_time'] = $sat_from_to_time[1];

    // fetch all holidays info
    $fetch_holidays_info = $db->get_opening_hours_holidays_info($user_id);
    while($data = $fetch_holidays_info->fetch_assoc()){
        $date = explode(":::",$data['publicholidays_fromdate_todate']);
        $temp_data = array();
        $temp_data['id'] = $data['id'];
        $temp_data['holidays_name'] = $data['publicholidays_name'];
        $temp_data['from_date'] = $date[0];
        $temp_data['to_date'] = $date[1];
        array_push($response['holidays_info'],$temp_data);
    }
    // End 
    $response['error'] = false;
    echoRespnse(200,$response);
});
// end 

// Add message form admin conversation table
$app->post('/storeContactadminmessage', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $sendermessage = $data['sendermessage'];
    $addmessage = $db->store_contract_administrator($user_id, $sendermessage);
    if ($addmessage == 1) {
        $response['error'] = false;
    } else {
        $response['error'] = true;

    }
    echoRespnse(200, $response);

});
// End

// get all pending purchase information
$app->get('/getAllpurchaseinformation', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $all_purchase_information = $db->get_purchase_information($user_id);
    $response["purchases"] = array();
    while ($my_purchase_information = $all_purchase_information->fetch_assoc()) {
        $temp = array();
        $temp['date'] = date("d/m/Y", strtotime($my_purchase_information['recorddate']));
        $temp['requestpurchase_id'] = $my_purchase_information['requestpurchase_id'];
        $temp['proposedpurchase'] = $my_purchase_information['proposedpurchase'];
        $temp['status'] = $my_purchase_information['mystatus'];
        array_push($response["purchases"], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end

// get All the default payments
$app->get('/getallDefaultPayments', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $get_all_default_payment = $db->default_payment();
    $response['defaultpayment'] = array();
    while ($all_default_payment = $get_all_default_payment->fetch_assoc()) {
        $tmp = array();
        $tmp['bank_payment_id'] = $all_default_payment['bank_payment_id'];
        $tmp['name'] = $all_default_payment['accountname'];
        $tmp['plate'] = $all_default_payment['plateno'];
        $tmp['date'] = $all_default_payment['ddstartdate'];
        $tmp['amount'] = $all_default_payment['ddamount'];
        $tmp['user_id'] = $all_default_payment['user_id'];
        array_push($response['defaultpayment'], $tmp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});
// End

// here we fetch all notes for default reports
$app->post('/getAllnotesdefaultreport', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $db = new DbHandler();
    $bank_payment_id = $data['bank_payment_id'];
    $get_all_notes = $db->get_all_notes($bank_payment_id);
    $response['allnotes'] = array();
    while ($all_notes = $get_all_notes->fetch_assoc()) {
        $temp = array();
        $temp['notes'] = $all_notes['notes'];
        $temp['date'] = $all_notes['notes_added_datetime'];
        $temp['username'] = $all_notes['firstname'] . " " . $all_notes['lastname'];
        array_push($response['allnotes'], $temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});
// end

// Here we call the incident conversation details
$app->post('/getincidentConversation', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $incidentid = $data['incidentid'];
    $db = new DbHandler();
    $get_conversation_details = $db->incident_detail_data($incidentid);
    $response['incidentdata'] = array();
    while ($conversation = $get_conversation_details->fetch_assoc()) {
        $temp_array = array();
        if ($conversation['sendername'] == 'admin') {
            $temp_array["position"] = 'left';
            $temp_array["senderName"] = 'admin';
        } else {
            $temp_array["position"] = 'right';
            $temp_array["senderName"] = "Me";
        }
        if ($conversation['profilepic'] == "" || $conversation['profilepic'] == null) {
            $profilepic = 'no-profile.jpg';
        } else {
            $profilepic = $conversation['profilepic'];
        }
        $temp_array["imgs"] = $profilepic;
        $temp_array["message"] = $conversation['incident_detail'];
        $temp_array["conversation_datetime"] = $conversation['incidentreport_datetime'];
        $temp_array["conversion_id"] = $conversation['incidentreport_id'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['sender_id'] = $conversation['sender_id'];
        array_push($response['incidentdata'], $temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});
// End

// Get contact adiministrator data
$app->get('/GetcontactAdministrator', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $get_conversation_details = $db->contact_administrator($user_id);
    $response['contactadministrator'] = array();
    while ($conversation = $get_conversation_details->fetch_assoc()) {
        $temp_array = array();
        if ($conversation['sendername'] == 'admin') {
            $temp_array["position"] = 'left';
            $temp_array["senderName"] = 'admin';
        } else {
            $temp_array["position"] = 'right';
            $temp_array["senderName"] = "Me";
        }
        if ($conversation['profilepic'] == "" || $conversation['profilepic'] == null) {
            $profilepic = 'no-profile.jpg';
        } else {
            $profilepic = $conversation['profilepic'];
        }
        $temp_array["imgs"] = $profilepic;
        $temp_array["message"] = $conversation['message'];
        $temp_array["conversation_datetime"] = $conversation['conversation_datetime'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['sender_id'] = $conversation['sender_id'];
        array_push($response['contactadministrator'], $temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});

// end

// Here we fetch the requestpurchase conversations
$app->post('/getrequestpurchaseConversations', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $requestpurchase_id = $data['requestpurchase_id'];
    $db = new DbHandler();
    $get_conversations = $db->get_requestpurchase_conversations($requestpurchase_id);
    $response['requestpurchase'] = array();
    while ($conversations = $get_conversations->fetch_assoc()) {
        $temp = array();
        if ($conversations['sendby'] == 0) {
            $temp["position"] = 'right';
            $temp["senderName"] = "Me";
        } else {
            $temp["position"] = 'left';
            $temp["senderName"] = 'admin';
        }

        if ($conversations['profilepic'] == "" || $conversations['profilepic'] == null) {
            $profilepic = 'no-profile.jpg';
        } else {
            $profilepic = $conversations['profilepic'];
        }
        $temp["imgs"] = $profilepic;
        $temp["message"] = $conversations['message'];
        $temp["conversation_datetime"] = $conversations['msg_sent_datetime'];
        $temp["requestpurchase_id"] = $conversations['requestpurchase_id'];
        $temp['receiver_id'] = $conversations['receiver_id'];
        $temp['sender_id'] = $conversations['sender_id'];
        array_push($response['requestpurchase'], $temp);
    }
    $response['error'] = true;
    echoRespnse(200, $response);
});
// End

// insert requestpurchase conversations from site manger side
$app->post('/Sitemangerreplaycomment', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $message = $data['message'];
    $requestpurchase_id = $data['requestpurchase_id'];
    global $user_id;
    $db = new DbHandler();
    $store_msg = $db->store_proposed_purchase_msg($user_id, $message, $requestpurchase_id);
    if ($store_msg == 1) {
        $response['error'] = false;
    } else {
        $response['error'] = true;
    }
    echoRespnse(200, $response);
});
// end

$app->post("/generatepdf", function () use ($app) { //
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $conversation_id = $data['conversation_id'];
    $db = new DbHandler();
    $get_conversation_details = $db->get_conversation($conversation_id);
    $response['conversation'] = array();
    // Test code for generate pdf

    $content = '<table cellspacing="0" cellpadding="0" border="0" width="100%">
    <tr>
      <td>
          <table cellspacing="0"  cellpadding="0" border="0">
              <tr>
                  <td style="font-size:14px;padding:10px 10px"><img src="http://kwmapp.opaldemo.com/images/logo.png"/> </td>
              </tr>
           </table>
      </td>
    </tr>
    </table>

    <table cellspacing="0"  cellpadding="0" border="0" width="100%">';
    while ($conversation = $get_conversation_details->fetch_assoc()) {
        $content .= '<tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr>';
        if ($conversation['send_by'] == "0") {
            $content .= '<tr><td style="width:50%;">&nbsp;</td><td style="width:50%;border-radius:10px;padding:10px 30px;background-color: rgb(152,251,152);"><b>Me,</b><br>' . $conversation['message'] . '<br><br>Date Time: ' . $conversation['conversation_datetime'] . '</td></tr>';
        } else {
            $content .= '<tr><td style="width:50%;background-color: rgb(211,211,211);border-radius: 10px;padding:10px 30px;"><b>Admin,</b><br>' . $conversation['message'] . ' <br><br>Date Time : ' . $conversation['conversation_datetime'] . '</td><td style="width:50%;">&nbsp;</td></tr>';
        }

    }
    $content .= '</table>';
    ob_start();
    $filename = "conversation_" . $conversation_id . ".pdf";
    $path = "../../imgs/pdf/" . $filename;

    try {
        $html2pdf = new HTML2PDF('P', 'A4', 'en');
        $html2pdf->pdf->SetDisplayMode('fullpage');
        $html2pdf->WriteHTML($content);
        $html2pdf->Output($path, 'F');
    } catch (HTML2PDF_exception $e) {
        echo $e;
        exit;
    }
    // Here we update file name
    $update_status_filename = $db->update_status_pdfname($conversation_id, $filename);
    // End
    $response['error'] = false;
    $response['msg'] = "Successfully close the file..!";
    echoRespnse(200, $response);

    // End

});

// Here we genrate pdf for enquery
$app->post("/enquerygeneratepdf", function () use ($app) { 
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $inquiryid = $data['inquiryid'];
    $db = new DbHandler();
    $get_conversation_details = $db->get_enquiry_conversation($inquiryid);
    // Test code for generate pdf

    $content = '<table cellspacing="0" cellpadding="0" border="0" width="100%">
    <tr>
      <td>
          <table cellspacing="0"  cellpadding="0" border="0">
              <tr>
                  <td style="font-size:14px;padding:10px 10px"><img src="http://kwmapp.opaldemo.com/images/logo.png"/> </td>
              </tr>
           </table>
      </td>
    </tr>
    </table>

    <table cellspacing="0"  cellpadding="0" border="0" width="100%">';
    while ($conversation = $get_conversation_details->fetch_assoc()) {
        $content .= '<tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr><tr><td>&nbsp;</td></tr>';
        if ($conversation['send_by'] == "0") {
            $content .= '<tr><td style="width:50%;">&nbsp;</td><td style="width:50%;border-radius:10px;padding:10px 30px;background-color: rgb(152,251,152);"><b>Me,</b><br>' . $conversation['message'] . '<br><br>Date Time: ' . $conversation['inquiry_message_date_time'] . '</td></tr>';
        } else {
            $reveiver_name = $db->get_customer_name($conversation['sender_id']);
            $content .= '<tr><td style="width:50%;background-color: rgb(211,211,211);border-radius: 10px;padding:10px 30px;"><b>'.$reveiver_name.',</b><br>' . $conversation['message'] . ' <br><br>Date Time : ' . $conversation['inquiry_message_date_time'] . '</td><td style="width:50%;">&nbsp;</td></tr>';
        }

    }
    $content .= '</table>';
    ob_start();

    $filename = "enquiry_conversation_" . $inquiryid . ".pdf";
    $path = "../../imgs/pdf/enquiry/" . $filename;
    try {
        $html2pdf = new HTML2PDF('P', 'A4', 'en');
        $html2pdf->pdf->SetDisplayMode('fullpage');
        $html2pdf->WriteHTML($content);
        $html2pdf->Output($path, 'F');
    } catch (HTML2PDF_exception $e) {
        echo $e;
        exit;
    }

    // Here we update the file status and file name from inquiry table
    $update_status = $db->update_inquiry_status($inquiryid,$filename);
    // end 

    $response['error'] = false;
    $response['msg'] = "Successfully close the file..!";
    echoRespnse(200, $response);




});
// End 



// sent message from front side
$app->post('/sentMessage', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $conversation_id = $data['convesation_id'];
    $message = $data['message'];
    $sender_id = $user_id;
    $receiver_id = $data['receiver_id'];
    $send_by = 0;
    $conversation_datetime = date("Y-m-d H:m:i");
    $db = new DbHandler();
    $send_details = $db->sent_message($conversation_id, $message, $sender_id, $receiver_id, $send_by, $conversation_datetime);
    if ($send_details == 1) {
        $response['error'] = false;
        $response['message'] = "Successfully Message sent.";

        echoRespnse(200, $response);
    } else {
        $response['error'] = true;
        $response['message'] = "There is some error.please try again";
        echoRespnse(200, $response);
    }
});
// end

// Here we fetch all the communication of customer
$app->post('/getCommunications', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $customer_id = $data['customer_id'];
    $all_feedback_customer = $db->get_all_conversation($customer_id);
    $feecback_array = array();
    while ($feedback_customer = $all_feedback_customer->fetch_assoc()) {
        $temp = array();
        $temp['date'] = date("d/m/y", strtotime($feedback_customer['conversation_datetime']));
        $temp['time'] = date("H:m:i", strtotime($feedback_customer['conversation_datetime']));
        $temp['type'] = "Feedback";
        array_push($feecback_array, $temp);
    }

    $all_inquery_customer = $db->get_customer_all_inquiry($customer_id);
    $inquery_array = array();
    while ($inquery_customer = $all_inquery_customer->fetch_assoc()) {
        $temp = array();
        $temp['date'] = date("d/m/y", strtotime($inquery_customer['inquiry_date']));
        $temp['time'] = date("H:m:i", strtotime($inquery_customer['inquiry_date']));
        $temp['type'] = "Enquiry";
        array_push($inquery_array, $temp);
    }
    $response['error'] = false;
    $response['communications'] = array_merge($feecback_array, $inquery_array);
    echoRespnse(200, $response);

});
// End

$app->get('/getAllinquiry', function () use ($app) {
    $db = new DbHandler();
    $all_inquiry = $db->get_all_inquiry();
    $response['error'] = false;
    $response['inquiry'] = array();
    while ($conversation = $all_inquiry->fetch_assoc()) {
        $temp_array = array();
        $temp_array['sender_id'] = $conversation['sender_id'];
        $temp_array['message'] = $conversation['message'];
        $temp_array['inquiry_id'] = $conversation['inquiry_id'];
        $temp_array['firstname'] = $conversation['firstname'];
        $temp_array['inquiry_date'] = $conversation['inquiry_date'];
        array_push($response['inquiry'], $temp_array);
    }
    echoRespnse(200, $response);
});

$app->get('/getAllarchivefeedback', 'authenticate', function () use ($app) {
    $db = new DbHandler();
    global $user_id;
    $all_inquiry = $db->get_all_archivefeedback($user_id);
    $response["feedback"] = array();
    while ($feedback = $all_inquiry->fetch_assoc()) {
        $temp_array = array();
        $temp_array['firstname'] = $feedback['firstname'];
        $temp_array['senderid'] = $feedback['user_id'];
        $temp_array['conversation_id'] = $feedback['conversation_id'];
        $temp_array['conversation_date'] = date("d/m/Y", strtotime($feedback['conversation_datetime']));
        $temp_array['conversation_time'] = date("H:i:s", strtotime($feedback['conversation_datetime']));
        $temp_array['pdf_filename'] = $feedback['pdf_filename'];
        array_push($response["feedback"], $temp_array);
    }
    $response["error"] = false;
    echoRespnse(200, $response);

});

/**
 * Update api_key to NULL
 * method POST
 * params - api_key
 * url - /logout
 */
$app->post('/logout', function () {
    //echo "Hello"; die();
    $headers = apache_request_headers();
    //print_r($headers);
    $response = array();
    if (isset($headers['Authorization'])) {
        $db = new DbHandler();
        $api_key = $headers['Authorization'];
        $val = $db->updateApikey('', $api_key);
        if ($val) {
            $response["error"] = false;
        } else {
            $response["error"] = true;
        }
    } else {
        $response["error"] = true;
    }
    $response["error"] = false;
    //print_r($response);
    echoRespnse(200, $response);

});

$app->post('/getServiceReport', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();

    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];

    if (isset($pass_start_date) && isset($pass_end_date)) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }

    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    $temp_array = array();
    $service_array = array();
    $service_array['service_completed'] = array();
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
        $service_array['actual_date'][] = date("d-m-Y", strtotime($my_date));
    }

    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $temp_array = array();
        $service_id = $services['servicetype_id'];
        $service_name = $services['name'];
        $temp_array['name'] = $service_name;
        $sum = 0;
        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            $each_count = $db->datewise_service_completed($my_date, $service_id);
            $sum = $sum + $each_count;
            $temp_array['data'][] = $db->datewise_service_completed($my_date, $service_id);
        }
        $service_array['count'][$service_name][] = $sum;

        array_push($service_array['service_completed'], $temp_array);

    }

    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});

// Get Parts Report daily
$app->post('/getPartsReportdaily', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];

    if (isset($pass_start_date) && isset($pass_end_date)) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }

    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    $temp_array = array();
    $service_array = array();
    $service_array['service_completed'] = array();

    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
        $service_array['actual_date'][] = date("d-m-Y", strtotime($my_date));

    }
    /* Test code */
    $test_array = array("Engine Oil" => "engineoil_amount", "Brake Fluid" => "breakfluid_amount", "Trans Fluid" => "clutchfluid_amount", "Coolant" => "coolant_amount", "Oil Filters" => "oilfilter_number", "Air Filters" => "airfilter_number");
    foreach ($test_array as $key => $val) {
        $tempdata = array();
        $tempdata['name'] = $key;
        $sum = 0;
        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            if ($val == 'engineoil_amount' || $val == 'breakfluid_amount' || $val == 'clutchfluid_amount' || $val == 'coolant_amount') {
                $sum_engineoil = $db->get_engine_oil($my_date, $val);
                $sum = $sum + $sum_engineoil;
                $tempdata['data'][] = $sum_engineoil;
            } else {
                $avg_data = $db->get_count_data($my_date, $val);
                $sum = $sum + $avg_data;
                $tempdata['data'][] = $avg_data;
            }
        }
        $service_array['count'][$val][] = $sum;
        array_push($service_array['service_completed'], $tempdata);
    }

    /* End */

    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});
// end


$app->post('/getBookCalendar', 'authenticate', function() use ($app) {

    $json = $app->request->getBody();
    $request_params = json_decode($json, true); 
    $current_date = $request_params;
    $date = new DateTime($current_date);
    $date->modify('+1 day');
    $match_database_date = $date->format('Y-m-d');
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $data = $db->getBookCalendar($match_database_date);
    $response["error"] = false;
    $response["event"] = $data;
    echoRespnse(200, $response);

});


// here we get site productivity result for daily
$app->post('/getsiteProductivityReportdaily', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];

    if ((isset($pass_start_date) && $pass_start_date != '') && (isset($pass_end_date) && $pass_end_date != '')) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }

    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    $temp_array = array();
    $service_array = array();
    $service_array['service_completed'] = array();
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
    }
    $all_technitions = $db->get_all_technitions($user_id);
    while ($technitions = $all_technitions->fetch_assoc()) {
        $tempdata = array();
        $technitions_id = $technitions['user_id'];
        $technitions_name = $technitions['firstname'] . " " . $technitions['lastname'];
        $tempdata['name'] = $technitions_name;
        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            $get_avg_technition_data = $db->get_total_time_avg($my_date, $technitions_id);
            $tempdata['data'][] = $get_avg_technition_data;
        }
        array_push($service_array['service_completed'], $tempdata);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});
// End

// Here we get technition Productivity report accoding to type
$app->post('/getTechnicianProductivityReportdaily', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $technician_id = $data['technician_id'];

    if ((isset($pass_start_date) && $pass_start_date != '') && (isset($pass_end_date) && $pass_end_date != '')) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }

    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    $temp_array = array();
    $service_array = array();
    $service_array['service_completed'] = array();
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
        $service_array['actual_date'][] = date("d-m-Y", strtotime($my_date));
    }

    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $tempdata = array();
        $service_id = $services['servicetype_id'];
        $tempdata['name'] = $services['name'];
        $servicename = $services['name'];
        for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
            $my_date = date('Y-m-d', $i);
            $get_technition_productivity_data = $db->get_technition_productivity_daily($my_date, $service_id, $technician_id);
            $tempdata['data'][] = $get_technition_productivity_data;
        }
        $average = array_sum($tempdata['data']) / count($tempdata['data']);
        $service_array[$servicename] = $average;

        array_push($service_array['service_completed'], $tempdata);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});

// End

// Here we get salesman perfomance daily
$app->post('/getSalesmanPerfomancedaily', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $salesman_id = $data['salesman_id'];
    $salesmanname = $data['salesmanname'];
    $service_array = array();
    $service_array['service_completed'] = array();
    if ((isset($pass_start_date) && $pass_start_date != '') && (isset($pass_end_date) && $pass_end_date != '')) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }
    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
    }
    $tempdata = array();
    $tempdata['name'] = "Salesman Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
        $my_date = date('Y-m-d', $i);
        $get_salesman_vehicle_data = $db->get_salesmandaily_report($my_date, $salesman_id);
        $tempdata['data'][] = $get_salesman_vehicle_data;
    }
    $average = array_sum($tempdata['data']) / count($tempdata['data']);
    $service_array['technician_avg'] = $average;

    array_push($service_array['service_completed'], $tempdata);

    $temp_data = array();
    $temp_data['name'] = "Team Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
        $my_date = date('Y-m-d', $i);
        $get_salesman_vehicle_data = $db->get_salesmandaily_report($my_date, '');
        $temp_data['data'][] = $get_salesman_vehicle_data;
    }
    $average_site = array_sum($temp_data['data']) / count($temp_data['data']);
    $service_array['site_avg'] = $average_site;
    array_push($service_array['service_completed'], $temp_data);

    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});
// End

$app->post('/getSalesManRoute', 'authenticate', function () use ($app) {
    //echo "Hello";
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $db = new DbHandler();
    global $user_id;

    $route = $db->getSalesManRoute($data['id'], $data['date'], $data['fromtime'], $data['totime'], $user_id);
    if ($data['id'] == "All") {
        $response["team"] = $route;
        $response["center"] = array("lat" => '-37.7870', "lan" => '175.2793');
    } else {
        $center = $db->getCenter($data['id'], $data['date']);
        $response["center"] = $center;
        $response["route"] = $route;
    }

    $response["error"] = false;

    echoRespnse(200, $response);
});

// get site avg for site productvity
$app->get('/getsiteProductivityAverage', function () use ($app) {
    $db = new DbHandler();
    $all_technitions = $db->get_avg_site_productivity();
    $response['error'] = false;
    $response['site_avg'] = number_format($all_technitions, 2);
    echoRespnse(200, $response);
});
// End

// Scann assign job insert query
$app->post('/storeJobtoBooking', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $response = array();
    $booking_id = $data['booking_id'];
    $technician_id = $data['technician_id'];

    $store_info = $db->store_booking_info($booking_id,$technician_id);
    if($store_info == 1){
        $response['error'] = false;
        $response['msg'] = "Job is successfully assign to the technician.";
    }else{
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error in assign job";
    }
    echoRespnse(200,$response);
});

// end 



$app->post('/getsiteProductivityReportHourly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $service_array['service_completed'] = array();
    for ($i = 8; $i <= 17; $i++) {
        $time = $i;
        $service_array['date'][] = $time;
    }
    $all_technitions = $db->get_all_technitions($user_id);
    while ($technitions = $all_technitions->fetch_assoc()) {
        $tempdata = array();
        $technitions_id = $technitions['user_id'];
        $technitions_name = $technitions['firstname'] . " " . $technitions['lastname'];
        $tempdata['name'] = $technitions_name;
        for ($i = 8; $i <= 17; $i++) {
            $start_time = $i . ":00:00";
            $end_time = ($i + 1) . ":00:00";
            $get_avg_technition_data = $db->get_houveryly_time_avg($start_time, $end_time, $technitions_id, $pass_start_date, $pass_end_date);
            $tempdata['data'][] = $get_avg_technition_data;
        }
        array_push($service_array['service_completed'], $tempdata);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});

// Here we get technition productivity report houverly
$app->post('/getTechnicianProductivityReportHourly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $technician_id = $data['technician_id'];
    $service_array['service_completed'] = array();
    for ($i = 8; $i <= 17; $i++) {
        $time = $i;
        $service_array['date'][] = $time;
        $service_array['actual_date'][] = $time.":00";
    }
    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $tempdata = array();
        $service_id = $services['servicetype_id'];
        $tempdata['name'] = $services['name'];
        $servicename = $services['name'];
        for ($i = 8; $i <= 17; $i++) {
            $start_time = $i . ":00:00";
            $end_time = ($i + 1) . ":00:00";
            $get_avg_technition_data = $db->get_technician_houveryly_time_avg($start_time, $end_time, $technician_id, $pass_start_date, $pass_end_date, $service_id);
            $tempdata['data'][] = $get_avg_technition_data;
        }
        $average = array_sum($tempdata['data']) / count($tempdata['data']);
        $service_array[$servicename] = $average;

        array_push($service_array['service_completed'], $tempdata);

    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});
// end



// here we fetch technitions report daily
$app->post('/getTechnicianReports', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $technician_id = $data['technician_id'];
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if (isset($pass_start_date) && isset($pass_end_date)) {
        $date = date("Y-m-d", strtotime($pass_end_date));
        $seven_days_before_date = date("Y-m-d", strtotime($pass_start_date));
    } else {
        $date = date("Y-m-d");
        $seven_days_before_date = date('Y-m-d', strtotime('-7 days'));
    }
    $startTime = strtotime($seven_days_before_date);
    $endTime = strtotime($date);
    $temp_array = array();
    $service_array = array();
    $service_array['service_completed'] = array();

    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) { // start loop for 7 days
        $my_date = date('Y-m-d', $i);
        $service_array['date'][] = date("d", strtotime($my_date));
        $service_array['actual_date'][] = date("d-m-Y", strtotime($my_date));
    }

    $tempdata = array();
    $tempdata['name'] = "Technician Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
        $my_date = date('Y-m-d', $i);
        $get_technitions_site_avg = $db->get_technitions_daily_completed_services($my_date, $technician_id);
        $tempdata['data'][] = $get_technitions_site_avg;

    }
    $average = array_sum($tempdata['data']) / count($tempdata['data']);
    $service_array['technician_avg'] = $average;
    array_push($service_array['service_completed'], $tempdata);

    $tmp_data = array();
    $tmp_data['name'] = "Site Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
        $my_date = date('Y-m-d', $i);
        $all_technitions = $db->get_all_technitions($user_id);
        $total_technitions = $all_technitions->num_rows;
        $total_completed_job = $db->get_technitions_daily_completed_services($my_date, '');
        $avg = $total_completed_job / $total_technitions;
        $tmp_data['data'][] = $avg;

    }
    $average_site = array_sum($tmp_data['data']) / count($tmp_data['data']);
    $service_array['site_avg'] = $average_site;

    array_push($service_array['service_completed'], $tmp_data);
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});

// End

// Here we get Technition report hourly
$app->post('/getTechnicianReportsHourly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $technician_id = $data['technician_id'];
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];

    $service_array['service_completed'] = array();
    for ($i = 8; $i <= 17; $i++) {
        $time = $i;
        $service_array['date'][] = $time;
        $service_array['actual_date'][] = $time.":00";
    }

    $tempdata = array();
    $tempdata['name'] = "Technician Average";
    $sum = 0;
    for ($i = 8; $i <= 17; $i++) {
        $start_time = $i . ":00:00";
        $end_time = ($i + 1) . ":00:00";
        $get_technitions_site_avg = $db->get_technitions_report_hourly($start_time, $end_time, $technician_id, $pass_start_date, $pass_end_date);
        $tempdata['data'][] = $get_technitions_site_avg;

    }
    $average = array_sum($tempdata['data']) / count($tempdata['data']);
    $service_array['technician_avg'] = $average;
    array_push($service_array['service_completed'], $tempdata);

    $temp_data = array();
    $temp_data['name'] = "Site Average";
    for ($i = 8; $i <= 17; $i++) {
        $start_time = $i . ":00:00";
        $end_time = ($i + 1) . ":00:00";

        $all_technitions = $db->get_all_technitions($user_id);
        $total_technitions = $all_technitions->num_rows;
        $total_completed_job = $db->get_technitions_report_hourly($start_time, $end_time, '', $pass_start_date, $pass_end_date);
        $avg = $total_completed_job / $total_technitions;
        $temp_data['data'][] = $avg;

    }
    $average_site = array_sum($temp_data['data']) / count($temp_data['data']);
    $service_array['site_avg'] = $average_site;
    array_push($service_array['service_completed'], $temp_data);
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});
// End

// Here we fetch the parts report hourly
$app->post('/getPartsReportHourly', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $service_array['service_completed'] = array();
    for ($i = 8; $i <= 17; $i++) {
        $time = $i;
        $service_array['date'][] = $time;
        $service_array['actual_date'][] = $time.":00";
    }
    $test_array = array("Engine Oil" => "engineoil_amount", "Brake Fluid" => "breakfluid_amount", "Trans Fluid" => "clutchfluid_amount", "Coolant" => "coolant_amount", "Oil Filters" => "oilfilter_number", "Air Filters" => "airfilter_number");
    foreach ($test_array as $key => $val) {
        $temp_array = array();
        $temp_array['name'] = $key;
        $sum = 0;
        for ($i = 8; $i <= 17; $i++) {
            $start_time = $i . ":00:00";
            $end_time = ($i + 1) . ":00:00";
            if ($val == 'engineoil_amount' || $val == 'breakfluid_amount' || $val == 'clutchfluid_amount' || $val == 'coolant_amount') {
                $each_count = $db->hourlywise_parts_completed($start_time, $end_time, $val, $pass_start_date, $pass_end_date);
                $sum = $sum + $each_count;
                $temp_array['data'][] = $each_count;
            } else {
                $each_count = $db->hourlywise_parts_count_completed($start_time, $end_time, $val, $pass_start_date, $pass_end_date);
                $sum = $sum + $each_count;
                $temp_array['data'][] = $each_count;
            }
        }
        $service_array['count'][$val][] = $sum;
        array_push($service_array['service_completed'], $temp_array);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});

// End

// Here we remove publicholidays of site manager
$app->post('/removepublicholidays', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $publicholidaysid = $data['publicholidaysid'];
    $response = array();
    $remove_holidays = $db->remove_public_holidays_user($publicholidaysid,$user_id);
    if($remove_holidays == 1){
        $response['error'] = false;
        $response['msg'] = "Holiday remove successfully.";
    }else{
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error in delete.Pleaase try again.";
    }
    echoRespnse(200, $response);


});
// end 


// Here we get the service report hourly

$app->post('/getServiceReportHourly', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();

    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    for ($i = 8; $i <= 17; $i++) {
        $time = $i;
        $service_array['date'][] = $time;
        $service_array['actual_date'][] = $time.":00";
    }
    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $temp_array = array();
        $service_id = $services['servicetype_id'];
        $service_name = $services['name'];
        $temp_array['name'] = $service_name;
        $sum = 0;
        for ($i = 8; $i <= 17; $i++) {
            $start_time = $i . ":00:00";
            $end_time = ($i + 1) . ":00:00";
            $each_count = $db->hourlywise_service_completed($start_time, $end_time, $service_id, $pass_start_date, $pass_end_date);
            $sum = $sum + $each_count;
            $temp_array['data'][] = $db->hourlywise_service_completed($start_time, $end_time, $service_id, $pass_start_date, $pass_end_date);
        }
        $service_array['count'][$service_name][] = $sum;
        array_push($service_array['service_completed'], $temp_array);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});
// End

// Here get past result weekly
$app->post('/getPartsReportWeekly', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);

    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $db = new DbHandler();

    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if (isset($pass_start_date) && isset($pass_end_date)) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }

    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $service_array['actual_date'][] = $k;
            $k++;
        }
    }
    $test_array = array("Engine Oil" => "engineoil_amount", "Brake Fluid" => "breakfluid_amount", "Trans Fluid" => "clutchfluid_amount", "Coolant" => "coolant_amount", "Oil Filters" => "oilfilter_number", "Air Filters" => "airfilter_number");
    foreach ($test_array as $key => $val) {
        $temp_array = array();
        $temp_array['name'] = $key;
        $sum = 0;
        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);
            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                if ($val == 'engineoil_amount' || $val == 'breakfluid_amount' || $val == 'clutchfluid_amount' || $val == 'coolant_amount') {
                    $each_count = $db->weekly_parts_reports($start_date, $end_date, $val);
                    $sum = $sum + $each_count;
                    $temp_array['data'][] = $each_count;
                } else {
                    $each_count = $db->weekly_parts_count_reports($start_date, $end_date, $val);
                    $sum = $sum + $each_count;
                    $temp_array['data'][] = $each_count;
                }
            }
        }
        $service_array['count'][$val][] = $sum;
        array_push($service_array['service_completed'], $temp_array);

    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});
// End

// Get Salesman report Weekly
$app->post('/getSalesmanPerfomanceweekly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $db = new DbHandler();

    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    $salesman_id = $data['salesman_id'];
    $salesmanname = $data['salesmanname'];

    if (isset($pass_start_date) && isset($pass_end_date)) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }

    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $k++;
        }
    }
    $tempdata = array();
    $tempdata['name'] = "Technician Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) {
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $my_date = date('Y-m-d', $i);
            $get_salesman_vehicle_data_weekly = $db->get_salesmanweekly_report($start_date, $end_date, $salesman_id);
            $tempdata['data'][] = $get_salesman_vehicle_data_weekly;
        }
    }
    $average = array_sum($tempdata['data']) / count($tempdata['data']);
    $service_array['technician_avg'] = $average;
    array_push($service_array['service_completed'], $tempdata);
    // echo "<pre>";print_r($service_array);exit;

    $temp_data = array();
    $temp_data['name'] = "Site Average";

    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) {
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $my_date = date('Y-m-d', $i);
            $get_salesman_vehicle_data_weekly = $db->get_salesmanweekly_report($start_date, $end_date, "");
            $temp_data['data'][] = $get_salesman_vehicle_data_weekly;
        }
    }
    $average_site = array_sum($temp_data['data']) / count($temp_data['data']);
    $service_array['site_avg'] = $average_site;
    array_push($service_array['service_completed'], $temp_data);

    echoRespnse(200, $service_array);

});
// End

$app->post('/getsiteProductivityReportWeekly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $technician_id = $data['technician_id'];
    $db = new DbHandler();
    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if ((isset($pass_start_date) && $pass_start_date != '') && (isset($pass_end_date) && $pass_end_date != '')) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }

    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $k++;
        }
    }
    $all_technitions = $db->get_all_technitions($user_id);
    while ($technitions = $all_technitions->fetch_assoc()) {
        $tempdata = array();
        $technitions_id = $technitions['user_id'];
        $technitions_name = $technitions['firstname'] . " " . $technitions['lastname'];
        $tempdata['name'] = $technitions_name;
        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);
            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                $get_avg_technition_data = $db->get_weeklysite_time_avg($start_date, $end_date, $technitions_id);
                $tempdata['data'][] = $get_avg_technition_data;
            }
        }
        array_push($service_array['service_completed'], $tempdata);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});

// Here we get technitions productivity weekly
$app->post('/getTechnicianProductivityReportweekly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);
    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $technician_id = $data['technician_id'];
    $db = new DbHandler();
    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if ((isset($pass_start_date) && $pass_start_date != '') && (isset($pass_end_date) && $pass_end_date != '')) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }
    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $service_array['actual_date'][] = $k;
            $k++;
        }
    }
    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $tempdata = array();
        $service_id = $services['servicetype_id'];
        $tempdata['name'] = $services['name'];
        $servicename = $services['name'];
        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);
            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                $get_avg_technition_data = $db->get_weekly_technition_avg($start_date, $end_date, $technician_id, $service_id);
                $tempdata['data'][] = $get_avg_technition_data;
            }
        }
        $average = array_sum($tempdata['data']) / count($tempdata['data']);
        $service_array[$servicename] = $average;
        array_push($service_array['service_completed'], $tempdata);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});
// End

// Get technitions graph weekly
$app->post('/getTechnicianReportsWeekly', 'authenticate', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);

    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $technician_id = $data['technician_id'];
    $db = new DbHandler();

    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if (isset($pass_start_date) && isset($pass_end_date)) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }
    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $service_array['actual_date'][] = $k;
            $k++;
        }
    }

    $tempdata = array();
    $tempdata['name'] = "Technician Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $get_technitions_site_avg = $db->get_technitions_weekly_completed_services($start_date, $end_date, $technician_id);
            $tempdata['data'][] = $get_technitions_site_avg;
        }

    }
    $average = array_sum($tempdata['data']) / count($tempdata['data']);
    $service_array['technician_avg'] = $average;
    array_push($service_array['service_completed'], $tempdata);

    $temp_data = array();
    $temp_data['name'] = "Site Average";
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $all_technitions = $db->get_all_technitions($user_id);
            $total_technitions = $all_technitions->num_rows;
            $total_completed_job = $db->get_technitions_weekly_completed_services($start_date, $end_date, '');
            $avg = $total_completed_job / $total_technitions;
            $temp_data['data'][] = $avg;
        }
    }
    $average_site = array_sum($temp_data['data']) / count($temp_data['data']);
    $service_array['site_avg'] = $average_site;
    array_push($service_array['service_completed'], $temp_data);
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);
});
// End

// get service report weekly
$app->post('/getServiceReportWeekly', function () use ($app) {
    $json = $app->request->getBody();
    global $user_id;
    $data = json_decode($json, true);

    $db = new DbHandler();
    $service_array = array();
    $service_array['service_completed'] = array();
    $date = date("Y-m-d");
    $db = new DbHandler();

    $three_month_before_date = date('Y-m-d', strtotime('-3 months'));
    $pass_start_date = $data['startdate'];
    $pass_end_date = $data['enddate'];
    if (isset($pass_start_date) && isset($pass_end_date)) {
        $startTime = strtotime($pass_start_date);
        $endTime = strtotime($pass_end_date);
    } else {
        $startTime = strtotime($three_month_before_date);
        $endTime = strtotime($date);
    }

    $k = 1;
    for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
        $start_date = date('Y-m-d', $i);
        $end_date = date('Y-m-d', $i + 604800);
        if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
            $service_array['date'][] = $k;
            $service_array['actual_date'][] = $k;
            $k++;
        }
    }

    $get_service_type = $db->get_service_type();
    while ($services = $get_service_type->fetch_assoc()) {
        $temp_array = array();
        $service_id = $services['servicetype_id'];
        $service_name = $services['name'];
        $temp_array['name'] = $service_name;
        $sum = 0;

        for ($i = $startTime; $i <= $endTime; $i = $i + 604800) { //  86400 == 1 day
            $start_date = date('Y-m-d', $i);
            $end_date = date('Y-m-d', $i + 604800);

            if (date("F", strtotime($start_date)) == date("F", strtotime($end_date))) { // if stat date moth same to end date moth then we execute data
                $each_count = $db->weekly_service_completed($start_date, $end_date, $service_id);
                $sum = $sum + $each_count;
                $temp_array['data'][] = $db->weekly_service_completed($start_date, $end_date, $service_id);
            }
        }

        $service_array['count'][$service_name][] = $sum;
        array_push($service_array['service_completed'], $temp_array);
    }
    // echo "<pre>";print_r($service_array);exit;
    echoRespnse(200, $service_array);

});

// End

$app->get('/Allservicetype', 'authenticate', function () use ($app) {
    $db = new DbHandler();
    $get_service_type = $db->get_service_type();
    $response['allservices'] = array();
    while ($services = $get_service_type->fetch_assoc()) {
        $temp = array();
        $temp['name'] = $services['name'];
        array_push($response['allservices'], $temp);
    }
    echoRespnse(200, $response['allservices']);
});

/*
 * Here we create function for fetch all jobs of technician
 */
$app->get('/getAlljobs', 'authenticate', function () use ($app) {
    global $user_id;
    $db = new DbHandler();
    $jobsdata = $db->fetchAlljobs($user_id);

    $response["jobs"] = array();
    // looping through result and preparing tasks array
    while ($jobs = $jobsdata->fetch_assoc()) {
        $tmp = array();
        $tmp["scheduledatetime"] = date('Y-m-d', strtotime($jobs["scheduledatetime"]));
        $tmp["plateno"] = $jobs["plateno"];
        $tmp["model"] = $jobs["model"];
        $tmp["name"] = $jobs["name"];
        $tmp["job_id"] = $jobs["job_id"];
        array_push($response["jobs"], $tmp);
    }
    if (empty($response)) {
        $response["error"] = false;
        $response["message"] = "No jobs found.";
        echoRespnse(200, $response);
    } else {
        $response["error"] = false;
        echoRespnse(200, $response);
    }
});
/*
 * End
 */

/**
 * Creating new Inquiry in db
 * method POST
 * params - name
 * url - /customerinquiry/
 */
$app->post('/updateAdmin', 'authenticate', function () use ($app) {
    // check for required params

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email', 'BankAccountName', 'BankAccountNo', 'Bank'));
    $response = array();
    global $user_id;
    $db = new DbHandler();
    // creating new task
    $customer_id = $db->updateAdmin($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email'], $request_params['BankAccountName'], $request_params['BankAccountNo'], $request_params['Bank']);
    if ($customer_id != null) {
        $response["error"] = false;
        $response["message"] = "Profile Successfully Updated";
        echoRespnse(201, $response);
    } else {
        $response["error"] = false;
        $response["message"] = "Profile Successfully Updated";
        echoRespnse(200, $response);
    }
});
/**
 * Listing all getAdmindata
 * method GET
 * url /getAdmindata
 */
$app->get('/getAdmindata', 'authenticate', function () {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    //echo $user_id;die();
    // fetching all user tasks
    $result = $db->getAdmindata($user_id);

    $response["error"] = false;
    $response["admin"] = $result;

    // looping through result and preparing tasks array

    //print_r($response);die();
    echoRespnse(200, $response);
});

/*
 * Here we create new function for fetch parts of order.
 */
$app->get('/getAllpartsorder', 'authenticate', function () {
    global $user_id;
    $db = new DbHandler();
    $jobsdata = $db->fetchAllpartsorder($user_id);
    $response = $jobsdata->fetch_assoc();

    if (empty($response)) {
        $response["error"] = false;
        $response["message"] = "No parts order found.";
        echoRespnse(200, $response);
    } else {
        $response["error"] = false;
        echoRespnse(200, $response);
    }
});
/*
 * End
 */

/**
 * Listing all tasks of particual user
 * method GET
 * url /tasks
 */
$app->get('/getTeam', 'authenticate', function () {
    $response = array();
    $db = new DbHandler();
    // fetching all user tasks
    $result = $db->getTeam();

    $response["error"] = false;
    $response["team"] = array();
    // looping through result and preparing tasks array
    while ($teams = $result->fetch_assoc()) {
        $tmp = array();
        $tmp["position"] = $teams["name"];
        $tmp["name"] = $teams["firstname"] . " " . $teams["lastname"];
        $tmp["phone"] = $teams["mobilenumber"];
        array_push($response["team"], $tmp);
    }
    echoRespnse(200, $response);
});

/**
 * Listing single task of particual user
 * method GET
 * url /tasks/:id
 * Will return 404 if the task doesn't belongs to user
 */
$app->get('/warningLights/:id', 'authenticate', function ($cms_id) {
    $response = array();
    $db = new DbHandler();

    // fetch task
    $result = $db->getWarningLight($cms_id);

    if ($result != null) {
        $response["error"] = false;
        $response["cms_id"] = $result["cms_id"];
        $response["cms_title"] = $result["cms_title"];
        $response["cms_description"] = $result["cms_description"];
        $response["cms_icon"] = $result["cms_icon"];
        echoRespnse(200, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "The requested resource doesn't exists";
        echoRespnse(404, $response);
    }
});

/*
 * here we create function for individual job
 */
$app->get('/getindividualjob/:id', 'authenticate', function ($job_id) use ($app) {
    global $user_id;
    $db = new DbHandler();
    $individual_job_details = $db->fetchindividualjob($job_id);
    $response["error"] = false;
    echoRespnse(201, $individual_job_details);
});

/*
 * here we fetch the technician contract history
 */
$app->post('/getContracthistory', 'authenticate', function () use ($app) {
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $response = $db->fetchcontracthistory($user_id);
    if (!empty($response)) {
        $response["error"] = false;
        echoRespnse(201, $response);
    } else {
        $response["error"] = false;
        $response["message"] = "There is no contract details are available.";
        echoRespnse(201, $response);
    }
});

/*
 *  End
 */

/*
 *  Here we create function for update information
 */

$app->post('/updateCustomer', 'authenticate', function () use ($app) {
    // check for required params
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email'));
    $response = array();
    global $user_id;
    $db = new DbHandler();
    // creating new task
    $customer_id = $db->updateCustomer($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email']);
    if ($customer_id != null) {
        $response["error"] = false;
        $response["message"] = "Profile Successfully Updated";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Error!!! Please try again";
        echoRespnse(200, $response);
    }
});

/*
 * End
 */

/**
 * Verifying required params posted or not
 */
function verifyRequiredParams($required_fields)
{
    $error = false;
    $error_fields = "";
    $request_params = array();
    //$request_params = $_REQUEST;
    // Handling PUT request params
    $app = \Slim\Slim::getInstance();
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
        // $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
 * Validating email address
 */
function validateEmail($email)
{
    $app = \Slim\Slim::getInstance();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["error"] = true;
        $response["message"] = 'Email address is not valid';
        echoRespnse(400, $response);
        $app->stop();
    }
}
/**
 * Echoing json response to client
 * @param String $status_code Http response code
 * @param Int $response Json response
 */
function echoRespnse($status_code, $response)
{
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);

    // setting response content type to json
    $app->contentType('application/json');

    echo json_encode($response);
}
$app->notFound(function () use ($app) {
    $headers = apache_request_headers();

    print_r($headers);
});
$app->run();
