<?php
//header('Access-Control-Allow-Origin: *');
require_once '../include/DbHandler-sales.php';
require_once '../include/PassHash.php';
require '.././libs/Slim/Slim.php';
require_once('../../admin/generate_pdf/html2pdf/html2pdf.class.php');

\Slim\Slim::registerAutoloader();

$app = new \Slim\Slim(array(
    'debug' => true
));

require ('CorsSlim.php');
$corsOptions = array(

    "exposeHeaders" => array("Content-Type", "X-Requested-With", "X-authentication", "X-client","Origin","Accept"),
    "allowMethods" => array('GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'),
    "Access-Control-Allow-Methods" => "*",
    "Origin" => "*",

);
$cors = new \CorsSlim\CorsSlim($corsOptions);
$app->add($cors);
$user_id = NULL;
$api_key = NULL;
//$site_url = 'http://kwmapp.opaldemo.com';
$site_url = 'http://localhost/kwmapp';
function authenticate(\Slim\Route $route) {
    //echo "Hee";die();
    // Getting request headers
    //$headers = apache_request_headers();
    $headers = $_SERVER;
    $response = array();
    $app = \Slim\Slim::getInstance();
    //print_r($_SERVER);exit;
    //print_r($headers);exit;
    // Verifying Authorization Header
    if (isset($headers['REDIRECT_HTTP_AUTHORIZATION'])) {
        $db = new DbHandler();
        global $api_key;
        //global $api_key;
        // get the api key
        $api_key = $headers['REDIRECT_HTTP_AUTHORIZATION'];
        //echo $api_key;
        // validating api key
        if (!$db->isValidApiKey($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
            //get user primary key id
            $user_id = $db->getUserId($api_key);
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}

$app->post('/addFolloup', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    $adddress = $request_params['address'];
    $email = $request_params['email'];
    $followupDate = $request_params['followupDate'];
    $lan = $request_params['lan'];
    $lat = $request_params['lat'];
    $name = $request_params['name'];
    $phone = $request_params['phone'];
    $db = new DbHandler();
    $insert_id = $db->addFolloup($adddress, $email, $followupDate, $lan, $lat, $name, $phone, $user_id);
    if($insert_id > 0){
        $response["error"] = false;
        $response["message"] = "Added Folloup";
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Please try again";
        echoRespnse(200, $response);
    }
});
$app->post('/removeFollowup', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;

    $json = $app->request->getBody();
    //$request_params = json_decode($json, true);


    $db = new DbHandler();
    $insert_id = $db->removeFollowup($json);
    //if($insert_id > 0){
    $response["error"] = false;
    $response["message"] = "Follwoup Deleted";
    echoRespnse(200, $response);

});
$app->get('/getFollowup', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;


    $db = new DbHandler();
    $data = $db->getFollowup($user_id);
    if(!empty($data)){
        $response["error"] = false;
        $response["followup"] = $data;
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Please try again";
        echoRespnse(200, $response);
    }
});
$app->get('/getApplicationData/:id', 'authenticate', function($cus_id) {

    $response = array();
    global $user_id;
    $customer_id = $cus_id;
    $db = new DbHandler();

    $vehicle_id = $db->getVehicleCustomerLastId($customer_id);

    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();

    $vehicleData = $db->getVehicle($vehicle_id);
    $vehicleDetail = $vehicleData->fetch_assoc();

    $bankData = $db->getBankData($vehicle_id);
    $bankDetail = $bankData->fetch_assoc();
    $account_no = explode('-',$bankDetail["accountnumber"]);

    $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
    $planDetail = $planData->fetch_assoc();

    $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
    $categoryDetail = $categoryData->fetch_assoc();

    $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
    $engineDetail = $engineData->fetch_assoc();


    $response["firstname"] = $customerDetail["firstname"];
    $response["lastname"] = $customerDetail["lastname"];
    $response["dob"] = $customerDetail["dateofborth"];
    $response["gender"] = $customerDetail["gender"];
    $response["mobile"] = $customerDetail["mobilenumber"];
    $response["home"] = $customerDetail["homenumber"];
    $response["address1"] = $customerDetail["address"];
    $response["address2"] = $customerDetail["address2"];
    $response["email"] = $customerDetail["emailaddress"];
    $response["licence"] = $customerDetail["drivinglicencenumber"];
    $response["expdate"] = $customerDetail["drivinglicenceexpiredate"];
    $response["plate_id"] = $vehicleDetail["plate_id"];
    $response["plateno"] = $vehicleDetail["plateno"];
    $response["make"] = $vehicleDetail["make"];
    $response["model"] = $vehicleDetail["model"];
    $response["year"] = $vehicleDetail["year"];
    $response["vin"] = $vehicleDetail["vin"];
    $response["fuel"] = $vehicleDetail["fuel"];
    $response["type"] = $planDetail["planname"];
    $response["category"] = $vehicleDetail["category_id"];
    $response["color"] = $vehicleDetail["color"];
    $response["enginType"] = $engineDetail["name"];
    $response["term"] = $planDetail["duration"];
    $response["paymentFrequency"] =  $vehicleDetail["paymentfrequency"];
    $response["paymentDay"] =  $vehicleDetail["paymentday"];
    $response["specialBenifit"] = $planDetail["special_benefits"];
    $response["vehicle_id"] = $vehicleDetail["vehicle_id"];
    $response["plan_price"] = $planDetail["plan_price"];
    $response["plan_id"] = $vehicleDetail["plan_id"];
    $response["BankAccountName"] = $bankDetail["accountname"];
    $response["BankAccountNo1"] = $account_no[0];
    $response["BankAccountNo2"] = $account_no[1];
    $response["BankAccountNo3"] = $account_no[2];
    $response["BankAccountNo4"] = $account_no[3];
    $response["Bank"] =  $bankDetail["bankname"];
    $response["ddStartDate"] = $bankDetail["ddstartdate"];
    $response["ddEndDate"] = $bankDetail["ddenddate"];
    $response["multiCarDiscount"] = $bankDetail["multicar_discount"];
    $plan_data = $db->getPlanData($vehicleDetail['enginetype_id'], $planDetail["duration"], $planDetail["planname"]);
    if($vehicleDetail["paymentfrequency"] == "Fortnightly"){
        $plan_price = $plan_data['price']*2;

    }else{
        $plan_price = $plan_data['price'];
    }
    $response["plan_price"] = $plan_price;
    $response["ddAmount"] = $plan_price;

    $response["error"] = false;
    echoRespnse(200, $response);
});

$app->get('/getApplicationDataNew/:id', 'authenticate', function($cus_id) {

    $response = array();
    global $user_id;
    $customer_id = $cus_id;
    $db = new DbHandler();



    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();
    $response["firstname"] = $customerDetail["firstname"];
    $response["lastname"] = $customerDetail["lastname"];
    $response["dob"] = $customerDetail["dateofborth"];
    $response["gender"] = $customerDetail["gender"];
    $response["mobile"] = $customerDetail["mobilenumber"];
    $response["home"] = $customerDetail["homenumber"];
    $response["address1"] = $customerDetail["address"];
    $response["address2"] = $customerDetail["address2"];
    $response["email"] = $customerDetail["emailaddress"];
    $response["licence"] = $customerDetail["drivinglicencenumber"];
    $response["expdate"] = $customerDetail["drivinglicenceexpiredate"];
    $response['cars'] = array();
    $vehicle_id_array = $db->getPendingVehicleCustomer($customer_id);
    //print_r($vehicle_id_array);
    foreach($vehicle_id_array as $vehicles_id){
        $tmp = array();
        $vehicle_id = $vehicles_id['id'];
        $vehicleData = $db->getVehicle($vehicle_id);
        $vehicleDetail = $vehicleData->fetch_assoc();

        $plate_id = $db->getPlateId($vehicleDetail["plateno"]);


        $bankData = $db->getBankData($vehicle_id);
        $bankDetail = $bankData->fetch_assoc();
        $account_no = explode('-',$bankDetail["accountnumber"]);

        $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
        $planDetail = $planData->fetch_assoc();

        $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
        $categoryDetail = $categoryData->fetch_assoc();

        $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
        $engineDetail = $engineData->fetch_assoc();


        $tmp["categoryType"] = $db->getCategoryByMake($vehicleDetail["make"]);
        $tmp["EngineType"] = $db->getEngineTypeByCategory($response["categoryType"][0]['id']);
        $tmp["plate_id"] = $plate_id;
        $tmp["plateno"] = $vehicleDetail["plateno"];
        $tmp["make"] = $vehicleDetail["make"];
        $tmp["model"] = $vehicleDetail["model"];
        $tmp["year"] = $vehicleDetail["year"];
        $tmp["vin"] = $vehicleDetail["vin"];
        $tmp["fuel"] = $vehicleDetail["fuel"];
        $tmp["type"] = $planDetail["planname"];
        $tmp["category"] = $vehicleDetail["category_id"];
        $tmp["color"] = $vehicleDetail["color"];
        $tmp["enginType"] = $engineDetail["name"];
        $tmp["term"] = $planDetail["duration"];
        $tmp["paymentFrequency"] =  $vehicleDetail["paymentfrequency"];
        $tmp["paymentDay"] =  $vehicleDetail["paymentday"];
        $tmp["specialBenifit"] = $planDetail["special_benefits"];
        $tmp["vehicle_id"] = $vehicleDetail["vehicle_id"];
        $tmp["plan_price"] = $planDetail["plan_price"];
        $tmp["plan_id"] = $vehicleDetail["plan_id"];
        $tmp["BankAccountName"] = $bankDetail["accountname"];
        $tmp["BankAccountNo1"] = $account_no[0];
        $tmp["BankAccountNo2"] = $account_no[1];
        $tmp["BankAccountNo3"] = $account_no[2];
        $tmp["BankAccountNo4"] = $account_no[3];
        $tmp["Bank"] =  $bankDetail["bankname"];
        $tmp["ddStartDate"] = $bankDetail["ddstartdate"];
        $tmp["ddEndDate"] = $bankDetail["ddenddate"];
        $tmp["multiCarDiscount"] = $bankDetail["multicar_discount"];
        $plan_data = $db->getPlanData($vehicleDetail['enginetype_id'], $planDetail["duration"], $planDetail["planname"]);
        if($vehicleDetail["paymentfrequency"] == "Fortnightly"){
            $plan_price = $plan_data['price']*2;

        }else{
            $plan_price = $plan_data['price'];
        }
        $tmp["plan_price"] = $plan_price;
        $tmp["ddAmount"] = $plan_price;
        array_push($response['cars'], $tmp);
    }


    $response["error"] = false;
    echoRespnse(200, $response);
});
$app->post('/deleteCar', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $vehicle_id = $request_params['vehicle_id'];
    $customer_id = $request_params['customer_id'];
    $db = new DbHandler();
    $res = $db->deleteCar($vehicle_id, $customer_id);
    if($res){
        $response["error"] = false;
        $response["message"] = "Deleted succesfully";
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Error try again";
        echoRespnse(200, $response);
    }


});
$app->post('/signupInsertNew', 'authenticate', function() use ($app) {
    $response = array();
    $response['data'] = array();
    global $user_id;

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    // reading post params
    $json_userid = $request_params['customer_id']; // json user id
    //$json_userid = 57;
    $firstname = $request_params['firstname'];
    $lastname = $request_params['lastname'];
    $dob = $request_params['dob'];
    $gender = $request_params['gender'];
    $mobile = $request_params['mobile'];
    $address1 = $request_params['address1'];
    $address2 = $request_params['address2'];
    $email = $request_params['email'];
    $licence = $request_params['licence'];
    $expdate = $request_params['expdate'];
    $datetime = $request_params['datetime'];
    $home = $request_params['home'];

    $nzlProof1 = '';
    $nzlProof2 = '';
    $profilepic = '';

    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                    $nzlProof1 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                    $nzlProof2 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                    $profilepic = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
            }
        }
    }
    // validating email address
    //validateEmail($email);
    $db = new DbHandler();
    // here we  check if $json_userid is present than update record
    if($json_userid != ''){
        $db->updateUserinfo($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home,$json_userid);
        //$response = $json_userid;
    }else{
        $check_already_usertable = $db->checkUsertable($mobile); // check user already exiest or not
        if(!empty($check_already_usertable)){
            $db->updateUserinfo($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home,$check_already_usertable);
            $json_userid = $check_already_usertable;
        }else{
            $json_userid = $db->createUser($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home);
        }
    }
    foreach($request_params['cars'] as $car){
        $tmp_arr = array();

        $plate_id = $car['plate_id'];
        $plate_no = $car['plateno'];
        $make = $car['make'];
        $model = $car['model'];
        $year = $car['year'];
        $vin = $car['vin'];
        $color = $car['color'];
        $fuel = $car['fuel'];
        $type = $car['type'];
        $category = $car['category'];
        $enginType = $car['enginType'];
        $term = $car['term'];
        $paymentFrequency = $car['paymentFrequency'];
        $paymentDay = $car['paymentDay'];

        $customer_id = $json_userid;
        // here we check for the secound table
        $plan_price = '';
        $check_vehicledata = '';
        //echo $json_userid."=".$plate_no."-----";

        //echo $check_vehicledata;
        $check_vehicledata = $car['vehicle_id'];
        //echo $check_vehicledata;
        if($check_vehicledata != ''){

            // update the vehicle information
            $plan_price = $db->updateUserregisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id, $check_vehicledata);

        }else{
            // Add vehicle information
            $check_vehicledata_data = $db->updateRegisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id);
            $check_vehicledata = $check_vehicledata_data['vehicle_id'];
            $plan_price = $check_vehicledata_data['plan_price'];
        }
        $tmp_arr['vehicle_id'] = $check_vehicledata;
        $tmp_arr['plan_price'] = $plan_price;
        // End

        // here we add or edit $car in bank account detail id
        $BankAccountName = $car['BankAccountName'];
        $BankAccountNo = $car['BankAccountNo1']."-".$car['BankAccountNo2']."-".$car['BankAccountNo3']."-".$car['BankAccountNo4'];
        $Bank = $car['Bank'];
        $ddStartDate = '';
        $ddEndDate = '';


        if($car['ddStartDate'] != ''  && $car['ddStartDate'] != '0000-00-00'){
            $ddStartDate = $car['ddStartDate'];
            $ddEndDate = date('Y-m-d',strtotime(str_replace(" ", "-",$car['ddEndDate'])));
        }


        $multiCarDiscount = $car['multiCarDiscount'];
        $customer_id = $json_userid;
        $vehicle_id = $check_vehicledata;
        $ddAmount = $car['ddAmount'];

        $chek_bank_userdetails = $db->checkUserbankDetails($customer_id,$vehicle_id);
        if(!empty($chek_bank_userdetails)){
            // Update information
            $db->updateUserRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount,$chek_bank_userdetails);
        }else{
            // insertdata
            $response_bank = $db->updateRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount, $customer_id, $vehicle_id);
        }
        // End

        // here check startdate and enddate than genrate the pdf file
        if($ddStartDate != '' && $car['ddEndDate'] != ''){

            $planData = $db->getPlanDataDis($plate_id);
            $planDetail = $planData->fetch_assoc();

            $categoryData = $db->getCategoryData($category);
            $categoryDetail = $categoryData->fetch_assoc();


            //$vehicle_id = $db->getVehicleCustomerLastId($customer_id);


            $vehicleData = $db->getVehicle($vehicle_id);
            $vehicleDetail = $vehicleData->fetch_assoc();

            $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
            $engineDetail = $engineData->fetch_assoc();

            $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
            $planDetail = $planData->fetch_assoc();

            $bankData = $db->getBankData($vehicle_id);
            $bankDetail = $bankData->fetch_assoc();
            $ddamount = $bankDetail['ddamount'];
            //print_r($bankDetail);
            // echo  die();
            if($planDetail['duration'] == '1 Year'){
                $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
                $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
                if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                    $nodd = 52;
                }else{
                    $nodd = 26;
                }
            }else{
                $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
                $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
                if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                    $nodd = 104;
                }else{
                    $nodd = 52;
                }

            }

            $name = $firstname." ".$lastname;
            $licenceNo = $request_params['licence'];
            $expirydate = $request_params['expdate'];
            $address = $request_params['address1'].", ".$request_params['address2'];
            $plateno = $car['plateno'];
            $viono = $car['vin'];
            $plantype = $planDetail['planname'];
            $vehicletype = $categoryDetail['name'];
            $cylinder = $engineDetail['name'];
            $specialbenifit = $planDetail['special_benefits'];
            $firstservice = $first_service;
            $lastservice = $last_service;

            $paymentfre = $vehicleDetail['paymentfrequency'];
            $payday = $vehicleDetail['paymentday'];
            $ddstartdate = $ddStartDate;
            $ddenddate = $car['ddEndDate'];
            $bacnkaccountname = $car['BankAccountName'];
            $bankaccountno = $BankAccountNo;
            $bank = $bankDetail['bankname'];
            $regDate = date('d-m-Y');

            $custSign = '';//<img src="http://kwmapp.opaldemo.com/imgs/customer/sign/'.$customerDetail['contract_sign'].'" height="40" />
            $saleSign = '';

            $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
            //$string = fgets($myfile);
            $string = fread($myfile,filesize("customer-contract.html"));
            fclose($myfile);

            if($gender == 0){
                $gender = "Male";
            }else{
                $gender = "Female";
            }

            $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
            $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);
            $file_string = str_replace($search, $replace, $string);
            $file_string .= '<page>
            <table width="100%" class="width97" border="0" cellspacing="0">
            <tr>
            <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
            </tr>
            <tr>
            <td>
            <p><strong>1.  Service Plan Validity Period</strong><br>
            The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
            <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
            <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
            <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
            <p><strong>2.  Service Plan Entitlements</strong><br>
            The KW Motors Service Plan entitles you to the following types of    services:</p>
            <table class="padding2" cellspacing="0" cellpadding="0">
            <tr>
            <td width="391" colspan="6" valign="top"><br>
            <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
            </tr>
            <tr>
            <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
            <td width="141" colspan="2" valign="top">&nbsp;</td>
            <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
            </tr>
            <tr>
            <td width="141" colspan="2" valign="top">&nbsp;</td>
            <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
            <td width="71" valign="top"><strong><em>Medius</em></strong></td>
            <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
            </tr>
            <tr>
            <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
            <td width="70" valign="top">Express</td>
            <td width="71" valign="top">2</td>
            <td width="71" valign="top">&nbsp;</td>
            <td width="72" valign="top">&nbsp;</td>
            </tr>
            <tr>
            <td width="70" valign="top">Standard</td>
            <td width="71" valign="top">1</td>
            <td width="71" valign="top">1</td>
            <td width="72" valign="top">&nbsp;</td>
            </tr>
            <tr>
            <td width="356" colspan="5" valign="top">&nbsp;</td>
            </tr>
            <tr>
            <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
            <td width="70" valign="top">Express</td>
            <td width="71" valign="top">4</td>
            <td width="71" valign="top">&nbsp;</td>
            <td width="72" valign="top">&nbsp;</td>
            </tr>
            <tr>
            <td width="70" valign="top">Standard</td>
            <td width="71" valign="top">2</td>
            <td width="71" valign="top">2</td>
            <td width="72" valign="top">&nbsp;</td>
            </tr>
            <tr>
            <td width="70" valign="top">Deluxe</td>
            <td width="71" valign="top">2</td>
            <td width="71" valign="top">1</td>
            <td width="72" valign="top">1</td>
            </tr>
            </table>

            <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
            <p><strong>3.  Payments</strong><br>
            You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
            <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
            <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
            <p><strong>4. Default in Direct    Debit Payments </strong><br>
            It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
            <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
            <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
            <br>
            <strong>5. Transfer of Service    Plan</strong><br>
            In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
            <p><strong>6. Termination of This    Agreement</strong><br>
            KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
            <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
            <p><strong>7. Notices</strong><br>
            Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
            <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
            <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
            <ol>
            <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
            <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
            </ol>
            <p><strong>8.    Governing Law</strong><br>
            This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

            </td>
            </tr>
            </table>
            </page>';
            //ob_start();
            //echo $file_string;

            try
            {
                $html2pdf1 = new HTML2PDF('P','A3','en');
                $html2pdf1->pdf->SetDisplayMode('fullpage');
                $html2pdf1->WriteHTML($file_string);
                $html2pdf1->Output("../../imgs/customer/contract/draft-".$vehicle_id.".pdf",'F');
                $tmp_arr['contract'] = "draft-".$vehicle_id.".pdf";

            }
            catch(HTML2PDF_exception $e) {
                echo $e;
                exit;
            }

            //print_r($result);

        }
        if(!isset($tmp_arr['contract']) || $tmp_arr['contract'] == ""){
            $tmp_arr['contract'] = '';
        }
        array_push($response['data'] , $tmp_arr);
    }


    //print_r($response);die();
    //die();
    if(!empty($response['data'])){

        $response["error"] = false;
        $response["customer_id"] = $customer_id;
        $response["message"] = "Application saved as draft.";
        echoRespnse(200, $response);
    }else{

        $response["error"] = true;
        $response["customer_id"] = $customer_id;
        $response["message"] = "Application saved as draft.";
        echoRespnse(200, $response);
    }
    // end
});

$app->post('/signupInsert', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    // reading post params
    $json_userid = $request_params['customer_id']; // json user id
    //$json_userid = 57;
    $firstname = $request_params['firstname'];
    $lastname = $request_params['lastname'];
    $dob = $request_params['dob'];
    $gender = $request_params['gender'];
    $mobile = $request_params['mobile'];
    $address1 = $request_params['address1'];
    $address2 = $request_params['address2'];
    $email = $request_params['email'];
    $licence = $request_params['licence'];
    $expdate = $request_params['expdate'];
    $datetime = $request_params['datetime'];
    $home = $request_params['home'];

    $nzlProof1 = '';
    $nzlProof2 = '';
    $profilepic = '';
    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                    $nzlProof1 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                    $nzlProof2 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                    $profilepic = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
            }
        }
    }
    // validating email address
    //validateEmail($email);
    $db = new DbHandler();
    // here we  check if $json_userid is present than update record
    if($json_userid != ''){
        $db->updateUserinfo($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home,$json_userid);
        $response = $json_userid;
    }else{
        $check_already_usertable = $db->checkUsertable($mobile); // check user already exiest or not
        if(!empty($check_already_usertable)){
            $db->updateUserinfo($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home,$check_already_usertable);
            $json_userid = $check_already_usertable;
        }else{
            $json_userid = $db->createUser($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof2, $profilepic, $user_id, $home);
        }
    }

    $plate_id = $request_params['plate_id'];
    $plate_no = $request_params['plateno'];
    $make = $request_params['make'];
    $model = $request_params['model'];
    $year = $request_params['year'];
    $vin = $request_params['vin'];
    $color = $request_params['color'];
    $fuel = $request_params['fuel'];
    $type = $request_params['type'];
    $category = $request_params['category'];
    $enginType = $request_params['enginType'];
    $term = $request_params['term'];
    $paymentFrequency = $request_params['paymentFrequency'];
    $paymentDay = $request_params['paymentDay'];

    $customer_id = $json_userid;
    // here we check for the secound table

    if($json_userid != '' && $plate_no != ''){
        $check_vehicledata =  $db->checkuserVehicle($json_userid,$plate_no);
    }
    if(!empty($check_vehicledata)){
        // update the vehicle information
        $plan_price = $db->updateUserregisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id,$json_userid);

    }else{
        // Add vehicle information
        $check_vehicledata_data = $db->updateRegisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id);
        $check_vehicledata = $check_vehicledata_data['vehicle_id'];
        $plan_price = $check_vehicledata_data['plan_price'];
    }
    // End

    // here we add or edit information in bank account detail id
    $BankAccountName = $request_params['BankAccountName'];
    $BankAccountNo = $request_params['BankAccountNo1']."-".$request_params['BankAccountNo2']."-".$request_params['BankAccountNo3']."-".$request_params['BankAccountNo4'];
    $Bank = $request_params['Bank'];
    $ddStartDate = $request_params['ddStartDate'];
    $ddEndDate = date('Y-m-d',strtotime(str_replace(" ", "-",$request_params['ddEndDate'])));

    $multiCarDiscount = $request_params['multiCarDiscount'];
    $customer_id = $json_userid;
    $vehicle_id = $check_vehicledata;
    $ddAmount = $request_params['ddAmount'];

    $chek_bank_userdetails = $db->checkUserbankDetails($customer_id,$vehicle_id);
    if(!empty($chek_bank_userdetails)){
        // Update information
        $db->updateUserRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount,$chek_bank_userdetails);
    }else{
        // insertdata
        $response = $db->updateRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount, $customer_id, $vehicle_id);
    }
    // End

    // here check startdate and enddate than genrate the pdf file
    if($ddStartDate != '' && $request_params['ddEndDate'] != ''){

        $planData = $db->getPlanDataDis($plate_id);
        $planDetail = $planData->fetch_assoc();

        $categoryData = $db->getCategoryData($category);
        $categoryDetail = $categoryData->fetch_assoc();


        $vehicle_id = $db->getVehicleCustomerLastId($customer_id);


        $vehicleData = $db->getVehicle($vehicle_id);
        $vehicleDetail = $vehicleData->fetch_assoc();

        $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
        $engineDetail = $engineData->fetch_assoc();

        $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
        $planDetail = $planData->fetch_assoc();

        $bankData = $db->getBankData($vehicle_id);
        $bankDetail = $bankData->fetch_assoc();
        $ddamount = $bankDetail['ddamount'];
        //print_r($bankDetail);
        // echo  die();
        if($planDetail['duration'] == '1 Year'){
            $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
            $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
            if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                $nodd = 52;
            }else{
                $nodd = 26;
            }
        }else{
            $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
            $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
            if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                $nodd = 104;
            }else{
                $nodd = 52;
            }

        }

        $name = $firstname." ".$lastname;
        $licenceNo = $request_params['licence'];
        $expirydate = $request_params['expdate'];
        $address = $request_params['address1'].", ".$request_params['address2'];
        $plateno = $request_params['plateno'];
        $viono = $request_params['vin'];
        $plantype = $planDetail['planname'];
        $vehicletype = $categoryDetail['name'];
        $cylinder = $engineDetail['name'];
        $specialbenifit = $planDetail['special_benefits'];
        $firstservice = $first_service;
        $lastservice = $last_service;

        $paymentfre = $vehicleDetail['paymentfrequency'];
        $payday = $vehicleDetail['paymentday'];
        $ddstartdate = $ddStartDate;
        $ddenddate = $request_params['ddEndDate'];
        $bacnkaccountname = $request_params['BankAccountName'];
        $bankaccountno = $BankAccountNo;
        $bank = $bankDetail['bankname'];
        $regDate = date('d-m-Y');

        $custSign = '';//<img src="http://kwmapp.opaldemo.com/imgs/customer/sign/'.$customerDetail['contract_sign'].'" height="40" />
        $saleSign = '';

        $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
        //$string = fgets($myfile);
        $string = fread($myfile,filesize("customer-contract.html"));
        fclose($myfile);

        if($gender == 0){
            $gender = "Male";
        }else{
            $gender = "Female";
        }

        $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
        $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);
        $file_string = str_replace($search, $replace, $string);
        $file_string .= '<page>
        <table width="100%" class="width97" border="0" cellspacing="0">
        <tr>
        <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
        </tr>
        <tr>
        <td>
        <p><strong>1.  Service Plan Validity Period</strong><br>
        The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
        <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
        <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
        <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
        <p><strong>2.  Service Plan Entitlements</strong><br>
        The KW Motors Service Plan entitles you to the following types of    services:</p>
        <table class="padding2" cellspacing="0" cellpadding="0">
        <tr>
        <td width="391" colspan="6" valign="top"><br>
        <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
        </tr>
        <tr>
        <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
        <td width="141" colspan="2" valign="top">&nbsp;</td>
        <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
        </tr>
        <tr>
        <td width="141" colspan="2" valign="top">&nbsp;</td>
        <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
        <td width="71" valign="top"><strong><em>Medius</em></strong></td>
        <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
        </tr>
        <tr>
        <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
        <td width="70" valign="top">Express</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">&nbsp;</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Standard</td>
        <td width="71" valign="top">1</td>
        <td width="71" valign="top">1</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="356" colspan="5" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
        <td width="70" valign="top">Express</td>
        <td width="71" valign="top">4</td>
        <td width="71" valign="top">&nbsp;</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Standard</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">2</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Deluxe</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">1</td>
        <td width="72" valign="top">1</td>
        </tr>
        </table>

        <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
        <p><strong>3.  Payments</strong><br>
        You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
        <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
        <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
        <p><strong>4. Default in Direct    Debit Payments </strong><br>
        It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
        <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
        <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
        <br>
        <strong>5. Transfer of Service    Plan</strong><br>
        In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
        <p><strong>6. Termination of This    Agreement</strong><br>
        KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
        <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
        <p><strong>7. Notices</strong><br>
        Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
        <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
        <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
        <ol>
        <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
        <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
        </ol>
        <p><strong>8.    Governing Law</strong><br>
        This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

        </td>
        </tr>
        </table>
        </page>';
        //ob_start();
        //echo $file_string;
        try
        {
            $html2pdf1 = new HTML2PDF('P','A3','en');
            $html2pdf1->pdf->SetDisplayMode('fullpage');
            $html2pdf1->WriteHTML($file_string);
            $html2pdf1->Output("../../imgs/customer/contract/draft-".$vehicle_id.".pdf",'F');
        }
        catch(HTML2PDF_exception $e) {
            echo $e;
            exit;
        }
        //print_r($result);
        $response = array();
        if ($ddStartDate != '' && $request_params['ddEndDate'] != '') {
            $response["error"] = false;
            $response["contract"] = "draft-".$vehicle_id.".pdf";
            $response["plan_price"] = $plan_price;
            $response["customer_id"] = $customer_id;

            echoRespnse(201, $response);
        } else {
            $response["error"] = true;
            $response["message"] = "Failed to save data. Please try again";
            echoRespnse(200, $response);
        }
    }else{
        $response = array();
        $response["error"] = true;
        $response["customer_id"] = $customer_id;
        $response["message"] = "Application saved as draft.";
        echoRespnse(200, $response);
    }
    // end
});

$app->post('/salesManSignup', 'authenticate', function() use ($app) {


    $response = array();
    global $user_id;
    $db = new DbHandler();

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    $user_id_insert = $request_params['user_id'];
    $first_name = $request_params['first_name'];
    $last_name = $request_params['last_name'];
    $date_of_birth = $request_params['date_of_birth'];
    $gender = $request_params['gender'];
    $mobile_no = $request_params['mobile_no'];
    $address = $request_params['address'];
    $address2 = $request_params['address2'];
    $email_address = $request_params['email_address'];
    $driver_licence_no = $request_params['driver_licence_no'];
    $driver_licence_expiry_date = $request_params['driver_licence_expiry_date'];
    $bank_account_name = $request_params['bank_account_name'];
    $bank_name = $request_params['bank_name'];
    $bank_account_no1 = $request_params['bank_account_no1'];
    $bank_account_no2 = $request_params['bank_account_no2'];
    $bank_account_no3 = $request_params['bank_account_no3'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $payment_frequency = $request_params['payment_frequency'];
    $payment_day = $request_params['payment_day'];
    $contract = $request_params['contract'];
    $bank_account_no = $bank_account_no1."-".$bank_account_no2."-".$bank_account_no3."-".$bank_account_no4;
    $nzlProof1 = $request_params['nzlProof1'];
    $nzlProof2 = $request_params['nzlProof2'];
    $profilepic = $request_params['profilepic'];
    $datetime = $request_params['datetime'];

    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                    $nzlProof1 = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                    $nzlProof2 = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                    $profilepic = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
            }
        }
    }

    if($user_id_insert == ""){
        //Insert user
        $user_id_insert  = $db->insertSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic);
    }else{
        //Update Signup
        $user_id_insert  = $db->updateSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic, $user_id_insert);
    }


    if ($user_id_insert<=0) {
        $response["error"] = true;
        $response["message"] = "Oops! An error occurred while registereing";
    } else {
        $response["error"] = false;
        $response["user_id_insert"] = $user_id_insert;
        $response["contract"] = $contract;
        $response["nzlProof2"] = $nzlProof2;
        $response["nzlProof1"] = $nzlProof1;
        $response["profilepic"] = $profilepic;
    }/**/
    // echo json response
    echoRespnse(201, $response);


});
/**
* ----------- METHODS WITHOUT AUTHENTICATION ---------------------------------
*/
/**
* User Registration
* url - /register
* method - POST
* params - name, email, password
*/
$app->post('/signupUser', 'authenticate', function() use ($app) {
    // check for required params
    //print_r($app);die();
    verifyRequiredParams(array('firstname', 'lastname', 'dob', 'gender', 'mobile', 'address1', 'address2', 'email', 'licence', 'expdate', 'datetime'));

    $response = array();
    global $user_id;

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    // reading post params
    $firstname = $request_params['firstname'];
    $lastname = $request_params['lastname'];
    $dob = $request_params['dob'];
    $gender = $request_params['gender'];
    $mobile = $request_params['mobile'];
    $address1 = $request_params['address1'];
    $address2 = $request_params['address2'];
    $email = $request_params['email'];
    $licence = $request_params['licence'];
    $expdate = $request_params['expdate'];
    $datetime = $request_params['datetime'];
    $home = $request_params['home'];
    $nzlProof1 = '';
    $nzlProof2 = '';
    $profilepic = '';
    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                    $nzlProof1 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                    $nzlProof2 = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                    $profilepic = $file;
                    rename('../tmp/'.$file, '../../imgs/customer/'.$file);
                }

            }
        }
    }

    // validating email address
    //validateEmail($email);

    $db = new DbHandler();
    $res = $db->createUser($firstname, $lastname, $dob, $gender, $mobile, $address1, $address2, $email, $licence, $expdate, $nzlProof1, $nzlProof1, $profilepic, $user_id, $home);

    if ($res == USER_CREATE_FAILED) {
        $response["error"] = true;
        $response["message"] = "Oops! An error occurred while registereing";
    } else {
        $response["error"] = false;
        $response["userId"] = $res;
    }/**/
    // echo json response
    echoRespnse(201, $response);
});
$app->post('/updateRegisterCar/:id', 'authenticate', function($customer_id)  use ($app) {

    $response = array();
    global $user_id;

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    // reading post params
    $plate_id = $request_params['plate_id'];
    $plate_no = $request_params['plateno'];
    $make = $request_params['make'];
    $model = $request_params['model'];
    $year = $request_params['year'];
    $vin = $request_params['vin'];
    $color = $request_params['color'];
    $fuel = $request_params['fuel'];
    $type = $request_params['type'];
    $category = $request_params['category'];
    $enginType = $request_params['enginType'];
    $term = $request_params['term'];
    $paymentFrequency = $request_params['paymentFrequency'];
    $paymentDay = $request_params['paymentDay'];
    $customer_id = $customer_id;
    $db = new DbHandler();
    $result = $db->updateRegisterCar($plate_id, $plate_no, $make, $model, $year, $vin, $color, $fuel, $type, $category, $enginType, $term, $paymentFrequency, $paymentDay, $customer_id);
    //print_r($result);
    if ($result != NULL) {
        $response["error"] = false;
        $response["plan_price"] = $result["plan_price"];
        $response["vehicle_id"] = $result["vehicle_id"];
        $response["plan_id"] = $result["plan_id"];
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

/* Here we fetch all user infromation and with id */
$app->post('/getUserinfo/:id', 'authenticate', function($customer_id)  use ($app) {
    $userinformation = array();
    $user_id = $request_params['user_id'];
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $db = new DbHandler();
    $userinformation = $db->getUserinfo($user_id);
    $userdetails = $userinformation->fetch_assoc();
    return $userdetails;
});
/* End */
/* Here we fetch all user infromation and with id */
$app->get('/getPlanFromYear/:id', 'authenticate', function($year) {
    $response = array();
    $db = new DbHandler();
    $response["error"] = false;
    $response["planData"] = $db->getPlanFromYear($year);
    echoRespnse(201, $response);

});
/* End */



$app->post('/updateRegisterBank/:id', 'authenticate', function($customer_id)  use ($app) {

    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    //$futureDate=date('Y-m-d', strtotime($year_text, strtotime($request_params['ddEndDate'])) );

    $BankAccountName = $request_params['BankAccountName'];
    $BankAccountNo = $request_params['BankAccountNo1']."-".$request_params['BankAccountNo2']."-".$request_params['BankAccountNo3']."-".$request_params['BankAccountNo4'];
    $Bank = $request_params['Bank'];
    $ddStartDate = $request_params['ddStartDate'];
    $ddEndDate = date('Y-m-d',strtotime(str_replace(" ", "-",$request_params['ddEndDate'])));
    $ddAmount = $request_params['ddAmount'];
    $multiCarDiscount = $request_params['multiCarDiscount'];
    $customer_id = $customer_id;
    $db = new DbHandler();
    $vehicle_id = $db->getVehicleCustomerLastId($customer_id);

    $result = $db->updateRegisterBank($BankAccountName, $BankAccountNo, $Bank, $ddStartDate, $ddEndDate, $ddAmount, $multiCarDiscount, $customer_id, $vehicle_id);

    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();

    $vehicleData = $db->getVehicle($vehicle_id);
    $vehicleDetail = $vehicleData->fetch_assoc();

    $bankData = $db->getBankData($vehicle_id);
    $bankDetail = $bankData->fetch_assoc();

    $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
    $planDetail = $planData->fetch_assoc();

    $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
    $categoryDetail = $categoryData->fetch_assoc();

    $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
    $engineDetail = $engineData->fetch_assoc();
    $reg_date = date('d-m-Y');
    if($planDetail['duration'] == '1 Year'){
        $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 52;
        }else{
            $nodd = 26;
        }
    }else{
        $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 104;
        }else{
            $nodd = 52;
        }

    }
    if($customerDetail['gender'] == '0')
    {
        $gender = 'Male';
    }else{
        $gender = 'Female';
    }

    $name = $customerDetail['firstname']. " ". $customerDetail['lastname'];
    $licenceNo = $customerDetail['drivinglicencenumber'];
    $expirydate = date('d-m-Y',strtotime($customerDetail['drivinglicenceexpiredate']));
    $dob = date('d-m-Y',strtotime($customerDetail['dateofborth']));
    $gender = $gender;
    $address = $customerDetail['address'].", ".$customerDetail['address2'];
    $mobile = $customerDetail['mobilenumber'];
    $home = $customerDetail['homenumber'];
    $email = $customerDetail['emailaddress'];
    $plateno = $vehicleDetail['plateno'];
    $make = $vehicleDetail['make'];
    $model = $vehicleDetail['model'];
    $viono = $vehicleDetail['vin'];
    $year = $vehicleDetail['year'];
    $color = $vehicleDetail['color'];
    $fuel = $vehicleDetail['fuel'];
    $plantype = $planDetail['planname'];
    $term = $planDetail['duration'];
    $vehicletype = $categoryDetail['name'];
    $cylinder = $engineDetail['name'];
    $specialbenifit  = $planDetail['special_benefits'];
    $firstservice = $first_service;
    $lastservice = $last_service;
    $paymentfre = $vehicleDetail['paymentfrequency'];
    $nodd = $nodd;
    $ddamount = $bankDetail['ddamount'];
    $payday = $vehicleDetail['paymentday'];
    $ddstartdate = date('d-m-Y',strtotime($bankDetail['ddstartdate']));
    $ddenddate = date('d-m-Y',strtotime($bankDetail['ddenddate']));
    $bacnkaccountname = $bankDetail['accountname'];
    $bankaccountno = $bankDetail['accountnumber'];
    $bank = $bankDetail['bankname'];
    $custSign = '';//<img src="http://kwmapp.opaldemo.com/imgs/customer/sign/'.$customerDetail['contract_sign'].'" height="40" />
    $saleSign = '';
    $regDate = $reg_date;

    $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
    //$string = fgets($myfile);
    $string = fread($myfile,filesize("customer-contract.html"));
    fclose($myfile);
    $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
    $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);


    $file_string = str_replace($search, $replace, $string);
    $file_string .= '<page>

    <table width="100%" class="width97" border="0" cellspacing="0">

    <tr>
    <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
    </tr>
    <tr>
    <td>
    <p><strong>1.  Service Plan Validity Period</strong><br>
    The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
    <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
    <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
    <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
    <p><strong>2.  Service Plan Entitlements</strong><br>
    The KW Motors Service Plan entitles you to the following types of    services:</p>
    <table class="padding2" cellspacing="0" cellpadding="0">
    <tr>
    <td width="391" colspan="6" valign="top"><br>
    <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
    </tr>
    <tr>
    <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
    </tr>
    <tr>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
    <td width="71" valign="top"><strong><em>Medius</em></strong></td>
    <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
    </tr>
    <tr>
    <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">1</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="356" colspan="5" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">4</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">2</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Deluxe</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">1</td>
    </tr>
    </table>

    <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
    <p><strong>3.  Payments</strong><br>
    You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
    <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
    <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
    <p><strong>4. Default in Direct    Debit Payments </strong><br>
    It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
    <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
    <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
    <br>
    <strong>5. Transfer of Service    Plan</strong><br>
    In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
    <p><strong>6. Termination of This    Agreement</strong><br>
    KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
    <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
    <p><strong>7. Notices</strong><br>
    Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
    <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
    <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
    <ol>
    <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
    <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
    </ol>
    <p><strong>8.    Governing Law</strong><br>
    This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

    </td>
    </tr>
    </table>
    </page>';
    //ob_start();
    try
    {
        $html2pdf1 = new HTML2PDF('P','A3','en');
        $html2pdf1->pdf->SetDisplayMode('fullpage');
        $html2pdf1->WriteHTML($file_string);
        $html2pdf1->Output("../../imgs/customer/contract/draft-".$vehicle_id.".pdf",'F');
    }
    catch(HTML2PDF_exception $e) {
        echo $e;
        exit;
    }
    //print_r($result);
    if ($result != NULL) {
        $response["error"] = false;
        $response["contract"] = "draft-".$vehicle_id.".pdf";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

/* Here we mohit create new complet registration process */
$app->post('/newcompleteRegistration/:id', 'authenticate', function($vehicle_id)  use ($app) {

    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    // here we fetch vehicle customer id
    $db = new DbHandler();
    $customer_id = $db->getVehicleCustid($vehicle_id);

    // End

    $result = $db->newcustomerRegisterComplete($customer_id, $user_id);

    $vehicle_id = $db->getVehicleCustomerLastId($customer_id);
    $db->updateSign($vehicle_id, $fileName);
    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();

    $vehicleData = $db->getVehicle($vehicle_id);
    $vehicleDetail = $vehicleData->fetch_assoc();

    $bankData = $db->getBankData($vehicle_id);
    $bankDetail = $bankData->fetch_assoc();

    $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
    $planDetail = $planData->fetch_assoc();

    $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
    $categoryDetail = $categoryData->fetch_assoc();

    $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
    $engineDetail = $engineData->fetch_assoc();
    $reg_date = date('d-m-Y');
    if($planDetail['duration'] == '1 Year'){
        $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 52;
        }else{
            $nodd = 26;
        }
    }else{
        $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 104;
        }else{
            $nodd = 52;
        }
    }
    if($customerDetail['gender'] == '0')
    {
        $gender = 'Male';
    }else{
        $gender = 'Female';
    }
    $name = $customerDetail['firstname']. " ". $customerDetail['lastname'];
    $licenceNo = $customerDetail['drivinglicencenumber'];
    $expirydate = date('d-m-Y',strtotime($customerDetail['drivinglicenceexpiredate']));
    $dob = date('d-m-Y',strtotime($customerDetail['dateofborth']));
    $gender = $gender;
    $address = $customerDetail['address'].", ".$customerDetail['address2'];
    $mobile = $customerDetail['mobilenumber'];
    $home = $customerDetail['homenumber'];
    $email = $customerDetail['emailaddress'];
    $plateno = $vehicleDetail['plateno'];
    $make = $vehicleDetail['make'];
    $model = $vehicleDetail['model'];
    $viono = $vehicleDetail['vin'];
    $year = $vehicleDetail['year'];
    $color = $vehicleDetail['color'];
    $fuel = $vehicleDetail['fuel'];
    $plantype = $planDetail['planname'];
    $term = $planDetail['duration'];
    $vehicletype = $categoryDetail['name'];
    $cylinder = $engineDetail['name'];
    $specialbenifit  = $planDetail['special_benefits'];
    $firstservice = $first_service;
    $lastservice = $last_service;
    $paymentfre = $vehicleDetail['paymentfrequency'];
    $nodd = $nodd;
    $ddamount = $bankDetail['ddamount'];
    $payday = $vehicleDetail['paymentday'];
    $ddstartdate = date('d-m-Y',strtotime($bankDetail['ddstartdate']));
    $ddenddate = date('d-m-Y',strtotime($bankDetail['ddenddate']));
    $bacnkaccountname = $bankDetail['accountname'];
    $bankaccountno = $bankDetail['accountnumber'];
    $bank = $bankDetail['bankname'];
    if($customerDetail['contract_sign'] != ""){
        $custSign = '<img src="http://kwmapp.opaldemo.com/imgs/customer/sign/'.$customerDetail['contract_sign'].'" height="40" />';
    }else{
        $custSign = '';
    }

    $saleSign = '';
    $regDate = $reg_date;

    $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
    //$string = fgets($myfile);
    $string = fread($myfile,filesize("customer-contract.html"));
    fclose($myfile);

    $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
    $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);


    $file_string = str_replace($search, $replace, $string);
    $file_string .= '<page>

    <table width="100%" class="width97" border="0" cellspacing="0">

    <tr>
    <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
    </tr>
    <tr>
    <td>
    <p><strong>1.  Service Plan Validity Period</strong><br>
    The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
    <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
    <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
    <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
    <p><strong>2.  Service Plan Entitlements</strong><br>
    The KW Motors Service Plan entitles you to the following types of    services:</p>
    <table class="padding2" cellspacing="0" cellpadding="0">
    <tr>
    <td width="391" colspan="6" valign="top"><br>
    <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
    </tr>
    <tr>
    <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
    </tr>
    <tr>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
    <td width="71" valign="top"><strong><em>Medius</em></strong></td>
    <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
    </tr>
    <tr>
    <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">1</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="356" colspan="5" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">4</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">2</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Deluxe</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">1</td>
    </tr>
    </table>

    <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
    <p><strong>3.  Payments</strong><br>
    You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
    <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
    <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
    <p><strong>4. Default in Direct    Debit Payments </strong><br>
    It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
    <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
    <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
    <br>
    <strong>5. Transfer of Service    Plan</strong><br>
    In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
    <p><strong>6. Termination of This    Agreement</strong><br>
    KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
    <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
    <p><strong>7. Notices</strong><br>
    Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
    <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
    <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
    <ol>
    <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
    <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
    </ol>
    <p><strong>8.    Governing Law</strong><br>
    This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

    </td>
    </tr>
    </table>
    </page>';
    //ob_start();
    try
    {
        $html2pdf1 = new HTML2PDF('P','A3','en');
        $html2pdf1->pdf->SetDisplayMode('fullpage');
        $html2pdf1->WriteHTML($file_string);
        $html2pdf1->Output("../../imgs/customer/contract/".$vehicle_id.".pdf",'F');
        //$db->updateContract($customer_id, $vehicle_id.".pdf");
        $db->updateContract($vehicle_id, $vehicle_id.".pdf");
    }
    catch(HTML2PDF_exception $e) {
        echo $e;
        exit;
    }



    if ($result){
        $response["error"] = false;
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }


});


$app->post('/insertRoute', 'authenticate', function() use ($app) {
    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $lat = $request_params['latitude'];
    $lan = $request_params['longitude'];
    $db = new DbHandler();
    $db->insertRoute($user_id, $lat, $lan);
    $response["error"] = true;
    $response["message"] = "Insert";
    echoRespnse(200, $response);

});
/* End */

// Change User Status, Vehicle Status, Add Commission for saleman and sales Manager. Create Contract with Sign
$app->post('/completeRegistrationNew/:id', 'authenticate', function($customer_id)  use ($app) {
    //$data = 'data:image/png;base64,AAAFBfj42Pj4';
    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    //print_r($request_params);die();
    if($request_params){
        list($type, $imageData) = explode(';', $request_params);
        list($x,$extension) = explode('/',$type);
        list($y,$imageData)      = explode(',', $imageData);
        $fileName = $customer_id.'.'.$extension;
        $imageData = base64_decode($imageData);

        file_put_contents("../../imgs/customer/sign/".$fileName, $imageData);
        //die();
    }
    $db = new DbHandler();
    //die();

    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();
    $vehicle_id_array = $db->getPendingVehicleCustomer($customer_id);

    //print_r($vehicle_id_array);
    foreach($vehicle_id_array as $vehicles_id){

        $vehicle_id = $vehicles_id['id'];
        $db->updateSign($vehicle_id, $fileName);


        $vehicleData = $db->getVehicle($vehicle_id);
        $vehicleDetail = $vehicleData->fetch_assoc();

        $bankData = $db->getBankData($vehicle_id);
        $bankDetail = $bankData->fetch_assoc();

        $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
        $planDetail = $planData->fetch_assoc();

        $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
        $categoryDetail = $categoryData->fetch_assoc();

        $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
        $engineDetail = $engineData->fetch_assoc();

        $reg_date = date('d-m-Y');

        if($planDetail['duration'] == '1 Year'){
            $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
            $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
            if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                $nodd = 52;
            }else{
                $nodd = 26;
            }
        }else{
            $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
            $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
            if($vehicleDetail['paymentfrequency'] == 'Weekly'){
                $nodd = 104;
            }else{
                $nodd = 52;
            }

        }
        if($customerDetail['gender'] == '0')
        {
            $gender = 'Male';
        }else{
            $gender = 'Female';
        }

        $name = $customerDetail['firstname']. " ". $customerDetail['lastname'];
        $licenceNo = $customerDetail['drivinglicencenumber'];
        $expirydate = date('d-m-Y',strtotime($customerDetail['drivinglicenceexpiredate']));
        $dob = date('d-m-Y',strtotime($customerDetail['dateofborth']));
        $gender = $gender;
        $address = $customerDetail['address'].", ".$customerDetail['address2'];
        $mobile = $customerDetail['mobilenumber'];
        $home = $customerDetail['homenumber'];
        $email = $customerDetail['emailaddress'];
        $plateno = $vehicleDetail['plateno'];
        $make = $vehicleDetail['make'];
        $model = $vehicleDetail['model'];
        $viono = $vehicleDetail['vin'];
        $year = $vehicleDetail['year'];
        $color = $vehicleDetail['color'];
        $fuel = $vehicleDetail['fuel'];
        $plantype = $planDetail['planname'];
        $term = $planDetail['duration'];
        $vehicletype = $categoryDetail['name'];
        $cylinder = $engineDetail['name'];
        $specialbenifit  = $planDetail['special_benefits'];
        $firstservice = $first_service;
        $lastservice = $last_service;
        $paymentfre = $vehicleDetail['paymentfrequency'];
        $nodd = $nodd;
        $ddamount = $bankDetail['ddamount'];
        $payday = $vehicleDetail['paymentday'];
        $ddstartdate = date('d-m-Y',strtotime($bankDetail['ddstartdate']));
        $ddenddate = date('d-m-Y',strtotime($bankDetail['ddenddate']));
        $bacnkaccountname = $bankDetail['accountname'];
        $bankaccountno = $bankDetail['accountnumber'];
        $bank = $bankDetail['bankname'];
        if($vehicleDetail['contract_sign'] == ""){
            $custSign = '';
        }else{
            $custSign = '<img src="http://192.168.1.33/kwmapp/imgs/customer/sign/'.$vehicleDetail['contract_sign'].'" height="40" />';
        }

        $saleSign = '';
        $regDate = $reg_date;

        $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
        $string = fread($myfile,filesize("customer-contract.html"));
        fclose($myfile);
        $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
        $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);


        $file_string = str_replace($search, $replace, $string);
        $file_string .= '<page>

        <table width="100%" class="width97" border="0" cellspacing="0">

        <tr>
        <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
        </tr>
        <tr>
        <td>
        <p><strong>1.  Service Plan Validity Period</strong><br>
        The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
        <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
        <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
        <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
        <p><strong>2.  Service Plan Entitlements</strong><br>
        The KW Motors Service Plan entitles you to the following types of    services:</p>
        <table class="padding2" cellspacing="0" cellpadding="0">
        <tr>
        <td width="391" colspan="6" valign="top"><br>
        <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
        </tr>
        <tr>
        <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
        <td width="141" colspan="2" valign="top">&nbsp;</td>
        <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
        </tr>
        <tr>
        <td width="141" colspan="2" valign="top">&nbsp;</td>
        <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
        <td width="71" valign="top"><strong><em>Medius</em></strong></td>
        <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
        </tr>
        <tr>
        <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
        <td width="70" valign="top">Express</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">&nbsp;</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Standard</td>
        <td width="71" valign="top">1</td>
        <td width="71" valign="top">1</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="356" colspan="5" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
        <td width="70" valign="top">Express</td>
        <td width="71" valign="top">4</td>
        <td width="71" valign="top">&nbsp;</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Standard</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">2</td>
        <td width="72" valign="top">&nbsp;</td>
        </tr>
        <tr>
        <td width="70" valign="top">Deluxe</td>
        <td width="71" valign="top">2</td>
        <td width="71" valign="top">1</td>
        <td width="72" valign="top">1</td>
        </tr>
        </table>

        <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
        <p><strong>3.  Payments</strong><br>
        You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
        <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
        <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
        <p><strong>4. Default in Direct    Debit Payments </strong><br>
        It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
        <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
        <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
        <br>
        <strong>5. Transfer of Service    Plan</strong><br>
        In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
        <p><strong>6. Termination of This    Agreement</strong><br>
        KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
        <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
        <p><strong>7. Notices</strong><br>
        Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
        <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
        <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
        <ol>
        <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
        <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
        </ol>
        <p><strong>8.    Governing Law</strong><br>
        This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

        </td>
        </tr>
        </table>
        </page>';
        //ob_start();
        try
        {
            $html2pdf1 = new HTML2PDF('P','A3','en');
            $html2pdf1->pdf->SetDisplayMode('fullpage');
            $html2pdf1->WriteHTML($file_string);
            $html2pdf1->Output("../../imgs/customer/contract/".$vehicle_id.".pdf",'F');
            $db->updateContract($vehicle_id, $vehicle_id.".pdf");
        }
        catch(HTML2PDF_exception $e) {
            echo $e;
            exit;
        }

    }
    $result = $db->customerRegisterCompleteNew($customer_id, $user_id);

    if ($result){
        $response["error"] = false;
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
$app->post('/completeRegistration/:id', 'authenticate', function($customer_id)  use ($app) {
    //$data = 'data:image/png;base64,AAAFBfj42Pj4';
    $response = array();
    global $user_id;
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);

    //print_r($request_params);die();
    if($request_params){
        list($type, $imageData) = explode(';', $request_params);
        list($x,$extension) = explode('/',$type);
        list($y,$imageData)      = explode(',', $imageData);
        $fileName = $customer_id.'.'.$extension;
        $imageData = base64_decode($imageData);

        file_put_contents("../../imgs/customer/sign/".$fileName, $imageData);
        //die();
    }
    $db = new DbHandler();
    //die();


    $result = $db->customerRegisterComplete($customer_id, $user_id);

    $vehicle_id = $db->getVehicleCustomerLastId($customer_id);
    $db->updateSign($vehicle_id, $fileName);
    $customerData = $db->getCustomer($customer_id);
    $customerDetail = $customerData->fetch_assoc();

    $vehicleData = $db->getVehicle($vehicle_id);
    $vehicleDetail = $vehicleData->fetch_assoc();

    $bankData = $db->getBankData($vehicle_id);
    $bankDetail = $bankData->fetch_assoc();

    $planData = $db->getPlanDataDis($vehicleDetail['plan_id']);
    $planDetail = $planData->fetch_assoc();

    $categoryData = $db->getCategoryData($vehicleDetail['category_id']);
    $categoryDetail = $categoryData->fetch_assoc();

    $engineData = $db->getEngineData($vehicleDetail['enginetype_id']);
    $engineDetail = $engineData->fetch_assoc();
    $reg_date = date('d-m-Y');
    if($planDetail['duration'] == '1 Year'){
        $first_service = date('d-m-Y', strtotime("+3 months",strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+15 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 52;
        }else{
            $nodd = 26;
        }
    }else{
        $first_service = date('d-m-Y', strtotime("+3 months", strtotime(date('Y-m-d'))));
        $last_service = date('d-m-Y', strtotime("+27 months", strtotime(date('Y-m-d'))));
        if($vehicleDetail['paymentfrequency'] == 'Weekly'){
            $nodd = 104;
        }else{
            $nodd = 52;
        }

    }
    if($customerDetail['gender'] == '0')
    {
        $gender = 'Male';
    }else{
        $gender = 'Female';
    }

    $name = $customerDetail['firstname']. " ". $customerDetail['lastname'];
    $licenceNo = $customerDetail['drivinglicencenumber'];
    $expirydate = date('d-m-Y',strtotime($customerDetail['drivinglicenceexpiredate']));
    $dob = date('d-m-Y',strtotime($customerDetail['dateofborth']));
    $gender = $gender;
    $address = $customerDetail['address'].", ".$customerDetail['address2'];
    $mobile = $customerDetail['mobilenumber'];
    $home = $customerDetail['homenumber'];
    $email = $customerDetail['emailaddress'];
    $plateno = $vehicleDetail['plateno'];
    $make = $vehicleDetail['make'];
    $model = $vehicleDetail['model'];
    $viono = $vehicleDetail['vin'];
    $year = $vehicleDetail['year'];
    $color = $vehicleDetail['color'];
    $fuel = $vehicleDetail['fuel'];
    $plantype = $planDetail['planname'];
    $term = $planDetail['duration'];
    $vehicletype = $categoryDetail['name'];
    $cylinder = $engineDetail['name'];
    $specialbenifit  = $planDetail['special_benefits'];
    $firstservice = $first_service;
    $lastservice = $last_service;
    $paymentfre = $vehicleDetail['paymentfrequency'];
    $nodd = $nodd;
    $ddamount = $bankDetail['ddamount'];
    $payday = $vehicleDetail['paymentday'];
    $ddstartdate = date('d-m-Y',strtotime($bankDetail['ddstartdate']));
    $ddenddate = date('d-m-Y',strtotime($bankDetail['ddenddate']));
    $bacnkaccountname = $bankDetail['accountname'];
    $bankaccountno = $bankDetail['accountnumber'];
    $bank = $bankDetail['bankname'];
    if($vehicleDetail['contract_sign'] == ""){
        $custSign = '';
    }else{
        $custSign = '<img src="http://kwmapp.opaldemo.com/imgs/customer/sign/'.$vehicleDetail['contract_sign'].'" height="40" />';
    }

    $saleSign = '';
    $regDate = $reg_date;

    $myfile= fopen("customer-contract.html", "r") or die("Unable to open file!");
    //$string = fgets($myfile);
    $string = fread($myfile,filesize("customer-contract.html"));
    fclose($myfile);
    $search = array("###name###", '###licenceno###', '###expirydate###', '###dob###', '###gender###', '###address###', '###mobile###', '###home###', '###email###', '###plateno###', '###make###', '###model###', '###viono###', '###year###', '###color###', '###fuel###', '###plantype###', '###term###', '###vehicletype###', '###cylinder###', '###specialbenifit###', '###firstservice###', '###lastservice###', '###paymentfre###', '###nodd###', '###ddamount###', '###payday###', '###ddstartdate###', '###ddenddate###', '###bacnkaccountname###', '###bankaccountno###', '###bank###', '###custSign###', '###saleSign###', '###regDate###' );
    $replace = array($name, $licenceNo, $expirydate, $dob, $gender, $address, $mobile, $home, $email, $plateno, $make, $model, $viono, $year, $color, $fuel, $plantype, $term, $vehicletype, $cylinder, $specialbenifit, $firstservice, $lastservice, $paymentfre, $nodd, $ddamount, $payday, $ddstartdate, $ddenddate, $bacnkaccountname, $bankaccountno, $bank, $custSign, $saleSign, $regDate);


    $file_string = str_replace($search, $replace, $string);
    $file_string .= '<page>

    <table width="100%" class="width97" border="0" cellspacing="0">

    <tr>
    <td bgcolor="#ffc000"><strong>Terms and Conditions</strong></td>
    </tr>
    <tr>
    <td>
    <p><strong>1.  Service Plan Validity Period</strong><br>
    The KW Motors Service Plan and accompanied special    benefits shall be valid for a Minimum Service Term of 1 or 2 years (<em>as applicable</em>) effective from the date    of the 12th weekly or 6th fortnightly payment, provided    that KW Motor receives all payments due and there are no defaults in the    direct debit payments. </p>
    <p>The Agreement shall be    automatically renewed from year to year upon the expiry of the Minimum    Service Term on the same terms and conditions, unless otherwise agreed in    writing or if the Agreement is terminated pursuant to the terms and    conditions of this Agreement. </p>
    <p>The <strong>First    Service </strong>can be booked after the completion a minimum of 12 weekly or 6    fortnightly payments, provided that KW Motors receives all payments due and    there are no defaults. </p>
    <p>The <strong>Last    Service</strong> can be booked no later than Minimum Service Term, either 1 or 2    years (<em>as applicable</em>) plus 12 weeks    from the date of this Agreement. If the date of the Last Service falls on a    non-working day, the date used for calculation shall be the following working    day. Saturday, Sundays and public holidays are not counted as working days. </p>
    <p><strong>2.  Service Plan Entitlements</strong><br>
    The KW Motors Service Plan entitles you to the following types of    services:</p>
    <table class="padding2" cellspacing="0" cellpadding="0">
    <tr>
    <td width="391" colspan="6" valign="top"><br>
    <strong>SERVICE PLAN ENTITLEMENTS</strong></td>
    </tr>
    <tr>
    <td width="35" rowspan="8" valign="top"><strong>Plan</strong></td>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="215" colspan="3" valign="top"><strong>Type of Services</strong></td>
    </tr>
    <tr>
    <td width="141" colspan="2" valign="top">&nbsp;</td>
    <td width="71" valign="top"><strong><em>Minimus</em></strong></td>
    <td width="71" valign="top"><strong><em>Medius</em></strong></td>
    <td width="72" valign="top"><strong><em>Maximus</em></strong></td>
    </tr>
    <tr>
    <td width="71" rowspan="2" valign="top"><strong>1 Year</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">1</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="356" colspan="5" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="71" rowspan="3" valign="top"><strong>2 Years</strong></td>
    <td width="70" valign="top">Express</td>
    <td width="71" valign="top">4</td>
    <td width="71" valign="top">&nbsp;</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Standard</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">2</td>
    <td width="72" valign="top">&nbsp;</td>
    </tr>
    <tr>
    <td width="70" valign="top">Deluxe</td>
    <td width="71" valign="top">2</td>
    <td width="71" valign="top">1</td>
    <td width="72" valign="top">1</td>
    </tr>
    </table>

    <p>Prior booking of the service appointment <em>via</em> KW Motors Service App or telephone    on (07) 847 0099 is required, and confirmation is subject to availability. </p>
    <p><strong>3.  Payments</strong><br>
    You agree to pay for the KW Service Plan by way of    weekly / fortnightly payments <em>via </em>direct    debit from your designated bank account for the Minimum Service Term, either    1 or 2 years (<em>as applicable</em>), irrespective    of whether you utilise the services and special benefits provided for under    the KW Service Plan. </p>
    <p>If the payment is due on a day which is not a working    day, the payment shall be due on the previous working day. Saturday, Sundays    and public holidays are not counted as working days. </p>
    <p>If there are any changes in your bank or bank    account, shall notify KW Motors within 5 working days and complete a    replacement direct debit form. </p>
    <p><strong>4. Default in Direct    Debit Payments </strong><br>
    It is your responsibility to keep your designated    bank account in funds and to pay all bank fees, including any fees which you    bank may charge if your account is overdrawn because of the direct debit    payment. </p>
    <p>In the event of a default in a direct debit payment    due to insufficient funds, KW Motors will make additional direct debit within    5 days of the original dishonoured transaction to recover the outstanding    sum. In such event, KW Motors is entitled to charge you our reasonable    administrative cost. </p>
    <p>If your account is more than four weeks in arrears,    KW Motors is entitled to de-activate your account and/or engage a debt    collection agency for the recovery of the outstanding sums. In such event,    you shall be required to pay all reasonable collection cost incurred by KW    Motors, including but not limited to legal fees, administrative fees,    interest etc. <br>
    <br>
    <strong>5. Transfer of Service    Plan</strong><br>
    In the event  you    wish to transfer the KW Service Plan to another vehicle during the Minimum    Service Term, either 1 or 2 years (<em>as    applicable</em>),  you are required to notify    KW Motors of the reason(s) for the transfer and shall provide all details    including but not limited to the Name of the Registered Owner, Plate No,    Make, Model, VIN No, Year, Color and Fuel Type of the new vehicle at least    twenty working days prior to booking a service appointment. During this    period, KW Motors shall notify you if there shall be increase the weekly /    fortnightly payments depending on the Make and Model of the new vehicle. All    unused benefits accrued under the KW Motors Service Plan cannot be transferred    to the new vehicle. </p>
    <p><strong>6. Termination of This    Agreement</strong><br>
    KW Motors is entitled to terminate the KW Motors    Service Plan immediately by giving you notice in writing, if you breach any    term or condition set out in this Agreement including but not limited to    there being a default in the direct debit payment. </p>
    <p>If you choose to terminate this Agreement anytime    during the Minimum Service Term, you must pay KW Motors a termination fee of    33% of the balance of the payments you agreed to pay for the Minimum Service    Term. KW Motors is entitled to debit the termination fee from your bank    account within five working days from the date you provide notice of the    termination. Termination shall be effective from the date KW Motors receives    the termination fees, and all service(s) and/or privilege(s) under the KW    Motors Service Plan shall be immediately forfeited. </p>
    <p><strong>7. Notices</strong><br>
    Each notice or other communication relating to this    Agreement shall be made in writing and sent by personal delivery, registered    post or email. The address and email address of you and KW Motors are as    stated in this Agreement. </p>
    <p>You agree to notify KW Motors should there be any    change in your Name, Driver&rsquo;s License, Address,  Contact Number(s), Address and/or Vehicle. </p>
    <p>A notice is not effective until the party it is    addressed to receives it. For this purpose, KW Motors deems a notice sent to    you to be received:</p>
    <ol>
    <li>In    the case of a written notice sent by registered post, on the third working    day after it has been posted or earlier based on the delivery notification;    and</li>
    <li>In    the case of an email, on the working day it was sent or the next working day,    if it was sent after 5.00 pm on a working day or anytime on a non-working    day. </li>
    </ol>
    <p><strong>8.    Governing Law</strong><br>
    This Agreement is governed by and shall be    interpreted under the laws of New Zealand.</p>

    </td>
    </tr>
    </table>
    </page>';
    //ob_start();
    try
    {
        $html2pdf1 = new HTML2PDF('P','A3','en');
        $html2pdf1->pdf->SetDisplayMode('fullpage');
        $html2pdf1->WriteHTML($file_string);
        $html2pdf1->Output("../../imgs/customer/contract/".$vehicle_id.".pdf",'F');
        //$db->updateContract($customer_id, $vehicle_id.".pdf");
        $db->updateContract($vehicle_id, $vehicle_id.".pdf");
    }
    catch(HTML2PDF_exception $e) {
        echo $e;
        exit;
    }



    if ($result){
        $response["error"] = false;
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});


$app->post('/addDate/:id', 'authenticate', function($year) use ($app) {
    //echo "Hello";
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    //echo $data;
    if($year == 1){
        $year_text = "+1 year";
    }else{
        $year_text = "+2 years";
    }
    $futureDate=date('d m Y', strtotime($year_text, strtotime($data)) );
    $response["error"] = false;
    $response["date"] = $futureDate;
    echoRespnse(200, $response);
});

$app->post('/getSalesManRoute', 'authenticate', function() use ($app) {
    //echo "Hello";
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $db = new DbHandler();
    global $user_id;

    $route = $db->getSalesManRoute($data['id'], $data['date'], $data['fromtime'], $data['totime'], $user_id);
    if($data['id'] == "All"){
        $response["team"] = $route;
        $response["center"] = array("lat"=>'-37.7870', "lan"=>'175.2793');
    }else{
        $center = $db->getCenter($data['id'], $data['date']);
        $response["center"] = $center;
        $response["route"] = $route;
    }

    $response["error"] = false;


    echoRespnse(200, $response);
});

/**
* User Login
* url - /login
* method - POST
* params - email, password
*/

$app->post('/login', function() use ($app) {

    // check for required params
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    //die();
    // reading post params
    $email = $data['email'];
    $password = $data['password'];

    verifyRequiredParams(array('email', 'password'));


    $response = array();

    $db = new DbHandler();

    // check for correct email and password
    if ($db->checkLogin($email, $password)) {
        // get the user by email

        $user = $db->getUserByEmail($email);

        if ($user != NULL) {
            $api_key=$db->generateApiKey();

            $db->updateApikey($user['emailaddress'],$api_key);
            //print_r($user);
            $response["error"] = false;
            $response['firstname'] = $user['firstname'];
            $response['lastname'] = $user['lastname'];
            $response['emailaddress'] = $user['emailaddress'];
            $response['api_key'] = $api_key;
            $response['userImage'] = $user['userImage'];
            $response['userRegisterDate'] = $user['userRegisterDate'];
            $response['userContract'] = $user['userContract'];
            $response['user_id'] = $user['user_id'];
        } else {
            // unknown error occurred
            $response['error'] = true;
            $response['message'] = "An error occurred. Please try again";
        }
    } else {
        // user credentials are wrong
        $response['error'] = true;
        $response['message'] = 'Login failed. Incorrect credentials';
    }
    echoRespnse(200, $response);
});
/**
* Update api_key to NULL
* method POST
* params - api_key
* url - /logout
*/
$app->post('/logout', function() {
    //echo "Hello"; die();
    $headers = apache_request_headers();
    //print_r($headers);
    $response = array();
    if (isset($headers['Authorization'])) {
        $db = new DbHandler();
        $api_key = $headers['Authorization'];
        $val = $db->updateApikey('',$api_key);
        if($val){
            $response["error"] = false;
        }else{
            $response["error"] = true;
        }
    }else{
        $response["error"] = true;
    }
    $response["error"] = false;
    //print_r($response);
    echoRespnse(200, $response);

});




/*
* ------------------------ METHODS WITH AUTHENTICATION ------------------------
*/


/**
* Listing all tasks of particual user
* method GET
* url /tasks
*/
$app->get('/getTeam', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    // fetching all user tasks
    $result = $db->getTeam();

    $response["error"] = false;
    $response["team"] = array();

    // looping through result and preparing tasks array
    while ($teams = $result->fetch_assoc()) {
        $tmp = array();
        $tmp["position"] = $teams["name"];
        $tmp["name"] = $teams["firstname"]." ".$teams["lastname"];
        $tmp["phone"] = $teams["mobilenumber"];
        array_push($response["team"], $tmp);
    }
    //print_r($response);
    echoRespnse(200, $response);
});


/**
* Listing all tasks of particual user
* method GET
* url /tasks
*/
$app->get('/getSalesMan', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    global $site_url;
    // fetching all user tasks
    $result = $db->getSalesMan($user_id);

    $response["error"] = false;
    $response["salesman"] = array();

    // looping through result and preparing tasks array
    while ($teams = $result->fetch_assoc()) {
        $tmp = array();
        $tmp["name"] = $teams["firstname"]." ".$teams["lastname"];
        $tmp["id"] = $teams["user_id"];
        $tmp["emailaddress"] = $teams["emailaddress"];
        $tmp["mobilenumber"] = $teams["mobilenumber"];
        $tmp["address"] = $teams["address"];
        $tmp["address2"] = $teams["address2"];
        $tmp["profilepic"] = $site_url."/imgs/user/".$teams["profilepic"];
        array_push($response["salesman"], $tmp);
    }
    //print_r($response);
    echoRespnse(200, $response);
});
$app->get('/getSalesData/:id', 'authenticate', function($user_id) {
    $response = array();
    $db = new DbHandler();

    $response = array();
    $db = new DbHandler();
    $result = $db->getMySales($user_id);
    echoRespnse(200, $result);
});
/**
* Listing all tasks of particual user
* method GET
* url /tasks
*/
$app->get('/getCommissionTable', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getCommissionTable($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getCommissionTableNew', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getCommissionTable(0);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getManagementCommissionTable', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getManagementCommissionTable($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getMyCommission', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getMyCommission($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getManagementCommission', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getManagementCommission($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getTotalCommission', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getTotalCommission($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getTeamCommission', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();

    global $user_id;

    // fetching all user tasks
    $result = $db->getTeamCommission($user_id);


    //$response["error"] = false;
    //$response["team"] = $result;


    //print_r($response);
    echoRespnse(200, $result);
});
$app->get('/getMySales', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getMySales($user_id);
    echoRespnse(200, $result);
});
$app->get('/getTeamSales', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getTeamSales($user_id);
    echoRespnse(200, $result);
});
$app->get('/getPendingApplication', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getPendingApplication($user_id);
    echoRespnse(200, $result);
});
$app->get('/getJobApplication', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getJobApplication($user_id);
    echoRespnse(200, $result);
});
$app->get('/getSalesmanData/:id', 'authenticate', function($id) {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getSalesmanData($id);
    echoRespnse(200, $result);
});
// Change User Status, Vehicle Status, Add Commission for saleman and sales Manager. Create Contract with Sign
$app->post('/completeSalesmanRegistraton/:id', 'authenticate', function($customer_id)  use ($app) {
    $response = array();
    global $user_id;
    $db = new DbHandler();
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $user_id_insert = $request_params['user_id'];
    $first_name = $request_params['first_name'];
    $last_name = $request_params['last_name'];
    $date_of_birth = $request_params['date_of_birth'];
    $gender = $request_params['gender'];
    $mobile_no = $request_params['mobile_no'];
    $address = $request_params['address'];
    $address2 = $request_params['address2'];
    $email_address = $request_params['email_address'];
    $driver_licence_no = $request_params['driver_licence_no'];
    $driver_licence_expiry_date = $request_params['driver_licence_expiry_date'];
    $bank_account_name = $request_params['bank_account_name'];
    $bank_name = $request_params['bank_name'];
    $bank_account_no1 = $request_params['bank_account_no1'];
    $bank_account_no2 = $request_params['bank_account_no2'];
    $bank_account_no3 = $request_params['bank_account_no3'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $bank_account_no4 = $request_params['bank_account_no4'];
    $payment_frequency = $request_params['payment_frequency'];
    $payment_day = $request_params['payment_day'];
    $contract = $request_params['contract'];
    $bank_account_no = $bank_account_no1."-".$bank_account_no2."-".$bank_account_no3."-".$bank_account_no4;
    $nzlProof1 = $request_params['nzlProof1'];
    $nzlProof2 = $request_params['nzlProof2'];
    $profilepic = $request_params['profilepic'];
    $datetime = $request_params['datetime'];

    if($datetime!=""){
        $scan = scandir('../tmp');
        foreach($scan as $file)
        {
            if (!is_dir($file))
            {
                if(strpos($file, 'nzlProof1') !== false && strpos($file, $datetime) !== false){
                    $nzlProof1 = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'nzlProof2') !== false && strpos($file, $datetime) !== false){
                    $nzlProof2 = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
                if(strpos($file, 'profile') !== false && strpos($file, $datetime) !== false){
                    $profilepic = $file;
                    rename('../tmp/'.$file, '../../imgs/user/'.$file);
                }
            }
        }
    }else{
        if($profilepic != ''){
            rename('../tmp/'.$profilepic, '../../imgs/user/'.$profilepic);
        }
        if($nzlProof1 != ''){
            rename('../tmp/'.$nzlProof1, '../../imgs/user/'.$nzlProof1);
        }
        if($nzlProof2 != ''){
            rename('../tmp/'.$nzlProof2, '../../imgs/user/'.$nzlProof2);
        }
    }

    if($user_id_insert == ""){
        //Insert user
        $user_id_insert  = $db->insertSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic);
    }else{
        //Update Signup
        $user_id_insert  = $db->updateSalesMan($first_name, $last_name, $date_of_birth, $gender, $mobile_no, $adddress, $address2, $email_address, $driver_licence_no, $driver_licence_expiry_date, $bank_account_name, $bank_name, $payment_day, $payment_frequency, $bank_account_no, $user_id, $nzlProof1, $nzlProof2, $profilepic, $user_id_insert);
    }
    if($request_params['signature'] != ""){
        list($type, $imageData) = explode(';', $request_params['signature']);
        list($x,$extension) = explode('/',$type);
        list($y,$imageData)      = explode(',', $imageData);
        $fileName = $user_id_insert.'.'.$extension;
        $imageData = base64_decode($imageData);

        file_put_contents("../../imgs/user/sign/".$fileName, $imageData);
    }

    $result = $db->addSalesmanCommission($user_id_insert);
    $result = $db->updateStaffStatusSign($fileName, $user_id_insert);
    if($result){
        $response["error"] = false;
        $response["message"] = "Salesman succesfully registered";
        echoRespnse(200, $response);
    }else{
        $response["error"] = true;
        $response["message"] = "Error!! Please try again";
        echoRespnse(200, $response);
    }


});
/**
* Listing single task of particual user
* method GET
* url /tasks/:id
* Will return 404 if the task doesn't belongs to user
*/
$app->get('/warningLights/:id', 'authenticate', function($cms_id) {
    $response = array();
    $db = new DbHandler();

    // fetch task
    $result = $db->getWarningLight($cms_id);

    if ($result != NULL) {
        $response["error"] = false;
        $response["cms_id"] = $result["cms_id"];
        $response["cms_title"] = $result["cms_title"];
        $response["cms_description"] = $result["cms_description"];
        $response["cms_icon"] = $result["cms_icon"];
        echoRespnse(200, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "The requested resource doesn't exists";
        echoRespnse(404, $response);
    }
});
/**
* Get All Customer Data
* method GET
* url /getCustomer
* Will return 404 if the task doesn't belongs to user
*/
$app->get('/getCustomer', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    // fetch task
    $result = $db->getCustomer($user_id);
    //print_r($result);
    //die();
    if ($result != NULL) {
        $response["error"] = false;

        $data = $result->fetch_assoc();
        $response["customer"] = $data;

        echoRespnse(200, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "The requested resource doesn't exists";
        echoRespnse(404, $response);
    }
});
/**
* Listing all Customer Car
* method GET
* url /tasks
*/
$app->get('/getCustomerCar', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    //echo $user_id;die();
    // fetching all user tasks
    $result = $db->getCustomerCar($user_id);

    $response["error"] = false;
    $response["cars"] = $result;

    // looping through result and preparing tasks array

    //print_r($response);
    echoRespnse(200, $response);
});

/**
* Listing all getAdmindata
* method GET
* url /getAdmindata
*/
$app->get('/getAdmindata', 'authenticate', function() {
    $response = array();
    $db = new DbHandler();
    global $user_id;
    //echo $user_id;die();
    // fetching all user tasks
    $result = $db->getAdmindata($user_id);

    $response["error"] = false;
    $response["admin"] = $result;

    // looping through result and preparing tasks array

    //print_r($response);die();
    echoRespnse(200, $response);
});
$app->post('/insertTrack', 'authenticate', function() use ($app) {
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $response = array();
    global $user_id;
    global $api_key;
    $db = new DbHandler();
    $result = $db->insertTrack($request_params);
    if ($result) {
        $response["error"] = false;
        $response["message"] = "Added succesfully";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
$app->post('/updateTrack', 'authenticate', function() use ($app) {
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $response = array();
    global $user_id;
    global $api_key;
    $db = new DbHandler();
    $result = $db->updateTrack($request_params);
    if ($result) {
        $response["error"] = false;
        $response["message"] = "Added succesfully";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
$app->post('/viewTargetArea', 'authenticate', function() use ($app) {
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    $response = array();
    global $user_id;
    global $api_key;
    $db = new DbHandler();

    $result = $db->viewTargetArea($request_params['dateSelected'], $request_params['id'], $user_id);
    if ($result) {
        $response["error"] = false;
        $response["data"] = $result;
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Creating new Location in db
* method POST
* params - lat,Lon
* url - /loackLocation/
*/
$app->post('/loackLocation', 'authenticate', function() use ($app) {
    // check for required params

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('lat', 'lan', 'minutes'));
    $response = array();
    global $user_id;
    global $api_key;

    //echo "Tes".$message;
    //echo "<br/>".$user_id;
    //die();
    $db = new DbHandler();


    $datetime = date('Y-m-d H:i:s', strtotime("+".$request_params['minutes']." minutes"));
    // creating new task
    $task_id = $db->createLockLocation($user_id, $request_params['lat'], $request_params['lan'], $datetime, $api_key);

    if ($task_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Location saved successfully";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Creating new Location in db
* method GET
* params -
* url - /getCarLocation/
*/
$app->get('/getCarLocation', 'authenticate', function() {

    $response = array();
    global $user_id;
    global $api_key;

    $db = new DbHandler();

    $response["car_location"] = array();
    $result = $db->getCarLocation($user_id, $api_key);

    if ($result != NULL) {
        $response["error"] = false;
        while ($car_location = $result->fetch_assoc()) {
            $tmp = array();
            $tmp["latitude"] = $car_location["latitude"];
            $tmp["longitude"] = $car_location["longitude"];
            $tmp["end_datetime"] = $car_location["end_datetime"];
            array_push($response["car_location"], $tmp);
        }

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Get Caategory
* method GET
* params -
* url - /getCategory/
*/
$app->get('/getCategory', 'authenticate', function() {

    $response = array();

    $db = new DbHandler();

    $result = $db->getCategory();

    if ($result != NULL) {
        $response["error"] = false;
        $response["category"] = array();

        while ($category = $result->fetch_assoc()) {
            $tmp = array();
            $tmp["categoryName"] = $category["name"];
            $tmp["categoryId"] = $category["category_id"];
            array_push($response["category"], $tmp);
        }

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Get Engine
* method GET
* params - category_id
* url - /getEngine/
*/
$app->get('/getEngine/:id', 'authenticate', function($category_id) {

    $response = array();

    $db = new DbHandler();

    $result = $db->getEngine($category_id);

    if ($result != NULL) {
        $response["error"] = false;
        $response["engine"] = array();
        while ($engine = $result->fetch_assoc()) {
            $tmp = array();
            $tmp["engineName"] = $engine["name"];
            $tmp["engineId"] = $engine["enginetype_id"];
            array_push($response["engine"], $tmp);
        }

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Get Cost
* method GET
* params - engine_id
* url - /getCost/
*/
$app->get('/getCost/:id', 'authenticate', function($engine_id) {

    $response = array();

    $db = new DbHandler();

    $result = $db->getCost($engine_id);

    if ($result != NULL) {
        //array_push($response, $result);
        //$response["costs"] = array();

        echoRespnse(201, $result);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Creating new Inquiry in db
* method POST
* params - name
* url - /customerinquiry/
*/
$app->post('/customerinquiry', 'authenticate', function() use ($app) {
    // check for required params

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('description'));
    $message = $request_params['description'];
    $response = array();
    global $user_id;

    //echo "Tes".$message;
    //echo "<br/>".$user_id;
    //die();
    $db = new DbHandler();

    // creating new task
    $task_id = $db->createCustomerInquiry($user_id, $message);

    if ($task_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Inquiry created successfully";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to create online Inquiry. Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Creating new Inquiry in db
* method POST
* params - name
* url - /customerinquiry/
*/
$app->post('/updateCustomer', 'authenticate', function() use ($app) {
    // check for required params

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email'));
    $response = array();
    global $user_id;
    $db = new DbHandler();
    // creating new task
    $customer_id = $db->updateCustomer($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email']);
    if ($customer_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Profile Successfully Updated";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Error!!! Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Creating new Inquiry in db
* method POST
* params - name
* url - /customerinquiry/
*/
$app->post('/updateAdmin', 'authenticate', function() use ($app) {
    // check for required params

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('addressLine1', 'addressLine2', 'Mobile', 'Email', 'BankAccountName', 'BankAccountNo', 'Bank' ));
    $response = array();
    global $user_id;
    $db = new DbHandler();
    // creating new task
    $customer_id = $db->updateAdmin($user_id, $request_params['addressLine1'], $request_params['addressLine2'], $request_params['Mobile'], $request_params['Email'], $request_params['BankAccountName'], $request_params['BankAccountNo'], $request_params['Bank']);
    if ($customer_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Profile Successfully Updated";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Error!!! Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Show Customer Feedback
* method GET
* params -
* url - /customerFeedback/
*/
$app->get('/customerFeedback', 'authenticate', function() {


    global $user_id, $site_url;
    $db = new DbHandler();
    // creating new task

    $admin_user = $db->getSitemanagerByCustomer($user_id);
    $admin_user_array = $db->getAdminUser($admin_user);
    //$response["sales_manager"] = $admin_user_array;

    $customer_data_result = $db->getCustomer($user_id);
    $customer_data = $customer_data_result->fetch_assoc();


    $result = $db->getUserFeedback($user_id);
    $response["feedback"] = array();
    if ($result) {
        // looping through result and preparing tasks array
        while ($feedback = $result->fetch_assoc()) {
            //print_r($feedback);
            $tmp = array();
            if($feedback['send_by'] == "1"){ // Customer

                $tmp["position"] = 'right';
                $tmp["senderName"] = 'Me';
                if($customer_data['profilepic'] == "" || $customer_data['profilepic'] == NULL){
                    $profilepic = 'no-profile.jpg';
                }else{
                    $profilepic = $customer_data['profilepic'];
                }
                $tmp["imgs"] = $site_url.'/imgs/customer/'.$profilepic;

            }else{ // Site Manager
                $tmp["position"] = 'left';
                $tmp["senderName"] = $admin_user_array['firstname'];
                if($admin_user_array['profilepic'] == "" || $admin_user_array['profilepic'] == NULL){
                    $profilepic = 'no-profile.jpg';
                }else{
                    $profilepic = $admin_user_array['profilepic'];
                }
                $tmp["imgs"] = $site_url.'/imgs/user/'.$profilepic;
            }
            //$tmp["sender_id"] = $feedback["sender_id"];
            //$tmp["cms_title"] = $feedback["cms_title"];
            //$tmp["receiver_id"] = $feedback["receiver_id"];
            //$tmp["send_by"] = $feedback['send_by'];
            $tmp["message"] = $feedback['message'];
            $tmp["conversation_datetime"] = $feedback['conversation_datetime'];
            $tmp["conversion_id"] = $feedback['conversation_id'];
            array_push($response["feedback"], $tmp);
        }

        $response["error"] = false;
        //$response["message"] = $result;
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Error!!! Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Creating new Message in db
* method POST
* params - name
* url - /sendMessage/
*/
$app->post('/sendMessage', 'authenticate', function() use ($app) {

    $json = $app->request->getBody();
    $request_params = json_decode($json, true);
    //print_r($request_params);
    verifyRequiredParams(array('message'));
    $response = array();
    global $user_id;
    $db = new DbHandler();

    $sender_id = $user_id;
    $admin_user = $db->getSitemanagerByCustomer($user_id);
    $admin_user_array = $db->getAdminUser($admin_user);
    $receiver_id = $admin_user_array['user_id'];
    $send_by = 1;
    $conversation_datetime = date('Y-m-d H:i:s');

    // creating new task
    $customer_id = $db->insertMessage($sender_id, $receiver_id, $request_params['message'], $request_params['conversion_id'], $conversation_datetime, $send_by);
    if ($customer_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Message send succesfully";
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Error!!! Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Creating new task in db
* method POST
* params - name
* url - /tasks/
*/
$app->post('/tasks', 'authenticate', function() use ($app) {
    // check for required params
    verifyRequiredParams(array('task'));

    $response = array();
    $task = $app->request->post('task');

    global $user_id;
    $db = new DbHandler();

    // creating new task
    $task_id = $db->createTask($user_id, $task);

    if ($task_id != NULL) {
        $response["error"] = false;
        $response["message"] = "Task created successfully";
        $response["task_id"] = $task_id;
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to create task. Please try again";
        echoRespnse(200, $response);
    }
});

/**
* Updating existing task
* method PUT
* params task, status
* url - /tasks/:id
*/
$app->put('/tasks/:id', 'authenticate', function($task_id) use($app) {
    // check for required params
    verifyRequiredParams(array('task', 'status'));

    global $user_id;
    $task = $app->request->put('task');
    $status = $app->request->put('status');

    $db = new DbHandler();
    $response = array();

    // updating task
    $result = $db->updateTask($user_id, $task_id, $task, $status);
    if ($result) {
        // task updated successfully
        $response["error"] = false;
        $response["message"] = "Task updated successfully";
    } else {
        // task failed to update
        $response["error"] = true;
        $response["message"] = "Task failed to update. Please try again!";
    }
    echoRespnse(200, $response);
});

/**
* Deleting task. Users can delete only their tasks
* method DELETE
* url /tasks
*/
$app->delete('/tasks/:id', 'authenticate', function($task_id) use($app) {
    global $user_id;

    $db = new DbHandler();
    $response = array();
    $result = $db->deleteTask($user_id, $task_id);
    if ($result) {
        // task deleted successfully
        $response["error"] = false;
        $response["message"] = "Task deleted succesfully";
    } else {
        // task failed to delete
        $response["error"] = true;
        $response["message"] = "Task failed to delete. Please try again!";
    }
    echoRespnse(200, $response);
});
/**
* Get Engine
* method GET
* params - category_id
* url - /getEngine/
*/
$app->get('/getCarApi/:id', 'authenticate', function($plat_id) {

    $response = array();
    $db = new DbHandler();

    $result = $db->getCarApi($plat_id);
    //print_r($result);
    if ($result != NULL) {
        $response["error"] = false;
        $response["plate_id"] = $result["id"];
        $response["make"] = $result["make"];
        $response["plateno"] = $result["plateno"];
        $response["model"] = $result["model"];
        $response["year"] = $result["year"];
        $response["vin"] = $result["vin"];
        $response["color"] = $result["color"];
        $response["fuel"] = $result["fuel"];

        $response["categoryType"] = $db->getCategoryByMake($result["make"]);
        $response["EngineType"] = $db->getEngineTypeByCategory($response["categoryType"][0]['id']);
        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});
/**
* Get Engine
* method GET
* params - category_id
* url - /getEngine/
*/
$app->get('/getCategoryId/:id', 'authenticate', function($category_make) {

    $response = array();
    $db = new DbHandler();

    $result = $db->getCategoryId($category_make);
    //print_r($result);
    if ($result != NULL) {
        $response["error"] = false;
        $response["category_id"] = $result["category_id"];

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Failed to save data. Please try again";
        echoRespnse(200, $response);
    }
});

$app->get('/getHome', 'authenticate', function() {

    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getHome($user_id);

    //print_r($result);die();
    if (!empty($result)) {
        $response["error"] = false;
        $response["home"] = $result;

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Please try again";
        echoRespnse(200, $response);
    }
});

$app->get('/getTargetArea/:id', 'authenticate', function($track_id) {

    $response = array();
    $db = new DbHandler();
    global $user_id;
    $result = $db->getTrack($track_id);

    //print_r($result);die();
    if (!empty($result)) {
        $response["error"] = false;
        $response["home"] = $result;

        echoRespnse(201, $response);
    } else {
        $response["error"] = true;
        $response["message"] = "Please try again";
        echoRespnse(200, $response);
    }
});
// Here we call the incident conversation details
$app->post('/getincidentConversation',function()  use ($app){
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    $incidentid = $data['incidentid'];
    $db = new DbHandler();
    $get_conversation_details = $db->incident_detail_data($incidentid);
    $response['incidentdata'] = array();
    while($conversation = $get_conversation_details->fetch_assoc()){
        $temp_array = array();
        if($conversation['sendername'] == 'admin'){
            $temp_array["position"] = 'left';
            $temp_array["senderName"] = 'admin';
        }else{
            $temp_array["position"] = 'right';
            $temp_array["senderName"] = "Me";
        }
        if($conversation['profilepic'] == "" || $conversation['profilepic'] == NULL){
            $profilepic = 'no-profile.jpg';
        }else{
            $profilepic = $conversation['profilepic'];
        }
        $temp_array["imgs"] = $profilepic;
        $temp_array["message"] = $conversation['incident_detail'];
        $temp_array["conversation_datetime"] = $conversation['incidentreport_datetime'];
        $temp_array["conversion_id"] = $conversation['incidentreport_id'];
        $temp_array['receiver_id'] = $conversation['receiver_id'];
        $temp_array['sender_id'] = $conversation['sender_id'];
        array_push($response['incidentdata'],$temp_array);
    }
    $response['error'] = false;
    echoRespnse(200, $response);

});
// End

// here we send msg to admin in incident chat
$app->post('/sendincidentMessage','authenticate', function() use ($app) {
    $json = $app->request->getBody();
    $data = json_decode($json, true);
    global $user_id;
    $db = new DbHandler();
    $incidentmsg = $data['incidentmsg'];
    $incidentid = $data['incidentid'];
    $store_data = $db->insert_incident_details($incidentmsg,$incidentid,$user_id);
    if($store_data == 1){
        $response['error'] = false;
    }else{
        $response['error'] = true;
    }
    echoRespnse(200, $response);
});
// end
// Get all incident perticular site manager
$app->get('/getincidentLogs','authenticate', function() use ($app) {
    global $user_id;
    $db = new DbHandler();
    $all_incident = $db->getall_incident_logs($user_id);
    $response['incidentlogs'] = array();
    while($incident_log = $all_incident->fetch_assoc()){
        $temp = array();
        $temp['incidentreport_id'] = $incident_log['incidentreport_id'];
        $temp['incident_datetime'] = date("d/m/y",strtotime($incident_log['incident_datetime']));
        $temp['incident_location'] = $incident_log['incident_location'];
        $temp['incident_people'] = $incident_log['incident_people'];
        array_push($response['incidentlogs'],$temp);
    }
    $response['error'] = false;
    echoRespnse(200, $response);
});

// Here we store incident data to table
$app->post('/storeincident','authenticate',function() use ($app) {
    global $user_id;
    $json = $app->request->getBody();
    $db = new DbHandler();
    $data = json_decode($json, true);

    $incidentdate       = $data['incidentdate'];
    $incidenttime       = $data['incidenttime'];
    $incidentlocation   = $data['incidentlocation'];
    $incidentperson     = $data['incidentperson'];
    $incidentdetails    = $data['incidentdetails'];
    $store_incident = $db->store_incident($user_id,$incidentdate,$incidenttime,$incidentlocation,$incidentperson,$incidentdetails);
    if($store_incident == 0){
        $response['error'] = false;
        $response['msg'] = "Incident information store successfully.";
    }else{
        $response['error'] = true;
        $response['msg'] = "Oops,there is some error to store information.";
    }
    echoRespnse(200, $response);
});
// End
/**
* Verifying required params posted or not
*/
function verifyRequiredParams($required_fields) {
    $error = false;
    $error_fields = "";
    $request_params = array();
    //$request_params = $_REQUEST;
    // Handling PUT request params
    $app = \Slim\Slim::getInstance();
    $json = $app->request->getBody();
    $request_params = json_decode($json, true);


    if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
        // $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}

/**
* Validating email address
*/
function validateEmail($email) {
    $app = \Slim\Slim::getInstance();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response["error"] = true;
        $response["message"] = 'Email address is not valid';
        echoRespnse(400, $response);
        $app->stop();
    }
}
/**
* Echoing json response to client
* @param String $status_code Http response code
* @param Int $response Json response
*/
function echoRespnse($status_code, $response) {
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);

    // setting response content type to json
    $app->contentType('application/json');

    echo json_encode($response);
}
$app->notFound(function () use ($app) {
    $headers = apache_request_headers();

    print_r($headers);
});
$app->run();
?>
