<?php
    include("../config/configuration.php");
    $load = new loader();
    $label = "entitlements";
    $dclass = new database();
    $gnrl = new general;
    
    if(!$gnrl->checkLogin()){
        $gnrl->redirectTo("index.php?msg=logfirst");
    }
    
    $load->includeother("header");

?>
<link rel="stylesheet" href="../css/responsive-table.css">
<div class="page-content full_page_content">
    <div id="portlet-config" class="modal hide">
        <div class="modal-header">
            <button data-dismiss="modal" class="close" type="button"></button>
            <h3>portlet Settings</h3>
        </div>
        <div class="modal-body">
            <p>Here will be a configuration form</p>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span12">
                <h3 class="page-title">&nbsp;<small></small></h3>
            </div>
        </div>
        <div class="row-fluid">
            <div class="span12">
				<?php 
				$pos_arg = "";
				if(isset($_REQUEST['pos']) && $_REQUEST['pos'] == "salesmanager"){
					$load->includeother("left_sidebar_sales_manager"); 
					$pos_arg = "&pos=salesmanager";
				}else{
					$load->includeother("left_sidebar_salesman"); 
				}
				?>
				<div class="span9">		
                    <div class="portlet box light-grey">
                        <div class="portlet-title">
                            <div class="caption"><i class="icon-globe"></i> <?php echo "Product Cost"; ?> </div>
                            <div class="tools"><a href="javascript:;" class="collapse"></a></div>
                        </div>
                        <div class="portlet-body">
                            <div class="table-fix">
                                <?php if(isset($_SESSION["msg"])){ ?>
									<div class="alert alert-success">
										<button data-dismiss="alert" class="close"></button>
										<?php echo $_SESSION["msg"]; unset($_SESSION["msg"]); ?>
									</div>
								<?php } 
								$categories = $dclass->select("tbl_category","*"," AND status = 1"); 
								?>
								<form name="userlist" id="userlist" method="post" enctype="multipart/form-data">
									<div class="control-group">
										<label class="control-label valiclrBold">Category</label>
										<div class="controls">
											<select name="category_id" id="category_id"  class="span3 m-wrap validate[required]">
												<option value="">Select Category</option>
												<?php foreach($categories as $category){ ?>
												<option value="<?php echo $category['category_id']; ?>" <?php if(isset($row['category_id']) && $row['category_id'] == $category['category_id']){ ?> selected="selected" <?php } ?>><?php echo $category['name']; ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="control-group">
										<label class="control-label valiclrBold">Engine Type</label>
										<div class="controls">
											<select name="enginetype_id" id="enginetype_id"  class="span3 m-wrap validate[required]">
												<option value="">Select Engine Type</option>
											</select>
										</div>
									</div>
									<div id="product_cost_div"></div>
								</form>
                        </div>
                    </div>
                </div>
				</div>
            </div>
        
    </div>
</div>
    </div>
</div>

<?php $load->includeother("footer"); ?>
<script src="assets/scripts/jquery.validationEngine.js"></script>
<script src="assets/scripts/jquery.validationEngine-en.js"></script>
<script src="assets/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
<script src="assets/scripts/app.js" type="text/javascript"></script>
<script src="assets/scripts/index.js" type="text/javascript"></script>
<script src="assets/scripts/tasks.js" type="text/javascript"></script>
<script type="text/javascript" src="inc/js/common.js"></script>
<script type="text/javascript">
    $(document).ready(function (){

        $("#example").dataTable({
            "aaSorting": [[1,"desc"]]
        });
		$(document).on("change","#category_id",function(){
            var category_id = $(this).val();
            get_enginetype(category_id);
        });
		$(document).on("change","#enginetype_id",function(){
            var enginetype_id = $(this).val();
			var category_id = document.getElementById("category_id").value;
			get_product_cost(category_id,enginetype_id);
        });
		$(document).on("click",".plan_type_btn",function(){
			var category_id = document.getElementById("category_id").value;
			var enginetype_id = document.getElementById("enginetype_id").value;
            var plan_type = $(this).attr("id");
			get_product_cost(category_id,enginetype_id,plan_type);
        });
		
    });
	function get_enginetype(category_id,sel_eng=""){
        $.ajax({
            type: "POST",
            url: "inc/ajax_call/get_enginetype.php",
            data: { category_id : category_id, sel_eng : sel_eng},
            success: function(res){
				$("#product_cost_div").html("");
                $("#enginetype_id").html(res);
            }
        });
    }
	function get_product_cost(category_id,enginetype_id,plan_type="Weekly"){
		var id = "<?php echo $_REQUEST['id']; ?>";
		var pos = "<?php echo $_REQUEST['pos']; ?>";
        $.ajax({
            type: "POST",
            url: "inc/ajax_call/get_product_cost.php",
            data: { category_id : category_id, enginetype_id : enginetype_id, plan_type : plan_type, id : id, pos : pos},
            success: function(res){
                $("#product_cost_div").html(res);
            }
        });
    }
</script>
