<?php
    include("../config/configuration.php");
    $load = new loader();
    $objPages = $load->includeclasses("technician");
    $label = "jobs";
    $dclass = new database();
    $gnrl = new general;
    
    if(!$gnrl->checkLogin()){
        $gnrl->redirectTo("index.php?msg=logfirst");
    }
    
    $load->includeother("header");
	$load->includeother("technician_sub");
?>
<link rel="stylesheet" href="../css/responsive-table.css">
<div class="page-content full_page_content">
    <div id="portlet-config" class="modal hide">
        <div class="modal-header">
            <button data-dismiss="modal" class="close" type="button"></button>
            <h3>portlet Settings</h3>
        </div>
        <div class="modal-body">
            <p>Here will be a configuration form</p>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row-fluid page-content1">        
		<?php $load->includeother("left_sidebar_technician_account"); ?>
		<div class="span10">
			<div class="row-fluid">
				<div class="span12">
						<div class="portlet box light-grey">
							<div class="portlet-title">
								<div class="caption"><i class="icon-globe"></i> <?php echo "Jobs"; ?> </div>
								<div class="tools"><a href="javascript:;" class="collapse"></a></div>
							</div>
							<div class="portlet-body">
								<div class="table-fix">
									<?php if(isset($_SESSION["msg"])){ ?>
										<div class="alert alert-success">
											<button data-dismiss="alert" class="close"></button>
											<?php echo $_SESSION["msg"]; unset($_SESSION["msg"]); ?>
										</div>
									<?php } ?>
									<form name="frm" id="frm" method="post"> 
										<?php $AllJobs = $objPages->getAllJobs(); ?>
										<div class="table-toolbar">
											
										</div>
										<table style="margin-bottom: 20px;" id="example">
											<thead>
												<tr>
													<th>#</th>
													<th>Plate</th>
													<th>Model</th>
													<th>Type</th>
													<th>Status</th>
													<th>Schedule Time</th>
													<th>Start Time</td>
													<th>Paused Time</td>
													<th>End Time</td>
													<th>Time Used(Hours)</th>
													<th>View</th>
												</tr>
											</thead>
											<tbody>
												<?php
												$i = 1;
												foreach($AllJobs as $rows){
													$getDatetime = $dclass->select( "tbl_job_time", " MIN(start_time) as starttime, MAX(end_time) as endtime, SUM(total_time) as total", " AND booking_id = ".$rows['booking_id']);
													
													$status = '';
													$duration = '';
													$job_card_pdf = $dclass->getvalue("tbl_jobcard","jobcard_pdf","booking_id = :booking_id",array("booking_id"=>$rows['booking_id']));
													if($rows['job_status'] == "0"){
														$status = '<span class="alert">Assigned</span>';
													}else if($rows['job_status'] == "1"){
														$status = '<span class="alert alert-info">In Progress</span>';
													}else if($rows['job_status'] == "2"){
														$duration = $getDatetime[0]['total'];
														$status = '<span class="alert alert-error">Paused</span>';
													}else if($rows['job_status'] == "3"){
														$duration = $rows["total_time"];
														$status = '<span class="alert alert-success">Completed / Unverified</span>';
													}else if($rows['job_status'] == "4"){
														$duration = $rows["total_time"];
														$status = '<span class="alert alert-success">Completed / Verified</span>';
													}
													
													$hours = floor($duration / 60);
													$mins = $duration % 60;

												?>
												<tr class="odd gradeX">
													<td><?php echo $i++;?></td>
													<td><?php echo $rows['plateno']; ?></td>
													<td><?php echo $rows['model']; ?></td>
													<td><?php echo $rows["service_type"]; ?></td>
													<td><?php echo $status;?></td>
													<td><?php echo date('d-m-Y H:i:s', strtotime($rows["scheduledatetime"]));?></td>
													
													<td><?php echo $r = ($getDatetime[0]["starttime"] != '') ? date('d-m-Y H:i:s', strtotime($getDatetime[0]["starttime"])) : 'N/A';?></td>
													<td><?php echo $r = ($rows['job_status'] == "2") ? date('d-m-Y H:i:s', strtotime($getDatetime[0]["endtime"])): 'NA';?></td>
													<td><?php echo $r = ($getDatetime[0]["endtime"] != '') ? date('d-m-Y H:i:s', strtotime($getDatetime[0]["endtime"])) : 'N/A';?></td>
													<td><?php echo str_pad($hours, 2, '0', STR_PAD_LEFT) , ':' , str_pad($mins, 2, '0', STR_PAD_LEFT) , ':00';;?></td>
													<td>
														<?php if($rows['job_status'] == '4' ){?>
															<span><a target="_blank" href="../imgs/jobcard/pdf/<?php echo $job_card_pdf;?>"><img src="inc/image/eyes-icon.png" name="View" alt="View" title="View"></a> </span>
														<?php }?>
													</td>
												</tr>
											<?php } ?>
										  </tbody>
										</table>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
    </div>
</div>

<?php $load->includeother("footer"); ?>
<script src="assets/scripts/jquery.validationEngine.js"></script>
<script src="assets/scripts/jquery.validationEngine-en.js"></script>
<script src="assets/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
<script src="assets/scripts/app.js" type="text/javascript"></script>
<script src="assets/scripts/index.js" type="text/javascript"></script>
<script src="assets/scripts/tasks.js" type="text/javascript"></script>
<script type="text/javascript" src="inc/js/common.js"></script>
<script type="text/javascript">
    $(document).ready(function (){
        $("#userlist").validationEngine();
		
		$("#example").dataTable({
            "aaSorting": [[1,"desc"]]
        });
		
    });
    
</script>
